/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.piaozone;

import java.util.HashMap;
import java.util.Map;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.cloudkingdee.CloudKingdeeApiUtil;
import kd.scm.common.piaozone.IPiaoZoneApiService;
import kd.scm.common.piaozone.config.PiaoZoneConfigration;
import kd.scm.common.piaozone.errorcode.PiaoZoneErrorCode;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.MD5Util;

public class PiaoZoneApiService
implements IPiaoZoneApiService {
    private static Log log = LogFactory.getLog(PiaoZoneApiService.class);
    private static ThreadLocal<String> URL = new ThreadLocal();
    private Map<String, Object> param = null;

    @Override
    public Object process(Map<String, Object> param) {
        PiaoZoneConfigration.initConfig();
        log.info("###piaoZoneApiService param:" + param);
        this.param = param;
        this.checkParams();
        this.getPostData();
        ApiResult result = this.invokeApi(this.getRequestContext());
        return this.handleResult(result);
    }

    protected void checkParams() {
        Object data;
        Object opType = this.param.get("czlx");
        if (opType == null) {
            throw new KDBizException(PiaoZoneErrorCode.OPRTYPE_ISNULL, new Object[0]);
        }
        if ((opType.equals("110") || opType.equals("3")) && (data = this.param.get("sjd")) == null) {
            throw new KDBizException(PiaoZoneErrorCode.INVOICE_DATA_ISNULL, new Object[0]);
        }
    }

    protected String getUrl() {
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(PiaoZoneConfigration.getHOST()).append(':').append(PiaoZoneConfigration.getPORT());
        String url = urlSb.toString();
        URL.set(url);
        return url;
    }

    protected ApiRequest getRequestContext() {
        ApiRequest request = new ApiRequest("post", this.getUrl());
        if (!this.param.isEmpty()) {
            request.setPostData(this.param);
        }
        return request;
    }

    private ApiResult invokeApi(ApiRequest request) {
        ApiClient.Option option = new ApiClient.Option();
        option.readTimeout = 50000;
        return ApiClientFactory.getExternal((ApiClient.Option)option).execute(request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handleResult(ApiResult result) {
        Object data = null;
        String errorMsg = null;
        if (result.isOk()) {
            Object json = JacksonJsonUtil.fromJson(result.getData(), Object.class);
            if (json instanceof Map) {
                Object opType = this.param.get("czlx");
                if (opType.equals("4")) return json;
                if (opType.equals("6")) {
                    return json;
                }
                Map map = (Map)json;
                if (map.get("errcode").equals("0000") || map.get("errcode").equals("0")) {
                    data = map.get("data");
                    if (data != null) return data;
                    return map.get("lists");
                }
                errorMsg = ResManager.loadKDString((String)"\u8c03\u7528\u7968\u65e0\u5fe7\u63a5\u53e3\uff1a", (String)"PiaoZoneApiService_0", (String)"scm-common", (Object[])new Object[0]) + URL.get() + ResManager.loadKDString((String)"\u7968\u65e0\u5fe7\u8fd4\u56de\u6d88\u606f\uff1a", (String)"PiaoZoneApiService_1", (String)"scm-common", (Object[])new Object[0]) + map.get("description");
                log.error(String.format(PiaoZoneErrorCode.INVOKE_FAILED.getMessage(), errorMsg));
                throw new KDException(PiaoZoneErrorCode.INVOKE_FAILED, new Object[]{errorMsg});
            }
            String url = URL.get();
            errorMsg = ResManager.loadKDString((String)"\u8c03\u7528\u7968\u65e0\u5fe7\u63a5\u53e3\uff1a", (String)"PiaoZoneApiService_0", (String)"scm-common", (Object[])new Object[0]) + url;
            log.error(String.format(PiaoZoneErrorCode.RETURNDATA_FORMAT_ERROR.getMessage(), errorMsg));
            throw new KDException(PiaoZoneErrorCode.RETURNDATA_FORMAT_ERROR, new Object[]{url});
        }
        String url = URL.get();
        errorMsg = PiaoZoneErrorCode.RETURNDATA_FORMAT_ERROR.getMessage() + ResManager.loadKDString((String)"\u8c03\u7528\u7968\u65e0\u5fe7\u63a5\u53e3\uff1a", (String)"PiaoZoneApiService_0", (String)"scm-common", (Object[])new Object[0]) + url;
        log.error(errorMsg);
        throw new KDException(PiaoZoneErrorCode.CONT_CONNECT_SERVER, new Object[]{url});
    }

    protected void getPostData() {
        this.getHeadData();
        this.getAuthInfo();
    }

    protected void getHeadData() {
        this.param.put("authcode", CloudKingdeeApiUtil.getAuthcode(null));
        this.param.put("tid", PiaoZoneConfigration.getTID());
    }

    protected void getAuthInfo() {
        HashMap<String, String> authMap = new HashMap<String, String>(4);
        StringBuilder signatureSB = new StringBuilder();
        String timeStampStr = String.valueOf(System.currentTimeMillis());
        signatureSB.append(PiaoZoneConfigration.getClient_id()).append(timeStampStr).append(PiaoZoneConfigration.getClient_secret());
        authMap.put("client_id", PiaoZoneConfigration.getClient_id());
        authMap.put("signature", MD5Util.encode(signatureSB.toString()));
        authMap.put("timestamp", timeStampStr);
        this.param.put("sfrz", authMap);
    }
}

