/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.scm.common.service.IExcelDataEntityService;
import kd.scm.common.util.MetaDataUtil;
import kd.scm.common.util.excel.ExcelDataEntity;

public class ExcelDataEntityServiceImp
implements IExcelDataEntityService {
    @Override
    public ExcelDataEntity wrapExcelDataEntity(DynamicObjectCollection rows, Function<List<ControlAp<?>>, Object> preDealItems) throws IOException {
        String entityName = rows.getRootEntity().getDynamicObjectType().getName();
        String entryEntity = rows.getDynamicObjectType().getName();
        ExcelDataEntity excelDataEntity = new ExcelDataEntity();
        excelDataEntity.createSheet();
        String entityId = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List<ControlAp<?>> items = MetaDataUtil.getControlAps(formmeta, entitymeta, entryEntity);
        if (preDealItems != null) {
            preDealItems.apply(items);
        }
        this.setColumn(excelDataEntity, items);
        this.setHeader(excelDataEntity, items);
        this.setEexclBody(excelDataEntity, entitymeta, items, rows);
        excelDataEntity.setDataFormatForNumberic(0, 1, 1, rows.size());
        return excelDataEntity;
    }

    protected void setHeader(ExcelDataEntity excelDataEntity, List<ControlAp<?>> items) throws IOException {
        excelDataEntity.setExcelHeaderWithControlAp(items);
    }

    protected void setEexclBody(ExcelDataEntity excelDataEntity, EntityMetadata entitymeta, List<ControlAp<?>> items, DynamicObjectCollection rows) throws IOException {
        int index = 0;
        for (DynamicObject row : rows) {
            List<String> rowData = this.getRowDataByIndex(entitymeta, items, row);
            excelDataEntity.createRow(0, index + 1);
            excelDataEntity.setRowValue(0, rowData, index + 1);
            ++index;
        }
    }

    protected List<String> getRowDataByIndex(EntityMetadata entitymeta, List<ControlAp<?>> items, DynamicObject dyObj) {
        ArrayList<String> rowData = new ArrayList<String>(items.size());
        String val = null;
        String name = "name";
        if (items != null) {
            for (ControlAp<?> ap : items) {
                String key = ap.getKey();
                if (!(ap instanceof EntryFieldAp)) continue;
                Field item = ((EntryFieldAp)ap).getField();
                val = item instanceof BasedataPropField ? this.getBaseDataProp(entitymeta, item, dyObj) : (item instanceof BasedataField ? this.getBaseDataInfo(item, dyObj, name) : (item instanceof DecimalField ? this.getBigDecimalProp(dyObj, key) : this.getValueToString(item, dyObj, key)));
                rowData.add(val);
            }
        }
        return rowData;
    }

    protected String getValueToString(Field<?> item, DynamicObject dyObj, String key) {
        return dyObj.getString(key);
    }

    protected String getBigDecimalProp(DynamicObject dyObj, String key) {
        BigDecimal value = dyObj.getBigDecimal(key);
        if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
            return "";
        }
        return value.stripTrailingZeros().toPlainString();
    }

    protected String getBaseDataInfo(Field<?> item, DynamicObject dyObj, String name) {
        BasedataField field = (BasedataField)item;
        String column = field.getKey();
        String displayName = field.getDisplayProp();
        String numberProp = field.getNumberProp();
        String val = null;
        val = displayName.contains(numberProp) && displayName.contains(name) ? (displayName.startsWith(numberProp) ? dyObj.getString(column + "." + numberProp) + displayName.replace(numberProp, "").replace(name, "") + dyObj.getString(column + "." + name) : dyObj.getString(column + "." + name) + displayName.replace(numberProp, "").replace(name, "") + dyObj.getString(column + "." + numberProp)) : dyObj.getString(column + "." + displayName);
        return val;
    }

    protected String getBaseDataProp(EntityMetadata entitymeta, Field<?> item, DynamicObject dyObj) {
        EntityItem itemById = entitymeta.getItemById(((BasedataPropField)item).getRefBaseFieldId());
        String column = itemById.getKey() + "." + ((BasedataPropField)item).getRefDisplayProp();
        return dyObj.getString(column);
    }

    protected void setColumn(ExcelDataEntity excelDataEntity, List<ControlAp<?>> items) {
        ArrayList<String> columnList = new ArrayList<String>();
        if (items != null) {
            items.forEach(iDataEntityProperty -> columnList.add(iDataEntityProperty.getKey()));
        }
        if (excelDataEntity != null) {
            excelDataEntity.setColumnKeyList(columnList);
        }
    }
}

