/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.service.botp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.scm.common.service.botp.BotpService;
import kd.scm.common.service.botp.impl.EasBotpServiceImpl;
import kd.scm.common.service.botp.impl.RepcBotpServiceImpl;
import kd.scm.common.service.botp.impl.XhBotpServiceImpl;
import kd.scm.common.service.botp.impl.XkBotpServiceImpl;
import kd.scm.common.util.ApiConfigUtil;

public class BotpServiceFactory {
    private static final Map<String, BotpService> servicesMap = new ConcurrentHashMap<String, BotpService>();

    public static BotpService getBotpService() {
        String connectErp = ApiConfigUtil.getConnectErp();
        BotpService botpService = servicesMap.get(connectErp);
        if (botpService != null) {
            return botpService;
        }
        switch (connectErp) {
            case "eas": {
                botpService = new EasBotpServiceImpl();
                break;
            }
            case "k3cloud": {
                botpService = new XkBotpServiceImpl();
                break;
            }
            case "repc": {
                botpService = new RepcBotpServiceImpl();
                break;
            }
            default: {
                botpService = new XhBotpServiceImpl();
            }
        }
        servicesMap.put(connectErp, botpService);
        return botpService;
    }

    public static BotpService getBotpService(boolean isGoodsBizType) {
        if (isGoodsBizType) {
            BotpService botpService = servicesMap.get("0");
            if (botpService == null) {
                botpService = new XhBotpServiceImpl();
                servicesMap.put("0", botpService);
            }
            return botpService;
        }
        return BotpServiceFactory.getBotpService();
    }

    public static BotpService getBotpService(boolean isGoodsBizType, boolean isRepcSource) {
        if (isRepcSource) {
            return new RepcBotpServiceImpl();
        }
        return BotpServiceFactory.getBotpService(isGoodsBizType);
    }
}

