/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.service.botp.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.isc.util.IerpIscEasSend;
import kd.scm.common.service.botp.BotpService;
import kd.scm.common.service.botp.entity.BotpPushArgs;
import kd.scm.common.service.botp.entity.BotpResult;
import kd.scm.common.service.botp.entity.BotpRule;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.ParamUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class EasBotpServiceImpl
implements BotpService {
    private static final Log log = LogFactory.getLog((String)EasBotpServiceImpl.class.getName());
    private static final String BOTPQUERY = "botpQuery";

    @Override
    public List<BotpRule> getRuleList(String srcEntity, String tarEntity, Map<String, Object> customParam) {
        ArrayList<BotpRule> lists = new ArrayList<BotpRule>();
        HashMap<String, Object> wrapParam = new HashMap<String, Object>();
        customParam.put("srctype", srcEntity);
        customParam.put("targetBillType", tarEntity);
        wrapParam.put("data", customParam);
        if (this.isEmpty(customParam)) {
            return lists;
        }
        try {
            HashMap<String, Object> iscLinkInfomap = new HashMap<String, Object>(8);
            Object isclinknumber = customParam.get("isclinknumber");
            if (isclinknumber != null) {
                iscLinkInfomap.put("number", isclinknumber);
            } else {
                Object iscbLink = ParamUtil.getParamObj("eae607fb000143ac", "isclink");
                String number = String.valueOf(((Map)iscbLink).get("number"));
                iscLinkInfomap.put("number", number);
            }
            IerpIscEasSend ierpIscEasSend = new IerpIscEasSend();
            log.info("\u8f6c\u6362\u89c4\u5219\u67e5\u8be2\u53c2\u6570wrapParam={}", (Object)JSON.toJSONString(wrapParam));
            String resStr = ierpIscEasSend.doExec(wrapParam, BOTPQUERY, iscLinkInfomap);
            log.info("\u8f6c\u6362\u89c4\u5219\u67e5\u8be2\u7ed3\u679cresStr={}", (Object)resStr);
            if (!StringUtils.isEmpty((CharSequence)resStr) && !"[]".equals(resStr) && resStr.startsWith("[")) {
                JSONArray resJa = JSONArray.fromObject((Object)resStr);
                for (int i = 0; i < resJa.size(); ++i) {
                    JSONObject jo = resJa.getJSONObject(i);
                    Object error = jo.get("error");
                    if (error != null && !"".equals(error)) {
                        log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002");
                        return lists;
                    }
                    BotpRule botpRule = new BotpRule();
                    botpRule.setId(jo.getString("number"));
                    botpRule.setName(new LocaleString(jo.getString("alias")));
                    botpRule.setEnabled(true);
                    Object isDefault = jo.get("isdefault");
                    if (isDefault != null && !"".equals(isDefault)) {
                        botpRule.setDefRule(Boolean.parseBoolean(isDefault.toString()));
                    } else {
                        botpRule.setDefRule(false);
                    }
                    botpRule.setAutoSave(true);
                    botpRule.setSrcEntity(srcEntity);
                    botpRule.setTarEntity(tarEntity);
                    lists.add(botpRule);
                }
            } else {
                log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002");
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        log.info("\u8f6c\u6362\u89c4\u5219\u67e5\u8be2\u5c01\u88c5\u7ed3\u679clists={}", (Object)JSON.toJSONString(lists));
        return lists;
    }

    @Override
    public BotpResult push(BotpPushArgs pushArgs) {
        BotpResult res = new BotpResult();
        if (!CollectionUtils.isEmpty(pushArgs.getDataMap())) {
            Map<String, Object> data = pushArgs.getDataMap();
            data.put("botpNumber", pushArgs.getRuleId());
            data.put("source", pushArgs.getSource());
            HashMap<String, Object> wrapParam = new HashMap<String, Object>();
            wrapParam.put("data", data);
            ApiUtil.putUserNUmberData(wrapParam);
            Object iscbLink = ParamUtil.getParamObj("eae607fb000143ac", "iscblink");
            IerpIscEasSend ierpIscEasSend = new IerpIscEasSend();
            log.info("\u8f6c\u6362\u89c4\u5219\u4e0b\u63a8\u53c2\u6570wrapParam={}", (Object)JSON.toJSONString(wrapParam));
            String resStr = ierpIscEasSend.doExec(wrapParam, pushArgs.getActionName(), iscbLink);
            log.info("\u8f6c\u6362\u89c4\u5219\u4e0b\u63a8\u7ed3\u679cresStr={}", (Object)resStr);
            if (resStr != null) {
                res.setSucced(true);
            } else {
                res.setSucced(false);
            }
            res.setMessage(resStr);
        }
        return res;
    }
}

