/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.service.botp.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.service.botp.BotpService;
import kd.scm.common.service.botp.entity.BotpPushArgs;
import kd.scm.common.service.botp.entity.BotpResult;
import kd.scm.common.service.botp.entity.BotpRule;

public class XhBotpServiceImpl
implements BotpService {
    private static Log log = LogFactory.getLog(XhBotpServiceImpl.class);

    @Override
    public List<BotpRule> getRuleList(String srcEntity, String tarEntity, Map<String, Object> customParam) {
        ArrayList<BotpRule> lists = new ArrayList<BotpRule>();
        List ruleList = ConvertMetaServiceHelper.loadRules((String)srcEntity, (String)tarEntity);
        log.info("\u8f6c\u6362\u89c4\u5219\u67e5\u8be2\u5c01\u88c5\u7ed3\u679cruleList={}", (Object)JSON.toJSONString((Object)ruleList));
        if (!ruleList.isEmpty()) {
            for (ConvertRuleElement convertRuleElement : ruleList) {
                BotpRule botpRule = new BotpRule();
                botpRule.setId(convertRuleElement.getId());
                botpRule.setName(convertRuleElement.getName());
                botpRule.setEnabled(convertRuleElement.isEnabled());
                botpRule.setDefRule(convertRuleElement.isDefRule());
                botpRule.setAutoSave(convertRuleElement.isAutoSave());
                botpRule.setSrcEntity(srcEntity);
                botpRule.setTarEntity(tarEntity);
                lists.add(botpRule);
            }
        }
        log.info("\u8f6c\u6362\u89c4\u5219\u67e5\u8be2\u5c01\u88c5\u7ed3\u679clists={}", (Object)JSON.toJSONString(lists));
        return lists;
    }

    @Override
    public BotpResult push(BotpPushArgs pushArgs) {
        BotpResult botpResult = new BotpResult();
        log.info("\u8f6c\u6362\u89c4\u5219\u4e0b\u63a8\u53c2\u6570pushArgs={}", (Object)JSON.toJSONString((Object)((Object)pushArgs)));
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        List billReports = result.getBillReports();
        Integer rowFailCount = 0;
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < billReports.size(); ++i) {
            SourceBillReport row = (SourceBillReport)billReports.get(i);
            if (row.getFailRowCount() > 0) {
                rowFailCount = rowFailCount + row.getFailRowCount();
            }
            message.append(ResManager.loadKDString((String)"\u5355\u636e", (String)"XhBotpServiceImpl_2", (String)"scm-common", (Object[])new Object[0])).append('[');
            if (!StringUtils.isEmpty((String)row.getBillNo())) {
                message.append(row.getBillNo());
            } else {
                message.append(row.getBillId());
            }
            message.append(']').append(row.getFailMessage()).append("\r\n");
        }
        botpResult.setRowFailCount(rowFailCount);
        if (rowFailCount == 0) {
            botpResult.setMessage("ok");
        } else {
            botpResult.setMessage(message.toString());
        }
        log.info("\u8f6c\u6362\u89c4\u5219\u4e0b\u63a8\u7ed3\u679cresult={}", (Object)JSON.toJSONString((Object)result));
        if (result.isSuccess()) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
            IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
            List<DynamicObject> targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            result.release(refDataProvider, mainType);
            List<DynamicObject> targetDataAll = null;
            if (botpResult.getTargetData() == null) {
                targetDataAll = targetData;
            } else {
                targetDataAll = botpResult.getTargetData();
                targetDataAll.addAll(targetData);
            }
            for (DynamicObject bill : targetData) {
                String billNo = CodeRuleServiceHelper.getNumber((String)pushArgs.getTargetEntityNumber(), (DynamicObject)bill, (String)bill.getDynamicObject(EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber()).getMainOrg()).getString("id"));
                if (billNo == null || billNo.isEmpty()) continue;
                bill.set("billno", (Object)billNo);
            }
            botpResult.setTargetData(targetDataAll);
            botpResult.setSucced(Boolean.TRUE);
        } else {
            botpResult.setSucced(Boolean.FALSE);
            botpResult.setMessage(message.toString());
            log.info("@@@\u5355\u636e\u8f6c\u6362\u5f02\u5e38\uff1aruleId:{},source:{},target:{}", new Object[]{pushArgs.getRuleId(), pushArgs.getSourceEntityNumber(), pushArgs.getTargetEntityNumber(), result.getMessage()});
        }
        return botpResult;
    }
}

