/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.skyeye;

import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.httpsutil.HttpClientUtil;
import kd.scm.common.skyeye.config.QiChaChaConfig;
import kd.scm.common.skyeye.enums.SkyEyeTypeEnum;
import kd.scm.common.skyeye.utils.HeaderUtils;
import kd.scm.common.util.ExceptionUtil;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;

public class QiChaChaApiUtil {
    private static Log log = LogFactory.getLog(QiChaChaApiUtil.class);

    public static String getResponseResult(String keyword) {
        String result = "";
        try {
            if (StringUtils.isBlank((CharSequence)QiChaChaConfig.getHOST()) || StringUtils.isBlank((CharSequence)QiChaChaConfig.getClient_id()) || StringUtils.isBlank((CharSequence)QiChaChaConfig.getClient_secret())) {
                QiChaChaConfig.initConfig();
            }
            HashMap<String, String> headerMap = new HashMap<String, String>();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            int tokenId = 0;
            int timespanId = 1;
            String[] autherHeader = QiChaChaApiUtil.RandomAuthentHeader(QiChaChaConfig.getClient_id(), QiChaChaConfig.getClient_secret());
            headerMap.put("Token", autherHeader[tokenId]);
            headerMap.put("Timespan", autherHeader[timespanId]);
            headerMap.putAll(HeaderUtils.getHeaders(null, SkyEyeTypeEnum.QICHACHA.getVal()));
            paramMap.put("key", QiChaChaConfig.getClient_id());
            paramMap.put("keyword", keyword);
            paramMap.put("dtype", "json");
            result = HttpClientUtil.doGet(QiChaChaConfig.getHOST(), paramMap, headerMap);
            log.info("\u4f01\u67e5\u67e5\u63a5\u53e3\u8fd4\u56dejson:" + result);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4f01\u67e5\u67e5\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace(e));
        }
        return result;
    }

    public static boolean verifySupplier(String companyName, String creditCode) {
        JSONObject detail;
        JSONObject node;
        boolean passCheck = false;
        String strJson = QiChaChaApiUtil.getResponseResult(companyName);
        if (StringUtils.isNotBlank((CharSequence)strJson) && StringUtils.equals((CharSequence)(node = JSONObject.fromObject((Object)strJson)).getString("Status"), (CharSequence)"200") && StringUtils.equals((CharSequence)companyName, (CharSequence)(detail = node.getJSONObject("Result")).optString("Name")) && StringUtils.equals((CharSequence)creditCode, (CharSequence)detail.optString("CreditCode"))) {
            passCheck = true;
        }
        return passCheck;
    }

    protected static final String[] RandomAuthentHeader(String appkey, String seckey) {
        String timeSpan = String.valueOf(System.currentTimeMillis() / 1000L);
        String[] authentHeaders = new String[]{DigestUtils.md5Hex((String)appkey.concat(timeSpan).concat(seckey)).toUpperCase(), timeSpan};
        return authentHeaders;
    }
}

