/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.skyeye.service.impl;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.httpsutil.HttpClientUtil;
import kd.scm.common.skyeye.config.SkyEyeConfig;
import kd.scm.common.skyeye.entity.CompanyInfo;
import kd.scm.common.skyeye.entity.Data;
import kd.scm.common.skyeye.entity.JsonRootBean;
import kd.scm.common.skyeye.enums.SkyEyeTypeEnum;
import kd.scm.common.skyeye.service.ISearchService;
import kd.scm.common.skyeye.utils.HeaderUtils;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import org.apache.commons.lang3.StringUtils;

public class SearchServiceImpl
implements ISearchService {
    private static Log log = LogFactory.getLog(SearchServiceImpl.class);
    private final String DEFAULT_PAGE_NUM = "1";
    private final String DEFAULT_PAGE_SIZE = "20";
    private final String DEFAULT_SORT_TYPE = "0";

    @Override
    public List<CompanyInfo> getSearchResult(String companyName, String pageNum, String pageSize, String sortType) {
        List companyList = null;
        try {
            if (StringUtils.isBlank((CharSequence)companyName)) {
                return null;
            }
            if (StringUtils.isBlank((CharSequence)SkyEyeConfig.getHOST()) || StringUtils.isBlank((CharSequence)SkyEyeConfig.getClient_secret())) {
                SkyEyeConfig.initConfig();
            }
            Map<String, String> headers = HeaderUtils.getHeaders(SkyEyeConfig.getClient_secret(), SkyEyeTypeEnum.SKYEYE.getVal());
            Map<String, String> paramsMap = this.getParamsMap(pageNum, pageSize, sortType);
            String result = HttpClientUtil.doGet(SkyEyeConfig.getHOST() + URLEncoder.encode(companyName), paramsMap, headers);
            log.info("\u5929\u773c\u67e5\u8fd4\u56dejson" + result);
            JsonRootBean jsonRootBean = JacksonJsonUtil.fromJson(result, JsonRootBean.class);
            Data data = jsonRootBean.getData();
            companyList = Optional.ofNullable(data.getCompanyList()).orElseGet(ArrayList::new);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5929\u773c\u67e5\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace(e));
        }
        return companyList;
    }

    @Override
    public List<CompanyInfo> getSearchResult(String companyName, String pageNum, String pageSize) {
        return this.getSearchResult(companyName, pageNum, pageSize, null);
    }

    @Override
    public List<CompanyInfo> getSearchResult(String companyName) {
        return this.getSearchResult(companyName, null, null, null);
    }

    private Map<String, String> getParamsMap(String pageNum, String pageSize, String sortType) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)pageNum)) {
            map.put("pageNum", this.DEFAULT_PAGE_NUM);
        } else {
            map.put("pageNum", pageNum);
        }
        map.put("pageSize", this.DEFAULT_PAGE_SIZE);
        if (StringUtils.isBlank((CharSequence)sortType)) {
            map.put("sortType", this.DEFAULT_SORT_TYPE);
        } else {
            map.put("sortType", sortType);
        }
        return map;
    }
}

