/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.splitrow;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.splitrow.SplitRowServiceHelper;

public abstract class AbstractSplitRowClickBillPlugin
extends AbstractBillPlugIn {
    private static Log log = LogFactory.getLog(AbstractSplitRowClickBillPlugin.class);
    private String splitRowField;
    private String opKeyField;
    private String advContoolBarApField;
    private String entityEntryField;

    public abstract void initConfig();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initConfig();
        this.addItemClickListeners(new String[]{this.advContoolBarApField, this.splitRowField});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if (this.opKeyField.equals(operationKey)) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(this.entityEntryField);
            int[] selectRows = grid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractSplitRowClickBillPlugin_1", (String)"scm-common", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("billkey", this.getModel().getDataEntityType().getName());
            param.put("entrykey", this.entityEntryField);
            param.put("selectrowindex", selectRows[0]);
            param.put("pageId", this.getView().getPageId());
            formShowParameter.setCustomParam("param", param);
            formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "splitrowbtnok"));
            formShowParameter.setFormId("pbd_splitrow_param");
            this.getView().showForm(formShowParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "splitrowbtnok": {
                Map selectReturnData = (Map)closedCallBackEvent.getReturnData();
                if (null == selectReturnData) {
                    return;
                }
                String billKey = String.valueOf(selectReturnData.get("billkey"));
                String entryKey = String.valueOf(selectReturnData.get("entrykey"));
                Integer selectRowIndex = (Integer)selectReturnData.get("selectrowindex");
                String createtype = String.valueOf(selectReturnData.get("createtype"));
                Integer rowCount = (Integer)selectReturnData.get("rowcount");
                if (rowCount <= 1 || rowCount > 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c6\u5206\u884c\u6570\u5fc5\u987b\u4e3a2\u5230100\u884c\u3002", (String)"AbstractSplitRowClickBillPlugin_4", (String)"scm-common", (Object[])new Object[0]));
                    return;
                }
                try {
                    IDataModel model = this.getModel();
                    DynamicObject dataEntity = model.getDataEntity(true);
                    model.beginInit();
                    SplitRowServiceHelper.spiltEntryRow(billKey, entryKey, selectRowIndex, createtype, rowCount, dataEntity);
                    break;
                }
                catch (Exception e1) {
                    log.error((Throwable)e1);
                    this.getView().showErrorNotification(e1.getMessage());
                    return;
                }
                finally {
                    this.getModel().endInit();
                    this.getView().updateView();
                }
            }
        }
    }

    public void setSplitRowField(String splitRowField) {
        this.splitRowField = splitRowField;
    }

    public void setOpKeyField(String opKeyField) {
        this.opKeyField = opKeyField;
    }

    public void setAdvContoolBarApField(String advContoolBarApField) {
        this.advContoolBarApField = advContoolBarApField;
    }

    public void setEntityEntryField(String entityEntryField) {
        this.entityEntryField = entityEntryField;
    }
}

