/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.splitrow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.splitrow.ISplitRowParamService;
import kd.scm.common.splitrow.SplitRowModel;
import kd.scm.common.splitrow.SplitRowParamDTO;
import kd.scm.common.util.MetaDataUtil;

public class SplitRowUtils {
    public void spiltEntryRow(String billKey, String entryKey, Integer selectRowIndex, String createtype, Integer rowCount, DynamicObject dataEntity) throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>(8);
        this.initConfig(billKey, entryKey, config);
        String relationconfig = (String)config.get("relationconfig");
        String pluginName = (String)config.get("pluginname");
        List pbdSplitRowModels = (List)config.get("splitrowmodels");
        if (CollectionUtils.isEmpty((Collection)pbdSplitRowModels)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u62c6\u5206\u6570\u636e,\u8bf7\u8054\u7cfb\u5ba2\u670d\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"AbstractSplitRowClickBillPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        List<Integer> newRowIndex = this.executeEntryRowOp(dataEntity, entryKey, relationconfig, createtype, rowCount, selectRowIndex, pbdSplitRowModels);
        this.excutePlugin(dataEntity, entryKey, pluginName, selectRowIndex, newRowIndex, pbdSplitRowModels);
    }

    private void initConfig(String billKey, String entryKey, Map<String, Object> config) {
        ArrayList<SplitRowModel> pbdSplitRowModels = new ArrayList<SplitRowModel>();
        String selectFields = "billno,billstatus,billkey,entrykey,relationconfig,pluginname,entryentity.currentmetadata,entryentity.currentmetadatakey,entryentity.copyrow,entryentity.splitrow,entryentity.defaultrow,entryentity.defaultvalue";
        String PBDSPLITROW = "pbd_splitrow";
        QFilter prodfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        prodfilter.and(new QFilter("entrykey", "=", (Object)entryKey));
        prodfilter.and(new QFilter("billkey", "=", (Object)billKey));
        DynamicObject[] destArray = BusinessDataServiceHelper.load((String)PBDSPLITROW, (String)selectFields, (QFilter[])new QFilter[]{prodfilter});
        if (destArray.length > 0) {
            config.put("pluginname", destArray[0].getString("pluginname"));
            config.put("relationconfig", destArray[0].getString("relationconfig"));
            DynamicObjectCollection entryCollection = destArray[0].getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCollection) {
                SplitRowModel model = new SplitRowModel();
                model.setCurrentMetadata(entry.getString("currentmetadata"));
                model.setCurrentMetadataKey(entry.getString("currentmetadatakey"));
                model.setDefaultValue(entry.getString("defaultvalue"));
                Boolean splitRow = entry.getBoolean("splitrow");
                Boolean defaultRow = entry.getBoolean("defaultrow");
                Boolean copyRow = entry.getBoolean("copyrow");
                model.setSplitRow(splitRow);
                model.setCopyRow(copyRow);
                model.setDefaultRow(defaultRow);
                pbdSplitRowModels.add(model);
            }
            config.put("splitrowmodels", pbdSplitRowModels);
        }
    }

    private void excutePlugin(DynamicObject dataEntity, String entryKey, String pluginName, int selectRowIndex, List<Integer> newRowIndex, List<SplitRowModel> pbdSplitRowModels) throws Exception {
        SplitRowParamDTO splitRowParamArgs = new SplitRowParamDTO();
        splitRowParamArgs.setDataEntity(dataEntity);
        splitRowParamArgs.setEntryKey(entryKey);
        splitRowParamArgs.setSrcRowIndex(selectRowIndex);
        splitRowParamArgs.setNewRowIndex(newRowIndex);
        splitRowParamArgs.setPbdSplitRowModels(pbdSplitRowModels);
        if (!StringUtils.isNotEmpty((String)pluginName)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\u201c{0}\u201d\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u63d2\u4ef6\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3\u201c{1}\u201d\u3002", (String)"AbstractSplitRowClickBillPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]), pluginName, "kd.scm.common.splitrow.ISplitRowParamService"));
        }
        Class<?> pluginClass = Class.forName(pluginName);
        ISplitRowParamService calQtyPlugin = (ISplitRowParamService)pluginClass.newInstance();
        calQtyPlugin.calSplitRowFields(splitRowParamArgs);
    }

    private List<Integer> executeEntryRowOp(DynamicObject dataEntity, String entryKey, String relationconfig, String createtype, int rowcount, int selectRowIndex, List<SplitRowModel> pbdSplitRowModels) {
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection(entryKey);
        int entryRowCount = entrys.getRowCount();
        int index = this.setIndex(createtype, selectRowIndex, entryRowCount);
        DynamicObjectCollection entryLk = null;
        if (this.isDrawByBOTP(dataEntity, entryKey, relationconfig)) {
            entryLk = this.getSrcRowRelation(selectRowIndex, entrys, entryKey, relationconfig);
        }
        String name = dataEntity.getDataEntityType().getName();
        Map<String, Control> controlMap = this.getControlMap(name);
        EntryProp entryProp = (EntryProp)dataEntity.getDataEntityType().getProperties().get((Object)entryKey);
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObject selectDy = (DynamicObject)entrys.get(selectRowIndex);
        ArrayList<Integer> newEntryRowIndex = new ArrayList<Integer>(rowcount);
        for (int i = 0; i < rowcount - 1; ++i) {
            DynamicObject newDy = new DynamicObject((DynamicObjectType)entryType);
            entrys.add(index + i, newDy);
            for (SplitRowModel splitRowModel : pbdSplitRowModels) {
                boolean isCopyRow = splitRowModel.getCopyRow();
                boolean isDefaultRow = splitRowModel.getDefaultRow();
                if (!isCopyRow && !isDefaultRow) continue;
                String currentMetaDataKey = splitRowModel.getCurrentMetadataKey();
                Boolean defaultRow = splitRowModel.getDefaultRow();
                if (defaultRow != null && defaultRow.booleanValue()) {
                    String defaultValue = splitRowModel.getDefaultValue();
                    newDy.set(currentMetaDataKey, (Object)defaultValue);
                    continue;
                }
                Control control = controlMap.get(currentMetaDataKey);
                if (control instanceof BasedataPropEdit) continue;
                if (control instanceof DateRangeEdit) {
                    String startDateFieldKey = ((DateRangeEdit)control).getStartDateFieldKey();
                    String endDateFieldKey = ((DateRangeEdit)control).getEndDateFieldKey();
                    Object startDateField = selectDy.get(startDateFieldKey);
                    newDy.set(startDateFieldKey, startDateField);
                    Object endDateField = selectDy.get(endDateFieldKey);
                    newDy.set(endDateFieldKey, endDateField);
                    continue;
                }
                Object srcValue = selectDy.get(currentMetaDataKey);
                newDy.set(currentMetaDataKey, srcValue);
            }
            newEntryRowIndex.add(index + i);
            this.setEntryRelation(dataEntity, entryKey, index + i, entryLk, relationconfig);
        }
        return newEntryRowIndex;
    }

    private int setIndex(String createtype, int selectRowIndex, int entryRowCount) {
        int index = "1".equals(createtype) ? selectRowIndex + 1 : entryRowCount;
        return index;
    }

    private Map<String, Control> getControlMap(String name) {
        FormMetadata formMetaData = MetaDataUtil.getFormMetaData(name);
        List items = formMetaData.getItems();
        HashMap<String, Control> controlMap = new HashMap<String, Control>(8);
        for (ControlAp controlAp : items) {
            Control control = controlAp.buildRuntimeControl();
            controlMap.put(controlAp.getKey(), control);
        }
        return controlMap;
    }

    private boolean isDrawByBOTP(DynamicObject bill, String entryKey, String relationconfig) {
        MainEntityType type;
        IDataEntityProperty dataEntityProperty;
        int size;
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
        if (entrys == null || (size = entrys.size()) == 0) {
            return false;
        }
        String name = bill.getDataEntityType().getName();
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)name);
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)relationconfig)) {
            entryKey = relationconfig;
        }
        String linkEntityKey = entryKey + "_lk";
        List items = linkSet.getItems();
        for (LinkSetItemElement item : items) {
            if (!entryKey.equals(item.getParentEntityKey())) continue;
            linkEntityKey = item.getLinkEntityKey();
            break;
        }
        if ((dataEntityProperty = (type = EntityMetadataCache.getDataEntityType((String)name)).findProperty(linkEntityKey)) == null) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection linkColl = entry.getDynamicObjectCollection(linkEntityKey);
            if (linkColl == null || linkColl.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private DynamicObjectCollection getSrcRowRelation(int selectRowIndex, DynamicObjectCollection entrys, String entryKey, String relationconfig) {
        DynamicObject selectedEntry = (DynamicObject)entrys.get(selectRowIndex);
        if (StringUtils.isNotEmpty((String)relationconfig)) {
            entryKey = relationconfig;
        }
        return selectedEntry.getDynamicObjectCollection(entryKey + "_lk");
    }

    private void setEntryRelation(DynamicObject dataEntity, String entryKey, int index, DynamicObjectCollection entryLks, String relationconfig) {
        if (entryLks == null || entryLks.isEmpty()) {
            return;
        }
        DynamicObject entry = (DynamicObject)dataEntity.getDynamicObjectCollection(entryKey).get(index);
        if (StringUtils.isNotEmpty((String)relationconfig)) {
            entryKey = relationconfig;
        }
        DynamicObjectCollection newEntryLk = entry.getDynamicObjectCollection(entryKey + "_lk");
        for (DynamicObject entryLk : entryLks) {
            DynamicObject newLk = new DynamicObject(entryLk.getDynamicObjectType());
            newLk.set(entryKey + "_lk_stableid", entryLk.get(entryKey + "_lk_stableid"));
            newLk.set(entryKey + "_lk_sbillid", entryLk.get(entryKey + "_lk_sbillid"));
            newLk.set(entryKey + "_lk_sid", entryLk.get(entryKey + "_lk_sid"));
            newEntryLk.add((Object)newLk);
        }
    }
}

