/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.store;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleLogHelper;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;
import kd.scm.common.store.SRMStoreDataTraceStackHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ParamConfigUtil;

public final class SRMStoreDataTraceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] saveStoreData(DynamicObject[] dynamicObjects) {
        Boolean srmstorestacktrace = ParamConfigUtil.getCacheBooleanParamConfig("srmstorestacktrace");
        Object[] saveObjects = new Object[]{};
        if (srmstorestacktrace.booleanValue()) {
            ScDataHandleLogInfo scDataHandleLogInfo = SRMStoreDataTraceHelper.getLogInfo();
            scDataHandleLogInfo.setOperateDesc("saveStoreData");
            SRMStoreDataTraceStackHelper.assembleStack(scDataHandleLogInfo);
            try {
                SRMStoreDataTraceHelper.assembleChangeData(scDataHandleLogInfo, dynamicObjects);
                saveObjects = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                scDataHandleLogInfo.setResult("success");
                scDataHandleLogInfo.setResultTag("success");
            }
            catch (Throwable throwable) {
                scDataHandleLogInfo.setResult(throwable.getMessage() != null ? throwable.getMessage() : "faild");
                scDataHandleLogInfo.setResultTag(ExceptionUtil.getStackTrace(throwable));
                scDataHandleLogInfo.setModifyTime(TimeServiceHelper.now());
                scDataHandleLogInfo.setModifier(RequestContext.get().getCurrUserId());
            }
            finally {
                if (saveObjects.length <= 0) {
                    saveObjects = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                }
                ScDataHandleLogHelper.fireInfoScDataLog(scDataHandleLogInfo);
            }
        } else {
            saveObjects = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        return saveObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateStoreData(DynamicObject[] dynamicObjects) {
        Boolean srmstorestacktrace = ParamConfigUtil.getCacheBooleanParamConfig("srmstorestacktrace");
        if (srmstorestacktrace.booleanValue()) {
            ScDataHandleLogInfo scDataHandleLogInfo = SRMStoreDataTraceHelper.getLogInfo();
            scDataHandleLogInfo.setOperateDesc("updateStoreData");
            SRMStoreDataTraceStackHelper.assembleStack(scDataHandleLogInfo);
            try {
                SRMStoreDataTraceHelper.assembleChangeData(scDataHandleLogInfo, dynamicObjects);
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
                scDataHandleLogInfo.setResult("success");
                scDataHandleLogInfo.setResultTag("success");
            }
            catch (Throwable throwable) {
                scDataHandleLogInfo.setResult(throwable.getMessage() != null ? throwable.getMessage() : "faild");
                scDataHandleLogInfo.setResultTag(ExceptionUtil.getStackTrace(throwable));
                scDataHandleLogInfo.setModifyTime(TimeServiceHelper.now());
                scDataHandleLogInfo.setModifier(RequestContext.get().getCurrUserId());
            }
            finally {
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
                ScDataHandleLogHelper.fireInfoScDataLog(scDataHandleLogInfo);
            }
        } else {
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    private static ScDataHandleLogInfo assembleChangeData(ScDataHandleLogInfo scDataHandleLogInfo, DynamicObject[] dynamicObjects) {
        ArrayList dataOfMapList = new ArrayList(dynamicObjects.length);
        LinkedHashMap<String, Object> dataMap = null;
        LinkedHashMap<String, Object> dataRowMap = null;
        for (DynamicObject bill : dynamicObjects) {
            DataEntityState dataEntityState;
            DynamicProperty number;
            dataMap = new LinkedHashMap<String, Object>(50);
            dataMap.put("pkvalue", bill.getPkValue());
            DynamicProperty billno = bill.getDynamicObjectType().getProperty("billno");
            if (billno != null) {
                dataMap.put(billno.getDisplayName().getLocaleValue(), billno.getValue((Object)bill));
            }
            if ((number = bill.getDynamicObjectType().getProperty("number")) != null) {
                dataMap.put(number.getDisplayName().getLocaleValue(), number.getValue((Object)bill));
            }
            if ((dataEntityState = bill.getDataEntityState()).isChanged()) {
                for (IDataEntityProperty dataEntityProperty : dataEntityState.getBizChangedProperties()) {
                    String proName = dataEntityProperty.getDisplayName() != null ? dataEntityProperty.getDisplayName().getLocaleValue() : dataEntityProperty.getName();
                    dataMap.put(proName, dataEntityProperty.getValue((Object)bill));
                }
            }
            HashSet entrySet = new HashSet(3);
            BillEntityType billEntityType = (BillEntityType)bill.getDynamicObjectType();
            if (billEntityType != null) {
                scDataHandleLogInfo.setEntityDesc(billEntityType.getDisplayName().getLocaleValue() + "(" + billEntityType.getName() + ")");
                for (Map.Entry entry : billEntityType.getAllEntities().entrySet()) {
                    if (((String)entry.getKey()).equals(billEntityType.getName()) || !((EntityType)entry.getValue()).getClass().equals(EntryType.class)) continue;
                    entrySet.add(entry.getKey());
                }
            }
            for (String string : entrySet) {
                DynamicObjectCollection collection = bill.getDynamicObjectCollection(string);
                EntryType entryType = (EntryType)collection.getDynamicObjectType();
                String entryDisName = entryType.getDisplayName().getLocaleValue();
                IDataEntityProperty seqProperty = entryType.getSeqProperty();
                for (DynamicObject row : collection) {
                    dataRowMap = new LinkedHashMap<String, Object>(50);
                    DataEntityState rowDataEntityState = row.getDataEntityState();
                    if (rowDataEntityState.isChanged()) {
                        for (IDataEntityProperty dataEntityProperty : rowDataEntityState.getBizChangedProperties()) {
                            String proName = dataEntityProperty.getDisplayName() != null ? dataEntityProperty.getDisplayName().getLocaleValue() : dataEntityProperty.getName();
                            dataRowMap.put(entryDisName + "." + proName, dataEntityProperty.getValue((Object)row));
                        }
                    }
                    StringBuilder entryKey = new StringBuilder(String.valueOf(row.getPkValue()));
                    if (seqProperty != null) {
                        entryKey.append(String.valueOf(seqProperty.getValue((Object)row)));
                    }
                    if (dataRowMap.isEmpty()) continue;
                    dataMap.put(entryKey.toString(), dataRowMap);
                }
            }
            dataOfMapList.add(dataMap);
        }
        String stackJson = SerializationUtils.toJsonString(dataOfMapList);
        scDataHandleLogInfo.setParams(stackJson);
        scDataHandleLogInfo.setParamsTag(stackJson);
        return scDataHandleLogInfo;
    }

    private static synchronized ScDataHandleLogInfo getLogInfo() {
        ScDataHandleLogInfo scDataHandleLogInfo = new ScDataHandleLogInfo();
        scDataHandleLogInfo.setId(DBServiceHelper.genStringId());
        scDataHandleLogInfo.setEntityDesc("SRMStoreDataTraceHelper");
        scDataHandleLogInfo.setLogAppId("pur");
        scDataHandleLogInfo.setLogType("successlog");
        scDataHandleLogInfo.setLogDim("storestacktrace");
        scDataHandleLogInfo.setState("success");
        try {
            String userName = RequestContext.get().getUserName();
            scDataHandleLogInfo.setUserName(userName == null || userName.isEmpty() ? "administrator" : userName);
        }
        catch (RuntimeException exception) {
            scDataHandleLogInfo.setUserName("administrator");
        }
        try {
            scDataHandleLogInfo.setCreator(RequestContext.get().getCurrUserId());
        }
        catch (RuntimeException exception) {
            scDataHandleLogInfo.setCreator(1L);
        }
        scDataHandleLogInfo.setTraceId(RequestContext.get().getTraceId());
        scDataHandleLogInfo.setCreateTime(TimeServiceHelper.now());
        return scDataHandleLogInfo;
    }
}

