/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.store;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.instance.Instance;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;

public final class SRMStoreDataTraceStackHelper {
    public static ScDataHandleLogInfo assembleStack(ScDataHandleLogInfo scDataHandleLogInfo) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int stackTraceDepth = stackTraceElements.length >= Integer.MAX_VALUE ? Integer.MAX_VALUE : stackTraceElements.length;
        ArrayList stackTraceMapList = new ArrayList(stackTraceDepth);
        HashMap<String, Object> stackTraceMap = null;
        try {
            stackTraceMap = new HashMap<String, Object>(3);
            stackTraceMap.put("clusterName", Instance.getClusterName());
            stackTraceMap.put("AppName", Instance.getAppName());
            stackTraceMap.put("InstanceId", Instance.getInstanceId());
            stackTraceMapList.add(stackTraceMap);
        }
        catch (Exception exception) {
            stackTraceMap = new HashMap(3);
            stackTraceMap.put("Exception", exception.getClass().getName());
            stackTraceMapList.add(stackTraceMap);
        }
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            stackTraceMap = new HashMap();
            stackTraceMap.put("ClassName", stackTraceElement.getClassName());
            stackTraceMap.put("MethodName", stackTraceElement.getMethodName());
            stackTraceMap.put("LineNumber", stackTraceElement.getLineNumber());
            stackTraceMapList.add(stackTraceMap);
        }
        String stackJson = SerializationUtils.toJsonString(stackTraceMapList);
        scDataHandleLogInfo.setConfig(stackJson);
        scDataHandleLogInfo.setConfigTag(stackJson);
        return scDataHandleLogInfo;
    }
}

