/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.systemjoint;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.systemjoint.ISystemJointService;

public final class CosmicCloudSystemJointService
implements ISystemJointService {
    private static final Log log = LogFactory.getLog(CosmicCloudSystemJointService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeStdMServiceSend(String cloudId, String appId, String serviceName, String methodName, Object ... params) {
        if (log.isInfoEnabled()) {
            StringBuilder paramString = new StringBuilder();
            for (Object param : params) {
                try {
                    paramString.append(SerializationUtils.toJsonString((Object)param)).append(";");
                }
                catch (Throwable throwable) {
                    log.warn("throwable:message:{},exceptionType:{}", (Object)String.valueOf(throwable), (Object)throwable.getClass().getName());
                }
            }
            log.info("cloudId:{},appId:{},serviceName:{},methodName:{},paramString:{}", new Object[]{cloudId, appId, serviceName, methodName, paramString});
        }
        Object resultData = "";
        try {
            resultData = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])params);
        }
        catch (RuntimeException runtimeException) {
            SRMStoreExceptionTraceHelper.saveWarnData(runtimeException);
            String message = runtimeException.getClass().getName() + ":" + runtimeException.getMessage();
            throw new KDException(new ErrorCode("SYSTEMJOINTEXCEPTION", message), new Object[0]);
        }
        catch (Throwable throwable) {
            SRMStoreExceptionTraceHelper.saveExceptionData(throwable);
        }
        finally {
            log.debug("\u8c03\u7528\u82cd\u7a79\u6807\u51c6\u5fae\u670d\u52a1\u7ed3\u675f\u3002");
        }
        return resultData;
    }
}

