/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.systemjoint;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.systemjoint.ISystemJointService;

public final class EASSystemJointService
implements ISystemJointService {
    private static final Log log = LogFactory.getLog(EASSystemJointService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeISCMServiceSend(String cloudId, String appId, String serviceName, String methodName, String connectNumber, String iscSourceFullName, Map<String, Object> customMap, String proxyUser) {
        if (log.isInfoEnabled()) {
            log.info("cloudId:{},appId:{},serviceName:{},methodName:{},connectNumber:{},iscSourceNumber:{},customMap:{},proxyUser:{}", new Object[]{cloudId, appId, serviceName, methodName, connectNumber, iscSourceFullName, SerializationUtils.toJsonString(customMap), proxyUser});
        }
        Object resultData = "";
        try {
            resultData = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{connectNumber, iscSourceFullName, customMap, proxyUser});
            if (resultData instanceof Map) {
                Object exception = ((Map)resultData).get("exception");
                if (exception != null) {
                    throw new KDException(new ErrorCode("SYSTEMJOINTEXCEPTION", exception.toString()), new Object[]{exception.toString()});
                }
                Object result = ((Map)resultData).get("result");
                if (result != null) {
                    resultData = result;
                }
            } else if ("null".equals(resultData)) {
                throw new KDException(new ErrorCode("SYSTEMJOINTEXCEPTION", ResManager.loadKDString((String)"result is null", (String)"", (String)"", (Object[])new Object[0])), new Object[0]);
            }
        }
        catch (RuntimeException exception) {
            SRMStoreExceptionTraceHelper.saveWarnData(exception);
            String message = exception.getClass().getName() + ":" + exception.getMessage();
            throw new KDException(new ErrorCode("SYSTEMJOINTEXCEPTION", message), new Object[]{exception});
        }
        catch (Throwable throwable) {
            SRMStoreExceptionTraceHelper.saveExceptionData(throwable);
        }
        finally {
            log.debug("\u8c03\u7528\u82cd\u7a79\u96c6\u6210\u4e91\u5fae\u670d\u52a1\u670d\u52a1\u7ed3\u675f\u3002");
        }
        return resultData;
    }
}

