/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.jd.dto.AfsServicebyCustomerPin;
import kd.scm.common.enums.PlatformEnums;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.enums.ReturnStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class AfterSaleUtil {
    private static final Log log = LogFactory.getLog(AfterSaleUtil.class);
    private static final String NULL = "null";
    private static final Map<Integer, ReturnStatusEnum> jdStatusMapping = new HashMap<Integer, ReturnStatusEnum>();

    public static void updateJdAfterSaleStateInPurOder() {
        DynamicObject[] needUpdateReturnReqDyns = AfterSaleUtil.getNeedUpdateReturnReq();
        HashMap<String, List<AfsServicebyCustomerPin>> afsServiceMap = new HashMap<String, List<AfsServicebyCustomerPin>>();
        HashMap<String, BigDecimal> needFailWriteBackDataMap = new HashMap<String, BigDecimal>((int)((double)needUpdateReturnReqDyns.length / 0.75));
        HashMap<String, BigDecimal> poentryReturnAmountMap = new HashMap<String, BigDecimal>();
        HashMap<Integer, DynamicObject> afterSaleEntryMap = new HashMap<Integer, DynamicObject>();
        HashMap<Integer, AfsServicebyCustomerPin> afsServicebyCustomerPinMap = new HashMap<Integer, AfsServicebyCustomerPin>();
        try {
            AfterSaleUtil.queryAndCollectForUpdateByAfsList(needUpdateReturnReqDyns, afterSaleEntryMap, afsServiceMap, afsServicebyCustomerPinMap, needFailWriteBackDataMap, poentryReturnAmountMap);
            DynamicObject[] jdAsServiceBillDyns = AfterSaleUtil.loadJdAsServiceBillDynCol(afsServicebyCustomerPinMap);
            HashMap<Integer, DynamicObject> jdAsServiceBillMap = new HashMap<Integer, DynamicObject>((int)((double)jdAsServiceBillDyns.length / 0.75));
            for (DynamicObject jdAsServiceBillDyn : jdAsServiceBillDyns) {
                jdAsServiceBillMap.put(jdAsServiceBillDyn.getInt("number"), jdAsServiceBillDyn);
            }
            AfterSaleUtil.synAndUpdateReturnReqAndEAfs(needUpdateReturnReqDyns, afterSaleEntryMap, afsServicebyCustomerPinMap, jdAsServiceBillMap);
            if (jdAsServiceBillDyns.length > 0) {
                SaveServiceHelper.save((DynamicObject[])jdAsServiceBillDyns);
            }
            SaveServiceHelper.save((DynamicObject[])needUpdateReturnReqDyns);
            log.info("@@\u66f4\u65b0\u552e\u540e\u7533\u8bf7\u5355\u6210\u529f\uff01\u6570\u91cf\uff1a" + needUpdateReturnReqDyns.length);
            AfterSaleUtil.writeBackMalOrderAndPurOrder(needFailWriteBackDataMap);
            AfterSaleUtil.writeBackSuccessMalOrder(poentryReturnAmountMap);
        }
        catch (Exception e) {
            log.error("@@afsServiceMap:" + afsServiceMap + "\r\n@@needFailWriteBackDataMap:" + needFailWriteBackDataMap + "\r\n@@afsServicebyCustomerPinMap:" + afsServicebyCustomerPinMap + "\n@@poentryReturnAmountMap:" + poentryReturnAmountMap + ResManager.loadKDString((String)"\r\n@@\u901a\u8fc7\u4eac\u4e1c\u552e\u540e\u67e5\u8be2\u66f4\u65b0\u9000\u8d27\u7533\u8bf7\u5355\u72b6\u6001\u5931\u8d25\u539f\u56e0:", (String)"AfterSaleUtil_0", (String)"scm-common", (Object[])new Object[0]) + Arrays.toString(e.getStackTrace()));
        }
    }

    public static void synAndUpdateReturnReqAndEAfs(DynamicObject[] needUpdateReturnReqDyns, Map<Integer, DynamicObject> afterSaleEntryMap, Map<Integer, AfsServicebyCustomerPin> afsServicebyCustomerPinMap, Map<Integer, DynamicObject> jdAsServiceBillMap) {
        if (needUpdateReturnReqDyns.length > 0) {
            DynamicObjectCollection afterSaleEntryCol = needUpdateReturnReqDyns[0].getDynamicObjectCollection("aftersaleentry");
            long[] pks = DBServiceHelper.genLongIds((String)"", (int)afsServicebyCustomerPinMap.size());
            ArrayList newAfsServiceBills = new ArrayList(afsServicebyCustomerPinMap.size());
            int[] index = new int[]{0};
            afsServicebyCustomerPinMap.forEach((afsServiceId, afs) -> {
                DynamicObject afterSaleEntry = (DynamicObject)afterSaleEntryMap.get(afsServiceId);
                if (afterSaleEntry == null) {
                    afterSaleEntry = new DynamicObject(afterSaleEntryCol.getDynamicObjectType());
                    afterSaleEntry.set("seq", (Object)0);
                    int n = index[0];
                    index[0] = n + 1;
                    DynamicObject afServiceBillDyn = AfterSaleUtil.createAfServiceBill(afs, pks[n]);
                    newAfsServiceBills.add(afServiceBillDyn);
                    afterSaleEntry.set("afservicebill_id", afServiceBillDyn.getPkValue());
                    for (DynamicObject needUpdateReturnReqDyn : needUpdateReturnReqDyns) {
                        DynamicObjectCollection afterSaleEntrys = needUpdateReturnReqDyn.getDynamicObjectCollection("aftersaleentry");
                        if (!needUpdateReturnReqDyn.getString("billno").equals(afs.getReturnReqBillNo())) continue;
                        afterSaleEntrys.add((Object)afterSaleEntry);
                    }
                } else {
                    AfterSaleUtil.updateAfServiceBill(afs, jdAsServiceBillMap);
                }
                AfterSaleUtil.adjustData(needUpdateReturnReqDyns);
            });
            if (!newAfsServiceBills.isEmpty()) {
                AfterSaleUtil.saveNewAsServiceBill(newAfsServiceBills.toArray(new DynamicObject[0]));
            }
        }
    }

    public static void adjustData(DynamicObject[] needUpdateReturnReqDyns) {
        for (DynamicObject needUpdateReturnReqDyn : needUpdateReturnReqDyns) {
            DynamicObjectCollection afterSaleEntrys = needUpdateReturnReqDyn.getDynamicObjectCollection("aftersaleentry");
            afterSaleEntrys.removeIf(entry -> 0L == entry.getLong("afservicebill_id"));
            afterSaleEntrys.sort((entry1, entry2) -> {
                Date date1 = entry1.getDate("afservicebill.applydate");
                Date date2 = entry2.getDate("afservicebill.applydate");
                if (date1 != null && date2 != null) {
                    return date2.compareTo(date1);
                }
                return 1;
            });
            int[] i = new int[]{1};
            afterSaleEntrys.forEach(entry -> {
                int n = i[0];
                i[0] = n + 1;
                entry.set("seq", (Object)n);
            });
        }
    }

    public static void queryAndCollectForUpdateByAfsList(DynamicObject[] needUpdateReturnReqDyns, Map<Integer, DynamicObject> afterSaleEntryMap, Map<String, List<AfsServicebyCustomerPin>> afsServiceMap, Map<Integer, AfsServicebyCustomerPin> afsServicebyCustomerPinMap, Map<String, BigDecimal> needFailWriteBackDataMap, Map<String, BigDecimal> poentryReturnAmountMap) {
        HashMap<Integer, String> afsidPoentryidMap = new HashMap<Integer, String>();
        for (int i = 0; i < needUpdateReturnReqDyns.length; ++i) {
            DynamicObjectCollection afterSaleEntryCol = needUpdateReturnReqDyns[i].getDynamicObjectCollection("aftersaleentry");
            for (DynamicObject afterSaleEntry : afterSaleEntryCol) {
                afterSaleEntryMap.put(afterSaleEntry.getInt("afservicebill.number"), afterSaleEntry);
            }
            ArrayList<Integer> normalAfsIds = null;
            ArrayList<Integer> successServiceIds = null;
            String oldCfmStatus = needUpdateReturnReqDyns[i].getString("cfmstatus");
            DynamicObjectCollection entryCol = needUpdateReturnReqDyns[i].getDynamicObjectCollection("entryentity");
            Long ecPorderPk = ((DynamicObject)entryCol.get(0)).getLong("ecorder.id");
            DynamicObject jdOrderDyn = QueryServiceHelper.queryOne((String)"pbd_jdorder", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ecPorderPk)});
            String jdChildOrderId = jdOrderDyn == null ? "" : jdOrderDyn.getString("number");
            for (DynamicObject dyn : entryCol) {
                boolean isWriteBackFailQty;
                if (StringUtils.isEmpty((CharSequence)jdChildOrderId)) {
                    jdChildOrderId = dyn.getString("jdchildorderid");
                }
                if (!afsServiceMap.containsKey(jdChildOrderId)) {
                    List<AfsServicebyCustomerPin> afsServicebyCustomerPinList = JdApiUtil.getServiceListPage(jdChildOrderId, "1", "20", null);
                    afsServiceMap.put(jdChildOrderId, afsServicebyCustomerPinList);
                    log.info("@@afsServiceMap:" + afsServiceMap);
                }
                List<AfsServicebyCustomerPin> afsServicebyCustomerPins = afsServiceMap.get(jdChildOrderId);
                for (AfsServicebyCustomerPin afs : afsServicebyCustomerPins) {
                    int size;
                    log.info("@@jdchildorderid:" + jdChildOrderId);
                    log.info("@@goods.number:" + dyn.getString("goods.number"));
                    if (!StringUtils.isBlank((CharSequence)afs.getReturnReqBillNo()) || !StringUtils.equals((CharSequence)String.valueOf(afs.getWareId()), (CharSequence)dyn.getString("goods.number"))) continue;
                    String cfmStatus = jdStatusMapping.get(afs.getAfsServiceStep()).getVal();
                    needUpdateReturnReqDyns[i].set("cfmstatus", (Object)cfmStatus);
                    log.info("@@cfmstatus:" + cfmStatus);
                    needUpdateReturnReqDyns[i].set("jdserviceid", (Object)afs.getAfsServiceId());
                    if (!StringUtils.equals((CharSequence)cfmStatus, (CharSequence)ReturnStatusEnum.CANCEL.getVal()) && !StringUtils.equals((CharSequence)cfmStatus, (CharSequence)ReturnStatusEnum.REFUSE.getVal())) {
                        if (normalAfsIds == null) {
                            size = afsServicebyCustomerPins.size() * entryCol.size();
                            normalAfsIds = new ArrayList<Integer>(size);
                        }
                        normalAfsIds.add(afs.getAfsServiceId());
                    }
                    if (StringUtils.equals((CharSequence)cfmStatus, (CharSequence)ReturnStatusEnum.FINISH.getVal()) || 40 == afs.getAfsServiceStep()) {
                        if (successServiceIds == null) {
                            size = afsServicebyCustomerPins.size() * entryCol.size();
                            successServiceIds = new ArrayList<Integer>(size);
                        }
                        successServiceIds.add(afs.getAfsServiceId());
                    }
                    afsServicebyCustomerPinMap.put(afs.getAfsServiceId(), afs);
                    afs.setReturnReqBillNo(needUpdateReturnReqDyns[i].getString("billno"));
                    afsidPoentryidMap.put(afs.getAfsServiceId(), dyn.getString("poentryid"));
                }
                String newCfmStatus = needUpdateReturnReqDyns[i].getString("cfmstatus");
                boolean bl = isWriteBackFailQty = (ReturnStatusEnum.REFUSE.getVal().equals(newCfmStatus) || ReturnStatusEnum.CANCEL.getVal().equals(newCfmStatus)) && !oldCfmStatus.equals(needUpdateReturnReqDyns[i].getString("cfmstatus"));
                if (isWriteBackFailQty) {
                    needFailWriteBackDataMap.put(dyn.getString("poentryid"), dyn.getBigDecimal("qty"));
                    if ("E".equals(newCfmStatus)) {
                        needUpdateReturnReqDyns[i].set("billstatus", (Object)"Z");
                    }
                }
                if (null != normalAfsIds) {
                    AfterSaleUtil.queryServiceDetailAndCompleteAfs(normalAfsIds, afsServicebyCustomerPinMap);
                }
                BigDecimal totalReturnAmount = BigDecimal.ZERO;
                if (null != successServiceIds) {
                    for (Integer successServiceId : successServiceIds) {
                        BigDecimal returnAmount = afsServicebyCustomerPinMap.get(successServiceId).getReturnAmount();
                        BigDecimal oldTotalReturnAmount = poentryReturnAmountMap.get(afsidPoentryidMap.get(successServiceId));
                        if (oldTotalReturnAmount == null || oldTotalReturnAmount.compareTo(BigDecimal.ZERO) <= 0) {
                            oldTotalReturnAmount = BigDecimal.ZERO;
                        }
                        if (returnAmount == null) continue;
                        totalReturnAmount = returnAmount.add(oldTotalReturnAmount);
                    }
                }
                poentryReturnAmountMap.put(dyn.getString("poentryid"), totalReturnAmount);
            }
        }
    }

    public static void saveNewAsServiceBill(DynamicObject[] newAfsServiceBills) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pbd_eafservicebill", (DynamicObject[])newAfsServiceBills, (OperateOption)option);
        if (!saveResult.isSuccess()) {
            log.error("\u4fdd\u5b58\u4eac\u4e1c\u670d\u52a1\u5355\u5931\u8d25\uff1a" + ExceptionUtil.getErrorInfoDetails(saveResult.getAllErrorOrValidateInfo()));
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u4eac\u4e1c\u670d\u52a1\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AfterSaleUtil_1", (String)"scm-common", (Object[])new Object[0]));
        }
    }

    public static void queryServiceDetailAndCompleteAfs(List<Integer> normalAfsId, Map<Integer, AfsServicebyCustomerPin> afsServicebyCustomerPinMap) {
        if (normalAfsId.isEmpty()) {
            return;
        }
        normalAfsId.forEach(serviceId -> {
            AfsServicebyCustomerPin afsServicebyCustomerPin = (AfsServicebyCustomerPin)afsServicebyCustomerPinMap.get(serviceId);
            JSONArray appendInfoSteps = JSONArray.fromObject((Object)"[1,2,3,4,5]");
            JSONObject compatibleServiceDetailJo = JdApiUtil.getServiceDetailInfo(String.valueOf(serviceId), appendInfoSteps);
            try {
                AfterSaleUtil.setReturnAmount(compatibleServiceDetailJo, afsServicebyCustomerPin);
                AfterSaleUtil.setReturnAddressInfo(compatibleServiceDetailJo, afsServicebyCustomerPin);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u552e\u540e\u670d\u52a1\u5355\u8be6\u7ec6\u5931\u8d25\uff1a" + ExceptionUtil.getStackTrace(e) + "||compatibleServiceDetailJo:" + compatibleServiceDetailJo);
            }
        });
    }

    public static void setReturnAddressInfo(JSONObject compatibleServiceDetailJo, AfsServicebyCustomerPin afsServicebyCustomerPin) {
        if (compatibleServiceDetailJo.containsKey((Object)"serviceAftersalesAddressInfoDTO") && !StringUtils.equals((CharSequence)NULL, (CharSequence)compatibleServiceDetailJo.getString("serviceAftersalesAddressInfoDTO")) && StringUtils.isNotBlank((CharSequence)compatibleServiceDetailJo.getString("serviceAftersalesAddressInfoDTO"))) {
            JSONObject serviceAftersalesAddressInfoJo = compatibleServiceDetailJo.getJSONObject("serviceAftersalesAddressInfoDTO");
            if (serviceAftersalesAddressInfoJo.containsKey((Object)"address")) {
                afsServicebyCustomerPin.setReturnAddress(serviceAftersalesAddressInfoJo.getString("address"));
            }
            if (serviceAftersalesAddressInfoJo.containsKey((Object)"tel")) {
                afsServicebyCustomerPin.setReturnPhone(serviceAftersalesAddressInfoJo.getString("tel"));
            }
            if (serviceAftersalesAddressInfoJo.containsKey((Object)"linkMan")) {
                afsServicebyCustomerPin.setReturnContact(serviceAftersalesAddressInfoJo.getString("linkMan"));
            }
        }
    }

    public static void setReturnAmount(JSONObject compatibleServiceDetailJo, AfsServicebyCustomerPin afsServicebyCustomerPin) {
        if (compatibleServiceDetailJo.containsKey((Object)"serviceFinanceDetailInfoDTOs") && !StringUtils.equals((CharSequence)NULL, (CharSequence)compatibleServiceDetailJo.getString("serviceFinanceDetailInfoDTOs")) && StringUtils.isNotBlank((CharSequence)compatibleServiceDetailJo.getString("serviceFinanceDetailInfoDTOs"))) {
            JSONArray serviceFinanceDetailInfoJa = compatibleServiceDetailJo.getJSONArray("serviceFinanceDetailInfoDTOs");
            BigDecimal returnAmount = BigDecimal.ZERO;
            for (Object serviceFinanceDetailInfoObj : serviceFinanceDetailInfoJa) {
                JSONObject serviceFinanceDetailInfoJo = (JSONObject)serviceFinanceDetailInfoObj;
                if (!serviceFinanceDetailInfoJo.containsKey((Object)"refundPrice")) continue;
                BigDecimal refundPrice = new BigDecimal(serviceFinanceDetailInfoJo.getString("refundPrice"));
                returnAmount = returnAmount.add(refundPrice);
            }
            afsServicebyCustomerPin.setReturnAmount(returnAmount);
        }
    }

    public static DynamicObject[] loadJdAsServiceBillDynCol(Map<Integer, AfsServicebyCustomerPin> afsServicebyCustomerPinMap) {
        HashSet afServiceIdSet = new HashSet();
        afsServicebyCustomerPinMap.keySet().forEach(afServiceId -> afServiceIdSet.add(String.valueOf(afServiceId)));
        QFilter numberFilter = new QFilter("number", "in", afServiceIdSet);
        QFilter sourceFilter = new QFilter("source", "=", (Object)ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
        String selectField = "number,afsservicestep,afsservicestepnum,afsservicestepdate,returncontact,returnphone,returnaddress,returnamount,cancelstatus";
        return BusinessDataServiceHelper.load((String)"pbd_eafservicebill", (String)selectField, (QFilter[])new QFilter[]{numberFilter, sourceFilter});
    }

    private static void updateAfServiceBill(AfsServicebyCustomerPin afs, Map<Integer, DynamicObject> jdAsServiceBillMap) {
        DynamicObject jdAsServiceDyn = jdAsServiceBillMap.get(afs.getAfsServiceId());
        if (null != jdAsServiceDyn) {
            jdAsServiceDyn.set("afsservicestepnum", (Object)afs.getAfsServiceStep());
            jdAsServiceDyn.set("afsservicestep", (Object)afs.getAfsServiceStepName());
            jdAsServiceDyn.set("cancelstatus", (Object)afs.getCancel());
            jdAsServiceDyn.set("returncontact", (Object)afs.getReturnContact());
            jdAsServiceDyn.set("returnphone", (Object)afs.getReturnPhone());
            jdAsServiceDyn.set("returnaddress", (Object)afs.getReturnAddress());
            jdAsServiceDyn.set("returnamount", (Object)afs.getReturnAmount());
        } else {
            log.info("jdAsServiceBillMap:" + jdAsServiceBillMap + "\r\nafs:" + afs);
        }
    }

    public static DynamicObject createAfServiceBill(AfsServicebyCustomerPin afs, long pk) {
        DynamicObject afServiceBillDyn = BusinessDataServiceHelper.newDynamicObject((String)"pbd_eafservicebill");
        afServiceBillDyn.set("id", (Object)pk);
        afServiceBillDyn.set("number", (Object)afs.getAfsServiceId());
        String applytime = afs.getAfsApplyTime();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            afServiceBillDyn.set("applydate", (Object)df.parse(applytime));
        }
        catch (ParseException e) {
            log.error(ExceptionUtil.getStackTrace(e));
        }
        afServiceBillDyn.set("orderid", (Object)afs.getOrderId());
        afServiceBillDyn.set("porderid", (Object)afs.getPorderId());
        afServiceBillDyn.set("returntype", (Object)afs.getCustomerExpect());
        afServiceBillDyn.set("afsservicestepnum", (Object)afs.getAfsServiceStep());
        afServiceBillDyn.set("afsservicestep", (Object)afs.getAfsServiceStepName());
        afServiceBillDyn.set("cancelstatus", (Object)afs.getCancel());
        afServiceBillDyn.set("source", (Object)ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
        afServiceBillDyn.set("returncontact", (Object)afs.getReturnContact());
        afServiceBillDyn.set("returnphone", (Object)afs.getReturnPhone());
        afServiceBillDyn.set("returnaddress", (Object)afs.getReturnAddress());
        afServiceBillDyn.set("returnamount", (Object)afs.getReturnAmount());
        DynamicObjectCollection entryentity = afServiceBillDyn.getDynamicObjectCollection("entryentity");
        DynamicObject entry = new DynamicObject(entryentity.getDynamicObjectType());
        entry.set("sku", (Object)afs.getWareId());
        entry.set("returnqty", (Object)1);
        entryentity.add((Object)entry);
        return afServiceBillDyn;
    }

    public static void writeBackSuccessMalOrder(Map<String, BigDecimal> poentryReturnAmountMap) {
        String selectMalOrderField = "entryentity,entryentity.sumreturnreqqty,entryentity.returnamount,entryentity.taxprice,entryentity.goods.number";
        DynamicObjectCollection purOrderCol = QueryServiceHelper.query((String)"pur_order", (String)"id,materialentry.srcentryid,materialentry.poentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poentryReturnAmountMap.keySet())});
        HashMap<Long, String> malOrderEntryIdPoEntryIdSet = new HashMap<Long, String>(purOrderCol.size() * 2);
        for (DynamicObject purOrderDyn : purOrderCol) {
            String malOrderEntryId = purOrderDyn.getString("materialentry.srcentryid");
            if (!StringUtils.isNotEmpty((CharSequence)malOrderEntryId)) continue;
            malOrderEntryIdPoEntryIdSet.put(Long.valueOf(malOrderEntryId), purOrderDyn.getString("materialentry.poentryid"));
        }
        DynamicObject[] malOrderCol = BusinessDataServiceHelper.load((String)"mal_order", (String)selectMalOrderField, (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", malOrderEntryIdPoEntryIdSet.keySet())});
        for (int i = 0; i < malOrderCol.length; ++i) {
            DynamicObjectCollection entryCol = malOrderCol[i].getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                if (!poentryReturnAmountMap.containsKey(malOrderEntryIdPoEntryIdSet.get(entry.getLong("id")))) continue;
                entry.set("returnamount", (Object)poentryReturnAmountMap.get(malOrderEntryIdPoEntryIdSet.get(entry.getLong("id"))));
            }
        }
        SaveServiceHelper.save((DynamicObject[])malOrderCol);
        log.info("@@\u53cd\u5199\u5546\u57cejd\u8ba2\u5355\u9000\u8d27\u91d1\u989d\u6210\u529f!\u6570\u91cf\uff1a" + malOrderCol.length);
    }

    public static void writeBackMalOrderAndPurOrder(Map<String, BigDecimal> needWriteBackDataMap) {
        HashMap<String, BigDecimal> malOrderMap = new HashMap<String, BigDecimal>();
        String selectPurOrderField = "id,materialentry,materialentry.sumreturnreqqty,materialentry.srcentryid,materialentry.poentryid,materialentry.pobillid";
        String filterEntryField = "poentryid";
        DynamicObject[] purOrderCol = BusinessDataServiceHelper.load((String)"pur_order", (String)selectPurOrderField, (QFilter[])new QFilter[]{new QFilter("materialentry." + filterEntryField, "in", needWriteBackDataMap.keySet())});
        for (int i = 0; i < purOrderCol.length; ++i) {
            DynamicObjectCollection entryCol = purOrderCol[i].getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                if (!needWriteBackDataMap.containsKey(entry.getString(filterEntryField))) continue;
                BigDecimal returnQty = needWriteBackDataMap.get(entry.getString(filterEntryField));
                BigDecimal oldSumReturnReqQty = entry.getBigDecimal("sumreturnreqqty");
                BigDecimal newSumReturnReqQty = oldSumReturnReqQty.subtract(returnQty);
                if (newSumReturnReqQty.compareTo(BigDecimal.ZERO) < 0) {
                    newSumReturnReqQty = BigDecimal.ZERO;
                }
                entry.set("sumreturnreqqty", (Object)newSumReturnReqQty);
                String srcEntryId = entry.getString("srcentryid");
                if (StringUtils.isNotEmpty((CharSequence)srcEntryId)) {
                    malOrderMap.put(srcEntryId, newSumReturnReqQty);
                }
                if (BigDecimal.ZERO.compareTo(newSumReturnReqQty) <= 0) continue;
                log.info("@@needWriteBackDataMap:" + needWriteBackDataMap + ";oldSumReturnReqQty:" + oldSumReturnReqQty);
            }
        }
        SaveServiceHelper.save((DynamicObject[])purOrderCol);
        String selectMalOrderField = "entryentity,entryentity.sumreturnreqqty,entryentity.returnamount,entryentity.taxprice,platform";
        HashSet malOrderEntryIdSet = new HashSet();
        malOrderMap.keySet().forEach(id -> malOrderEntryIdSet.add(Long.valueOf(id)));
        DynamicObject[] malOrderCol = BusinessDataServiceHelper.load((String)"mal_order", (String)selectMalOrderField, (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", malOrderEntryIdSet)});
        for (int i = 0; i < malOrderCol.length; ++i) {
            DynamicObjectCollection entryCol = malOrderCol[i].getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                if (!malOrderMap.containsKey(entry.getString("id"))) continue;
                BigDecimal newSumReturnReqQty = (BigDecimal)malOrderMap.get(entry.getString("id"));
                entry.set("sumreturnreqqty", (Object)newSumReturnReqQty);
                if (!ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(malOrderCol[i].getString("platform"))) continue;
                BigDecimal returnAmount = newSumReturnReqQty.multiply(entry.getBigDecimal("taxprice"));
                entry.set("returnamount", (Object)returnAmount);
            }
        }
        SaveServiceHelper.save((DynamicObject[])malOrderCol);
    }

    public static DynamicObject[] getNeedUpdateReturnReq() {
        String selectFields = "billno,billstatus,cfmstatus,entryentity.jdchildorderid,entryentity.goods.number,entryentity.seq,entryentity.qty,entryentity.amount,entryentity.poentryid,jdserviceid,entryentity.goods,aftersaleentry,aftersaleentry.afservicebill,aftersaleentry.afservicebill.number,aftersaleentry.seq,ecsource,entryentity.ecorder,entryentity.ecorder.id";
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(ReturnStatusEnum.TO_BE_CONFIRM.getVal());
        statusList.add(ReturnStatusEnum.CONFIRMED.getVal());
        statusList.add(ReturnStatusEnum.CANCEL.getVal());
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter cfmstatusFilter = new QFilter("cfmstatus", "in", statusList);
        QFilter platformFilter = new QFilter("platform", "=", (Object)PlatformEnums.JD.getValue());
        Date dateBeforeMonth = DateUtil.addWeek(TimeServiceHelper.now(), -2);
        QFilter billdateFilter = new QFilter("billdate", ">", (Object)dateBeforeMonth);
        QFilter[] filters = new QFilter[]{billstatusFilter, cfmstatusFilter, platformFilter, billdateFilter};
        return BusinessDataServiceHelper.load((String)"mal_returnreq", (String)selectFields, (QFilter[])filters);
    }

    public static Map<String, BigDecimal> collectFailWriteBackDataMap(DynamicObjectCollection returnReqDyns) {
        HashMap<String, BigDecimal> needFailWriteBackDataMap = new HashMap<String, BigDecimal>();
        String entryentity = "entryentity";
        for (DynamicObject returnReqDyn : returnReqDyns) {
            if ("scp_request".equals(returnReqDyn.getDataEntityType().getName())) {
                entryentity = "materialentry";
            }
            DynamicObjectCollection aftersaleEntryCol = returnReqDyn.getDynamicObjectCollection(entryentity);
            for (DynamicObject dyn : aftersaleEntryCol) {
                String poentryId = dyn.getString("poentryid");
                if (!StringUtils.isNotEmpty((CharSequence)poentryId)) continue;
                needFailWriteBackDataMap.put(dyn.getString("poentryid"), dyn.getBigDecimal("qty"));
            }
        }
        return needFailWriteBackDataMap;
    }

    public static void writeBackMalOrderAndPurOrder(DynamicObjectCollection returnReqDyns) {
        Map<String, BigDecimal> needWriteBackDataMap = AfterSaleUtil.collectFailWriteBackDataMap(returnReqDyns);
        AfterSaleUtil.writeBackMalOrderAndPurOrder(needWriteBackDataMap);
    }

    static {
        jdStatusMapping.put(10, ReturnStatusEnum.TO_BE_CONFIRM);
        jdStatusMapping.put(20, ReturnStatusEnum.REFUSE);
        jdStatusMapping.put(21, ReturnStatusEnum.TO_BE_CONFIRM);
        jdStatusMapping.put(4, ReturnStatusEnum.CONFIRMED);
        jdStatusMapping.put(22, ReturnStatusEnum.CONFIRMED);
        jdStatusMapping.put(31, ReturnStatusEnum.CONFIRMED);
        jdStatusMapping.put(32, ReturnStatusEnum.CONFIRMED);
        jdStatusMapping.put(33, ReturnStatusEnum.CONFIRMED);
        jdStatusMapping.put(34, ReturnStatusEnum.CONFIRMED);
        jdStatusMapping.put(40, ReturnStatusEnum.CONFIRMED);
        jdStatusMapping.put(50, ReturnStatusEnum.FINISH);
        jdStatusMapping.put(60, ReturnStatusEnum.CANCEL);
    }
}

