/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.scm.common.ORMUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;

public class DataTransterLogUtil {
    private static final String ENTITYKEY = "pur_apilog";
    private static final String APICONFIG = "apiconfig";
    private static final String INTERFACE = "interface";
    private static final String ENTITYNAME = "entityname";
    private static final String CREATOR = "creator";
    private static final String CREATETIME = "createtime";
    private static final String INPUTDATA = "inputdata";
    private static final String OUTPUTDATA = "outputdata";

    private DataTransterLogUtil() {
    }

    public static DynamicObject logInputData(long apiconfigId, String interfaceName, String entityname, Object inputData) {
        DynamicObject logObj = ORMUtil.newDynamicObject(ENTITYKEY);
        logObj.set(APICONFIG, (Object)apiconfigId);
        logObj.set(INTERFACE, (Object)interfaceName);
        logObj.set(ENTITYNAME, (Object)entityname);
        logObj.set(CREATOR, (Object)RequestContext.get().getUserId());
        logObj.set(CREATETIME, (Object)new Date());
        logObj.set(INPUTDATA, inputData);
        logObj.set(OUTPUTDATA, (Object)"");
        try (TXHandle h = TX.notSupported();){
            SRMStoreDataTraceHelper.saveStoreData(new DynamicObject[]{logObj});
        }
        return logObj;
    }

    public static void logInputData(DynamicObject logObj, Object inputData) {
        String traceId = RequestContext.get().getTraceId();
        logObj.set(INPUTDATA, (Object)(traceId + inputData));
        try (TXHandle h = TX.notSupported();){
            SRMStoreDataTraceHelper.saveStoreData(new DynamicObject[]{logObj});
        }
    }

    public static void logOutputData(DynamicObject logObj, Object outputData) {
        if (null == logObj) {
            return;
        }
        String traceId = RequestContext.get().getTraceId();
        logObj.set(OUTPUTDATA, (Object)(traceId + outputData));
        SRMStoreDataTraceHelper.saveStoreData(new DynamicObject[]{logObj});
    }

    public static DynamicObject logOutputData(long apiconfigId, String interfaceName, String entityname, Object outputData) {
        DynamicObject logObj = ORMUtil.newDynamicObject(ENTITYKEY);
        logObj.set(APICONFIG, (Object)apiconfigId);
        logObj.set(INTERFACE, (Object)interfaceName);
        logObj.set(ENTITYNAME, (Object)entityname);
        logObj.set(CREATOR, (Object)RequestContext.get().getUserId());
        logObj.set(CREATETIME, (Object)new Date());
        logObj.set(OUTPUTDATA, outputData);
        logObj.set(INPUTDATA, (Object)"");
        SRMStoreDataTraceHelper.saveStoreData(new DynamicObject[]{logObj});
        return logObj;
    }
}

