/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.CommonUtil;
import org.apache.commons.lang.StringUtils;

public class DynamicObjectUtil {
    private static Log log = LogFactory.getLog(DynamicObjectUtil.class);

    @Deprecated
    public static List<String> getEntryentityProperties(IDataModel model, String entryKey) {
        DataEntityPropertyCollection entityProperties = model.getEntryEntity(entryKey).getDynamicObjectType().getProperties();
        ArrayList<String> properties = new ArrayList<String>(entityProperties.size());
        for (IDataEntityProperty iDataEntityProperty : entityProperties) {
            properties.add(iDataEntityProperty.getName());
        }
        return properties;
    }

    public static List<String> getEntryentityProperties(IDataEntityType dynamicObjectType) {
        ArrayList<String> properties = new ArrayList<String>();
        DataEntityPropertyCollection entityProperties = dynamicObjectType.getProperties();
        for (IDataEntityProperty iDataEntityProperty : entityProperties) {
            properties.add(iDataEntityProperty.getName().toLowerCase());
        }
        return properties;
    }

    public static List<String> getContainerProperties(Container container) {
        List items = container.getItems();
        ArrayList<String> properties = new ArrayList<String>(items.size());
        for (Control control : items) {
            properties.add(control.getKey());
        }
        return properties;
    }

    public static Map<String, Object> plainObject2Map(DynamicObject dynamicObject) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (dynamicObject != null) {
            DataEntityPropertyCollection dynamicObjects = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : dynamicObjects) {
                String property = iDataEntityProperty.getName().toLowerCase();
                objectMap.put(property, dynamicObject.get(property));
            }
        }
        return objectMap;
    }

    public static Map<String, String> getDynamicObjectKeyMap(DynamicObject dyObject) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        if (dyObject != null) {
            DataEntityPropertyCollection dynamicObjects = dyObject.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : dynamicObjects) {
                String property = iDataEntityProperty.getName().toLowerCase();
                keyMap.put(property, property);
            }
        }
        return keyMap;
    }

    public static Map<String, Object> object2Map(DynamicObject dynamicObject) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (dynamicObject != null) {
            DataEntityPropertyCollection dynamicObjects = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : dynamicObjects) {
                String name = iDataEntityProperty.getName();
                Object val = dynamicObject.get(name);
                if (iDataEntityProperty instanceof BasedataProp) {
                    if (val instanceof DynamicObject) {
                        objectMap.put(name.toLowerCase(), DynamicObjectUtil.getBDNumberOfValue((DynamicObject)val));
                        continue;
                    }
                    if (!(dynamicObject.get(name) instanceof Long)) continue;
                    objectMap.put(name.toLowerCase(), val);
                    continue;
                }
                if (iDataEntityProperty instanceof EntryProp && val instanceof Long) {
                    objectMap.put(name.toLowerCase(), val);
                    continue;
                }
                if (iDataEntityProperty instanceof MulBasedataProp) {
                    if (!(val instanceof DynamicObjectCollection)) continue;
                    objectMap.put(name.toLowerCase(), DynamicObjectUtil.getMulBaseDataOfId(dynamicObject.getDynamicObjectCollection(name)));
                    continue;
                }
                objectMap.put(name.toLowerCase(), val);
            }
        }
        return objectMap;
    }

    public static Map<String, Object> object2MapByQuery(DynamicObject dynamicObject) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (dynamicObject != null) {
            DataEntityPropertyCollection dynamicObjects = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : dynamicObjects) {
                String name = iDataEntityProperty.getName();
                Object val = dynamicObject.get(name);
                if (iDataEntityProperty instanceof BasedataProp) {
                    if (val instanceof DynamicObject) {
                        objectMap.put(name.toLowerCase(), DynamicObjectUtil.getBDIdOfValue((DynamicObject)val));
                        continue;
                    }
                    if (!(val instanceof Long)) continue;
                    objectMap.put(name.toLowerCase(), val);
                    continue;
                }
                if (iDataEntityProperty instanceof EntryProp) continue;
                if (iDataEntityProperty instanceof MulBasedataProp) {
                    if (!(val instanceof DynamicObjectCollection)) continue;
                    objectMap.put(name.toLowerCase(), DynamicObjectUtil.getMulBaseDataOfId(dynamicObject.getDynamicObjectCollection(name)));
                    continue;
                }
                objectMap.put(name.toLowerCase(), val);
            }
        }
        return objectMap;
    }

    public static Map<String, DynamicProperty> object2EntityTypeMapByQuery(DynamicObject dynamicObject) {
        HashMap<String, DynamicProperty> objectMap = new HashMap<String, DynamicProperty>();
        if (dynamicObject != null) {
            DataEntityPropertyCollection dynamicObjects = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : dynamicObjects) {
                String name = iDataEntityProperty.getName();
                if (!(iDataEntityProperty instanceof DynamicProperty)) continue;
                objectMap.put(name, (DynamicProperty)iDataEntityProperty);
            }
        }
        return objectMap;
    }

    public static Object getBDNumberOfValue(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            return dynamicObject.get("number");
        }
        return null;
    }

    public static Object getBDIdOfValue(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            return dynamicObject.get("id");
        }
        return null;
    }

    public static List<String> getProVal2List(DynamicObject[] objs, String proName) {
        ArrayList ProValList = new ArrayList(objs.length);
        for (DynamicObject dynamicObject : objs) {
            ProValList.add(String.valueOf(dynamicObject.get(proName)));
        }
        return ProValList.isEmpty() ? Collections.emptyList() : ProValList;
    }

    public static List<String> getProVal2List(DynamicObject[] objs, String entryKey, String proName) {
        ArrayList ProValList = new ArrayList();
        for (DynamicObject dynamicObject : objs) {
            DynamicObjectCollection cols = dynamicObject.getDynamicObjectCollection(entryKey);
            for (DynamicObject col : cols) {
                ProValList.add(String.valueOf(col.get(proName)));
            }
        }
        return ProValList.isEmpty() ? Collections.emptyList() : ProValList;
    }

    public static List<Long> array2ListId(DynamicObject[] objs, String proName) {
        ArrayList list = new ArrayList();
        for (DynamicObject dynamicObject : objs) {
            if (null != proName) {
                list.add((Long)dynamicObject.get(proName));
                continue;
            }
            list.add((Long)dynamicObject.getPkValue());
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    public static List<Long> array2ListProLong(DynamicObject[] objs, String proName) {
        ArrayList list = new ArrayList();
        for (DynamicObject dynamicObject : objs) {
            Object tempObj = dynamicObject.get(proName);
            if (null == proName || !(tempObj instanceof Long)) continue;
            list.add(Long.parseLong(tempObj.toString()));
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    public static List<Long> col2ListId(DynamicObjectCollection cols, String proName) {
        ArrayList list = new ArrayList();
        for (DynamicObject col : cols) {
            if (null != proName) {
                Object proVal = col.get(proName);
                if (null == proVal) continue;
                if (proVal instanceof DynamicObject) {
                    list.add((Long)((DynamicObject)proVal).getPkValue());
                    continue;
                }
                list.add((Long)proVal);
                continue;
            }
            list.add((Long)col.getPkValue());
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    public static DynamicObject toDynamicObject(DynamicObject obj, String property) {
        DynamicObject dynamicObject = null;
        if (null != obj && null != property) {
            dynamicObject = obj.getDynamicObject(property);
        }
        return dynamicObject;
    }

    public static long getDynamicObjectPk(DynamicObject obj, String property) {
        DynamicObject dynamicObject = null;
        if (null != obj && null != property) {
            dynamicObject = obj.getDynamicObject(property);
        }
        return null == dynamicObject ? 0L : (Long)dynamicObject.getPkValue();
    }

    public static Object[] getMulBaseDataOfId(DynamicObjectCollection dynamicObjects) {
        ArrayList<Object> reList = new ArrayList<Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject obj;
            if (null == dynamicObject || dynamicObject.toString().length() == 0 || null == (obj = dynamicObject.getDynamicObject(1))) continue;
            reList.add(dynamicObject.getDynamicObject(1).getPkValue());
        }
        return reList.toArray();
    }

    public static String getSelectfields(String entityKey, boolean isNeedAlias) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entityKey);
        Map<String, List<String>> allProsMap = DynamicObjectUtil.getDifferDynamicProperties(obj);
        List<String> allProsList = allProsMap.get("allProList");
        List<String> bdList = allProsMap.get("bdList");
        StringBuilder sb = new StringBuilder();
        for (String key : allProsList) {
            if (bdList.contains(key)) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (isNeedAlias) {
                    sb.append(key).append(".id").append(' ').append(key);
                    continue;
                }
                sb.append(key).append(".id");
                continue;
            }
            if (StringUtils.equals((String)"materialentry", (String)key) || StringUtils.equals((String)"billhead_lk", (String)key) || StringUtils.equals((String)"multilanguagetext", (String)key) || StringUtils.equals((String)"entryentity", (String)key)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(key);
        }
        return sb.toString();
    }

    @Deprecated
    public static String getSelectfields(String entityKey) {
        DynamicObject obj = ORMUtil.newDynamicObject(entityKey);
        Map<String, List<String>> allProsMap = DynamicObjectUtil.getDifferDynamicProperties(obj);
        List<String> allProsList = allProsMap.get("allProList");
        List<String> bdList = allProsMap.get("bdList");
        StringBuilder sb = new StringBuilder();
        for (String key : allProsList) {
            if (bdList.contains(key)) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(key).append(".id").append(' ').append(key);
                continue;
            }
            if (StringUtils.equals((String)"materialentry", (String)key) || StringUtils.equals((String)"multilanguagetext", (String)key)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(key);
        }
        return sb.toString();
    }

    @Deprecated
    public static String getEntrySelectfields(String select, String entityKey, String entryKey) {
        DynamicObject entry = ORMUtil.newDynamicObject(entityKey + "." + entryKey);
        Map<String, List<String>> allProsMap = DynamicObjectUtil.getDifferDynamicProperties(entry);
        List<String> allProsList = allProsMap.get("allProList");
        List<String> bdList = allProsMap.get("bdList");
        StringBuilder sb = new StringBuilder();
        sb.append(select);
        for (String key : allProsList) {
            if ("entryentity_lk".equals(key)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (bdList.contains(key)) {
                sb.append(entryKey).append('.').append(key).append(".id").append(' ').append(key);
                continue;
            }
            sb.append(entryKey).append('.').append(key).append(' ').append(key);
        }
        return sb.toString();
    }

    public static String getEntrySelectfields(String srcSelect, String entityKey, String entryKey, boolean isNeedAlias) {
        DynamicObject entry = ORMUtil.newDynamicObject(entityKey + "." + entryKey);
        Map<String, List<String>> allProsMap = DynamicObjectUtil.getDifferDynamicProperties(entry);
        List<String> allProsList = allProsMap.get("allProList");
        List<String> bdList = allProsMap.get("bdList");
        StringBuilder sb = new StringBuilder();
        sb.append(srcSelect);
        for (String key : allProsList) {
            if ("entryentity_lk".equals(key) || "materialentry_lk".equals(key)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(entryKey).append('.').append(key);
            if (!isNeedAlias) continue;
            sb.append(' ').append(key);
        }
        return sb.toString();
    }

    public static String getEntrySelectfields(String srcSelect, String entityKey, String entryKey, String childentryKey, boolean isNeedAlias) {
        DynamicObject entry = ORMUtil.newDynamicObject(entityKey + "." + entryKey + "." + childentryKey);
        String leftString = childentryKey;
        Map<String, List<String>> allProsMap = DynamicObjectUtil.getDifferDynamicProperties(entry);
        List<String> allProsList = allProsMap.get("allProList");
        List<String> bdList = allProsMap.get("bdList");
        StringBuilder sb = new StringBuilder();
        sb.append(srcSelect);
        for (String key : allProsList) {
            if ("entryentity_lk".equals(key) || "materialentry_lk".equals(key)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(leftString).append('.').append(key);
            if (!isNeedAlias) continue;
            sb.append(' ').append(key);
        }
        return sb.toString();
    }

    public static Map getEntityFieldsForTemplate(String entityKey) {
        HashMap<String, String> keyValue = new HashMap<String, String>();
        DynamicObject obj = ORMUtil.newDynamicObject(entityKey);
        if (null != obj) {
            DataEntityPropertyCollection proptiesCol = obj.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
                DynamicProperty pro = (DynamicProperty)iDataEntityProperty;
                StringBuilder displayName = new StringBuilder();
                if (null != pro.getDisplayName()) {
                    displayName.append(pro.getDisplayName().getLocaleValue());
                } else {
                    displayName.append(pro.getAlias());
                }
                displayName.append('(');
                displayName.append(pro.getName());
                displayName.append(')');
                keyValue.put(pro.getName(), displayName.toString());
            }
        }
        return keyValue;
    }

    public static Map<String, List<String>> getDifferDynamicProperties(DynamicObject dynamicObject) {
        HashMap<String, List<String>> differProMap = new HashMap<String, List<String>>();
        ArrayList<String> allProList = new ArrayList<String>();
        ArrayList<String> bdList = new ArrayList<String>();
        ArrayList<String> dateList = new ArrayList<String>();
        ArrayList<String> decimalList = new ArrayList<String>();
        ArrayList<String> booleanList = new ArrayList<String>();
        if (dynamicObject != null) {
            DataEntityPropertyCollection proptiesCol = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
                if (StringUtils.isBlank((String)iDataEntityProperty.getAlias())) continue;
                if (!(iDataEntityProperty instanceof LongProp || StringUtils.isEmpty((String)iDataEntityProperty.getName()) || bdList.contains(iDataEntityProperty.getName().replace("_id", "")))) {
                    allProList.add(iDataEntityProperty.getName());
                }
                if (iDataEntityProperty instanceof DateProp || iDataEntityProperty instanceof DateTimeProp) {
                    dateList.add(iDataEntityProperty.getName());
                    continue;
                }
                if (iDataEntityProperty instanceof BasedataProp) {
                    bdList.add(iDataEntityProperty.getName());
                    continue;
                }
                if (iDataEntityProperty instanceof DecimalProp) {
                    decimalList.add(iDataEntityProperty.getName());
                    continue;
                }
                if (!(iDataEntityProperty instanceof BooleanProp)) continue;
                booleanList.add(iDataEntityProperty.getName());
            }
        }
        differProMap.put("allProList", allProList);
        differProMap.put("bdList", bdList);
        differProMap.put("dateList", dateList);
        differProMap.put("decimalList", decimalList);
        differProMap.put("booleanList", booleanList);
        return differProMap;
    }

    public static List<String> getDynamicAllProperties(DynamicObject dynamicObject) {
        return DynamicObjectUtil.getDifferDynamicProperties(dynamicObject).get("allProList");
    }

    public static DynamicObjectCollection getEntryEntityData(DynamicObject dynamicObject) {
        return dynamicObject != null && dynamicObject.toString().length() >= 0 ? dynamicObject.getDynamicObjectCollection("materialentry") : null;
    }

    public static DynamicObjectCollection getEntryEntityData(DynamicObject dynamicObject, String entryEntityKey) {
        return dynamicObject != null && dynamicObject.toString().length() >= 0 ? dynamicObject.getDynamicObjectCollection(entryEntityKey) : null;
    }

    public static String getBillPro2Str(Object[] objs, String pro) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject obj = (DynamicObject)objs[i];
            if (sb.length() > 0) {
                sb.append(',').append(obj.get(pro));
                continue;
            }
            sb.append(obj.get(pro));
        }
        return sb.toString();
    }

    public static void setBillEntrySeq(DynamicObject billObject, String entryKey) {
        DynamicObjectCollection entrys = billObject.getDynamicObjectCollection(entryKey);
        IDataEntityProperty propSeq = (IDataEntityProperty)entrys.getDynamicObjectType().getProperties().get((Object)"seq");
        if (propSeq != null) {
            int seqIndex = 1;
            for (DynamicObject entry : entrys) {
                propSeq.setValueFast((Object)entry, (Object)seqIndex);
                ++seqIndex;
            }
        }
    }

    public static Map<String, DynamicObject> colsToMap(DynamicObjectCollection cols, String pro) {
        HashMap<String, DynamicObject> dynMap = new HashMap<String, DynamicObject>();
        for (DynamicObject col : cols) {
            dynMap.put(col.get(pro) == null ? null : col.get(pro).toString(), col);
        }
        return dynMap;
    }

    public static Map<String, DynamicObject> arraysToMap(List<DynamicObject> objs, String entryKey, String pro) {
        HashMap<String, DynamicObject> dynMap = new HashMap<String, DynamicObject>();
        for (DynamicObject obj : objs) {
            if (null == entryKey) {
                dynMap.put(obj.get(pro) == null ? null : obj.get(pro).toString(), obj);
                continue;
            }
            DynamicObjectCollection cols = obj.getDynamicObjectCollection(entryKey);
            for (DynamicObject col : cols) {
                dynMap.put(col.get(pro) == null ? null : col.get(pro).toString(), col);
            }
        }
        return dynMap;
    }

    public static List<DynamicObject> getDataByIdList(List<DynamicObject> srcDataList, List<Object> idList) {
        ArrayList<DynamicObject> tarDataList = new ArrayList<DynamicObject>();
        for (DynamicObject data : srcDataList) {
            if (!idList.contains(data.getPkValue())) continue;
            tarDataList.add(data);
        }
        return tarDataList;
    }

    public static List<DynamicObject> getUnPushBillObjs(List<DynamicObject> srcBillObjs, String entityKey, String srcEntryKey) {
        ArrayList<DynamicObject> newReturnObjs = new ArrayList<DynamicObject>();
        if (srcBillObjs.size() == 0) {
            return newReturnObjs;
        }
        List<String> entryIdList = DynamicObjectUtil.getProVal2List(srcBillObjs.toArray(new DynamicObject[0]), srcEntryKey, "id");
        ArrayList<Long> entryIdLi = new ArrayList<Long>(entryIdList.size());
        for (String entryId : entryIdList) {
            entryIdLi.add(Long.valueOf(entryId));
        }
        log.info("###dynamicObjectUtil getUnPushBillObjs:" + CommonUtil.collection2str(entryIdLi));
        HashMap src_tarIDMap = new HashMap();
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)entityKey, (String)srcEntryKey, (Long[])entryIdLi.toArray(new Long[0]));
        bfRowList.forEach(bfRow -> src_tarIDMap.putIfAbsent(bfRow.getSId().getBillId(), bfRow.getId().getBillId()));
        for (DynamicObject returnObj : srcBillObjs) {
            if (null != src_tarIDMap.get(returnObj.getPkValue())) continue;
            newReturnObjs.add(returnObj);
        }
        return newReturnObjs;
    }
}

