/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.useragent.util.DeviceType;
import kd.bos.useragent.util.OperatingSystem;
import kd.scm.common.plugin.constant.LicenseConstant;
import kd.scm.common.util.ParamConfigUtil;

public class FeatureCheckUtil {
    private static final Log logger = LogFactory.getLog(FeatureCheckUtil.class);

    public static Map<String, Object> checkMalFeature() {
        return FeatureCheckUtil.checkFeature("PRO_PMAL");
    }

    public static Map<String, Object> checkMalJdFeature() {
        if (ParamConfigUtil.getCacheBooleanParamConfig("ignoreLic").booleanValue()) {
            return null;
        }
        return FeatureCheckUtil.checkFeature("PRO_PMLJD");
    }

    public static Map<String, Object> checkSupFeature() {
        return FeatureCheckUtil.checkFeature("PRO_SRM");
    }

    public static Map<String, Object> checkScFeature() {
        return FeatureCheckUtil.checkFeature("PRO_SC");
    }

    public static Map<String, Object> checkAdmFeature() {
        return FeatureCheckUtil.checkMultiVersionFeature("PRO_ADM");
    }

    public static Map<String, Object> checkQuoFeature() {
        return FeatureCheckUtil.checkMultiVersionFeature("PRO_QUO");
    }

    public static Map<String, Object> checkTenFeature() {
        return FeatureCheckUtil.checkMultiVersionFeature("PRO_TEN");
    }

    public static Map<String, Object> checkTndFeature() {
        return FeatureCheckUtil.checkMultiVersionFeature("PRO_TND");
    }

    private static Map<String, Object> checkFeature(String licenseKey) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)licenseKey);
        resultMap.put("hasLicense", checkResult.getHasLicense());
        resultMap.put("licenseMsg", checkResult.getMsg());
        return resultMap;
    }

    public static Map<String, Object> checkMultiVersionFeature(String licenseKey) {
        String productVersion = LicenseServiceHelper.getProductVersion();
        logger.info("\u83b7\u53d6\u5230\u5f53\u524d\u8bb8\u53ef\u7248\u672c\uff1a" + productVersion);
        if (productVersion.compareToIgnoreCase("4.0") < 0) {
            return FeatureCheckUtil.checkFeature("PRO_SRM");
        }
        if (LicenseConstant.VERSION_SET.contains(productVersion)) {
            return FeatureCheckUtil.checkFeature(licenseKey);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("hasLicense", Boolean.TRUE);
        return resultMap;
    }

    public static LicenseCheckResult checkSRMFeatureByVersion(String bizAppID, String bizObjID, Long userID, String version) {
        return FeatureCheckUtil.checkFeatureByVersion(bizAppID, bizObjID, userID, version);
    }

    public static LicenseCheckResult checkFeatureByVersion(String bizAppID, String bizObjID, Long userID, String version) {
        String curVersion = LicenseServiceHelper.getProductVersion();
        logger.info("\u83b7\u53d6\u5230\u5f53\u524d\u8bb8\u53ef\u7248\u672c\uff1a" + curVersion);
        if (curVersion.compareToIgnoreCase(version) >= 0) {
            return LicenseServiceHelper.checkByAppAndBizObj((String)bizAppID, (String)bizObjID, (Long)userID);
        }
        return new LicenseCheckResult(Boolean.TRUE, "");
    }

    public static LicenseCheckResult checkNewFeature(String licenseKey) {
        String productVersion = LicenseServiceHelper.getProductVersion();
        logger.info("\u83b7\u53d6\u5230\u5f53\u524d\u8bb8\u53ef\u7248\u672c\uff1a" + productVersion);
        if (productVersion.compareToIgnoreCase("4.0") < 0) {
            return LicenseServiceHelper.checkPerformGroup((String)"PRO_SRM");
        }
        if (LicenseConstant.VERSION_SET.contains(productVersion)) {
            return LicenseServiceHelper.checkPerformGroup((String)licenseKey);
        }
        return new LicenseCheckResult(Boolean.TRUE, "");
    }

    public static boolean checkMalJdLicense() {
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMLJD");
        if (null != checkResult) {
            return checkResult.getHasLicense();
        }
        return false;
    }

    public static String buildCancelFormShowParameter(String bizAppId, String entityTypeId, LicenseCheckResult checkResult) {
        MobileFormShowParameter licCheckLogShowParam;
        if (FeatureCheckUtil.isMobilForm(entityTypeId)) {
            licCheckLogShowParam = new MobileFormShowParameter();
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("position", "center");
            licCheckLogShowParam.getOpenStyle().setCustParam(param);
            licCheckLogShowParam.setFormId("lic_licchecknotice_m");
        } else {
            licCheckLogShowParam = new FormShowParameter();
            licCheckLogShowParam.setFormId("lic_licchecknotice");
        }
        licCheckLogShowParam.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(checkResult.getMsg());
        messages.add(checkResult.getMsg());
        licCheckLogShowParam.setCustomParam("messages", messages);
        licCheckLogShowParam.setCustomParam("cancelmessage", (Object)checkResult.getMsg());
        return licCheckLogShowParam.toString();
    }

    public static FormShowParameter buildCancelFormShowParameter(String bizAppId, String entityTypeId, String message) {
        MobileFormShowParameter licCheckLogShowParam;
        if (FeatureCheckUtil.isMobilForm(entityTypeId)) {
            licCheckLogShowParam = new MobileFormShowParameter();
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("position", "center");
            licCheckLogShowParam.getOpenStyle().setCustParam(param);
            licCheckLogShowParam.setFormId("lic_licchecknotice_m");
        } else {
            licCheckLogShowParam = new FormShowParameter();
            licCheckLogShowParam.setFormId("lic_licchecknotice");
        }
        licCheckLogShowParam.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(message);
        licCheckLogShowParam.setCustomParam("messages", messages);
        licCheckLogShowParam.setCustomParam("cancelmessage", (Object)message);
        return licCheckLogShowParam;
    }

    private static boolean isMobilForm(String entityTypeId) {
        String modelType;
        String userAgent = RequestContext.get().getUserAgent();
        OperatingSystem operatingSystem = OperatingSystem.parseUserAgentString((String)userAgent);
        DeviceType deviceType = operatingSystem.getDeviceType();
        try {
            modelType = FormMetadataCache.getFormConfig((String)entityTypeId).getModelType();
        }
        catch (Exception e) {
            modelType = "base";
        }
        logger.debug("LicenseServiceImpl#isMobilForm:deviceType={},modelType={}", (Object)deviceType, (Object)modelType);
        return modelType.contains("mobile") || DeviceType.MOBILE.equals((Object)deviceType);
    }
}

