/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import org.apache.commons.lang.StringUtils;

public class InquiryUtil {
    private static Log log = LogFactory.getLog((String)"InquiryUtil");

    private InquiryUtil() {
    }

    public static void updateInquirySupInfo(String inquiryEntityKey, String quoteEntityKey, List<String> inquiryBillNoList) {
        if (inquiryBillNoList.size() > 0) {
            DynamicObject[] inquiryBillObjs = InquiryUtil.getInquiyrByInquiryBillNo(inquiryEntityKey, inquiryBillNoList);
            DynamicObject[] quoteBillObjs = InquiryUtil.getQuoteBillByInquiryBillNo(inquiryBillNoList);
            Map<String, Map<String, Object>> inquiryQuoteMap = InquiryUtil.getInuiryQuoteData(quoteBillObjs);
            InquiryUtil.updateInquiryBill(inquiryBillObjs, inquiryQuoteMap);
        }
    }

    public static void updateInquiryQuoResult(DynamicObject[] inquiryObjs, List<String> inquiryBillNoList) {
        if (!inquiryBillNoList.isEmpty()) {
            DynamicObject[] quoteBillObjs = InquiryUtil.getQuoteBillByInquiryBillNo(inquiryBillNoList);
            Map<String, Map<String, Object>> inquiryQuoteMap = InquiryUtil.getInuiryQuoteData(quoteBillObjs);
            InquiryUtil.updateInquiryBill(inquiryObjs, inquiryQuoteMap);
        }
    }

    public static DynamicObject[] getInquiryBillByBillNo(List<String> billNoList) {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>(1);
        idMap.put("in", billNoList);
        params.put("billno", idMap);
        String selectFields = DynamicObjectUtil.getSelectfields("sou_inquiry", false);
        selectFields = DynamicObjectUtil.getEntrySelectfields(selectFields, "sou_inquiry", "entryentity", false);
        selectFields = DynamicObjectUtil.getEntrySelectfields(selectFields, "sou_inquiry", "materialentry", false);
        return ORMUtil.load("sou_inquiry", selectFields, params);
    }

    public static DynamicObject[] getInquiyrByInquiryBillNo(String inquiryEntityKey, List<String> billNoList) {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>(1);
        idMap.put("in", billNoList);
        params.put("billno", idMap);
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", BillStatusEnum.AUDIT.getVal());
        params.put("billstatus", statusMap);
        String selectFields = DynamicObjectUtil.getSelectfields(inquiryEntityKey, false);
        selectFields = DynamicObjectUtil.getEntrySelectfields(selectFields, inquiryEntityKey, "materialentry", false);
        return ORMUtil.load(inquiryEntityKey, selectFields, params);
    }

    public static DynamicObject[] getQuoteBillByInquiryBillNo(List<String> billNoList) {
        QFilter inquiryNoFilter = new QFilter("inquiryno", "in", billNoList);
        QFilter statusQFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        QFilter entrystatusFilter = new QFilter("materialentry.entrystatus", "=", (Object)"A");
        String selectFields = DynamicObjectUtil.getSelectfields("quo_quote", false);
        selectFields = DynamicObjectUtil.getEntrySelectfields(selectFields, "quo_quote", "materialentry", false);
        return BusinessDataServiceHelper.load((String)"quo_quote", (String)selectFields, (QFilter[])new QFilter[]{inquiryNoFilter, statusQFilter, entrystatusFilter});
    }

    private static boolean isNotQuoSupplier(DynamicObject quoBill, Map<String, Set<String>> notQuoSupplierIdsMap) {
        String inquiryno = quoBill.getString("inquiryno");
        Set<String> notQuoSupplierIdSet = notQuoSupplierIdsMap.get(inquiryno);
        return null != notQuoSupplierIdSet && notQuoSupplierIdSet.contains(quoBill.getString("supplier.id"));
    }

    public static Map<String, Set<String>> getUnQuoSupplierIds(Set<String> billNoSet) {
        QFilter billnoFilter = new QFilter("billno", "in", billNoSet);
        QFilter supEntryStatusFilter = new QFilter("entryentity.supentrystatus", "=", (Object)SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal());
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(billnoFilter);
        filters.add(supEntryStatusFilter);
        return InquiryUtil.getUnQuoSupplierIds(filters);
    }

    public static Map<String, Set<String>> getUnQuoSupplierIds(Set<String> billNoSet, List<Long> supplierIds) {
        QFilter billnoFilter = new QFilter("billno", "in", billNoSet);
        QFilter supEntryStatusFilter = new QFilter("entryentity.supentrystatus", "=", (Object)SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal());
        QFilter supplierIdFilter = new QFilter("entryentity.supplier.id", "in", supplierIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(billnoFilter);
        filters.add(supEntryStatusFilter);
        filters.add(supplierIdFilter);
        return InquiryUtil.getUnQuoSupplierIds(filters);
    }

    public static Map<String, Set<String>> getUnQuoSupplierIds(List<QFilter> filters) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"InquiryUtil", (String)"sou_inquiry", (String)"id,billno,entryentity.supplier.id", (QFilter[])filters.toArray(new QFilter[0]), (String)"");){
            ds.forEach(row -> {
                String billno = row.getString("billno");
                HashSet<String> notSupplierIds = (HashSet<String>)result.get(billno);
                if (null == notSupplierIds) {
                    notSupplierIds = new HashSet<String>();
                }
                notSupplierIds.add(row.getString("entryentity.supplier.id"));
                result.put(billno, notSupplierIds);
            });
        }
        log.info("\u4e0d\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546:" + result);
        return result;
    }

    public static Map<String, Map<String, Object>> getInuiryQuoteData(DynamicObject[] quoteBillObjs) {
        HashMap<String, Map<String, Object>> inquiryQuoteMap = new HashMap<String, Map<String, Object>>(quoteBillObjs.length);
        boolean flag = false;
        if (quoteBillObjs != null && quoteBillObjs.length > 0 && quoteBillObjs[0].getDataEntityType().getProperties().containsKey((Object)"materialentry")) {
            flag = true;
        }
        for (DynamicObject quoteBill : quoteBillObjs) {
            BigDecimal minQuoteTaxAmount;
            int quoteNum = 0;
            if (null == quoteBill) continue;
            String inquiryNo = quoteBill.getString("inquiryno");
            HashMap<String, Object> quoteMap = (HashMap<String, Object>)inquiryQuoteMap.get(inquiryNo);
            if (quoteMap == null) {
                quoteMap = new HashMap<String, Object>();
                quoteMap.put("quoteNum", quoteNum);
            }
            quoteNum = Integer.parseInt(quoteMap.get("quoteNum").toString());
            quoteMap.put("quoteNum", quoteNum + 1);
            if (flag) {
                InquiryUtil.dealSupQuoteNum(quoteBill.getDynamicObjectCollection("materialentry"), quoteMap);
            }
            BigDecimal taxAmount = quoteBill.getBigDecimal("sumtaxamount");
            DynamicObject supplier = quoteBill.getDynamicObject("supplier");
            BigDecimal maxQuoteTaxAmount = CommonUtil.getBigDecimalPro(quoteMap.get("maxQuoteTaxAmount"));
            if (taxAmount.compareTo(maxQuoteTaxAmount) > 0) {
                quoteMap.put("maxQuoteTaxAmount", taxAmount);
                quoteMap.put("maxQuoteSuppier", supplier);
            }
            if (taxAmount.compareTo(minQuoteTaxAmount = CommonUtil.getBigDecimalPro(quoteMap.get("minQuoteTaxAmount"))) < 0 || minQuoteTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                quoteMap.put("minQuoteTaxAmount", taxAmount);
                quoteMap.put("minQuoteSupplier", supplier);
            }
            BigDecimal sumQuoteTaxAmount = CommonUtil.getBigDecimalPro(quoteMap.get("sumQuoteTaxAmount"));
            sumQuoteTaxAmount = sumQuoteTaxAmount.add(taxAmount);
            quoteMap.put("sumQuoteTaxAmount", sumQuoteTaxAmount);
            inquiryQuoteMap.put(inquiryNo, quoteMap);
        }
        log.info("@@\u8be2\u4ef7\u5355\u5bf9\u5e94\u7684\u62a5\u4ef7\u4fe1\u606f:" + inquiryQuoteMap);
        return inquiryQuoteMap;
    }

    private static void dealSupQuoteNum(DynamicObjectCollection materialentry, Map<String, Object> quoteMap) {
        if (materialentry != null) {
            for (DynamicObject info : materialentry) {
                BigDecimal price = info.getBigDecimal("price");
                if (price == null || BigDecimal.ZERO.compareTo(price) >= 0) continue;
                Integer num = (Integer)quoteMap.get(info.getString("srcentryid"));
                if (num == null) {
                    quoteMap.put(info.getString("srcentryid"), 1);
                    continue;
                }
                quoteMap.put(info.getString("srcentryid"), num + 1);
            }
        }
    }

    public static void updateInquiryBill(DynamicObject[] inquiryBillList, Map<String, Map<String, Object>> inquiryQuoteMap) {
        DataEntityPropertyCollection properties;
        boolean flag = false;
        if (inquiryBillList.length > 0 && (properties = inquiryBillList[0].getDataEntityType().getProperties()).containsKey((Object)"materialentry")) {
            flag = true;
        }
        for (DynamicObject inquiryBill : inquiryBillList) {
            String inquiryNo = inquiryBill.getString("billno");
            Map<String, Object> quoteDataMap = inquiryQuoteMap.get(inquiryNo);
            if (quoteDataMap == null) {
                inquiryBill.set("minsupplier", (Object)0L);
                inquiryBill.set("maxsupplier", (Object)0L);
                inquiryBill.set("quoteNum", (Object)0L);
                inquiryBill.set("supquonum", (Object)0L);
                inquiryBill.set("minsumamount", (Object)0L);
                inquiryBill.set("maxsumamount", (Object)0L);
                inquiryBill.set("avgsumamount", (Object)0);
            } else {
                Object maxSupplier;
                BigDecimal quoteNum = new BigDecimal(quoteDataMap.get("quoteNum").toString());
                Object minSupplier = quoteDataMap.get("minQuoteSupplier");
                if (minSupplier != null) {
                    inquiryBill.set("minsupplier", ((DynamicObject)minSupplier).getPkValue());
                }
                if ((maxSupplier = quoteDataMap.get("maxQuoteSuppier")) != null) {
                    inquiryBill.set("maxsupplier", ((DynamicObject)maxSupplier).getPkValue());
                }
                inquiryBill.set("quoteNum", (Object)quoteNum);
                inquiryBill.set("supquonum", (Object)quoteNum);
                inquiryBill.set("minsumamount", quoteDataMap.get("minQuoteTaxAmount"));
                inquiryBill.set("maxsumamount", quoteDataMap.get("maxQuoteTaxAmount"));
                if (quoteNum.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal sumQuoteTaxAmount = CommonUtil.getBigDecimalPro(quoteDataMap.get("sumQuoteTaxAmount"));
                    inquiryBill.set("avgsumamount", (Object)sumQuoteTaxAmount.divide(quoteNum, 4, RoundingMode.HALF_UP));
                }
            }
            if (!flag) continue;
            DynamicObjectCollection entry = inquiryBill.getDynamicObjectCollection("materialentry");
            String key = null;
            for (DynamicObject info : entry) {
                key = info.getString("srcentryid");
                if (StringUtils.isBlank((String)key)) {
                    key = info.getString("id");
                }
                BigDecimal o = quoteDataMap == null ? BigDecimal.ZERO : quoteDataMap.get(key);
                info.set("validnum", (Object)(o == null ? BigDecimal.ZERO : o));
            }
        }
    }

    public static void updateInquiryBill(DynamicObject[] inquiryBillList, DynamicObject[] quoteBillObjs) {
        InquiryUtil.updateInquiryBill(inquiryBillList, InquiryUtil.getInuiryQuoteData(quoteBillObjs));
    }

    public static void logTurnsQuote(DynamicObject[] inquiryBills, String note) {
        for (DynamicObject inquiryBill : inquiryBills) {
            if (null == inquiryBill) continue;
            DynamicObjectCollection rows = inquiryBill.getDynamicObjectCollection("entrylog");
            String turns = inquiryBill.getString("turns");
            boolean[] flag = new boolean[]{false};
            if (rows == null) continue;
            rows.forEach(info -> {
                if (StringUtils.equals((String)turns, (String)info.getString("turns_log"))) {
                    InquiryUtil.setTurnsLog(info, turns, inquiryBill, note);
                    flag[0] = true;
                }
            });
            if (flag[0]) continue;
            int i = rows.size();
            DynamicObject row = rows.addNew();
            row.set("seq", (Object)(i + 1));
            InquiryUtil.setTurnsLog(row, turns, inquiryBill, note);
        }
        SaveServiceHelper.save((DynamicObject[])inquiryBills);
    }

    private static void setTurnsLog(DynamicObject row, String turns, DynamicObject inquiryBill, String note) {
        row.set("turns_log", (Object)turns);
        row.set("handler_id", (Object)RequestContext.get().getUserId());
        row.set("handletime", (Object)TimeServiceHelper.now());
        row.set("logdeadline", (Object)inquiryBill.getDate("enddate"));
        if ("1".equalsIgnoreCase(turns)) {
            row.set("entrylogscope", (Object)inquiryBill.getString("supscope"));
        } else {
            row.set("entrylogscope", (Object)"2");
        }
        row.set("note_log", (Object)note);
    }

    public static DynamicObject[] getNormalQuoteBillByInquiryBill(List<String> billnos) {
        QFilter inquiryNoFilter = new QFilter("inquiryno", "in", billnos);
        QFilter entrystatusFilter = new QFilter("materialentry.entrystatus", "=", (Object)"A");
        String selectFields = DynamicObjectUtil.getSelectfields("quo_quote", false);
        selectFields = DynamicObjectUtil.getEntrySelectfields(selectFields, "quo_quote", "materialentry", false);
        return BusinessDataServiceHelper.load((String)"quo_quote", (String)selectFields, (QFilter[])new QFilter[]{inquiryNoFilter, entrystatusFilter});
    }

    public static void wrapSelectsByEntryPro(DataEntityPropertyCollection properties, Set<String> selectList, Map<String, String> extMap, Map<String, Character> blackListMap, DataEntityPropertyCollection dataSourceProperties, String prex) {
        if (blackListMap == null) {
            blackListMap = new HashMap<String, Character>();
        }
        String[] midResult = new String[2];
        String propertyName = null;
        String s = null;
        for (IDataEntityProperty property : properties) {
            IDataEntityProperty property1;
            boolean endPrex;
            if (property instanceof DynamicLocaleProperty || property instanceof AttachmentProp) continue;
            midResult[0] = "";
            midResult[1] = "";
            propertyName = property.getName();
            if (StringUtils.isNotBlank((String)prex) && (endPrex = propertyName.endsWith(prex))) {
                propertyName = propertyName.substring(0, propertyName.lastIndexOf(prex));
            }
            if (blackListMap.containsKey(propertyName = propertyName.replace(prex, "")) || "seq".equals(propertyName)) continue;
            s = null;
            if (extMap != null) {
                s = extMap.get(propertyName);
            }
            if (kd.bos.util.StringUtils.isNotEmpty(s)) {
                IDataEntityProperty property12 = (IDataEntityProperty)dataSourceProperties.get((Object)s);
                if (property12 != null) {
                    if (property12.getParent() instanceof EntryType) {
                        midResult[0] = property12.getParent().getName() + "." + property12.getName();
                        midResult[1] = propertyName;
                    } else {
                        midResult[0] = property12.getName();
                        midResult[1] = propertyName;
                    }
                }
            } else if (dataSourceProperties.containsKey((Object)propertyName) && (property1 = (IDataEntityProperty)dataSourceProperties.get((Object)propertyName)) != null) {
                if (property1.getParent() instanceof EntryType) {
                    midResult[0] = property1.getParent().getName() + "." + property1.getName();
                    midResult[1] = propertyName;
                } else {
                    midResult[0] = property1.getName();
                    midResult[1] = propertyName;
                }
            }
            if (!kd.bos.util.StringUtils.isNotEmpty((String)midResult[0])) continue;
            if (InquiryUtil.isBaseProp(property)) {
                selectList.add(midResult[0] + ".id " + midResult[1]);
            } else if (midResult[0].equals(midResult[1])) {
                selectList.add(midResult[0]);
            } else {
                selectList.add(midResult[0] + " " + midResult[1]);
            }
            blackListMap.put(propertyName, Character.valueOf('1'));
        }
    }

    private static boolean isBaseProp(IDataEntityProperty property) {
        return property instanceof BasedataProp || property instanceof CurrencyProp || property instanceof OrgProp;
    }
}

