/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.jd.entity.JdInvoiceInfo;
import kd.scm.common.ecapi.jd.entity.JdInvoiceSkuDetail;
import kd.scm.common.ecapi.jd.entity.JdOrderInfo;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.JDOrderStatusEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.jd.util.JDAccessTokenUtil;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.operation.message.base.SendMsgCommonService;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.MessageUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JDOrderUtil {
    private static Log log = LogFactory.getLog(JDOrderUtil.class);
    public static final SendMsgCommonService SEND_MSG_COMMON_SERVICE = new SendMsgCommonService();

    public static boolean confirmJDOrder(String token, String jdOrderID) {
        String data = "token=" + token + "&jdOrderId=" + jdOrderID;
        String json = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/order/confirmOrder", data);
        JSONObject node = JSONObject.fromObject((Object)json);
        return node.getBoolean("success");
    }

    public static Map<String, Object> getJdChildOrderIdMap(String token, String jdOrderID) {
        String data = "token=" + token + "&jdOrderId=" + jdOrderID + "&queryExts=jdOrderState";
        String json = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/order/selectJdOrder", data);
        log.info("@@@getJdChildOrderIdMap\u8c03\u7528\u63a5\u53e3\u83b7\u53d6json\uff1a" + json);
        return JDOrderUtil.parseJdChildOrderIdMap(json);
    }

    public static Map<String, Object> parseJdChildOrderIdMap(Object orderJson) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        JSONObject node = JSONObject.fromObject((Object)orderJson);
        JSONArray corders = null;
        JSONObject corder = null;
        JdOrderInfo jdOrderInfo = null;
        if (node.getBoolean("success")) {
            if (node.getJSONObject("result").get("cOrder") != null && !node.getJSONObject("result").get("cOrder").equals("null")) {
                resultMap.put("isHasChildOrder", String.valueOf(true));
                corders = node.getJSONObject("result").getJSONArray("cOrder");
                int size = corders.size();
                for (int i = 0; i < size; ++i) {
                    jdOrderInfo = new JdOrderInfo();
                    corder = corders.getJSONObject(i);
                    JDOrderUtil.setJdOrderInfo(corder, jdOrderInfo);
                    log.info("@@@getJdChildOrderIdMap\u4eac\u4e1c\u5355Info\uff1a" + jdOrderInfo);
                    resultMap.put(jdOrderInfo.getJdOrderId(), jdOrderInfo);
                }
            } else {
                resultMap.put("isHasChildOrder", String.valueOf(false));
            }
        }
        return resultMap;
    }

    private static void setJdOrderInfo(JSONObject order, JdOrderInfo jdOrderInfo) {
        JSONArray skus = order.getJSONArray("sku");
        ArrayList<String> skuList = new ArrayList<String>(skus.size());
        String childJdOrderId = order.optString("jdOrderId");
        if (order.get("pOrder") != null && order.optString("pOrder").length() > 5) {
            jdOrderInfo.setpOrder(order.optString("pOrder"));
        } else {
            jdOrderInfo.setpOrder(order.optString("jdOrderId"));
        }
        jdOrderInfo.setJdOrderId(childJdOrderId);
        jdOrderInfo.setType(order.optString("type"));
        jdOrderInfo.setState(order.optString("state"));
        jdOrderInfo.setSubmitState(order.optString("submitState"));
        jdOrderInfo.setOrderState(order.optString("orderState"));
        if (order.get("jdOrderState") != null) {
            jdOrderInfo.setJdOrderState(order.optString("jdOrderState"));
        }
        jdOrderInfo.setOrderPrice(order.optString("orderPrice"));
        jdOrderInfo.setFreight(order.optString("freight"));
        jdOrderInfo.setOrderNakedPrice(order.optString("orderNakedPrice"));
        jdOrderInfo.setOrderTaxPrice(order.optString("orderTaxPrice"));
        for (int j = 0; j < skus.size(); ++j) {
            String skuId = skus.getJSONObject(j).optString("skuId");
            skuList.add(skuId);
        }
        jdOrderInfo.setSkuList(skuList);
    }

    public static List<String> checkJdOrderStatus(String token, List<String> jdOrderList) {
        ArrayList<String> cancelOrderList = new ArrayList<String>();
        jdOrderList.forEach(jdOrderID -> {
            JSONObject jsons;
            int orderState;
            String data = "token=" + token + "&jdOrderId=" + jdOrderID;
            String json = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/order/selectJdOrder", data);
            JSONObject node = JSONObject.fromObject((Object)json);
            if (node.getBoolean("success") && (orderState = (jsons = JSONObject.fromObject((Object)node.get("result"))).getInt("orderState")) == 0) {
                cancelOrderList.add((String)jdOrderID);
            }
        });
        return cancelOrderList;
    }

    public static boolean checkJdOrderStatus(String token, String jdOrderID) {
        JSONObject jsons;
        int orderState;
        String data = "token=" + token + "&jdOrderId=" + jdOrderID;
        String json = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/order/selectJdOrder", data);
        JSONObject node = JSONObject.fromObject((Object)json);
        return node.getBoolean("success") && (orderState = (jsons = JSONObject.fromObject((Object)node.get("result"))).getInt("orderState")) == 1;
    }

    public static Map<String, JdOrderInfo> getJdOrderState(String token, Set<String> jdOrderIdSet) {
        HashMap<String, JdOrderInfo> jdStateMap = new HashMap<String, JdOrderInfo>();
        if (null == jdOrderIdSet || jdOrderIdSet.size() <= 0) {
            return jdStateMap;
        }
        jdOrderIdSet.forEach(jdOrderId -> {
            String data = "token=" + token + "&jdOrderId=" + jdOrderId + "&queryExts=jdOrderState";
            String json = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/order/selectJdOrder", data);
            log.info("@@@\u8c03\u7528\u4eac\u4e1c\u8ba2\u5355\u67e5\u8be2\u63a5\u53e3\u8fd4\u56dejson\uff1a" + json);
            JSONObject node = JSONObject.fromObject((Object)json);
            JSONArray corders = null;
            if (node.getBoolean("success")) {
                if (node.getJSONObject("result").get("cOrder") != null && !node.getJSONObject("result").get("cOrder").equals("null")) {
                    corders = node.getJSONObject("result").getJSONArray("cOrder");
                    JdOrderInfo jdOrderInfo = null;
                    int size = corders.size();
                    for (int i = 0; i < size; ++i) {
                        jdOrderInfo = new JdOrderInfo();
                        JSONObject corder = corders.getJSONObject(i);
                        JDOrderUtil.setJdOrderInfo(corder, jdOrderInfo);
                        log.info("@@@\u83b7\u53d6\u5230\u7684\u4eac\u4e1c\u8ba2\u5355\u4fe1\u606f(\u7236\u8ba2\u5355)-->" + jdOrderInfo);
                        jdStateMap.put(corder.optString("jdOrderId"), jdOrderInfo);
                    }
                } else {
                    JdOrderInfo jdOrderInfo = new JdOrderInfo();
                    JSONObject porder = node.getJSONObject("result");
                    JDOrderUtil.setJdOrderInfo(porder, jdOrderInfo);
                    log.info("@@@\u83b7\u53d6\u5230\u7684\u4eac\u4e1c\u8ba2\u5355\u4fe1\u606f\uff08\u5b50\u8ba2\u5355\uff09-->" + jdOrderInfo);
                    jdStateMap.put((String)jdOrderId, jdOrderInfo);
                }
            }
        });
        return jdStateMap;
    }

    public static Map<String, List<JdInvoiceInfo>> getJdInvoiceState(String token, Set<String> markIdSet) {
        HashMap<String, List<JdInvoiceInfo>> jdInvoiceMap = new HashMap<String, List<JdInvoiceInfo>>();
        if (null == markIdSet || markIdSet.size() <= 0) {
            return jdInvoiceMap;
        }
        markIdSet.forEach(markId -> {
            String data = "token=" + token + "&markId=" + markId;
            log.info("@@@\u83b7\u53d6\u5230\u7684markID\u4e3a\uff1a" + markId);
            String json = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/invoice/select", data);
            log.info("@@@\u83b7\u53d6\u5230\u7684\u4eac\u4e1c\u63a5\u53e3json\u4e3a\uff1a" + json);
            JSONObject node = JSONObject.fromObject((Object)json);
            if (node.getBoolean("success")) {
                Object result = node.get("result");
                JSONArray ja = JSONArray.fromObject((Object)result);
                for (int i = 0; i < ja.size(); ++i) {
                    String itemParam;
                    String invoiceItemJson;
                    JSONObject invoiceItemJo;
                    JSONObject jo = ja.getJSONObject(i);
                    JdInvoiceInfo jdInvoiceInfo = new JdInvoiceInfo();
                    jdInvoiceInfo.setMarkId((String)markId);
                    jdInvoiceInfo.setResultCode(node.getString("resultCode"));
                    if ("3302".equals(node.getString("resultCode")) && "null".equals(node.getString("resultMessage"))) {
                        jdInvoiceInfo.setResultMessage(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5f00\u7968\u3002", (String)"JDOrderUtil_4", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    } else {
                        jdInvoiceInfo.setResultMessage(node.getString("resultMessage"));
                    }
                    jdInvoiceInfo.setInvoiceId(jo.getString("invoiceId"));
                    jdInvoiceInfo.setInvoiceCode(jo.getString("invoiceCode"));
                    jdInvoiceInfo.setInvoiceDate(DateUtil.string2date(jo.getString("invoiceDate"), null));
                    jdInvoiceInfo.setInvoiceNakedAmount(JDOrderUtil.converStr2BigDecimal(jo.getString("invoiceNakedAmount")));
                    jdInvoiceInfo.setInvoiceTaxRate(JDOrderUtil.converStr2BigDecimal(jo.getString("invoiceTaxRate")));
                    jdInvoiceInfo.setInvoiceTaxAmount(JDOrderUtil.converStr2BigDecimal(jo.getString("invoiceTaxAmount")));
                    jdInvoiceInfo.setInvoiceAmount(JDOrderUtil.converStr2BigDecimal(jo.getString("invoiceAmount")));
                    jdInvoiceInfo.setInvoiceType(jo.getString("invoiceType"));
                    String fileData = "token=" + token + "&jdOrderId=" + markId.split("-")[1] + "&ivcType=" + jdInvoiceInfo.getInvoiceType();
                    String invoiceListJson = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/invoice/getInvoiceList", fileData);
                    JSONObject node3 = JSONObject.fromObject((Object)invoiceListJson);
                    if (node3.getString("success").equals("true")) {
                        JSONArray fileResult = JSONArray.fromObject((Object)node3.get("result"));
                        jdInvoiceInfo.setInvoiceFileUrl(fileResult.getJSONObject(0).getString("fileUrl"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)jdInvoiceInfo.getInvoiceId()) && StringUtils.isNotEmpty((CharSequence)jdInvoiceInfo.getInvoiceCode()) && (invoiceItemJo = JSONObject.fromObject((Object)(invoiceItemJson = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/invoice/queryInvoiceItem", itemParam = "token=" + token + "&invoiceId=" + jdInvoiceInfo.getInvoiceId() + "&invoiceCode=" + jdInvoiceInfo.getInvoiceCode())))).getBoolean("success")) {
                        JSONObject invoiceItemRespJo = invoiceItemJo.getJSONObject("result");
                        JSONArray invoiceSkuDetailJa = invoiceItemRespJo.getJSONArray("skuDetails");
                        Set<String> ecOrders = jdInvoiceInfo.getEcOrders();
                        List<JdInvoiceSkuDetail> jdInvoiceSkuDetails = jdInvoiceInfo.getInvoiceSkuDetails();
                        for (int j = 0; j < invoiceSkuDetailJa.size(); ++j) {
                            JSONObject invoiceSkuDetailJo = invoiceSkuDetailJa.getJSONObject(j);
                            ecOrders.add(invoiceSkuDetailJo.getString("jdOrderId"));
                            jdInvoiceSkuDetails.add(new JdInvoiceSkuDetail(invoiceSkuDetailJo));
                        }
                    }
                    log.info("@@@\u53d1\u7968\u63a5\u53e3\u6210\u529f\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\uff1a" + jdInvoiceInfo);
                    ArrayList<JdInvoiceInfo> jdInvoiceInfos = (ArrayList<JdInvoiceInfo>)jdInvoiceMap.get(markId);
                    if (jdInvoiceInfos == null) {
                        jdInvoiceInfos = new ArrayList<JdInvoiceInfo>(ja.size());
                        jdInvoiceInfos.add(jdInvoiceInfo);
                    } else {
                        jdInvoiceInfos.add(jdInvoiceInfo);
                    }
                    jdInvoiceMap.put((String)markId, (List<JdInvoiceInfo>)jdInvoiceInfos);
                    jdInvoiceInfo.setSuccess(true);
                }
            } else {
                JdInvoiceInfo jdInvoiceInfo = new JdInvoiceInfo();
                jdInvoiceInfo.setSuccess(false);
                jdInvoiceInfo.setMarkId((String)markId);
                jdInvoiceInfo.setResultCode(node.getString("resultCode"));
                jdInvoiceInfo.setResultMessage(node.getString("resultMessage"));
                log.info("@@@\u53d1\u7968\u63a5\u53e3\u5931\u8d25\u67e5\u8be2\u65f6\u53d1\u7968\u4fe1\u606f\uff1a" + jdInvoiceInfo);
                ArrayList<JdInvoiceInfo> jdInvoiceInfos = new ArrayList<JdInvoiceInfo>(1);
                jdInvoiceInfos.add(jdInvoiceInfo);
                jdInvoiceMap.put((String)markId, (List<JdInvoiceInfo>)jdInvoiceInfos);
            }
        });
        return jdInvoiceMap;
    }

    public static BigDecimal converStr2BigDecimal(String str) {
        if (StringUtils.endsWithIgnoreCase((CharSequence)str, (CharSequence)"null")) {
            return BigDecimal.ZERO;
        }
        return CommonUtil.getBigDecimalPro(str);
    }

    public static void updateJdStateInfo(Set<String> jdChildIdSet) {
        if (null == jdChildIdSet || jdChildIdSet.size() <= 0) {
            jdChildIdSet = JDOrderUtil.getNeededChildOrderList();
        }
        log.info("@@@kd.scm.common.util.JDOrderUtil.autoUpdateJdStateInfo()\u83b7\u53d6\u5230\u7684\u5b50\u8ba2\u5355\u4e2a\u6570\uff1a" + jdChildIdSet.size());
        if (jdChildIdSet.size() > 0) {
            String token = JDAccessTokenUtil.getAccessTokenByKD(RequestContext.get().getTenantId());
            log.info("@@@kd.scm.common.util.JDOrderUtil.autoUpdateJdStateInfo()\u83b7\u53d6\u5230\u7684Token\uff1a" + token);
            Map<String, JdOrderInfo> resultMap = JDOrderUtil.getJdOrderState(token, jdChildIdSet);
            QFilter filter = new QFilter("number", "in", resultMap.keySet());
            Object[] dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)"number,jdchildorderstatus,jdstate", (QFilter[])new QFilter[]{filter});
            if (null == dyos || dyos.length <= 0) {
                return;
            }
            log.info("@@@\u83b7\u53d6\u4eac\u4e1c\u5355\u4e2a\u6570" + dyos.length);
            for (DynamicObject dynamicObject : dyos) {
                String childOrderId = dynamicObject.getString("number");
                JdOrderInfo jdOrderInfoValue = resultMap.get(childOrderId);
                if (jdOrderInfoValue == null) continue;
                log.info("@@@kd.scm.common.util.JDOrderUtil.autoUpdateJdStateInfo()\u5b50\u8ba2\u5355ID\uff1a" + childOrderId);
                dynamicObject.set("jdchildorderstatus", (Object)jdOrderInfoValue.getJdOrderState());
                dynamicObject.set("jdstate", (Object)jdOrderInfoValue.getState());
            }
            BusinessDataWriter.save((IDataEntityType)dyos[0].getDataEntityType(), (Object[])dyos);
            log.info("@@@kd.scm.common.util.JDOrderUtil.autoUpdateJdStateInfo()\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
        }
    }

    public static void updateJdInvoiceInfo() {
        JDOrderUtil.updateJdInvoiceInfo(null);
    }

    public static void updateJdInvoiceInfo(Set<String> jdChildOrderSet) {
        QFilter invoiceIdFilter = new QFilter("invoiceid", "=", (Object)" ");
        QFilter invoiceCodeFilter = new QFilter("invoicecode", "=", (Object)" ");
        QFilter invoicestateFilter = new QFilter("invoicestate", "!=", (Object)"1");
        QFilter jdFilter = invoiceIdFilter.and(invoiceCodeFilter).and(invoicestateFilter);
        if (jdChildOrderSet != null && jdChildOrderSet.size() > 0) {
            jdFilter.and(new QFilter("number", "in", jdChildOrderSet));
        }
        String selector = "markid,number,invoicestate,invoiceresult,invoiceid,invoicecode,invoicedate,invoiceamount,invoicetax,invoicetaxamount,invoicetype,invaddress";
        DynamicObject[] jdDyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)selector, (QFilter[])new QFilter[]{jdFilter});
        HashSet<String> markIdSet = new HashSet<String>();
        HashMap<String, String> markIdMap = new HashMap<String, String>();
        for (DynamicObject dyo : jdDyos) {
            String markId = dyo.getString("markid");
            String number = dyo.getString("number");
            if (StringUtils.isNotBlank((CharSequence)markId) && StringUtils.isNotBlank((CharSequence)number)) {
                markIdMap.put(dyo.getString("number"), markId);
                markIdSet.add(markId);
            }
            log.info("@@@\u83b7\u53d6\u5230\u7684markId\uff1a[" + dyo.getString("markid") + "]\u5b50\u8ba2\u5355id\uff1a" + dyo.getString("number"));
        }
        log.info("@@@kd.scm.common.util.JDOrderUtil.autoUpdateJdInvoiceInfo()\u83b7\u53d6\u5230\u7684markId\u4e2a\u6570\uff1a" + markIdSet.size());
        if (markIdSet.size() > 0) {
            String token = JDAccessTokenUtil.getAccessTokenByKD(RequestContext.get().getTenantId());
            Map<String, List<JdInvoiceInfo>> invoiceMap = JDOrderUtil.getJdInvoiceState(token, markIdSet);
            JDOrderUtil.updateJdorder(jdDyos, invoiceMap);
            JDOrderUtil.updateInvoiceBill(markIdMap, invoiceMap);
        }
    }

    private static void updateJdorder(DynamicObject[] jdDyos, Map<String, List<JdInvoiceInfo>> invoiceMap) {
        for (DynamicObject jdOrder : jdDyos) {
            String markid = jdOrder.getString("markid");
            List<JdInvoiceInfo> jdInvoiceInfos = invoiceMap.get(markid);
            String ecOrder = jdOrder.getString("number");
            if (jdInvoiceInfos == null || jdInvoiceInfos.isEmpty()) continue;
            for (JdInvoiceInfo jdInvoiceInfoValue : jdInvoiceInfos) {
                if (!jdInvoiceInfoValue.getEcOrders().contains(ecOrder) && jdInvoiceInfoValue.isSuccess()) continue;
                JDOrderUtil.updateJdorderByInv(jdOrder, jdInvoiceInfoValue);
            }
        }
        BusinessDataWriter.save((IDataEntityType)jdDyos[0].getDataEntityType(), (Object[])jdDyos);
        log.info("@@@kd.scm.common.util.JDOrderUtil.autoUpdateJdStateInfo()\u5546\u57ce\u8ba2\u5355\u5f00\u7968\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
    }

    public static void updateJdorderByInv(DynamicObject jdOrder, JdInvoiceInfo jdInvoiceInfoValue) {
        log.info("@@@kd.scm.common.util.JDOrderUtil.autoUpdateJdInvoiceInfo()\u53d1\u7968\u552f\u4e00\u6807\u5fd7\u5bf9\u5e94\u4eac\u4e1c\u5355\uff1a" + jdOrder.getString("number"));
        JDOrderUtil.setInvoiceSate(jdInvoiceInfoValue, jdOrder);
        if (jdInvoiceInfoValue.getResultMessage() != null) {
            if (jdInvoiceInfoValue.getResultMessage().length() > 250) {
                jdOrder.set("invoiceresult", (Object)jdInvoiceInfoValue.getResultMessage().substring(0, 250));
            } else {
                jdOrder.set("invoiceresult", (Object)jdInvoiceInfoValue.getResultMessage());
            }
        }
        jdOrder.set("invoiceid", (Object)jdInvoiceInfoValue.getInvoiceId());
        jdOrder.set("invoicecode", (Object)jdInvoiceInfoValue.getInvoiceCode());
        jdOrder.set("invoicedate", (Object)jdInvoiceInfoValue.getInvoiceDate());
        jdOrder.set("invoiceamount", (Object)jdInvoiceInfoValue.getInvoiceNakedAmount());
        jdOrder.set("invoicetax", (Object)jdInvoiceInfoValue.getInvoiceTaxAmount());
        jdOrder.set("invoicetaxamount", (Object)jdInvoiceInfoValue.getInvoiceAmount());
        jdOrder.set("invoicetype", (Object)jdInvoiceInfoValue.getInvoiceType());
        jdOrder.set("invaddress", (Object)jdInvoiceInfoValue.getInvoiceFileUrl());
    }

    private static void updateInvoiceBill(Map<String, String> markIdMap, Map<String, List<JdInvoiceInfo>> invoiceMap) {
        QFilter filter = new QFilter("entryentity1.entryjdorder.number", "in", markIdMap.keySet());
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pur_invoice", (String)"invoicecode,invoiceno,invoicedate,invoiceid,invaddress,entryentity1.entryjdorder,entryentity1.entryjdorder.number,entryentity,entryentity.invamount,entryentity.invtax,entryentity.invoiceamount,entryentity.invcode,entryentity.invno,entryentity.invdate,entryentity.invserialnum,entryentity.invaddr,entryentity.invid,entryentity.invremark,entryentity.invattachment,sumtaxamount,sumamount,sumtax,sumqty,entryentity1.taxamount1,entryentity1.amount1,entryentity1.tax1,entryentity1.qty1,entryentity1,entryentity1.goods1,entryentity1.goods1.number", (QFilter[])new QFilter[]{filter});
        if (null == dyos || dyos.length == 0) {
            return;
        }
        log.info("@@@\u83b7\u53d6\u5230\u4eac\u4e1c\u5b50\u5355\u5bf9\u5e94\u7684\u53d1\u7968\u7b7e\u6536\u4e2a\u6570" + dyos.length);
        HashSet<DynamicObject> sucessBill = new HashSet<DynamicObject>();
        HashSet<String> sucesspks = new HashSet<String>();
        HashSet<String> errorpks = new HashSet<String>();
        for (DynamicObject bill : dyos) {
            String childOrderId = JDOrderUtil.getEcChildOrderIdFromInvoiceDyn(bill);
            String markid = markIdMap.get(childOrderId);
            log.info("@@@\u53d1\u7968\u552f\u4e00\u6807\u5fd7\uff0cchildOrderId\uff1a" + markid + ":" + childOrderId);
            List<JdInvoiceInfo> jdInvoiceInfos = invoiceMap.get(markid);
            if (jdInvoiceInfos == null || jdInvoiceInfos.isEmpty()) continue;
            JDOrderUtil.updateInvoiceBillValue(bill, jdInvoiceInfos);
            String resultCode = jdInvoiceInfos.get(0).getResultCode();
            if (JDOrderUtil.isInvoiceSuccess(jdInvoiceInfos.get(0)) && !"3301".equals(resultCode) && !"0010".equals(resultCode)) {
                sucessBill.add(bill);
                sucesspks.add(bill.getPkValue().toString());
            }
            if (JDOrderUtil.isInvoiceSuccess(jdInvoiceInfos.get(0))) continue;
            errorpks.add(bill.getPkValue().toString());
            log.info("@@@kd.scm.common.util.JDOrderUtil.\u88ab\u9a73\u56de\u7684\u53d1\u7968\u7b7e\u6536\u5355\uff1a" + bill.getPkValue());
        }
        JDOrderUtil.saveAndSubmitAuditInvBill(sucessBill, dyos, sucesspks, errorpks);
    }

    private static String getEcChildOrderIdFromInvoiceDyn(DynamicObject invoiceDyn) {
        DynamicObject entryjdorder = ((DynamicObject)invoiceDyn.getDynamicObjectCollection("entryentity1").get(0)).getDynamicObject("entryjdorder");
        if (entryjdorder == null) {
            return "";
        }
        return entryjdorder.getString("number");
    }

    public static void updateInvoiceBillValue(DynamicObject bill, List<JdInvoiceInfo> jdInvoiceInfos) {
        JdInvoiceInfo jdInvoiceInfo = jdInvoiceInfos.get(0);
        bill.set("invoicecode", (Object)jdInvoiceInfo.getInvoiceCode());
        bill.set("invoiceno", (Object)jdInvoiceInfo.getInvoiceId());
        bill.set("invoiceid", (Object)jdInvoiceInfo.getInvoiceId());
        bill.set("invoicedate", (Object)jdInvoiceInfo.getInvoiceDate());
        bill.set("invaddress", (Object)jdInvoiceInfo.getInvoiceFileUrl());
        JDOrderUtil.updateInvoiceDetailEntry(bill, jdInvoiceInfos);
        JDOrderUtil.updateMaterialEntry(bill, jdInvoiceInfos);
    }

    private static void updateMaterialEntry(DynamicObject bill, List<JdInvoiceInfo> jdInvoiceInfos) {
        DynamicObjectCollection materialEntryCol = bill.getDynamicObjectCollection("entryentity1");
        Iterator itr = materialEntryCol.iterator();
        BigDecimal sumtaxamount = bill.getBigDecimal("sumtaxamount");
        BigDecimal sumamount = bill.getBigDecimal("sumamount");
        BigDecimal sumtax = bill.getBigDecimal("sumtax");
        HashSet<String> failEcOrderIdSet = new HashSet<String>(materialEntryCol.size());
        HashSet<String> ecOrderIdSet = new HashSet<String>(materialEntryCol.size());
        while (itr.hasNext()) {
            DynamicObject materialEntry = (DynamicObject)itr.next();
            String ecOrderId = materialEntry.getString("entryjdorder.number");
            String sku = materialEntry.getString("goods1.number");
            BigDecimal qty = materialEntry.getBigDecimal("qty1");
            boolean isExist = false;
            for (JdInvoiceInfo jdInvoiceInfo : jdInvoiceInfos) {
                if (!jdInvoiceInfo.isSuccess()) {
                    log.info("@@\u6ca1\u6709\u83b7\u53d6\u5230\u53d1\u7968\u4fe1\u606f\u3002");
                    return;
                }
                List<JdInvoiceSkuDetail> jdInvoiceSkuDetails = jdInvoiceInfo.getInvoiceSkuDetails();
                for (JdInvoiceSkuDetail jdInvoiceSkuDetail : jdInvoiceSkuDetails) {
                    ecOrderIdSet.add(jdInvoiceSkuDetail.getJdOrderId());
                    if (!StringUtils.equals((CharSequence)jdInvoiceSkuDetail.getJdOrderId(), (CharSequence)ecOrderId) || !StringUtils.equals((CharSequence)jdInvoiceSkuDetail.getSkuId(), (CharSequence)sku)) continue;
                    isExist = true;
                    if (qty.compareTo(jdInvoiceSkuDetail.getNum()) == 0) continue;
                    log.info("@@\u53d1\u73b0\u53d1\u7968\u7b7e\u6536\u5546\u54c1\u6570\u91cf\u4e0e\u7535\u5546\u53d1\u7968\u5546\u54c1\u6570\u91cf\u4e0d\u4e00\u81f4:" + jdInvoiceInfo);
                    materialEntry.set("qty1", (Object)jdInvoiceSkuDetail.getNum());
                    BigDecimal oldTaxamount1 = materialEntry.getBigDecimal("taxamount1");
                    BigDecimal taxamount1 = oldTaxamount1.divide(qty).multiply(jdInvoiceSkuDetail.getNum());
                    materialEntry.set("taxamount1", (Object)taxamount1);
                    sumtaxamount = sumtaxamount.subtract(oldTaxamount1.subtract(taxamount1));
                    BigDecimal oldAmount1 = materialEntry.getBigDecimal("amount1");
                    BigDecimal amount1 = oldAmount1.divide(qty).multiply(jdInvoiceSkuDetail.getNum());
                    materialEntry.set("amount1", (Object)amount1);
                    sumamount = sumamount.subtract(oldAmount1.subtract(amount1));
                    BigDecimal oldTax1 = materialEntry.getBigDecimal("tax1");
                    BigDecimal tax1 = oldTax1.divide(qty).multiply(jdInvoiceSkuDetail.getNum());
                    materialEntry.set("tax1", (Object)tax1);
                    sumtax = sumtax.subtract(oldTax1.subtract(tax1));
                }
            }
            if (isExist) continue;
            log.info("@@\u53d1\u73b0\u53d1\u7968\u7b7e\u6536\u5355\u4e2d\u4e0d\u5b58\u5728\u8ba2\u5355\u5546\u54c1" + ecOrderId + ":" + sku + ":" + qty);
            sumtaxamount = sumtaxamount.subtract(materialEntry.getBigDecimal("taxamount1"));
            sumamount = sumamount.subtract(materialEntry.getBigDecimal("amount1"));
            sumtax = sumtax.subtract(materialEntry.getBigDecimal("tax1"));
            failEcOrderIdSet.add(ecOrderId);
            itr.remove();
        }
        bill.set("sumtaxamount", (Object)sumtaxamount);
        bill.set("sumamount", (Object)sumamount);
        bill.set("sumtax", (Object)sumtax);
        failEcOrderIdSet.removeIf(ecOrderIdSet::contains);
        JDOrderUtil.updateEcOrderForPartFail(failEcOrderIdSet);
    }

    public static void updateEcOrderForPartFail(Set<String> failEcOrderIdSet) {
        if (failEcOrderIdSet != null && !failEcOrderIdSet.isEmpty()) {
            DynamicObject[] jdDyos;
            QFilter numberFilter = new QFilter("number", "in", failEcOrderIdSet);
            String selector = "markid,number,invoicestate,invoiceresult,invoiceid,invoicecode,invoicedate,invoiceamount,invoicetax,invoicetaxamount,invoicetype,invaddress";
            for (DynamicObject jdDyo : jdDyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)selector, (QFilter[])new QFilter[]{numberFilter})) {
                jdDyo.set("invoicestate", (Object)"8");
                jdDyo.set("invoiceresult", (Object)ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\u90e8\u5206", (String)"JDOrderUtil_6", (String)"scm-common", (Object[])new Object[0]));
            }
            SaveServiceHelper.save((DynamicObject[])jdDyos);
        }
    }

    private static void updateInvoiceDetailEntry(DynamicObject bill, List<JdInvoiceInfo> jdInvoiceInfos) {
        DynamicObjectCollection invoiceDetailEntryCol = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, DynamicObject> invIdInvDetailEntryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject invoiceDetaiEntry : invoiceDetailEntryCol) {
            invIdInvDetailEntryMap.put(invoiceDetaiEntry.getString("invno"), invoiceDetaiEntry);
        }
        for (JdInvoiceInfo jdInvoiceInfo : jdInvoiceInfos) {
            if (!jdInvoiceInfo.isSuccess() || !StringUtils.isNotEmpty((CharSequence)jdInvoiceInfo.getInvoiceId())) continue;
            DynamicObject invoiceDetailEntry = null;
            if (invIdInvDetailEntryMap.containsKey(jdInvoiceInfo.getInvoiceId())) {
                invoiceDetailEntry = (DynamicObject)invIdInvDetailEntryMap.get(jdInvoiceInfo.getInvoiceId());
            } else {
                invoiceDetailEntry = new DynamicObject(invoiceDetailEntryCol.getDynamicObjectType());
                invoiceDetailEntryCol.add((Object)invoiceDetailEntry);
            }
            invoiceDetailEntry.set("invamount", (Object)jdInvoiceInfo.getInvoiceAmount());
            invoiceDetailEntry.set("invdate", (Object)jdInvoiceInfo.getInvoiceDate());
            invoiceDetailEntry.set("invcode", (Object)jdInvoiceInfo.getInvoiceCode());
            invoiceDetailEntry.set("invno", (Object)jdInvoiceInfo.getInvoiceId());
            invoiceDetailEntry.set("invaddr", (Object)jdInvoiceInfo.getInvoiceFileUrl());
            invoiceDetailEntry.set("invoiceamount", (Object)jdInvoiceInfo.getInvoiceNakedAmount());
            invoiceDetailEntry.set("invtax", (Object)jdInvoiceInfo.getInvoiceTaxAmount());
        }
        invoiceDetailEntryCol.removeIf(enty -> StringUtils.isEmpty((CharSequence)enty.getString("invno")));
    }

    public static void saveAndSubmitAuditInvBill(Set<DynamicObject> sucessBill, DynamicObject[] dyos, Set<String> sucesspks, Set<String> errorpks) {
        if (sucessBill.size() > 0) {
            BusinessDataWriter.save((IDataEntityType)dyos[0].getDataEntityType(), (Object[])sucessBill.toArray());
            log.info("@@@\u4fdd\u5b58\u53d1\u7968\u7b7e\u6536\u5355\u4e2a\u6570:" + sucessBill.size());
            if (sucesspks.size() > 0) {
                OperationResult auditResult;
                Object[] pks = sucesspks.toArray(new String[0]);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("WF", String.valueOf(false));
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"pur_invoice", (Object[])pks, (OperateOption)option);
                if (!submitResult.isSuccess()) {
                    log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u63d0\u4ea4\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails(submitResult.getAllErrorOrValidateInfo()));
                }
                if (!(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"pur_invoice", (Object[])pks, (OperateOption)option)).isSuccess()) {
                    log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u5ba1\u6838\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails(auditResult.getAllErrorOrValidateInfo()));
                }
            }
        }
        if (errorpks.size() > 0) {
            BusinessDataWriter.delete((IDataEntityType)dyos[0].getDataEntityType(), (Object[])errorpks.toArray());
            log.info("@@@\u5220\u9664\u53d1\u7968\u7b7e\u6536\u5355\u4e2a\u6570:" + errorpks.size());
        }
        log.info("@@@kd.scm.common.util.JDOrderUtil.autoUpdateJdInvoiceInfo()\u5f00\u7968\u7b7e\u6536\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
    }

    public static boolean isInvoiceSuccess(JdInvoiceInfo jdInvoiceInfoValue) {
        String code = jdInvoiceInfoValue.getResultCode();
        boolean isSucess = true;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            switch (code) {
                case "0004": 
                case "0005": 
                case "0006": 
                case "3301": 
                case "3303": 
                case "0010": {
                    isSucess = true;
                    break;
                }
                case "3302": 
                case "3304": 
                case "5002": 
                case "5001": {
                    isSucess = false;
                    break;
                }
                default: {
                    isSucess = false;
                }
            }
        }
        return isSucess;
    }

    private static Set<String> getNeededChildOrderList() {
        HashSet<String> idSet = new HashSet<String>();
        QFilter cStatusFilter = new QFilter("jdchildorderstatus", "!=", (Object)"19");
        QFilter pStatusFilter = new QFilter("jdorderstate", "=", (Object)"1");
        QFilter stateFilter = new QFilter("jdstate", "!=", (Object)"1");
        QFilter filter = stateFilter.and(cStatusFilter).and(pStatusFilter);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pbd_jdorder", (String)"number", (QFilter[])new QFilter[]{filter});
        dyoCol.forEach(dyo -> {
            String childOrderId = dyo.getString("number");
            if (StringUtils.isNotBlank((CharSequence)childOrderId)) {
                idSet.add(dyo.getString("number"));
                log.info("@@@\u83b7\u53d6\u5230\u7684JdChildOrderID\uff1a[" + childOrderId + "]");
            }
        });
        return idSet;
    }

    private static void setInvoiceSate(JdInvoiceInfo info, DynamicObject bill) {
        String code = info.getResultCode();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            switch (code) {
                case "0001": {
                    bill.set("invoicestate", (Object)"1");
                    break;
                }
                case "3301": {
                    bill.set("invoicestate", (Object)"2");
                    break;
                }
                case "3302": {
                    bill.set("invoicestate", (Object)"3");
                    break;
                }
                case "0005": {
                    bill.set("invoicestate", (Object)"4");
                    break;
                }
                case "3303": {
                    bill.set("invoicestate", (Object)"5");
                    break;
                }
                case "0004": {
                    bill.set("invoicestate", (Object)"6");
                    break;
                }
                case "0007": {
                    bill.set("invoicestate", (Object)"9");
                    break;
                }
                case "0010": {
                    bill.set("invoicestate", (Object)"7");
                    break;
                }
                default: {
                    bill.set("invoicestate", (Object)"8");
                }
            }
        }
    }

    public static String confirmRecieve(Set<String> childOrderIdSet) {
        StringBuilder result = new StringBuilder();
        String token = JDAccessTokenUtil.getAccessTokenByKD(RequestContext.get().getTenantId());
        for (String jdOrderID : childOrderIdSet) {
            String data = "token=" + token + "&jdOrderId=" + jdOrderID;
            String json = JDHttpsUtil.httpsJDPost("https://bizapi.jd.com/api/order/confirmReceived", data);
            log.info("$$$$$$$\u4eac\u4e1c\u786e\u8ba4\u6536\u8d27\u8fd4\u56de\u7ed3\u679c\uff1a" + json);
            JSONObject node = JSONObject.fromObject((Object)json);
            if (node.getBoolean("success")) continue;
            result.append(MessageFormat.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7535\u5546\u5b50\u8ba2\u5355{0}\u786e\u8ba4\u6536\u8d27\u5931\u8d25\uff1a{1}\u3002", (String)"JDOrderUtil_5", (String)"scm-common", (Object[])new Object[0]), jdOrderID, node.get("resultMessage"))).append('\n');
        }
        return result.toString();
    }

    public static void saveJdParentOrder(Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, String jsonStr) {
        DynamicObject jdOrder = BusinessDataServiceHelper.newDynamicObject((String)"pbd_jdorder");
        JDOrderUtil.setJdOrderHeadInfo(jdOrder, jsonStr);
        JDOrderUtil.setJdOrderEntryInfo(jdOrder, skuIdMap, priceMap, qtyMap);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jdOrder});
    }

    public static Map<String, Long> saveChildOrder(Map<String, Object> childJdOrderIdMap, String remittanceCode, DynamicObject jdOrder) {
        QFilter filter;
        DynamicObjectCollection dyoCol;
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        ArrayList<String> goodsNumList = new ArrayList<String>();
        DynamicObjectCollection dyos = new DynamicObjectCollection();
        for (Map.Entry<String, Object> entryMap : childJdOrderIdMap.entrySet()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)entryMap.getKey(), (CharSequence)"isHasChildOrder")) continue;
            JdOrderInfo jdOrderInfo = (JdOrderInfo)entryMap.getValue();
            goodsNumList.addAll(jdOrderInfo.getSkuList());
            if (QueryServiceHelper.exists((String)"pbd_jdorder", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)jdOrderInfo.getJdOrderId())})) continue;
            DynamicObject childOrder = (DynamicObject)OrmUtils.clone((IDataEntityBase)jdOrder, (boolean)false, (boolean)true);
            JDOrderUtil.setJdChildOrderHeadInfo(childOrder, remittanceCode, jdOrderInfo);
            JDOrderUtil.setJdChildOrderEntryInfo(childOrder, jdOrderInfo.getSkuList());
            dyos.add((Object)childOrder);
        }
        if (!dyos.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dyos.toArray((Object[])new DynamicObject[dyos.size()])));
        }
        if (null != (dyoCol = QueryServiceHelper.query((String)"pbd_jdorder", (String)"entryentity.goods.number,id", (QFilter[])new QFilter[]{filter = new QFilter("entryentity.goods.number", "in", goodsNumList).and("number", "in", childJdOrderIdMap.keySet())})) && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                resultMap.put(dyo.getString("entryentity.goods.number"), dyo.getLong("id"));
            }
        }
        return resultMap;
    }

    private static void setJdChildOrderHeadInfo(DynamicObject childOrder, String remittanceCode, JdOrderInfo jdOrderInfo) {
        Date currentDate = new Date();
        String personId = RequestContext.get().getUserId();
        childOrder.set("number", (Object)jdOrderInfo.getJdOrderId());
        childOrder.set("jdorderid", (Object)jdOrderInfo.getpOrder());
        childOrder.set("jdorderstate", (Object)jdOrderInfo.getOrderState());
        childOrder.set("jdstate", (Object)jdOrderInfo.getState());
        childOrder.set("jdchildorderstatus", (Object)jdOrderInfo.getJdOrderState());
        childOrder.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        childOrder.set("paycode", (Object)remittanceCode);
        childOrder.set("amount", (Object)CommonUtil.getBigDecimalPro(jdOrderInfo.getOrderNakedPrice()));
        childOrder.set("tax", (Object)CommonUtil.getBigDecimalPro(jdOrderInfo.getOrderTaxPrice()));
        childOrder.set("freight", (Object)CommonUtil.getBigDecimalPro(jdOrderInfo.getFreight()));
        childOrder.set("taxamount", (Object)CommonUtil.getBigDecimalPro(jdOrderInfo.getOrderPrice()));
        childOrder.set("creator", (Object)personId);
        childOrder.set("createtime", (Object)currentDate);
        childOrder.set("modifier", (Object)personId);
        childOrder.set("modifytime", (Object)currentDate);
        childOrder.set("auditor", (Object)personId);
        childOrder.set("auditdate", (Object)currentDate);
    }

    private static void setJdChildOrderEntryInfo(DynamicObject childOrder, List<String> skuList) {
        DynamicObjectCollection oldEntryDyoCol = childOrder.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newEntryDynCol = new DynamicObjectCollection();
        for (DynamicObject dyo : oldEntryDyoCol) {
            String goodsNum = dyo.getString("goods.number");
            if (!skuList.contains(goodsNum)) continue;
            newEntryDynCol.add((Object)dyo);
        }
        childOrder.set("entryentity", (Object)newEntryDynCol);
    }

    public static void setJdOrderHeadInfo(DynamicObject jdOrder, String jsonStr) {
        String currency = MalOrderUtil.getDefaultCurrency();
        Date currentDate = new Date();
        String personId = RequestContext.get().getUserId();
        JSONObject node = JSONObject.fromObject((Object)jsonStr).getJSONObject("result");
        String jdOrderId = node.getString("jdOrderId");
        jdOrder.set("number", (Object)jdOrderId);
        jdOrder.set("jdorderid", (Object)jdOrderId);
        jdOrder.set("jdorderstate", (Object)"1");
        jdOrder.set("jdstate", (Object)"0");
        jdOrder.set("jdchildorderstatus", (Object)"1");
        jdOrder.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        jdOrder.set("amount", (Object)BigDecimal.valueOf(node.getDouble("orderNakedPrice")));
        jdOrder.set("tax", (Object)BigDecimal.valueOf(node.getDouble("orderTaxPrice")));
        jdOrder.set("freight", (Object)BigDecimal.valueOf(node.containsKey((Object)"freight") ? node.getDouble("freight") : 0.0));
        jdOrder.set("taxamount", (Object)BigDecimal.valueOf(node.getDouble("orderPrice")));
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            jdOrder.set("currency", (Object)currency);
        } else {
            jdOrder.set("currency", (Object)"1");
        }
        jdOrder.set("status", (Object)"C");
        jdOrder.set("enable", (Object)"1");
        jdOrder.set("creator", (Object)personId);
        jdOrder.set("createtime", (Object)currentDate);
        jdOrder.set("modifier", (Object)personId);
        jdOrder.set("modifytime", (Object)currentDate);
        jdOrder.set("auditor", (Object)personId);
        jdOrder.set("auditdate", (Object)currentDate);
    }

    private static void setJdOrderEntryInfo(DynamicObject jdOrder, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap) {
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)jdOrder.get("entryentity");
        for (Map.Entry<String, Integer> skuMap : qtyMap.entrySet()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)skuIdMap.get(skuMap.getKey()));
            entryDyo.set("qty", (Object)skuMap.getValue());
            entryDyo.set("taxprice", (Object)priceMap.get(skuMap.getKey()).getTaxPrice());
            entryDyo.set("jdprice", (Object)priceMap.get(skuMap.getKey()).getEcPrice());
        }
    }

    public static void updateJdChildOrder() {
        Map<String, DynamicObject> needHandleDyoMap = JDOrderUtil.getNeedHadleDyoMap();
        if (needHandleDyoMap.isEmpty()) {
            return;
        }
        log.info("\u672c\u6b21\u9700\u8981\u66f4\u65b0\u7684\u4eac\u4e1c\u7236\u8ba2\u5355\u4e3a\uff1a" + needHandleDyoMap.keySet());
        DynamicObject malOrderDyo = null;
        String token = JDAccessTokenUtil.getAccessTokenByKD(RequestContext.get().getTenantId());
        for (Map.Entry<String, DynamicObject> jdOrderIdMap : needHandleDyoMap.entrySet()) {
            DynamicObject dynamicObject;
            malOrderDyo = jdOrderIdMap.getValue();
            if (!StringUtils.isNotBlank((CharSequence)jdOrderIdMap.getKey()) || null == (dynamicObject = JDOrderUtil.getJdOrder(jdOrderIdMap.getKey())) || !dynamicObject.getString("number").equals(dynamicObject.getString("jdorderid"))) continue;
            Map<String, Object> childJdOrderIdMap = JDOrderUtil.getJdChildOrderIdMap(token, jdOrderIdMap.getKey());
            String remittanceCode = JdApiUtil.selectRemittanceCode(2, 0, jdOrderIdMap.getKey(), 0, 1, "", 0, dynamicObject.getBigDecimal("taxamount"));
            Map<String, Long> numberJdOrderIdMap = JDOrderUtil.getNumberJdOrderIdMap(childJdOrderIdMap, remittanceCode, dynamicObject);
            DynamicObjectCollection maColl = malOrderDyo.getDynamicObjectCollection("entryentity");
            for (DynamicObject coll : maColl) {
                if (childJdOrderIdMap == null) continue;
                if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
                    coll.set("jdorder", (Object)numberJdOrderIdMap.get(((DynamicObject)coll.get("goods")).get("number")));
                    continue;
                }
                coll.set("jdorder", (Object)numberJdOrderIdMap.get("jdorder"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{malOrderDyo});
            QFilter filter = new QFilter("jdorderid", "=", (Object)jdOrderIdMap.getKey());
            DynamicObject purOrder = BusinessDataServiceHelper.loadSingle((String)"pur_order", (String)"materialentry,materialentry.goods,materialentry.jdorder", (QFilter[])new QFilter[]{filter});
            if (purOrder != null) {
                DynamicObjectCollection purColl = purOrder.getDynamicObjectCollection("materialentry");
                for (DynamicObject coll : purColl) {
                    if (childJdOrderIdMap == null) continue;
                    if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
                        coll.set("jdorder", (Object)numberJdOrderIdMap.get(((DynamicObject)coll.get("goods")).get("number")));
                        continue;
                    }
                    coll.set("jdorder", (Object)numberJdOrderIdMap.get("jdorder"));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purOrder});
                continue;
            }
            log.info("@@not found purOrder:" + filter);
        }
    }

    public static Map<String, Long> getNumberJdOrderIdMap(Map<String, Object> childJdOrderIdMap, String remittanceCode, DynamicObject jdOrder) {
        HashMap<String, Long> resultMap = new HashMap();
        if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
            resultMap = JDOrderUtil.saveChildOrder(childJdOrderIdMap, remittanceCode, jdOrder);
        } else {
            jdOrder.set("paycode", (Object)remittanceCode);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jdOrder});
            resultMap.put("jdorder", jdOrder.getLong("id"));
        }
        return resultMap;
    }

    public static DynamicObject getJdOrder(String jdOrderId) {
        QFilter filter = new QFilter("number", "=", (Object)jdOrderId);
        String selectFields = DynamicObjectUtil.getSelectfields("pbd_jdorder", false);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)(selectFields = DynamicObjectUtil.getEntrySelectfields(selectFields, "pbd_jdorder", "entryentity", false)), (QFilter[])new QFilter[]{filter});
        if (dyos != null && dyos.length > 0) {
            return dyos[0];
        }
        return null;
    }

    public static Map<String, DynamicObject> getNeedHadleDyoMap() {
        QFilter timeFilter;
        HashMap<String, DynamicObject> needHandleDyoMap = new HashMap<String, DynamicObject>();
        QFilter platFilter = new QFilter("platform", "=", (Object)"2");
        QFilter jdOrderFilter = new QFilter("jdorderid", "!=", (Object)" ");
        QFilter statusFilter = new QFilter("jdorderstatus", "=", (Object)ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"JDOrderUtil_1", (String)"scm-common", (Object[])new Object[0]));
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"mal_order", (String)"jdorderid,entryentity,entryentity.goods,entryentity.jdorder", (QFilter[])new QFilter[]{platFilter, jdOrderFilter, statusFilter, timeFilter = new QFilter("auditdate", ">=", (Object)DateUtil.getDateByOffsetDay(new Date(), -15))});
        if (null != dyos && dyos.length > 0) {
            String jdorderId = "";
            for (DynamicObject dyo : dyos) {
                jdorderId = dyo.getString("jdorderid");
                DynamicObjectCollection maColl = dyo.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryDyo : maColl) {
                    if (!StringUtils.equals((CharSequence)jdorderId, (CharSequence)entryDyo.getString("jdorder.number"))) continue;
                    needHandleDyoMap.put(jdorderId, dyo);
                }
            }
        }
        return needHandleDyoMap;
    }

    public static void updateJdValidStatus() {
        Map<String, String> resultMap = JdApiUtil.getMessage("10");
        ArrayList<String> idList = new ArrayList<String>(resultMap.size());
        if (!CollectionUtils.isEmpty(resultMap)) {
            for (Map.Entry<String, String> entry : resultMap.entrySet()) {
                String orderId = JSONObject.fromObject((Object)entry.getValue()).getString("orderId");
                idList.add(orderId);
            }
        }
        if (idList.size() > 0) {
            QFilter filter = new QFilter("number", "in", idList);
            HashSet<String> pNumberSet = new HashSet<String>(idList.size());
            log.info("\u672c\u6b21\u6d88\u606f\u66f4\u65b0\u7684\u4eac\u4e1c\u8ba2\u5355\u53f7\uff1a" + ((Object)idList).toString());
            DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)"number,jdorderstate,jdorderid", (QFilter[])new QFilter[]{filter});
            if (null == dyos || dyos.length <= 0) {
                return;
            }
            log.info("@@@\u83b7\u53d6\u4eac\u4e1c\u5355\u4e2a\u6570" + dyos.length);
            for (DynamicObject dynamicObject : dyos) {
                dynamicObject.set("jdorderstate", (Object)"0");
                pNumberSet.add(dynamicObject.getString("jdorderid"));
            }
            SaveServiceHelper.save((DynamicObject[])dyos);
            QFilter orderfilter = new QFilter("jdorderid", "in", pNumberSet);
            DynamicObject[] orders = BusinessDataServiceHelper.load((String)"mal_order", (String)"id,jdorderstatus,creator,billno,billstatus,entryentity.erpbillstatus,entryentity.erplogstatus", (QFilter[])new QFilter[]{orderfilter});
            if (null == orders || orders.length <= 0) {
                return;
            }
            log.info("@@@\u83b7\u53d6\u5546\u57ce\u8ba2\u5355\u4e2a\u6570" + orders.length);
            try {
                JDOrderUtil.cancelOrder(orders, "jdorderstatus", JDOrderStatusEnum.JDCANCEL.getName(), false, "1");
                log.info("\u4eac\u4e1c\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u7684\u4e0b\u6e38\u8ba2\u5355\u72b6\u6001\u5f00\u59cb");
                HashSet<String> malOrderIds = new HashSet<String>(orders.length);
                for (DynamicObject dynamicObject : orders) {
                    if (!StringUtils.isNotBlank((CharSequence)dynamicObject.getString("id"))) continue;
                    malOrderIds.add(dynamicObject.getString("id"));
                }
                QFilter qFilter = new QFilter("billentry.srcbillid", "in", malOrderIds);
                HashSet<String> pmOrderNumbers = new HashSet<String>(orders.length);
                if (ApiConfigUtil.hasCQScmConfig() && StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)MalOrderUtil.getBizFlowParam())) {
                    DynamicObject[] purOrderBills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,cancelstatus,billno,billentry.srcbillid", (QFilter[])new QFilter[]{qFilter});
                    log.info("\u4eac\u4e1c\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u66f4\u65b0\u5546\u57ce\u4e0b\u6e38\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf: " + purOrderBills.length);
                    for (DynamicObject order : purOrderBills) {
                        if (!StringUtils.isNotBlank((CharSequence)order.getString("billno"))) continue;
                        pmOrderNumbers.add(order.getString("billno"));
                    }
                    JDOrderUtil.cancelOrder(purOrderBills, "cancelstatus", "B", true, "2");
                }
                DynamicObjectCollection malOrders = QueryServiceHelper.query((String)"mal_order", (String)"id,billno,entryentity.erpbillnumber", (QFilter[])new QFilter[]{orderfilter});
                HashSet<String> hashSet = new HashSet<String>(malOrders.size());
                for (DynamicObject malOrder : malOrders) {
                    if (!StringUtils.isNotBlank((CharSequence)malOrder.getString("entryentity.erpbillnumber"))) continue;
                    hashSet.add(malOrder.getString("entryentity.erpbillnumber"));
                }
                QFilter erpFilter = hashSet.size() > 0 ? new QFilter("billno", "in", hashSet) : (pmOrderNumbers.size() > 0 ? new QFilter("billno", "in", pmOrderNumbers) : new QFilter("billno", "=", (Object)"0"));
                DynamicObject[] purOrders = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billstatus,billno,cfmstatus,logstatus", (QFilter[])new QFilter[]{erpFilter});
                log.info("\u4eac\u4e1c\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u66f4\u65b0\u5546\u57ce\u4e0b\u6e38\u4f9b\u5e94\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf: " + purOrders.length);
                for (DynamicObject purOrder : purOrders) {
                    purOrder.set("billstatus", (Object)BillStatusEnum.CANCELED.getVal());
                    purOrder.set("cfmstatus", (Object)"");
                    purOrder.set("logstatus", (Object)"");
                    log.info("\u4eac\u4e1c\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u7684\u4e0b\u6e38\u8ba2\u5355\u72b6\u6001\u7ed3\u675f");
                    SaveServiceHelper.save((DynamicObject[])purOrders);
                }
            }
            catch (Exception exception) {
                log.info("\u5e9f\u5f03\u8fdb\u884c\u4e2d\u7684\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25--->" + ExceptionUtil.getStackTrace(exception));
            }
            JDOrderUtil.orderInvalidSendMessage(orders);
            int count = resultMap.size() % 100 > 0 ? resultMap.size() / 100 + 1 : resultMap.size() / 100;
            String[] stringArray = resultMap.keySet().toArray(new String[0]);
            if (count > 1) {
                JDOrderUtil.delMessage(stringArray, 0, 100);
                JDOrderUtil.delMessage(stringArray, 100, resultMap.size());
            } else {
                JDOrderUtil.delMessage(stringArray, 0, resultMap.size());
            }
        }
    }

    public static void cancelOrder(DynamicObject[] orders, String statusKey, String status, boolean useOp, String bizFlow) {
        for (DynamicObject bill : orders) {
            String orderId = bill.getString("id");
            if (StringUtils.equalsIgnoreCase((CharSequence)bizFlow, (CharSequence)MalOrderUtil.getBizFlowParam()) && WorkflowServiceHelper.inProcess((String)orderId)) {
                log.info("\u4eac\u4e1c\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u5b58\u5728\u5355\u636e\u5bf9\u5e94\u7684\u5904\u7406\u4e2d\u7684\u5ba1\u6279\u6d41\uff0c\u5f00\u59cb\u4e2d\u65ad\u5ba1\u6279\u6d41");
                Long procInstId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)orderId);
                if (null != procInstId) {
                    WorkflowServiceHelper.abandon((Long)procInstId);
                    log.info("\u4eac\u4e1c\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u5b58\u5728\u5355\u636e\u5bf9\u5e94\u7684\u5904\u7406\u4e2d\u7684\u5ba1\u6279\u6d41\uff0c\u6210\u529f\u4e2d\u65ad\u5ba1\u6279\u6d41");
                }
            }
            bill.set(statusKey, (Object)status);
            if (useOp) continue;
            bill.set("billstatus", (Object)BillStatusEnum.CANCELED.getVal());
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                entry.set("erpbillstatus", (Object)"Z");
                entry.set("erplogstatus", (Object)"");
            }
        }
        if (useOp) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationServiceHelper.executeOperate((String)"bizclose", (String)"pm_purorderbill", (DynamicObject[])orders, (OperateOption)option);
        } else {
            SaveServiceHelper.save((DynamicObject[])orders);
        }
    }

    public static void orderInvalidSendMessage(DynamicObject[] orders) {
        log.info("@@@\u8ba2\u5355\u5931\u6548\uff0c\u53d1\u9001\u901a\u77e5\u6d88\u606f\u5f00\u59cb\u3002\u5931\u6548\u8ba2\u5355\u6570\uff1a" + orders.length);
        List<Long> userIds = SEND_MSG_COMMON_SERVICE.getBillCreators(Arrays.asList(orders));
        Set<Long> enableUserId = SEND_MSG_COMMON_SERVICE.filterUnableUser(userIds);
        for (DynamicObject obj : orders) {
            Map<String, Object> msgParam = SEND_MSG_COMMON_SERVICE.toCreatorMap(obj);
            Object creator = obj.get("creator.id");
            Object billno = obj.get("billno");
            if (!enableUserId.contains((Long)creator)) continue;
            msgParam.put("title", ResManager.loadKDString((String)"\u8ba2\u5355\u5931\u6548\u901a\u77e5", (String)"JDOrderUtil_2", (String)"scm-common", (Object[])new Object[0]));
            msgParam.put("entityNumber", "mal_order");
            msgParam.put("formId", "mal_order");
            msgParam.put("tplScene", "mal_order_invalid_notice");
            msgParam.put("content", MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u7533\u8bf7\u7684\u5546\u57ce\u8ba2\u5355\uff08\u7f16\u53f7\uff1a{0}\uff09\u5df2\u5931\u6548\uff0c\u8bf7\u77e5\u6089\u3002", (String)"JDOrderUtil_3", (String)"scm-common", (Object[])new Object[0]), billno));
            MessageUtil.sendMessage(msgParam, true);
            log.info("@@@\u8ba2\u5355\u5931\u6548\uff0c\u53d1\u9001\u901a\u77e5\u6d88\u606f\u3002\u5931\u6548\u8ba2\u5355\u53f7\uff1a" + billno);
        }
    }

    private static void delMessage(String[] strs, int from, int to) {
        ArrayList<String> temp = new ArrayList<String>(100);
        for (int j = from; j < to; ++j) {
            temp.add(strs[j]);
        }
        JdApiUtil.delMessage(String.join((CharSequence)",", temp));
    }
}

