/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class JacksonJsonUtil {
    private static ObjectMapper toJSONMapper = new ObjectMapper();
    private static ObjectMapper fromJSONMapper = new ObjectMapper();

    public static <T> T fromJson(String json, Class<T> clazz) {
        ObjectMapper mapper = fromJSONMapper;
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json + "---parse json error==>"});
        }
    }

    public static <T> String toJson(Object value, Class<T> clazz) {
        ObjectMapper mapper = toJSONMapper;
        try {
            String json = mapper.writeValueAsString(value);
            return json;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"can't convert to json:"});
        }
    }

    public static String toJSON(Object value) {
        ObjectMapper mapper = toJSONMapper;
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, value);
        }
        catch (JsonGenerationException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + value.toString() + "---parse json error==>"});
        }
        catch (JsonMappingException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + value.toString() + "---parse json error==>"});
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + value.toString() + "---parse json error==>"});
        }
        return writer.toString();
    }

    public static void toJSON(Object obj, OutputStream stream, String charset) {
        ObjectMapper mapper = toJSONMapper;
        try {
            OutputStreamWriter writer = new OutputStreamWriter(stream, charset);
            mapper.writeValue((Writer)writer, obj);
        }
        catch (JsonGenerationException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + obj.toString() + "---parse json error==>"});
        }
        catch (JsonMappingException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + obj.toString() + "---parse json error==>"});
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + obj.toString() + "---parse json error==>"});
        }
    }

    public static <T> T fromJSON(String json, Class<T> clazz) throws IOException {
        ObjectMapper mapper = fromJSONMapper;
        return (T)mapper.readValue(json, clazz);
    }

    public static <T> T fromJSON(InputStream json, Class<T> clazz) {
        ObjectMapper mapper = fromJSONMapper;
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json.toString() + "---parse json error==>"});
        }
        catch (JsonMappingException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json.toString() + "---parse json error==>"});
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json.toString() + "---parse json error==>"});
        }
    }

    public static <T> boolean toJSONList(List<T> list) {
        String json = null;
        try {
            json = toJSONMapper.writeValueAsString(list);
        }
        catch (JsonGenerationException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json + "---parse json error==>"});
        }
        catch (JsonMappingException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json + "---parse json error==>"});
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json + "---parse json error==>"});
        }
        return json != null;
    }

    public static <T> List<T> fromJSONList(String json, Class<?> clazz) {
        List list = null;
        JavaType javaType = fromJSONMapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clazz});
        try {
            list = (List)fromJSONMapper.readValue(json, javaType);
        }
        catch (JsonParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json + "---parse json error==>"});
        }
        catch (JsonMappingException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json + "---parse json error==>"});
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"json==>" + json + "---parse json error==>"});
        }
        return list;
    }

    static {
        fromJSONMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        fromJSONMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        fromJSONMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        fromJSONMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        toJSONMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }
}

