/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.ParamUtil;

public class MalOrderParamUtil {
    private static final Log log = LogFactory.getLog(MalOrderParamUtil.class);

    public static String getBizFlowParam() {
        String bizflow = ParamUtil.getSysCtrlParam("UUPIH+47DAK", "bizflow_param");
        log.info("@@@getBizFlowParam,\u53c2\u6570\u662f\u4e1a\u52a1\u6d41\u7a0b\u914d\u7f6e" + String.valueOf(bizflow));
        return StringUtils.isBlank((CharSequence)bizflow) ? "1" : bizflow;
    }

    public static String getGenerateErpBill() {
        String generateErpBill = ParamUtil.getSysCtrlParam("UUPIH+47DAK", "generateorder");
        log.info("@@@getGenerateErpBill,\u53c2\u6570\u662f\u5426\u751f\u6210ERP\u8ba2\u5355" + String.valueOf(generateErpBill));
        return StringUtils.isBlank((CharSequence)generateErpBill) ? "1" : generateErpBill;
    }

    public static boolean getDefaultMalVersion() {
        String defaultVersion = ParamUtil.getSysCtrlParam("UUPIH+47DAK", "latestversion");
        return Boolean.parseBoolean(defaultVersion);
    }

    public static String getDefaultCurrency() {
        Map defaultCurrency = (Map)ParamUtil.getParamObj("UUPIH+47DAK", "defaultcurrency");
        log.info("@@@getDefaultCurrency,\u53c2\u6570\u9ed8\u8ba4\u5e01\u522b" + String.valueOf(defaultCurrency));
        return StringUtils.isBlank((Object)defaultCurrency) ? "" : String.valueOf(defaultCurrency.get("id"));
    }

    public static boolean isSelfInventoryUnlimited() {
        String selfInventoryUnlimited = ParamUtil.getSysCtrlParam("UUPIH+47DAK", "selfinventoryunlimited");
        log.info("@@@isSelfInventoryUnlimited,\u53c2\u6570\u81ea\u5efa\u5546\u54c1\u65e0\u5e93\u5b58\u4e0b\u5355:" + selfInventoryUnlimited);
        return Boolean.parseBoolean(selfInventoryUnlimited);
    }

    public static boolean isJD(String platform) {
        return EcPlatformEnum.ECPLATFORM_JD.getVal().equals(platform) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform);
    }

    public static boolean isSN(String platform) {
        return EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(platform);
    }

    public static boolean isXY(String platform) {
        return EcPlatformEnum.ECPLATFORM_XY.getVal().equals(platform);
    }

    public static boolean isCG(String platform) {
        return EcPlatformEnum.ECPLATFORM_CG.getVal().equals(platform);
    }

    public static boolean isDL(String platform) {
        return EcPlatformEnum.ECPLATFORM_DL.getVal().equals(platform);
    }
}

