/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MalOrderWriteBackUtil {
    private static final Log log = LogFactory.getLog((String)"MalOrderWriteBackUtil");

    public static void writeBackMalOrder(DynamicObject[] objs) {
        String writeBackPro;
        if (null == objs || objs.length == 0) {
            return;
        }
        String entityKey = objs[0].getDataEntityType().getName();
        if ("pur_receipt".equals(entityKey)) {
            writeBackPro = "sumreceiptqty";
        } else if ("pur_instock".equals(entityKey)) {
            writeBackPro = "suminstockqty";
        } else {
            log.warn("@@\u65e0\u6cd5\u8bc6\u522b\u5b9e\u4f53\u6807\u8bc6\uff1a" + entityKey);
            return;
        }
        DynamicObjectCollection purOrders = MalOrderWriteBackUtil.getPurOrders(objs);
        HashMap<Long, BigDecimal> malEntryId_qtyMap = new HashMap<Long, BigDecimal>();
        for (DynamicObject purOrder : purOrders) {
            String malEntryId = purOrder.getString("materialentry.srcentryid");
            BigDecimal qty = purOrder.getBigDecimal("materialentry." + writeBackPro);
            if (!StringUtils.isNotEmpty((CharSequence)malEntryId)) continue;
            malEntryId_qtyMap.put(Long.valueOf(malEntryId), qty);
        }
        String selectMalOrderField = "entryentity,entryentity." + writeBackPro;
        log.info("\u5546\u57ce\u8ba2\u5355\u5206\u5f55id_\u6536\u8d27/\u5165\u5e93\u6570\u91cf:" + malEntryId_qtyMap);
        DynamicObject[] malOrderDyns = BusinessDataServiceHelper.load((String)"mal_order", (String)selectMalOrderField, (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", malEntryId_qtyMap.keySet())});
        if (malOrderDyns.length > 0) {
            for (DynamicObject malOrderDyn : malOrderDyns) {
                DynamicObjectCollection malOrderEntryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject malOrderEntry : malOrderEntryCol) {
                    BigDecimal qty = (BigDecimal)malEntryId_qtyMap.get(Long.valueOf(malOrderEntry.getPkValue().toString()));
                    if (qty == null) continue;
                    malOrderEntry.set(writeBackPro, (Object)qty);
                }
            }
            SaveServiceHelper.save((DynamicObject[])malOrderDyns);
        }
    }

    public static DynamicObjectCollection getPurOrders(DynamicObject[] objs) {
        HashSet<String> poBillIdSet = new HashSet<String>();
        for (DynamicObject dynamicObject : objs) {
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("materialentry");
            if (dynamicObjects.size() == 0) continue;
            for (DynamicObject dynamicObjectinner : dynamicObjects) {
                String poBillId = dynamicObjectinner.getString("pobillid");
                if (null == poBillId || poBillId.length() <= 0) continue;
                poBillIdSet.add(poBillId);
            }
        }
        return MalOrderWriteBackUtil.queryPurOrderByPoBillids(poBillIdSet);
    }

    public static DynamicObjectCollection queryPurOrderByPoBillids(Set<String> poBillIdSet) {
        QFilter poBillIdFilter = new QFilter("materialentry.pobillid", "in", poBillIdSet);
        return QueryServiceHelper.query((String)"scp_order", (String)"billno,cfmstatus,logstatus,materialentry.pobillid,materialentry.entrystatus,materialentry.poentryid,materialentry.srcentryid,materialentry.srcbillid,materialentry.suminstockqty,materialentry.sumreceiptqty", (QFilter[])new QFilter[]{poBillIdFilter});
    }
}

