/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialUtil {
    private static final String BASE_UNIT_ID = "baseunit_id";

    public static List<Object> getMaterialByGroup(Object[] groupIds) {
        if (null == groupIds) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"MaterialUtil_0", (String)"scm-common", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("group", "in", (Object)groupIds);
        String selectProperties = "id,number,name,group";
        DynamicObject[] materials = BusinessDataServiceHelper.load((String)"bd_material", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        ArrayList<Object> materialIds = new ArrayList<Object>(materials.length);
        for (DynamicObject material : materials) {
            materialIds.add(material.getPkValue());
        }
        return materialIds;
    }

    public static void materialChanged(IDataModel model, String propertyName, DynamicObject material, String entryKey, int rowIndex) {
        DynamicObjectCollection rows;
        DataEntityPropertyCollection properties1;
        DynamicObject materialPurchaseInfo;
        String selectFields = "id,masterid,purchaseunit";
        String entity = model.getDataEntityType().getName();
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entity).getProperties();
        QFilter qFilter = new QFilter("masterid", "=", (Object)material.getLong("masterid"));
        if (properties.containsKey((Object)"org")) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialpurchaseinfo", (Long)model.getDataEntity().getLong("org_id"));
            qFilter.and(baseDataFilter);
        }
        if (null != (materialPurchaseInfo = QueryServiceHelper.queryOne((String)"bd_materialpurchaseinfo", (String)selectFields, (QFilter[])new QFilter[]{qFilter}))) {
            Long purunitid = materialPurchaseInfo.getLong("purchaseunit");
            if (purunitid == null || purunitid.equals(0L)) {
                Long baseunitId = material.getLong(BASE_UNIT_ID);
                model.setValue("unit", (Object)(null != baseunitId ? baseunitId : 0L), rowIndex);
            } else {
                model.setValue("unit", (Object)purunitid, rowIndex);
            }
        } else {
            Long baseunitId = material.getLong(BASE_UNIT_ID);
            model.setValue("unit", (Object)(null != baseunitId ? baseunitId : 0L), rowIndex);
        }
        DynamicObject baseunit = material.getDynamicObject("baseunit");
        DataEntityPropertyCollection propertys = model.getDataEntity(true).getDataEntityType().getProperties();
        IDataEntityProperty property = (IDataEntityProperty)propertys.get((Object)entryKey);
        if (property instanceof EntryProp && (properties1 = (rows = model.getDataEntity(true).getDynamicObjectCollection(entryKey)).getDynamicObjectType().getProperties()).containsKey((Object)"basicunit")) {
            model.setValue("basicunit", null == baseunit ? Long.valueOf(0L) : baseunit.getPkValue(), rowIndex);
        }
    }

    public static final void materialChanged(DynamicObject billDynamic, int rowIndex) {
        DynamicObject materialPurchaseInfo;
        DynamicObjectCollection dynamicObjectCollection = billDynamic.getDynamicObjectCollection("materialentry");
        DynamicObject materialDynamicObject = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        DynamicObject material = materialDynamicObject.getDynamicObject("material");
        String selectFields = "id,masterid,purchaseunit";
        String entity = billDynamic.getDataEntityType().getName();
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entity).getProperties();
        QFilter qFilter = new QFilter("masterid", "=", (Object)material.getLong("masterid"));
        if (properties.containsKey((Object)"org")) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialpurchaseinfo", (Long)billDynamic.getLong("org_id"));
            qFilter.and(baseDataFilter);
        }
        if ((materialPurchaseInfo = QueryServiceHelper.queryOne((String)"bd_materialpurchaseinfo", (String)selectFields, (QFilter[])new QFilter[]{qFilter})) == null) {
            materialDynamicObject.set("unit", (Object)MaterialUtil.getUnitDynamicObject(material.getLong(BASE_UNIT_ID)));
            return;
        }
        Long purUnitId = materialPurchaseInfo.getLong("purchaseunit");
        materialDynamicObject.set("unit", (Object)(purUnitId.equals(0L) ? MaterialUtil.getUnitDynamicObject(material.getLong(BASE_UNIT_ID)) : MaterialUtil.getUnitDynamicObject(purUnitId)));
    }

    private static DynamicObject getUnitDynamicObject(Long unitId) {
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"number,name,precisionaccount,precision,group,conversiontype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)unitId)});
        return (DynamicObject)unitMap.get(unitId);
    }

    public static Map<Object, DynamicObject> getMaterialInventoryinfo(Set materialSet, long orgid, String selector) {
        QFilter idFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgid);
        QFilter materialFilter = new QFilter("masterid.id", "in", (Object)materialSet);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)selector, (QFilter[])new QFilter[]{idFilter, materialFilter, statusFilter, enableFilter});
        Set materialinventoryinfos = result.entrySet();
        DynamicObject info = null;
        HashMap<Object, DynamicObject> resultnew = new HashMap<Object, DynamicObject>(result.size());
        for (Map.Entry entry : materialinventoryinfos) {
            info = (DynamicObject)entry.getValue();
            resultnew.put(info.get("masterid.id"), info);
        }
        return resultnew;
    }
}

