/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.message.api.YzjMessageInfo;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.ApiConfigUtil;

public class MessageUtil {
    private static Map<Long, DynamicObject> supplierMap = new HashMap<Long, DynamicObject>();
    private static Map<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>();

    private MessageUtil() {
    }

    @Deprecated
    public static void sendYzjMessage(String message, String userId) {
        ArrayList<Long> userList = new ArrayList<Long>();
        if (null == userId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237ID\u4e3a\u7a7a", (String)"MessageUtil_0", (String)"scm-common", (Object[])new Object[0]));
        }
        userList.add(Long.valueOf(userId));
        MessageUtil.sendYzjMessage(message, userList);
    }

    @Deprecated
    public static void sendYzjMessage(String message, List<Long> userList) {
        if (ApiConfigUtil.hasOldMsgConfig()) {
            YzjMessageInfo yzjMsg = new YzjMessageInfo();
            yzjMsg.setPubAcctCode("XT-6fb96101-b0d7-445e-b53b-cd8b4373d6d7");
            yzjMsg.setPubAccKey("c3b5fc1703dadfb5b815092bac5951a0");
            ArrayList<Long> receiverList = new ArrayList<Long>();
            if (null == userList) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237ID\u4e3a\u7a7a", (String)"MessageUtil_0", (String)"scm-common", (Object[])new Object[0]));
            }
            receiverList.addAll(userList);
            if (null == message) {
                yzjMsg.setContent(ResManager.loadKDString((String)"\u8fd9\u662f\u4e00\u6761\u6ca1\u6709\u7075\u9b42\u7684\u6d88\u606f\uff01", (String)"MessageUtil_1", (String)"scm-common", (Object[])new Object[0]));
            } else {
                yzjMsg.setContent(message);
            }
            yzjMsg.setReceiverList(receiverList);
            yzjMsg.setToAllUser(Boolean.FALSE);
            MessageServiceHelper.sendYzjMessage((YzjMessageInfo)yzjMsg);
        }
    }

    public static String buildYzjMessage(DynamicObject obj, String entityType) {
        StringBuilder yzjMessage = new StringBuilder();
        if ("scp_order".equals(entityType)) {
            String supName = MessageUtil.getDisplayName(obj, "supplier");
            yzjMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u201c{0}\u201d\uff0c\u7ecf\u4f9b\u5e94\u5546\u201c{1}\u201d\u786e\u8ba4\u901a\u8fc7\uff0c\u8bf7\u6ce8\u610f\u5904\u7406\u3002", (String)"MessageUtil_2", (String)"scm-common", (Object[])new Object[0]), obj.getString("billno"), supName));
        } else if ("pur_order".equals(entityType)) {
            String orgName = MessageUtil.getDisplayName(obj, "org");
            yzjMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u5df2\u6536\u5230{0}\u7684\u91c7\u8d2d\u8ba2\u5355\u201c{1}\u201d\uff0c\u8bf7\u60a8\u53ca\u65f6\u5904\u7406\u3002", (String)"MessageUtil_3", (String)"scm-common", (Object[])new Object[0]), orgName, obj.getString("billno")));
        } else if ("scp_saloutstock".equals(entityType)) {
            String supName = MessageUtil.getDisplayName(obj, "supplier");
            yzjMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u9500\u552e\u53d1\u8d27\u5355\u201c{0}\u201d\uff0c\u7ecf\u4f9b\u5e94\u5546\u201c{1}\u201d\u5ba1\u6838\u901a\u8fc7\uff0c\u8bf7\u6ce8\u610f\u5904\u7406\u3002", (String)"MessageUtil_4", (String)"scm-common", (Object[])new Object[0]), obj.getString("billno"), supName));
        }
        return yzjMessage.toString();
    }

    public static String getDisplayName(DynamicObject obj, String proName) {
        Object proObj = obj.get(proName);
        String proDisplayName = "";
        if (null != proObj && proObj instanceof DynamicObject) {
            DynamicObject proDynamicObject = (DynamicObject)proObj;
            try {
                proDisplayName = proDynamicObject.getString("name");
            }
            catch (Exception e) {
                if ("supplier".equals(proName)) {
                    proDynamicObject = MessageUtil.getSupplier((Long)proDynamicObject.get("id"));
                } else if ("org".equals(proName)) {
                    proDynamicObject = MessageUtil.getOrg((Long)proDynamicObject.get("id"));
                }
                if (null != proDynamicObject) {
                    proDisplayName = proDynamicObject.getString("name");
                }
            }
        } else if (null != proObj) {
            DynamicObject proDynamicObject = null;
            if ("supplier".equals(proName)) {
                proDynamicObject = MessageUtil.getSupplier(Long.valueOf(proObj.toString()));
            } else if ("org".equals(proName)) {
                proDynamicObject = MessageUtil.getOrg(Long.valueOf(proObj.toString()));
            }
            if (null != proDynamicObject) {
                proDisplayName = proDynamicObject.getString("name");
            }
        }
        return proDisplayName;
    }

    private static DynamicObject getSupplier(Long supId) {
        DynamicObject supplier = supplierMap.get(supId);
        if (null == supplier) {
            HashMap<String, Object> idMap = new HashMap<String, Object>(1);
            idMap.put("id", supId);
            supplier = ORMUtil.querySingleByPro("bd_supplier", "id,name", idMap);
            supplierMap.put(supId, supplier);
        }
        return supplier;
    }

    private static DynamicObject getOrg(Long orgId) {
        DynamicObject org = orgMap.get(orgId);
        if (null == org) {
            HashMap<String, Object> idMap = new HashMap<String, Object>(1);
            idMap.put("id", orgId);
            org = ORMUtil.querySingleByPro("bos_org", "id,name", idMap);
            orgMap.put(orgId, org);
        }
        return org;
    }

    public static void release() {
        orgMap.clear();
        supplierMap.clear();
    }

    public static void sendMsgToMsgCenter() {
        if (ApiConfigUtil.hasOldMsgConfig()) {
            MessageInfo messageInfo = new MessageInfo();
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(Long.valueOf(RequestContext.get().getUserId()));
            messageInfo.setType("message");
            messageInfo.setSenderName(ResManager.loadKDString((String)"\u534a\u4eba\u9a6c\u5ea7", (String)"MessageUtil_5", (String)"scm-common", (Object[])new Object[0]));
            messageInfo.setUserIds(userIds);
            messageInfo.setTitle(ResManager.loadKDString((String)"\u6d88\u606f\u6d4b\u8bd5", (String)"MessageUtil_6", (String)"scm-common", (Object[])new Object[0]));
            messageInfo.setContent(ResManager.loadKDString((String)"\u5ba2\u6237\u786e\u8ba4\u4e86\u8ba2\u5355\uff1a00000002,\u8bf7\u53ca\u65f6\u5904\u7406\uff01", (String)"MessageUtil_7", (String)"scm-common", (Object[])new Object[0]));
            messageInfo.setSendTime(new Date());
            String userId = RequestContext.get().getUserId();
            MessageInfo message = new MessageInfo();
            message.setType("message");
            message.setTitle("Message Message Message!!!");
            ArrayList<Long> receivers = new ArrayList<Long>();
            receivers.add(Long.valueOf(userId));
            receivers.add(Long.valueOf("25346500"));
            message.setUserIds(receivers);
            message.setSenderName("sender");
            message.setSenderId(Long.valueOf(userId));
            message.setSendTime(new Date(System.currentTimeMillis()));
            message.setEntityNumber("wf_tripreqbill_edit");
            message.setOperation("save");
            message.setBizDataId(Long.valueOf("477206338401754112"));
            message.setTag(ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb", (String)"MessageUtil_8", (String)"scm-common", (Object[])new Object[0]));
            message.setContentUrl("http://localhost:8080/ierp/ierp/index.html?formId=wf_deadletterjob&pkId=531736201699273728");
            message.setContent(ResManager.loadKDString((String)"\u901a\u77e5\u6d88\u606f", (String)"MessageUtil_9", (String)"scm-common", (Object[])new Object[0]));
            Long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            BizLog.log((String)MessageFormat.format(ResManager.loadKDString((String)"\u53d1\u9001\u6d88\u606f\u8fd4\u56de\u7684\u6d88\u606fID\uff1a{0}", (String)"MessageUtil_10", (String)"scm-common", (Object[])new Object[0]), msgId));
        }
    }

    public static void sendMsg(String title, String content, List<Long> userIds) {
        if (ApiConfigUtil.hasOldMsgConfig()) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setUserIds(userIds);
            messageInfo.setTitle(title);
            messageInfo.setContent(content);
            messageInfo.setSendTime(new Date());
            messageInfo.setType("message");
            Long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            BizLog.log((String)MessageFormat.format(ResManager.loadKDString((String)"\u53d1\u9001\u6d88\u606f\u8fd4\u56de\u7684\u6d88\u606fID\uff1a{0}", (String)"MessageUtil_10", (String)"scm-common", (Object[])new Object[0]), msgId));
        }
    }

    public static void sendMessage(Map<String, Object> param, boolean isUrl) {
        if (ApiConfigUtil.hasOldMsgConfig()) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setType("message");
            messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
            messageInfo.setSenderName(RequestContext.get().getUserName());
            List<Long> receiveUserIds = MessageUtil.filterRepeat((List)param.get("receiveUserIds"));
            messageInfo.setUserIds(receiveUserIds);
            messageInfo.setBizDataId((Long)param.get("pkId"));
            messageInfo.setEntityNumber((String)param.get("entityNumber"));
            messageInfo.setTitle((String)param.get("title"));
            messageInfo.setContent((String)param.get("content"));
            Object tplScene = param.get("tplScene");
            if (null != tplScene) {
                messageInfo.setTplScene((String)tplScene);
            }
            List urlParams = (List)param.get("urlParams");
            if (isUrl && urlParams != null && urlParams.size() > 0) {
                String url = RequestContext.get().getClientUrl();
                if (url == null) {
                    url = "";
                }
                StringBuilder contentUrl = new StringBuilder(url);
                int urlParamIndex = 0;
                for (String urlParam : urlParams) {
                    if (urlParamIndex == 0) {
                        contentUrl.append('?').append(urlParam).append('=').append(param.get(urlParam));
                    } else {
                        contentUrl.append('&').append(urlParam).append('=').append(param.get(urlParam));
                    }
                    ++urlParamIndex;
                }
                messageInfo.setContentUrl(contentUrl.toString());
            }
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    public static void sendSms(List<String> phones, String content) {
        if (ApiConfigUtil.hasOldMsgConfig()) {
            ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
            shortMessageInfo.setMessage(content);
            shortMessageInfo.setPhone(phones);
            MessageServiceHelper.sendShortMessage((ShortMessageInfo)shortMessageInfo);
        }
    }

    public static void sendEmail(List<String> recEmails, String content, String title) {
        if (ApiConfigUtil.hasOldMsgConfig()) {
            EmailInfo emailInfo = new EmailInfo();
            emailInfo.setContent(content);
            emailInfo.setTitle(title);
            emailInfo.setReceiver(recEmails);
            MessageServiceHelper.sendEmail((EmailInfo)emailInfo);
        }
    }

    public static List<Long> filterRepeat(List<Long> list) {
        ArrayList<Long> newList = new ArrayList<Long>();
        for (Long id : list) {
            if (newList.contains(id)) continue;
            newList.add(id);
        }
        return newList;
    }

    public static void sendSmsNoConfig(String entityNumber, List<String> phones, String content, String url) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        messageInfo.setContent(content);
        messageInfo.setMobContentUrl(url);
        messageInfo.setEntityNumber(entityNumber);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("phone", phones);
        param.put("bizDescprtion", "bizUseOldImpl");
        messageInfo.setParams(param);
        messageInfo.setNotifyType("sms");
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static void sendEmailNoConfig(String entityNumber, List<String> recEmails, String content, String title, String url) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        messageInfo.setTitle(title);
        messageInfo.setContent(content);
        messageInfo.setMobContentUrl(url);
        messageInfo.setEntityNumber(entityNumber);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("email", recEmails);
        param.put("bizDescprtion", "bizUseOldImpl");
        messageInfo.setParams(param);
        messageInfo.setNotifyType("email");
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }
}

