/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;

public class MutexUtil {
    public static final String MUTEX_DATAOBJID = "dataObjId";
    public static final String MUTEX_GROUPID = "groupId";
    public static final String MUTEX_ENTITYKEY = "entityKey";
    public static final String MUTEX_OPERATIONKEY = "operationKey";

    public static Map<String, Boolean> batchRequest(Set<String> dataPkIds, String entityKey, String opKey) {
        String group = "op_" + opKey;
        List<Map<String, Object>> mutexRequireList = MutexUtil.getMutexRequires(dataPkIds, entityKey, opKey);
        DataMutex dataMutex = MutexFactory.createDataMutex();
        return dataMutex.batchrequire(mutexRequireList);
    }

    public static Map<String, Boolean> batchRelease(Set<String> dataPkIds, String entityKey, String opKey) {
        String group = "op_" + opKey;
        List<Map<String, Object>> mutexRequireList = MutexUtil.getMutexRequires(dataPkIds, entityKey, opKey);
        DataMutex dataMutex = MutexFactory.createDataMutex();
        return dataMutex.batchRelease(mutexRequireList);
    }

    public static boolean request(String id, String entityKey, String opKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        String group = "op_" + opKey;
        return dataMutex.require(id, group, entityKey, opKey, true);
    }

    public static boolean release(String id, String entityKey, String operationKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        return dataMutex.release(id, entityKey, operationKey);
    }

    public static Map<String, String> getLockInfo(String id, String entityKey, String opKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        String group = "op_" + opKey;
        return dataMutex.getLockInfo(id, group, entityKey);
    }

    private static List<Map<String, Object>> getMutexRequires(Set<String> dataObjIds, String entityKey, String opKey) {
        ArrayList<Map<String, Object>> mutexRequires = new ArrayList<Map<String, Object>>(16);
        String groupId = "op_" + opKey;
        for (String billno : dataObjIds) {
            HashMap<String, Object> mutexRequire = new HashMap<String, Object>(16);
            mutexRequire.put(MUTEX_DATAOBJID, billno);
            mutexRequire.put(MUTEX_GROUPID, groupId);
            mutexRequire.put(MUTEX_ENTITYKEY, entityKey);
            mutexRequire.put(MUTEX_OPERATIONKEY, opKey);
            mutexRequire.put("isStrict", true);
            mutexRequires.add(mutexRequire);
        }
        return mutexRequires;
    }
}

