/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class OpenFormUtil {
    public static void openDynamicPage(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(pageKey);
        if (paramMap != null) {
            fsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.getOpenStyle().setShowType(showType);
        currView.showForm(fsp);
    }

    public static void openBasePage(IFormView currView, String pageKey, Object billId, BillOperationStatus openStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        BaseShowParameter bsp = new BaseShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(openStatus);
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)bsp);
    }

    public static void openBillPage(IFormView currView, String pageKey, Object billId, BillOperationStatus openStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(openStatus);
        if (openStatus.equals((Object)BillOperationStatus.VIEW)) {
            bsp.setStatus(OperationStatus.VIEW);
        }
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)bsp);
    }

    public static void openListPage(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, QFilter qFilter, CloseCallBack closeCallBack) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(pageKey);
        lsp.getOpenStyle().setShowType(showType);
        lsp.getListFilterParameter().setFilter(qFilter);
        if (paramMap != null) {
            lsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            lsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)lsp);
    }
}

