/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class PurWorkFlowUtils {
    public static boolean isNoApproval(IFormView view, IDataModel model) {
        String billStatus;
        BillOperationStatus status = BillOperationStatus.VIEW;
        if (view.getFormShowParameter() instanceof BillShowParameter) {
            status = ((BillShowParameter)view.getFormShowParameter()).getBillStatus();
        }
        boolean isinprocess = false;
        Object pk = model.getDataEntity(true).getPkValue();
        if (pk != null) {
            isinprocess = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)pk.toString()) != null;
        }
        boolean isaddnew = (billStatus = (String)model.getValue("billstatus")) == null || BillOperationStatus.ADDNEW.compareTo((Enum)status) == 0;
        return isaddnew || !isinprocess || PurWorkFlowUtils.isSSC(view) || PurWorkFlowUtils.isSCENE(view);
    }

    public static boolean isSCENE(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (formShowParameter == null) {
            return false;
        }
        Map customParams = formShowParameter.getCustomParams();
        String sceneSign = "SCENE";
        if (customParams != null && customParams.size() >= 1 && customParams.get(sceneSign) != null) {
            return StringUtils.equalsIgnoreCase((CharSequence)"AUDITFLOW", (CharSequence)customParams.get(sceneSign).toString());
        }
        return false;
    }

    public static boolean isSSC(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String fromId = parameter.getParentFormId();
        return fromId != null && fromId.contains("task_");
    }
}

