/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.SrmCategoryEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.QueryRecordUtil;

public class SrmCommonUtil {
    private static Log log = LogFactory.getLog((String)"SrmCommonUtil");
    private static final Set<String> entryAttKeySet = new HashSet<String>();
    private static final String[] ADM_FORMS;

    public static Map<String, Object> recordAuditInfo(DynamicObject dynamicObject) {
        DynamicObject billObj;
        String examNote;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long srcBillId = dynamicObject.getLong("id");
        String bizType = dynamicObject.getString("biztype");
        if (srcBillId == 0L || bizType == null || bizType.trim().equalsIgnoreCase("")) {
            return resultMap;
        }
        long supplierId = 0L;
        String srcBillNo = null;
        String examStatus = dynamicObject.getString("auditstatus");
        if (bizType.equals("1")) {
            supplierId = srcBillId;
            srcBillNo = dynamicObject.getString("number");
            if ("A".equals(examStatus)) {
                examStatus = "E";
            }
        } else {
            supplierId = (Long)dynamicObject.getDynamicObject("supplier").getPkValue();
            srcBillNo = bizType.equals("9") || bizType.equals("A") ? dynamicObject.getString("number") : dynamicObject.getString("billno");
        }
        if ((examNote = dynamicObject.getString("auditopinion")).startsWith("\"") && examNote.endsWith("\"")) {
            examNote = "";
        }
        String srcMetadata = null;
        srcMetadata = ADM_FORMS[Integer.parseInt(bizType) - 1];
        if (srcMetadata == null) {
            srcMetadata = "adm_supplierreg";
        }
        if ((billObj = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"pbd_suppliertpl")) == null) {
            return resultMap;
        }
        DynamicObjectCollection examRows = billObj.getDynamicObjectCollection("entry_exam");
        DynamicObject tempRow = examRows.addNew();
        tempRow.set("examtype", (Object)bizType);
        tempRow.set("examstatus", (Object)examStatus);
        tempRow.set("examtime", (Object)TimeServiceHelper.now());
        tempRow.set("examer", (Object)Long.valueOf(RequestContext.get().getUserId()));
        tempRow.set("examnote", (Object)examNote);
        tempRow.set("srctype", (Object)srcMetadata);
        tempRow.set("srcbillid", (Object)srcBillId);
        tempRow.set("srcbillno", (Object)srcBillNo);
        DynamicObjectUtil.setBillEntrySeq(billObj, "entry_exam");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        return resultMap;
    }

    public static Map<String, Boolean> getSrmParameter() {
        HashMap<String, Boolean> paraMap = new HashMap<String, Boolean>();
        paraMap.put("ispurorg", Boolean.TRUE);
        paraMap.put("iscategory", Boolean.TRUE);
        paraMap.put("isuseeas", Boolean.TRUE);
        paraMap.put("iscategoryctl", Boolean.FALSE);
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setAppId("XV1IC150UR4");
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        Map systemMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Object ispurorg = systemMap.get("ispurorg");
        if (ispurorg == null) {
            paraMap.put("ispurorg", Boolean.TRUE);
        } else {
            paraMap.put("ispurorg", (Boolean)ispurorg);
        }
        Object iscategory = systemMap.get("iscategory");
        if (iscategory == null) {
            paraMap.put("iscategory", Boolean.TRUE);
        } else {
            paraMap.put("iscategory", (Boolean)iscategory);
        }
        Object isuseesa = systemMap.get("isuseeas");
        if (isuseesa == null) {
            paraMap.put("isuseeas", Boolean.TRUE);
        } else {
            paraMap.put("isuseeas", (Boolean)isuseesa);
        }
        Object iscategoryctl = systemMap.get("iscategoryctl");
        if (iscategoryctl == null) {
            paraMap.put("iscategoryctl", Boolean.FALSE);
        } else {
            paraMap.put("iscategoryctl", (Boolean)iscategoryctl);
        }
        return paraMap;
    }

    public static long getPkValue(DynamicObject obj) {
        if (obj == null) {
            return 0L;
        }
        return (Long)obj.getPkValue();
    }

    public static Map<String, Object> saveDynamicObject(String metaData, DynamicObject billObj) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        try {
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)metaData, (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)option);
            resultMap.put("succed", saveResult.isSuccess());
            if (!saveResult.isSuccess()) {
                StringBuilder errMsg = new StringBuilder();
                for (int i = 0; i < saveResult.getAllErrorOrValidateInfo().size(); ++i) {
                    errMsg.append(((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
                }
                resultMap.put("message", errMsg + "\n" + ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879\u662f\u5426\u90fd\u5df2\u7ecf\u5f55\u5165\u3002", (String)"SrmCommonUtil_0", (String)"scm-common", (Object[])new Object[0]));
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"SrmCommonUtil_10", (String)"scm-common", (Object[])new Object[0]) + errMsg);
            }
            resultMap.put("message", saveResult.getMessage());
            return resultMap;
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"@@\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"SrmCommonUtil_11", (String)"scm-common", (Object[])new Object[0]) + e.getMessage());
        }
    }

    public static Map<String, Object> saveDynamicObject(String metaData, DynamicObject[] billObjs) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)metaData, (DynamicObject[])billObjs, (OperateOption)option);
        resultMap.put("succed", saveResult.isSuccess());
        if (!saveResult.isSuccess()) {
            StringBuilder errMsg = new StringBuilder();
            for (int i = 0; i < saveResult.getAllErrorOrValidateInfo().size(); ++i) {
                errMsg.append(((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
            }
            resultMap.put("message", errMsg + "\n" + ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879\u662f\u5426\u90fd\u5df2\u7ecf\u5f55\u5165\u3002", (String)"SrmCommonUtil_0", (String)"scm-common", (Object[])new Object[0]));
        } else {
            resultMap.put("message", saveResult.getMessage());
        }
        log.info("@@\u4fdd\u5b58\u5931\u8d25\uff1a" + resultMap);
        return resultMap;
    }

    public static long getBillSelectedId(IFormView currview, BillList list) {
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length == 0) {
            currview.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"SrmCommonUtil_1", (String)"scm-common", (Object[])new Object[0]));
        } else if (objects.length != 1) {
            currview.showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SrmCommonUtil_2", (String)"scm-common", (Object[])new Object[0]));
        } else {
            return (Long)objects[0];
        }
        return 0L;
    }

    public static Map<String, Object> haveLeader(ExtendedDataEntity row, String isLeader, String inspectentryentity) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        DynamicObjectCollection dys = row.getDataEntity().getDynamicObjectCollection(inspectentryentity);
        List isLeaders = dys.stream().map(x -> x.getBoolean(isLeader)).filter(x -> x.equals(Boolean.TRUE)).collect(Collectors.toList());
        if (isLeaders.size() != 1) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8003\u5bdf\u5c0f\u7ec4\u9700\u8981\u4e00\u4f4d\u8d1f\u8d23\u4eba\u3002", (String)"SrmCommonUtil_9", (String)"scm-common", (Object[])new Object[0]));
        }
        return resultMap;
    }

    public static Map<String, Object> isRepeatForEntry(DynamicObjectCollection rows, String key1, String key2, String key3) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        boolean succed = true;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        StringBuilder message = new StringBuilder();
        int i = 1;
        for (DynamicObject row : rows) {
            String key = null;
            key = String.valueOf(SrmCommonUtil.getPkValue(row.getDynamicObject(key1)));
            if (key2 != null) {
                key = key + "|" + SrmCommonUtil.getPkValue(row.getDynamicObject(key2));
            }
            if (key3 != null) {
                key = key + "|" + SrmCommonUtil.getPkValue(row.getDynamicObject(key3));
            }
            if (key == null || key.trim().equals("")) continue;
            Integer count = (Integer)countMap.get(key);
            if (count != null) {
                if (message.length() == 0) {
                    message.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"SrmCommonUtil_3", (String)"scm-common", (Object[])new Object[0]), String.valueOf(i)));
                } else {
                    message.append(MessageFormat.format(ResManager.loadKDString((String)"\uff0c\u7b2c{0}\u884c", (String)"SrmCommonUtil_4", (String)"scm-common", (Object[])new Object[0]), String.valueOf(i)));
                }
                countMap.put(key, count + 1);
                succed = false;
            } else {
                countMap.put(key, 1);
            }
            ++i;
        }
        if (!succed) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u8fd9\u4e9b\u884c\u91cd\u590d\u4e86\uff0c\u8bf7\u68c0\u67e5\uff1a", (String)"SrmCommonUtil_5", (String)"scm-common", (Object[])new Object[0]) + "\n" + message);
        }
        return resultMap;
    }

    public static boolean isRepeatField(String metaData, String key, Object value, long currentId) {
        QFilter[] filters = new QFilter[]{new QFilter(key, "=", value).and("id", "!=", (Object)currentId)};
        DynamicObject tempObj = QueryServiceHelper.queryOne((String)metaData, (String)"id", (QFilter[])filters);
        return tempObj == null;
    }

    public static boolean isSupplier(String key, String value, String metadataName) {
        boolean issupplier = false;
        DynamicObjectCollection spuColl = QueryServiceHelper.query((String)metadataName, (String)"id", (QFilter[])new QFilter[]{new QFilter(key, "=", (Object)value)});
        if (spuColl.size() > 0) {
            issupplier = true;
        }
        return issupplier;
    }

    public static boolean isBlackEnterpirse(long supplierId, String number, String name) {
        String creditcode = number;
        String enterprise = name;
        if (supplierId > 0L && creditcode == null && enterprise == null) {
            DynamicObject supplierObj = QueryRecordUtil.queryRecordSet("srm_supplier", "id,name,societycreditcode", "id", supplierId, null, null, null, null, null, null, null, "queryOne", null);
            if (supplierObj == null) {
                return false;
            }
            creditcode = supplierObj.getString("societycreditcode");
            enterprise = supplierObj.getString("name");
        }
        if (StringUtils.isEmpty((CharSequence)creditcode) && StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        QFilter qFilter = null;
        qFilter = StringUtils.isEmpty((CharSequence)enterprise) && StringUtils.isNotEmpty((CharSequence)creditcode) ? new QFilter("number", "=", (Object)creditcode).and(new QFilter("auditstatus", "=", (Object)"C")) : (StringUtils.isEmpty((CharSequence)creditcode) && StringUtils.isNotEmpty((CharSequence)enterprise) ? new QFilter("name", "=", (Object)enterprise).and(new QFilter("auditstatus", "=", (Object)"C")) : new QFilter("number", "=", (Object)creditcode).or(new QFilter("name", "=", (Object)enterprise)).and(new QFilter("auditstatus", "=", (Object)"C")));
        DynamicObject blackObj = QueryServiceHelper.queryOne((String)"srm_blackenterprise", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return blackObj != null;
    }

    public static boolean isBlackPerson(String number) {
        DynamicObject blackObj = QueryRecordUtil.queryRecordSet("srm_blackperson", "id", "number", number, null, null, null, null, null, null, null, "queryOne", null);
        return blackObj != null;
    }

    public static Map<String, Object> autoAuditOp(String billName, long billId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)billName, (Object[])new Object[]{billId}, (OperateOption)option);
        resultMap.put("succed", auditResult.isSuccess());
        resultMap.put("message", auditResult.getMessage());
        return resultMap;
    }

    public static String getImportDataValue(Map<String, Object> data, String objName, String fieldName) {
        JSONObject JSONObj;
        Object obj = data.get(objName);
        if (obj instanceof JSONObject && (JSONObj = (JSONObject)obj).containsKey((Object)fieldName)) {
            return JSONObj.getString(fieldName);
        }
        return null;
    }

    public static Map<String, Object> getAuditOrgFilter(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)"1")};
        DynamicObjectCollection auditOrgs = QueryServiceHelper.query((String)"srm_audit_org", (String)"org", (QFilter[])filters);
        if (auditOrgs == null || auditOrgs.size() == 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4f9b\u5e94\u5546\u7684\u51c6\u5165\u5ba1\u6279\u5355\u4f4d\uff0c\u8bf7\u5728\u201c\u4f9b\u5e94\u5546\u7ba1\u7406>\u57fa\u7840\u8bbe\u7f6e>\u4f9b\u5e94\u5546\u5ba1\u6279\u5355\u4f4d\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"SrmCommonUtil_6", (String)"scm-common", (Object[])new Object[0]), (String)"SrmCommonUtil_6", (String)"scm-common", (Object[])new Object[0]));
            return resultMap;
        }
        ArrayList<Long> orgList = new ArrayList<Long>();
        for (DynamicObject obj : auditOrgs) {
            orgList.add(obj.getLong("org"));
        }
        QFilter filter = new QFilter("id", "in", orgList);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", filter);
        return resultMap;
    }

    public static Set<Long> getAllNodes(String entityName, QFilter filter, Set<Long> parentIds) {
        boolean haveChild;
        DynamicObjectCollection objs = QueryServiceHelper.query((String)entityName, (String)"id,parent.id", (QFilter[])new QFilter[]{filter});
        if (objs == null || objs.size() == 0) {
            return parentIds;
        }
        HashMap<String, Long> nodes = new HashMap<String, Long>();
        for (DynamicObject obj : objs) {
            nodes.put(obj.getString("id"), obj.getLong("parent.id"));
        }
        do {
            haveChild = false;
            Iterator ite = nodes.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry node = ite.next();
                Long childId = Long.valueOf((String)node.getKey());
                Long parentId = (Long)node.getValue();
                if (!parentIds.contains(parentId)) continue;
                parentIds.add(childId);
                ite.remove();
                haveChild = true;
            }
        } while (haveChild);
        return parentIds;
    }

    public static Set<Long> getCategoryBySupplier_Org(Long supplierId, Long orgId) {
        DynamicObjectCollection rows;
        Set<Long> categoryIds = new HashSet<Long>();
        if (supplierId == 0L) {
            return null;
        }
        QFilter filter = new QFilter("supplier", "=", (Object)supplierId).and("auditstatus", "=", (Object)SrmCategoryEnum.VALID.getVal());
        Map<String, Boolean> paraMap = SrmCommonUtil.getSrmParameter();
        if (paraMap.get("ispurorg").booleanValue()) {
            if (orgId == 0L) {
                return null;
            }
            filter = filter.and("org", "=", (Object)orgId);
        }
        if ((rows = QueryServiceHelper.query((String)"srm_supcategory", (String)"category", (QFilter[])new QFilter[]{filter})) == null || rows.size() == 0) {
            return null;
        }
        for (DynamicObject row : rows) {
            categoryIds.add(row.getLong("category"));
        }
        categoryIds = SrmCommonUtil.getAllNodes("bd_materialgroup", new QFilter("enable", "=", (Object)"1"), categoryIds);
        return categoryIds;
    }

    public static Set<Long> getGoodsCategoryBySupplier_Org(Long supplierId, Long orgId) {
        Set<Long> categoryIds = new HashSet<Long>();
        Set<Long> groupIds = SrmCommonUtil.getCategoryBySupplier_Org(supplierId, orgId);
        QFilter filter = new QFilter("materialgroup", "in", groupIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pmm_catmapping", (String)"category", (QFilter[])new QFilter[]{filter});
        if (rows == null || rows.size() == 0) {
            return null;
        }
        for (DynamicObject row : rows) {
            categoryIds.add(row.getLong("category"));
        }
        categoryIds = SrmCommonUtil.getAllNodes("pbd_goodsclass", new QFilter("enable", "=", (Object)"1"), categoryIds);
        return categoryIds;
    }

    public static void setOrgDefaultValue(IDataModel currModel) {
        currModel.setValue("org", (Object)RequestContext.getOrCreate().getOrgId());
        currModel.setValue("createorg", (Object)RequestContext.getOrCreate().getOrgId());
        currModel.setValue("useorg", (Object)RequestContext.getOrCreate().getOrgId());
    }

    public static void setEvaPlanStatus(Set<Long> billIds, String setStatus, String queryStatus1, String queryStatus2) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((String)"srm_evaplan", (String)"id,bizstatus", (QFilter[])new QFilter[]{qFilter});
        if (taskObjs == null || taskObjs.length == 0) {
            taskObjs = BusinessDataServiceHelper.load((String)"srm_evaplan_batch", (String)"id,bizstatus", (QFilter[])new QFilter[]{qFilter});
        }
        if (taskObjs == null || taskObjs.length == 0) {
            return;
        }
        boolean haveChange = false;
        for (DynamicObject taskObj : taskObjs) {
            long taskbillId = taskObj.getLong("id");
            qFilter = new QFilter("taskbillid", "=", (Object)taskbillId);
            DynamicObjectCollection scoreObjs = QueryServiceHelper.query((String)"srm_score", (String)"bizstatus", (QFilter[])new QFilter[]{qFilter});
            if (scoreObjs == null || scoreObjs.size() == 0) continue;
            boolean finished = true;
            for (DynamicObject scoreObj : scoreObjs) {
                String bizStatus = scoreObj.getString("bizstatus");
                if (setStatus.equals("E")) {
                    if (bizStatus.equals(queryStatus1) || bizStatus.equals(queryStatus2) || bizStatus.equals("G") || bizStatus.equals("H") || bizStatus.equals(SrmScoreStatusEnum.ENDED.getValue())) continue;
                    finished = false;
                    break;
                }
                if (!setStatus.equals("F") || bizStatus.equals(queryStatus1) || bizStatus.equals(queryStatus2) || bizStatus.equals(SrmScoreStatusEnum.ENDED.getValue())) continue;
                finished = false;
                break;
            }
            if (!finished) continue;
            taskObj.set("bizstatus", (Object)setStatus);
            haveChange = true;
        }
        if (haveChange) {
            SaveServiceHelper.save((DynamicObject[])taskObjs);
        }
    }

    public static final String getBaseName(long baseId, String entityName) {
        StringBuilder content = new StringBuilder();
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)baseId, (String)entityName, (String)"name");
        if (obj == null) {
            return ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"SrmCommonUtil_7", (String)"scm-common", (Object[])new Object[0]);
        }
        content.append(obj.getString("name"));
        return content.toString();
    }

    public static boolean verifycurrentNode(IListView currView) {
        ITreeListView treeListView = currView.getTreeListView();
        String rootId = treeListView.getTreeModel().getRoot().getId();
        Object currentId = treeListView.getTreeModel().getCurrentNodeId();
        if (currentId == null || currentId.equals(rootId)) {
            currView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u6811\u9009\u62e9\u5408\u9002\u7684\u8282\u70b9\uff0c\u518d\u65b0\u589e\u6216\u4fee\u6539\u8d44\u6599\u3002", (String)"SrmCommonUtil_8", (String)"scm-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static void setScoreRptTabStatus(IFormView currView, IDataModel currModel) {
        if (currModel.getDataEntity().getString("bizstatus") == null) {
            return;
        }
        String bizStatus = currModel.getDataEntity().getString("bizstatus");
        String cfmStatus = currModel.getDataEntity().getString("cfmstatus");
        String tab = bizStatus == null ? "etab" : (bizStatus.equals(SrmScoreStatusEnum.APPROVED.getValue()) || bizStatus.equals(SrmScoreStatusEnum.UNAPPROVED.getValue()) ? bizStatus.toLowerCase() + "tab" : (cfmStatus != null && (cfmStatus.equals("B") || cfmStatus.equals("C")) ? cfmStatus.toLowerCase() + "cfmtab" : bizStatus.toLowerCase() + "tab"));
        BillFormUtil.activeTab(currView, "status_tabap", tab);
    }

    public static Object getMulBasedataValue(DynamicObject regSupplierObj, DynamicObject row, String entryname, String fieldname) {
        DynamicObjectCollection col = new DynamicObjectCollection();
        DynamicObject tempRow = null;
        if (entryname != null && !"".equals(entryname)) {
            EntryType entryType = (EntryType)((EntryProp)regSupplierObj.getDataEntityType().getProperties().get((Object)entryname)).getItemType();
            col = new DynamicObjectCollection();
            tempRow = new DynamicObject((DynamicObjectType)entryType);
        } else {
            tempRow = regSupplierObj;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)tempRow.getDataEntityType().getProperties().get((Object)fieldname);
        DynamicObjectType muldata_EtryType = (DynamicObjectType)mulBasedataProp.getItemType();
        String value = row.getString("srcbillid").trim();
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            DynamicObject[] provinces;
            String[] ids = value.split(",");
            ArrayList<Long> idList = new ArrayList<Long>(10);
            for (String id : ids) {
                idList.add(Long.parseLong(id));
            }
            QFilter idFilter = new QFilter("id", "in", idList);
            for (DynamicObject obj : provinces = BusinessDataServiceHelper.load((String)mulBasedataProp.getBaseEntityId(), (String)"id,longnumber", (QFilter[])new QFilter[]{idFilter})) {
                DynamicObject dynObj = new DynamicObject(muldata_EtryType);
                dynObj.set(1, (Object)obj);
                col.add((Object)dynObj);
            }
        }
        return col;
    }

    @Deprecated
    public static void processEntry(String meta, DynamicObjectCollection bdentry, String key, EntryType entryType, String fieldname, Object newvalue) {
        SrmCommonUtil.setEntryValue(meta, bdentry, key, entryType, fieldname, newvalue);
    }

    private static void setEntryValue(String srmBdSupplier, DynamicObjectCollection rows, String seq, EntryType entryType, String fieldname, Object newvalue) {
        boolean haveRecord = false;
        Iterator itr = rows.iterator();
        DynamicObjectType dynamicObjectType = rows.getDynamicObjectType();
        StringBuilder fielname = new StringBuilder(fieldname);
        while (itr.hasNext()) {
            DynamicObject row = (DynamicObject)itr.next();
            if (!row.getString("seq").equals(seq)) continue;
            haveRecord = true;
            if ("seq".equals(fieldname) && StringUtils.isBlank((Object)newvalue)) {
                itr.remove();
                continue;
            }
            if (entryAttKeySet.contains(fieldname)) {
                DynamicObjectCollection cols = (DynamicObjectCollection)newvalue;
                DynamicObjectCollection newAttCol = new DynamicObjectCollection(cols.getDynamicObjectType(), (Object)cols);
                for (DynamicObject obj : cols) {
                    newAttCol.add((Object)obj);
                }
                row.set(fieldname, (Object)newAttCol);
                continue;
            }
            DynamicProperty property = dynamicObjectType.getProperty(fieldname);
            if (property instanceof BasedataProp) {
                String newValueStr = newvalue.toString();
                if (StringUtils.isBlank((CharSequence)newValueStr)) {
                    row.set(fieldname, null);
                    continue;
                }
                Long baseId = Long.parseLong(newValueStr);
                Map baseData = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)((BasedataProp)property).getDynamicComplexPropertyType(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)baseId)});
                row.set(fieldname, baseData.get(baseId));
                continue;
            }
            row.set(fieldname, newvalue);
        }
        if (!haveRecord) {
            DynamicObject tempRow = ORMUtil.newDynamicObject(srmBdSupplier + "." + entryType);
            tempRow.set("seq", (Object)(rows.size() + 1));
            tempRow.set(fieldname, newvalue);
            rows.add((Object)tempRow);
        }
    }

    public static boolean enableNewAccessFlow() {
        QFilter qFilter = new QFilter("paramkey", "=", (Object)"enableNewAccessFlow");
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"pur_updateparamconfig", (String)"id,paramvalue,paramkey", (QFilter[])qFilter.toArray());
        return dyn != null && "Y".equals(dyn.getString("paramvalue"));
    }

    static {
        entryAttKeySet.add("goodsattachmentfield");
        entryAttKeySet.add("contractattachment");
        entryAttKeySet.add("attachmentfield");
        ADM_FORMS = new String[]{"adm_supplierreg", "adm_aptitude", "adm_scene", "adm_sample", "adm_material", "adm_approve", "srm_categorychg", "srm_supquit", "srm_blackenterprise", "srm_blackperson"};
    }
}

