/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ValidateMatchUtil {
    private static final String REGEX_MOBILE_SIMPLE = "^[1]\\d{10}$";
    private static final Pattern PATTERN_REGEX_MOBILE_SIMPLE = Pattern.compile("^[1]\\d{10}$");
    private static final String REGEX_MOBILE_EXACT = "^((((13[0-9])|(14[5-9])|(15[0-3,5-9])|(17[0-9])|(18[0-9])|(166)|(19[8-9])|(16[5,7]))\\d{8})|(((1440)|(1410))\\d{7}))$";
    private static final Pattern PATTERN_REGEX_MOBILE_EXACT = Pattern.compile("^((((13[0-9])|(14[5-9])|(15[0-3,5-9])|(17[0-9])|(18[0-9])|(166)|(19[8-9])|(16[5,7]))\\d{8})|(((1440)|(1410))\\d{7}))$");
    private static final String REGEX_TEL = "^(\\d{3,4}-)?\\d{6,8}$";
    private static final Pattern PATTERN_REGEX_TEL = Pattern.compile("^(\\d{3,4}-)?\\d{6,8}$");
    private static final String REGEX_ID_CARD15 = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$";
    private static final Pattern PATTERN_REGEX_ID_CARD15 = Pattern.compile("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$");
    private static final String REGEX_ID_CARD18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$";
    private static final Pattern PATTERN_REGEX_ID_CARD18 = Pattern.compile("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$");
    private static final String REGEX_EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    private static final Pattern PATTERN_REGEX_EMAIL = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
    private static final String REGEX_URL = "[a-zA-z]+://[^\\s]*";
    private static final Pattern PATTERN_REGEX_URL = Pattern.compile("[a-zA-z]+://[^\\s]*");
    private static final String REGEX_DATE = "^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$";
    private static final Pattern PATTERN_REGEX_DATE = Pattern.compile("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$");
    private static final String REGEX_IP = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)";
    private static final Pattern PATTERN_REGEX_IP = Pattern.compile("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)");
    private static final String REGEX_CAR = "^[\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886A-Z]{1}[A-Z]{1}[A-Z0-9]{3,4}[A-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3]{1}$";
    private static final Pattern PATTERN_REGEX_CAR = Pattern.compile("^[\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886A-Z]{1}[A-Z]{1}[A-Z0-9]{3,4}[A-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3]{1}$");
    private static final String REGEX_NAME = "^([\\u4e00-\u9fa5]{1,20}|[a-zA-Z\\.\\s]{1,20})$";
    private static final Pattern PATTERN_REGEX_NAME = Pattern.compile("^([\\u4e00-\u9fa5]{1,20}|[a-zA-Z\\.\\s]{1,20})$");
    private static final String REGEX_NAME255 = "^([\\u4e00-\u9fa5]{1,255}|[a-zA-Z\\.\\s]{1,255})$";
    private static final Pattern PATTERN_REGEX_NAME255 = Pattern.compile("^([\\u4e00-\u9fa5]{1,255}|[a-zA-Z\\.\\s]{1,255})$");
    private static final String REGEX_MAC = "([A-Fa-f0-9]{2}-){5}[A-Fa-f0-9]{2}";
    private static final Pattern PATTERN_REGEX_MAC = Pattern.compile("([A-Fa-f0-9]{2}-){5}[A-Fa-f0-9]{2}");

    public static boolean isMobileSimple(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_MOBILE_SIMPLE, str);
    }

    @Deprecated
    public static boolean isMobileExact(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_MOBILE_EXACT, str);
    }

    public static boolean isTel(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_TEL, str);
    }

    public static boolean isIdCard(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_ID_CARD15, str) || ValidateMatchUtil.isMatch(PATTERN_REGEX_ID_CARD18, str);
    }

    public static boolean isEmail(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_EMAIL, str);
    }

    public static boolean isUrl(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_URL, str);
    }

    public static boolean isDate(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_DATE, str);
    }

    public static boolean isIp(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_IP, str);
    }

    public static boolean isCar(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_CAR, str);
    }

    public static boolean isName(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_NAME, str);
    }

    public static boolean isName255(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_NAME255, str);
    }

    public static boolean isMac(String str) {
        return ValidateMatchUtil.isMatch(PATTERN_REGEX_MAC, str);
    }

    public static boolean isMatch(Pattern pattern, String str) {
        return StringUtils.isNotEmpty((String)str) && pattern.matcher(str).matches();
    }

    public static boolean isLicense18(String license) {
        if (StringUtils.isEmpty((String)license)) {
            return false;
        }
        if (license.length() != 18) {
            return false;
        }
        String regex = "^([159Y]{1})([1239]{1})([0-9ABCDEFGHJKLMNPQRTUWXY]{6})([0-9ABCDEFGHJKLMNPQRTUWXY]{9})([0-90-9ABCDEFGHJKLMNPQRTUWXY])$";
        if (!license.matches(regex)) {
            return false;
        }
        String str = "0123456789ABCDEFGHJKLMNPQRTUWXY";
        int[] ws = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
        String[] codes = new String[]{license.substring(0, license.length() - 1), license.substring(license.length() - 1, license.length())};
        int sum = 0;
        int firstCodes = 0;
        int secondCodes = 1;
        for (int i = 0; i < 17; ++i) {
            sum += str.indexOf(codes[firstCodes].charAt(i)) * ws[i];
        }
        int c18 = 31 - sum % 31;
        if (c18 == 31) {
            c18 = 0;
        }
        return str.charAt(c18) == codes[secondCodes].charAt(0);
    }

    public static boolean isInteger(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isDouble(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isPositiveNumber(String str) {
        return ValidateMatchUtil.isMatch(Pattern.compile("^[+]{0,1}(\\d+)$|^[+]{0,1}(\\d+\\.\\d+)$"), str);
    }

    public static boolean isPostcode(String str) {
        return ValidateMatchUtil.isMatch(Pattern.compile("^[0-9]{6}$"), str);
    }
}

