/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.cal;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.NumberUtils;
import kd.scm.common.util.cal.CalculateUtils;

public class InvoiceCal {
    private static Log log = LogFactory.getLog(InvoiceCal.class);
    private BigDecimal ZERO = BigDecimal.ZERO;
    private String PRICE = "price";
    private String TAXPRICE = "taxprice";
    private String ACTUALPRICE = "actprice";
    private String ACTUALTAXPRICE = "acttaxprice";
    private String UNMATCH_QTY = "unmatchqty";
    private String UNMATCH_AMT = "unmatchamt";
    private String AMOUNT = "amount";
    private String TAXAMOUNT = "taxamount";
    private String TAX = "tax";
    private String DISCOUNTRATE = "dctrate";
    private String DISCOUNTAMOUNT = "dctamount";
    private String TAXRATE = "taxrate";
    private String QTY = "qty";
    private String SUMQTY = "sumqty";
    private String TAXTYPE = "taxtype";
    private String HEAD_AMOUNT = "sumamount";
    private String HEAD_TAXAMOUNT = "sumtaxamount";
    private String HEAD_TAX = "sumtax";
    private int amoutScale = 2;

    public int getAmoutscale() {
        return this.amoutScale;
    }

    public void setAmoutscale(int amoutScale) {
        this.amoutScale = amoutScale;
    }

    public String getTAXRATE() {
        return this.TAXRATE;
    }

    public void setTAXRATE(String taxrate) {
        this.TAXRATE = taxrate;
    }

    public String getPRICE() {
        return this.PRICE;
    }

    public void setPRICE(String price) {
        this.PRICE = price;
    }

    public String getTAXPRICE() {
        return this.TAXPRICE;
    }

    public void setTAXPRICE(String taxprice) {
        this.TAXPRICE = taxprice;
    }

    public String getACTUALPRICE() {
        return this.ACTUALPRICE;
    }

    public void setACTUALPRICE(String actualprice) {
        this.ACTUALPRICE = actualprice;
    }

    public String getACTUALTAXPRICE() {
        return this.ACTUALTAXPRICE;
    }

    public void setACTUALTAXPRICE(String actualtaxprice) {
        this.ACTUALTAXPRICE = actualtaxprice;
    }

    public String getAMOUNT() {
        return this.AMOUNT;
    }

    public void setAMOUNT(String amount) {
        this.AMOUNT = amount;
    }

    public String getTAXAMOUNT() {
        return this.TAXAMOUNT;
    }

    public void setTAXAMOUNT(String taxamount) {
        this.TAXAMOUNT = taxamount;
    }

    public String getTAX() {
        return this.TAX;
    }

    public void setTAX(String tax) {
        this.TAX = tax;
    }

    public String getDISCOUNTRATE() {
        return this.DISCOUNTRATE;
    }

    public void setDISCOUNTRATE(String dISCOUNTRATE) {
        this.DISCOUNTRATE = dISCOUNTRATE;
    }

    public String getTAXTYPE() {
        return this.TAXTYPE;
    }

    public void setTAXTYPE(String tAXTYPE) {
        this.TAXTYPE = tAXTYPE;
    }

    public String getDISCOUNTAMOUNT() {
        return this.DISCOUNTAMOUNT;
    }

    public void setDISCOUNTAMOUNT(String discountamount) {
        this.DISCOUNTAMOUNT = discountamount;
    }

    public String getQTY() {
        return this.QTY;
    }

    public void setQTY(String qty) {
        this.QTY = qty;
    }

    public String getHEAD_AMOUNT() {
        return this.HEAD_AMOUNT;
    }

    public void setHEAD_AMOUNT(String head_amount) {
        this.HEAD_AMOUNT = head_amount;
    }

    public String getHEAD_TAXAMOUNT() {
        return this.HEAD_TAXAMOUNT;
    }

    public void setHEAD_TAXAMOUNT(String head_taxamount) {
        this.HEAD_TAXAMOUNT = head_taxamount;
    }

    public String getHEAD_TAX() {
        return this.HEAD_TAX;
    }

    public void setHEAD_TAX(String head_tax) {
        this.HEAD_TAX = head_tax;
    }

    public String getUNMATCH_QTY() {
        return this.UNMATCH_QTY;
    }

    public void setUNMATCH_QTY(String uNMATCH_QTY) {
        this.UNMATCH_QTY = uNMATCH_QTY;
    }

    public String getUNMATCH_AMT() {
        return this.UNMATCH_AMT;
    }

    public void setUNMATCH_AMT(String uNMATCH_AMT) {
        this.UNMATCH_AMT = uNMATCH_AMT;
    }

    public void calByEntryQtyChange(DynamicObject dynamicObject, String entryKey) {
        this.initFiledValue();
        String taxType = dynamicObject.getString(this.TAXTYPE);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(dynamicObject, entryKey);
            this.calEntryTaxAmount(dynamicObject, entryKey);
            this.calEntryTax(dynamicObject, entryKey);
            this.calEntryAmount(dynamicObject, entryKey);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(dynamicObject, entryKey);
            this.calEntryAmount(dynamicObject, entryKey);
            this.calEntryTax(dynamicObject, entryKey);
            this.calEntryTaxAmount(dynamicObject, entryKey);
        }
        this.calEntryActcheckTaxAmount(dynamicObject, entryKey);
        this.calSum(dynamicObject, entryKey);
    }

    protected void calSum(DynamicObject dynamicObject, String entryKey) {
        BigDecimal sumAmount = this.ZERO;
        BigDecimal sumTax = this.ZERO;
        BigDecimal sumQty = this.ZERO;
        BigDecimal sumTaxAmount = this.ZERO;
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            sumAmount = sumAmount.add(entry.getBigDecimal(this.AMOUNT));
            sumTax = sumTax.add(entry.getBigDecimal(this.TAX));
            sumQty = sumQty.add(entry.getBigDecimal(this.QTY));
            sumTaxAmount = sumTaxAmount.add(entry.getBigDecimal(this.getActcheckTaxAmount()));
        }
        dynamicObject.set(this.HEAD_AMOUNT, (Object)sumAmount);
        dynamicObject.set(this.HEAD_TAX, (Object)sumTax);
        dynamicObject.set(this.SUMQTY, (Object)sumQty);
        dynamicObject.set(this.HEAD_TAXAMOUNT, (Object)sumTaxAmount);
    }

    protected void initFiledValue() {
        String str = "1";
        this.setQTY(this.getQTY() + str);
        this.setAMOUNT(this.getAMOUNT() + str);
        this.setACTUALPRICE(this.getACTUALPRICE() + str);
        this.setACTUALTAXPRICE(this.getACTUALTAXPRICE() + str);
        this.setDISCOUNTAMOUNT(this.getDISCOUNTAMOUNT() + str);
        this.setDISCOUNTRATE(this.getDISCOUNTRATE() + str);
        this.setPRICE(this.getPRICE() + str);
        this.setTAX(this.getTAX() + str);
        this.setTAXAMOUNT(this.getTAXAMOUNT() + str);
        this.setTAXPRICE(this.getTAXPRICE() + str);
        this.setTAXRATE(this.getTAXRATE() + str);
    }

    public String getActcheckTaxPrice() {
        return "actchecktaxprice";
    }

    public String getActcheckTaxAmount() {
        return "actchecktaxamount";
    }

    public void calEntryDiscountAmount(DynamicObject dynamicObject, String entryKey) {
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            BigDecimal qty = entry.getBigDecimal(this.getQTY());
            BigDecimal taxPrice = entry.getBigDecimal(this.getTAXPRICE());
            BigDecimal discountRate = entry.getBigDecimal(this.getDISCOUNTRATE());
            BigDecimal discountAmount = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(dynamicObject, entryKey);
            discountAmount = CalculateUtils.calDiscountAmountByPercent(discountRate, qty, taxPrice, scale);
            entry.set(this.getDISCOUNTAMOUNT(), (Object)discountAmount);
        }
    }

    public void calEntryTaxAmount(DynamicObject dynamicObject, String entryKey) {
        String taxType = dynamicObject.getString(this.TAXTYPE);
        boolean containTax = this.isContainTax(taxType);
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            BigDecimal taxAmount = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(dynamicObject, entryKey);
            if (containTax) {
                BigDecimal qty = entry.getBigDecimal(this.getQTY());
                BigDecimal taxPrice = entry.getBigDecimal(this.getTAXPRICE());
                BigDecimal discount = entry.getBigDecimal(this.getDISCOUNTRATE());
                taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(qty, taxPrice, discount, scale);
            } else {
                BigDecimal amount = entry.getBigDecimal(this.getAMOUNT());
                BigDecimal tax = entry.getBigDecimal(this.getTAX());
                taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
            }
            entry.set(this.getTAXAMOUNT(), (Object)taxAmount);
        }
    }

    public void calEntryTax(DynamicObject dynamicObject, String entryKey) {
        String taxType = dynamicObject.getString(this.TAXTYPE);
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            BigDecimal taxAmount = entry.getBigDecimal(this.getTAXAMOUNT());
            BigDecimal taxRate = entry.getBigDecimal(this.getTAXRATE());
            BigDecimal tax = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(dynamicObject, entryKey);
            if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
                tax = CalculateUtils.calTaxWhenPriceExludeTax(taxAmount, taxRate, scale);
            } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
                BigDecimal amount = entry.getBigDecimal(this.getAMOUNT());
                tax = CalculateUtils.calTax(amount, taxRate, scale);
            } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
                tax = CalculateUtils.calTaxWhenPriceInludeTax(taxAmount, taxRate, scale);
            }
            entry.set(this.getTAX(), (Object)tax);
        }
    }

    public void calEntryAmount(DynamicObject dynamicObject, String entryKey) {
        String taxType = dynamicObject.getString(this.TAXTYPE);
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            BigDecimal amount = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(dynamicObject, entryKey);
            if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
                BigDecimal taxAmount = entry.getBigDecimal(this.getTAXAMOUNT());
                BigDecimal tax = entry.getBigDecimal(this.getTAX());
                amount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
            } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
                BigDecimal discountRate = entry.getBigDecimal(this.getDISCOUNTRATE());
                BigDecimal qty = entry.getBigDecimal(this.getQTY());
                BigDecimal price = entry.getBigDecimal(this.getPRICE());
                amount = CalculateUtils.calAmountByDiscountPercent(qty, price, discountRate, scale);
            }
            entry.set(this.getAMOUNT(), (Object)amount);
        }
    }

    public void calEntryActcheckTaxAmount(DynamicObject dynamicObject, String entryKey) {
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            BigDecimal actcheckTaxAmount = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(dynamicObject, entryKey);
            BigDecimal qty = entry.getBigDecimal(this.getQTY());
            BigDecimal actcheckTaxPrice = entry.getBigDecimal(this.getActcheckTaxPrice());
            qty = NumberUtils.effectualNumeric(qty);
            actcheckTaxPrice = NumberUtils.effectualNumeric(actcheckTaxPrice);
            actcheckTaxAmount = qty.multiply(actcheckTaxPrice);
            actcheckTaxAmount = actcheckTaxAmount.setScale(scale, 4);
            entry.set(this.getActcheckTaxAmount(), (Object)actcheckTaxAmount);
        }
    }

    public void calEntryUnmatchAmount(DynamicObject dynamicObject, String entryKey) {
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        Object currObj = dynamicObject.get("curr");
        int scale = 6;
        if (null != currObj) {
            if (currObj instanceof Long) {
                Long currId = (Long)currObj;
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,priceprecision,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currId)});
                if (null != currency) {
                    scale = currency.getInt("amtprecision");
                }
            } else if (currObj instanceof DynamicObject) {
                scale = this.getAmtPrecision(dynamicObject, entryKey);
            }
        }
        for (DynamicObject entry : col) {
            BigDecimal unmatchTaxAmount = BigDecimal.ZERO;
            BigDecimal qty = BigDecimal.ZERO;
            qty = "entryentity1".equals(entryKey) ? entry.getBigDecimal(this.getUNMATCH_QTY() + "1") : entry.getBigDecimal(this.getUNMATCH_QTY());
            BigDecimal actcheckTaxPrice = entry.getBigDecimal(this.getActcheckTaxPrice());
            qty = NumberUtils.effectualNumeric(qty);
            actcheckTaxPrice = NumberUtils.effectualNumeric(actcheckTaxPrice);
            unmatchTaxAmount = qty.multiply(actcheckTaxPrice);
            unmatchTaxAmount = unmatchTaxAmount.setScale(scale, 4);
            entry.set(this.getUNMATCH_AMT(), (Object)unmatchTaxAmount);
        }
    }

    protected boolean isContainTax(String taxType) {
        boolean containTax = false;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            containTax = true;
        }
        return containTax;
    }

    protected int getAmtPrecision(DynamicObject dynamicObject, String entryKey) {
        int amtPrecision = 6;
        DynamicObject currency = dynamicObject.getDynamicObject("curr");
        if (null != currency) {
            DynamicObject curr = currency;
            amtPrecision = curr.getInt("amtprecision");
        }
        return amtPrecision;
    }
}

