/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.cal;

import java.math.BigDecimal;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.NumberUtils;
import kd.scm.common.util.cal.AbstractCal;
import kd.scm.common.util.cal.CalculateUtils;

public class InvoiceCalImpl
extends AbstractCal {
    @Override
    public void needChange(boolean isNeedChange) {
    }

    @Override
    public void proChanged(IDataModel datamodel, String entryKey, String propertyName) {
    }

    @Override
    public void calByEntryQtyChange(IDataModel datamodel, String entryKey) {
        this.initFiledValue();
        super.calByEntryQtyChange(datamodel, entryKey);
        this.calEntryActcheckTaxAmount(datamodel, entryKey);
    }

    @Override
    protected void initFiledValue() {
        String str = "1";
        this.setQTY(this.getQTY() + str);
        this.setAMOUNT(this.getAMOUNT() + str);
        this.setACTUALPRICE(this.getACTUALPRICE() + str);
        this.setACTUALTAXPRICE(this.getACTUALTAXPRICE() + str);
        this.setDISCOUNTAMOUNT(this.getDISCOUNTAMOUNT() + str);
        this.setDISCOUNTRATE(this.getDISCOUNTRATE() + str);
        this.setPRICE(this.getPRICE() + str);
        this.setTAX(this.getTAX() + str);
        this.setTAXAMOUNT(this.getTAXAMOUNT() + str);
        this.setTAXPRICE(this.getTAXPRICE() + str);
        this.setTAXRATE(this.getTAXRATE() + str);
    }

    public String getActcheckTaxPrice() {
        return "actchecktaxprice";
    }

    public String getActcheckTaxAmount() {
        return "actchecktaxamount";
    }

    @Override
    public void calSumTaxAmount(IDataModel datamodel, String entryKey) {
    }

    @Override
    public void calEntryDiscountAmount(IDataModel datamodel, String entryKey) {
        for (int index = 0; index < datamodel.getEntryRowCount(entryKey); ++index) {
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
            BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.getTAXPRICE());
            BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
            BigDecimal discountAmount = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(datamodel, entryKey);
            discountAmount = CalculateUtils.calDiscountAmountByPercent(discountRate, qty, taxPrice, scale);
            datamodel.setValue(this.getDISCOUNTAMOUNT(), (Object)discountAmount, index);
        }
    }

    @Override
    public void calEntryTaxAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        boolean containTax = this.isContainTax(taxType);
        for (int index = 0; index < datamodel.getEntryRowCount(entryKey); ++index) {
            BigDecimal taxAmount = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(datamodel, entryKey);
            if (containTax) {
                BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
                BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.getTAXPRICE());
                BigDecimal discount = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
                taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(qty, taxPrice, discount, scale);
            } else {
                BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.getAMOUNT());
                BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.getTAX());
                taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
            }
            datamodel.setValue(this.getTAXAMOUNT(), (Object)taxAmount, index);
        }
    }

    public void calEntryActcheckTaxAmount(IDataModel datamodel, String entryKey) {
        for (int index = 0; index < datamodel.getEntryRowCount(entryKey); ++index) {
            BigDecimal actcheckTaxAmount = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(datamodel, entryKey);
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
            BigDecimal actcheckTaxPrice = this.getEntryBigDecimalValue(datamodel, index, this.getActcheckTaxPrice());
            qty = NumberUtils.effectualNumeric(qty);
            actcheckTaxPrice = NumberUtils.effectualNumeric(actcheckTaxPrice);
            actcheckTaxAmount = qty.multiply(actcheckTaxPrice);
            actcheckTaxAmount = actcheckTaxAmount.setScale(scale, 4);
            datamodel.setValue(this.getActcheckTaxAmount(), (Object)actcheckTaxAmount, index);
        }
    }

    @Override
    public void calEntryTax(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        for (int index = 0; index < datamodel.getEntryRowCount(entryKey); ++index) {
            BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, this.getTAXAMOUNT());
            BigDecimal taxRate = this.getEntryBigDecimalValue(datamodel, index, this.getTAXRATE());
            BigDecimal tax = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(datamodel, entryKey);
            if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
                tax = CalculateUtils.calTaxWhenPriceExludeTax(taxAmount, taxRate, scale);
            } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
                BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.getAMOUNT());
                tax = CalculateUtils.calTax(amount, taxRate, scale);
            } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
                tax = CalculateUtils.calTaxWhenPriceInludeTax(taxAmount, taxRate, scale);
            }
            datamodel.setValue(this.getTAX(), (Object)tax, index);
        }
    }

    @Override
    public void calEntryAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        for (int index = 0; index < datamodel.getEntryRowCount(entryKey); ++index) {
            BigDecimal amount = BigDecimal.ZERO;
            int scale = this.getAmtPrecision(datamodel, entryKey);
            if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
                BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, this.getTAXAMOUNT());
                BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.getTAX());
                amount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
            } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
                BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
                BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
                BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, this.getPRICE());
                amount = CalculateUtils.calAmountByDiscountPercent(qty, price, discountRate, scale);
            }
            datamodel.setValue(this.getAMOUNT(), (Object)amount, index);
        }
    }
}

