/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.caldynamic;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.CheckUtils;
import kd.scm.common.util.CurrencyUtils;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.common.util.caldynamic.ICalDynamic;

public abstract class AbstractCalDynamic
implements ICalDynamic {
    private static final Log log = LogFactory.getLog(AbstractCalDynamic.class);
    private String priceKey = "price";
    private String taxPriceKey = "taxprice";
    private String actPriceKey = "actprice";
    private String actTaxPriceKey = "acttaxprice";
    private String amountKey = "amount";
    private String taxAmountKey = "taxamount";
    private String taxKey = "tax";
    private String discountTypekey = "discounttype";
    private String discountRateKey = "dctrate";
    private String discountAmountKey = "dctamount";
    private String taxRateKey = "taxrate";
    private String qtyKey = "qty";
    private String sumQtyKey = "sumqty";
    private String taxTypeKey = "taxtype";
    private String sumAmountKey = "sumamount";
    private String sumTaxAmountKey = "sumtaxamount";
    private String sumTaxKey = "sumtax";
    private int amountScale = 2;
    private String locamountKey = "locamount";
    private String loctaxamountKey = "loctaxamount";
    private String loctaxKey = "loctax";
    private String exchrateKey = "exchrate";
    private String actcheckpriceKey = "actcheckprice";
    private String actchecktaxpriceKey = "actchecktaxprice";
    private String actcheckamountKey = "actcheckamount";
    private String actchecktaxamountKey = "actchecktaxamount";
    private String unmatchQtyKey = "unmatchqty";
    private String unmatchAmtKey = "unmatchamt";
    private String unmatchAmountKey = "unmatchamount";
    private String inTaxAmountKey = "intaxamount";
    private String diffAmtKey = "diffamt";

    public String getPriceKey() {
        return this.priceKey;
    }

    public void setPriceKey(String priceKey) {
        this.priceKey = priceKey;
    }

    public String getTaxPriceKey() {
        return this.taxPriceKey;
    }

    public void setTaxPriceKey(String taxPriceKey) {
        this.taxPriceKey = taxPriceKey;
    }

    public String getActPriceKey() {
        return this.actPriceKey;
    }

    public void setActPriceKey(String actPriceKey) {
        this.actPriceKey = actPriceKey;
    }

    public String getActTaxPriceKey() {
        return this.actTaxPriceKey;
    }

    public void setActTaxPriceKey(String actTaxPriceKey) {
        this.actTaxPriceKey = actTaxPriceKey;
    }

    public String getAmountKey() {
        return this.amountKey;
    }

    public void setAmountKey(String amountKey) {
        this.amountKey = amountKey;
    }

    public String getLocamountKey() {
        return this.locamountKey;
    }

    public void setLocamountKey(String locamountKey) {
        this.locamountKey = locamountKey;
    }

    public String getLoctaxamountKey() {
        return this.loctaxamountKey;
    }

    public void setLoctaxamountKey(String loctaxamountKey) {
        this.loctaxamountKey = loctaxamountKey;
    }

    public String getLoctaxKey() {
        return this.loctaxKey;
    }

    public void setLoctaxKey(String loctaxKey) {
        this.loctaxKey = loctaxKey;
    }

    public String getExchrateKey() {
        return this.exchrateKey;
    }

    public void setExchrateKey(String exchrateKey) {
        this.exchrateKey = exchrateKey;
    }

    public String getTaxAmountKey() {
        return this.taxAmountKey;
    }

    public void setTaxAmountKey(String taxAmountKey) {
        this.taxAmountKey = taxAmountKey;
    }

    public String getTaxKey() {
        return this.taxKey;
    }

    public void setTaxKey(String taxKey) {
        this.taxKey = taxKey;
    }

    public String getDiscountTypekey() {
        return this.discountTypekey;
    }

    public void setDiscountTypekey(String discountTypekey) {
        this.discountTypekey = discountTypekey;
    }

    public String getDiscountRateKey() {
        return this.discountRateKey;
    }

    public void setDiscountRateKey(String discountRateKey) {
        this.discountRateKey = discountRateKey;
    }

    public String getDiscountAmountKey() {
        return this.discountAmountKey;
    }

    public void setDiscountAmountKey(String discountAmountKey) {
        this.discountAmountKey = discountAmountKey;
    }

    public String getTaxRateKey() {
        return this.taxRateKey;
    }

    public void setTaxRateKey(String taxRateKey) {
        this.taxRateKey = taxRateKey;
    }

    public String getQtyKey() {
        return this.qtyKey;
    }

    public void setQtyKey(String qtyKey) {
        this.qtyKey = qtyKey;
    }

    public String getSumQtyKey() {
        return this.sumQtyKey;
    }

    public void setSumQtyKey(String sumQtyKey) {
        this.sumQtyKey = sumQtyKey;
    }

    public String getTaxTypeKey() {
        return this.taxTypeKey;
    }

    public void setTaxTypeKey(String taxTypeKey) {
        this.taxTypeKey = taxTypeKey;
    }

    public String getSumAmountKey() {
        return this.sumAmountKey;
    }

    public void setSumAmountKey(String sumAmountKey) {
        this.sumAmountKey = sumAmountKey;
    }

    public String getSumTaxAmountKey() {
        return this.sumTaxAmountKey;
    }

    public void setSumTaxAmountKey(String sumTaxAmountKey) {
        this.sumTaxAmountKey = sumTaxAmountKey;
    }

    public String getSumTaxKey() {
        return this.sumTaxKey;
    }

    public void setSumTexKey(String sumTaxKey) {
        this.sumTaxKey = sumTaxKey;
    }

    public int getAmountScale() {
        return this.amountScale;
    }

    public void setAmountScale(int amountScale) {
        this.amountScale = amountScale;
    }

    public void setSumTaxKey(String sumTaxKey) {
        this.sumTaxKey = sumTaxKey;
    }

    public String getActcheckpriceKey() {
        return this.actcheckpriceKey;
    }

    public void setActcheckpriceKey(String actcheckpriceKey) {
        this.actcheckpriceKey = actcheckpriceKey;
    }

    public String getActchecktaxpriceKey() {
        return this.actchecktaxpriceKey;
    }

    public void setActchecktaxpriceKey(String actchecktaxpriceKey) {
        this.actchecktaxpriceKey = actchecktaxpriceKey;
    }

    public String getActcheckamountKey() {
        return this.actcheckamountKey;
    }

    public void setActcheckamountKey(String actcheckamountKey) {
        this.actcheckamountKey = actcheckamountKey;
    }

    public String getActchecktaxamountKey() {
        return this.actchecktaxamountKey;
    }

    public void setActchecktaxamountKey(String actchecktaxamountKey) {
        this.actchecktaxamountKey = actchecktaxamountKey;
    }

    public String getUnmatchQtyKey() {
        return this.unmatchQtyKey;
    }

    public void setUnmatchQtyKey(String unmatchQtyKey) {
        this.unmatchQtyKey = unmatchQtyKey;
    }

    public String getUnmatchAmtKey() {
        return this.unmatchAmtKey;
    }

    public void setUnmatchAmtKey(String unmatchAmtKey) {
        this.unmatchAmtKey = unmatchAmtKey;
    }

    public String getUnmatchAmountKey() {
        return this.unmatchAmountKey;
    }

    public void setUnmatchAmountKey(String unmatchAmountKey) {
        this.unmatchAmountKey = unmatchAmountKey;
    }

    public String getInTaxAmountKey() {
        return this.inTaxAmountKey;
    }

    public void setInTaxAmountKey(String inTaxAmountKey) {
        this.inTaxAmountKey = inTaxAmountKey;
    }

    public String getDiffAmtKey() {
        return this.diffAmtKey;
    }

    public void setDiffAmtKey(String diffAmtKey) {
        this.diffAmtKey = diffAmtKey;
    }

    @Override
    public void calSumTaxAmount(DynamicObject dynamicObject, String entryKey) {
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : dynamicObjectCollection) {
            sumTaxAmount = sumTaxAmount.add(entry.getBigDecimal(this.taxAmountKey));
        }
        dynamicObject.set(this.sumTaxAmountKey, (Object)sumTaxAmount);
    }

    @Override
    public void calEntryDiscountAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        BigDecimal taxPrice = entryDynamic.getBigDecimal(this.taxPriceKey);
        BigDecimal discountAmount = this.calDiscountAmountByPercentNoScale(billDynamicObject, entryDynamic, scale, taxPrice);
        discountAmount = discountAmount.setScale(scale, 4);
        entryDynamic.set(this.discountAmountKey, (Object)discountAmount);
    }

    public void calEntryDiscountAmountByPrice(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        boolean containTax = this.isContainTax(billDynamicObject);
        BigDecimal taxPrice = BigDecimal.ZERO;
        taxPrice = containTax ? this.calEntryTaxPriceByTaxAmountNoScale(billDynamicObject, entryDynamic) : this.calEntryTaxPriceByPriceNoScale(entryDynamic, scale);
        BigDecimal discountAmount = this.calDiscountAmountByPercentNoScale(billDynamicObject, entryDynamic, scale, taxPrice);
        discountAmount = discountAmount.setScale(scale, 4);
        entryDynamic.set(this.discountAmountKey, (Object)discountAmount);
    }

    private BigDecimal calDiscountAmountByPercentNoScale(DynamicObject billDynamicObject, DynamicObject entryDynamic, int scale, BigDecimal taxPrice) {
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal discountAmount = CalculateUtils.calDiscountAmountByPercentNoScale(discountType, discountRate, qty, taxPrice, taxType, taxRate, scale);
        return discountAmount;
    }

    private String getDiscountType(DynamicObject entryDynamic) {
        String discountType = "A";
        try {
            if (entryDynamic.containsProperty(this.discountTypekey)) {
                discountType = entryDynamic.getString(this.discountTypekey);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return discountType;
    }

    @Override
    public void calEntryTaxAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        BigDecimal taxAmount = this.calTaxAmount(billDynamicObject, entryDynamic, scale);
        taxAmount = taxAmount.setScale(scale, 4);
        int locScale = CurrencyUtils.getLocalAmtPrecision(billDynamicObject);
        BigDecimal exchrate = billDynamicObject.getBigDecimal(this.exchrateKey);
        if (exchrate != null) {
            BigDecimal loctaxamount = taxAmount.multiply(exchrate).setScale(locScale, 4);
            entryDynamic.set(this.loctaxamountKey, (Object)loctaxamount);
        }
        entryDynamic.set(this.taxAmountKey, (Object)taxAmount);
    }

    private BigDecimal calTaxAmount(DynamicObject billDynamicObject, DynamicObject entryDynamic, int scale) {
        boolean containTax = this.isContainTax(billDynamicObject);
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (containTax) {
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            BigDecimal taxPrice = entryDynamic.getBigDecimal(this.taxPriceKey);
            BigDecimal discount = entryDynamic.getBigDecimal(this.discountRateKey);
            String discountType = this.getDiscountType(entryDynamic);
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(discountType, qty, taxPrice, discount, scale);
        } else {
            BigDecimal amount = entryDynamic.getBigDecimal(this.amountKey);
            BigDecimal tax = entryDynamic.getBigDecimal(this.taxKey);
            taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
        }
        return taxAmount;
    }

    @Override
    public void calEntryTax(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        BigDecimal tax = this.calEntryTax(billDynamicObject, entryDynamic, scale);
        tax = tax.setScale(scale, 4);
        int locScale = CurrencyUtils.getLocalAmtPrecision(billDynamicObject);
        BigDecimal exchrate = billDynamicObject.getBigDecimal(this.exchrateKey);
        if (exchrate != null) {
            BigDecimal loctax = tax.multiply(exchrate).setScale(locScale, 4);
            entryDynamic.set(this.loctaxKey, (Object)loctax);
        }
        entryDynamic.set(this.taxKey, (Object)tax);
    }

    private BigDecimal calEntryTax(DynamicObject billDynamicObject, DynamicObject entryDynamic, int scale) {
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal taxAmount = entryDynamic.getBigDecimal(this.taxAmountKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal tax = BigDecimal.ZERO;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceExludeTax(taxAmount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal amount = entryDynamic.getBigDecimal(this.amountKey);
            tax = CalculateUtils.calTax(amount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceInludeTax(taxAmount, taxRate, scale);
        }
        return tax;
    }

    @Override
    public void calEntryAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        BigDecimal amount = this.calEntryAmountNoScale(billDynamicObject, entryDynamic, scale);
        amount = amount.setScale(scale, 4);
        int locScale = CurrencyUtils.getLocalAmtPrecision(billDynamicObject);
        BigDecimal exchrate = billDynamicObject.getBigDecimal(this.exchrateKey);
        if (exchrate != null) {
            BigDecimal locamount = amount.multiply(exchrate).setScale(locScale, 4);
            entryDynamic.set(this.locamountKey, (Object)locamount);
        }
        entryDynamic.set(this.amountKey, (Object)amount);
    }

    private BigDecimal calEntryAmountNoScale(DynamicObject billDynamicObject, DynamicObject entryDynamic, int scale) {
        BigDecimal amount = BigDecimal.ZERO;
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxAmount = entryDynamic.getBigDecimal(this.taxAmountKey);
            BigDecimal tax = this.calEntryTax(billDynamicObject, entryDynamic, scale);
            amount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            BigDecimal price = entryDynamic.getBigDecimal(this.priceKey);
            String discountType = this.getDiscountType(entryDynamic);
            amount = CalculateUtils.calAmountByDiscountPercent(discountType, qty, price, discountRate, scale);
        }
        return amount;
    }

    @Override
    public void calEntryTaxPriceByPrice(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal price = entryDynamic.getBigDecimal(this.priceKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
        entryDynamic.set(this.taxPriceKey, (Object)taxPrice);
    }

    public void calEntryTaxPriceByAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal taxPrice = this.calEntryTaxPriceByAmountNoScale(entryDynamic, scale);
        taxPrice = taxPrice.setScale(scale, 4);
        entryDynamic.set(this.taxPriceKey, (Object)taxPrice);
    }

    private BigDecimal calEntryTaxPriceByAmountNoScale(DynamicObject entryDynamic, int scale) {
        BigDecimal price = this.calEntryPriceByAmountNoScale(entryDynamic, scale);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale(price, taxRate, scale);
        return taxPrice;
    }

    private BigDecimal calEntryTaxPriceByPriceNoScale(DynamicObject entryDynamic, int scale) {
        BigDecimal price = entryDynamic.getBigDecimal(this.priceKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale(price, taxRate, scale);
        return taxPrice;
    }

    private BigDecimal calEntryTaxPriceByTaxAmountNoScale(DynamicObject billDynamicObject, DynamicObject entryDynamic) {
        BigDecimal taxAmount = entryDynamic.getBigDecimal(this.taxAmountKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        String discountType = this.getDiscountType(entryDynamic);
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale(discountType, taxAmount, qty, discountRate, scale);
        return taxPrice;
    }

    @Override
    public void calEntryActualPrice(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        if (this.actPriceKey == null) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        boolean containTax = this.isContainTax(billDynamicObject);
        BigDecimal actualPrice = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        amount = containTax ? this.calEntryAmountNoScale(billDynamicObject, entryDynamic, scale) : entryDynamic.getBigDecimal(this.amountKey);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        actualPrice = CalculateUtils.calActualPrice(amount, qty, scale);
        entryDynamic.set(this.actPriceKey, (Object)actualPrice);
    }

    @Override
    public void calEntryActualTaxPrice(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        if (this.actTaxPriceKey == null) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        boolean containTax = this.isContainTax(billDynamicObject);
        BigDecimal actualTaxPrice = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        taxAmount = containTax ? entryDynamic.getBigDecimal(this.taxAmountKey) : this.calTaxAmount(billDynamicObject, entryDynamic, scale);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        actualTaxPrice = CalculateUtils.calActualTaxPrice(taxAmount, qty, scale);
        entryDynamic.set(this.actTaxPriceKey, (Object)actualTaxPrice);
    }

    @Override
    public void calEntryPriceByTaxPrice(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        if (null == taxType || "2".equals(taxType)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal taxPrice = entryDynamic.getBigDecimal(this.taxPriceKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPrice(taxPrice, taxRate, scale) : CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale);
        entryDynamic.set(this.priceKey, (Object)price);
    }

    public void calEntryPriceByTaxAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        if (null == taxType || "2".equals(taxType)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal price = this.calEntryPriceByTaxAmountNoScale(billDynamicObject, taxType, entryDynamic);
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        price = price.setScale(scale, 4);
        entryDynamic.set(this.priceKey, (Object)price);
    }

    private BigDecimal calEntryPriceByTaxAmountNoScale(DynamicObject billDynamicObject, String taxType, DynamicObject entryDynamic) {
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal taxPrice = this.calEntryTaxPriceByTaxAmountNoScale(billDynamicObject, entryDynamic);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPriceNoScale(taxPrice, taxRate, scale) : CalculateUtils.calPriceIsPriceInTaxNoScale(taxRate, taxPrice, scale);
        return price;
    }

    @Override
    public void calEntryPriceByAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal price = this.calEntryPriceByAmountNoScale(entryDynamic, scale);
        price = price.setScale(scale, 4);
        entryDynamic.set(this.priceKey, (Object)price);
    }

    private BigDecimal calEntryPriceByAmountNoScale(DynamicObject entryDynamic, int scale) {
        BigDecimal amount = entryDynamic.getBigDecimal(this.amountKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal price = CalculateUtils.calPriceNoScale(discountType, amount, qty, discountRate, scale);
        return price;
    }

    @Override
    public void calEntryTaxPriceByTaxAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal taxPrice = this.calEntryTaxPriceByTaxAmountNoScale(billDynamicObject, entryDynamic);
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        taxPrice = taxPrice.setScale(scale, 4);
        entryDynamic.set(this.taxPriceKey, (Object)taxPrice);
    }

    @Override
    public void calEntryDiscountRate(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        BigDecimal taxPrice = this.calEntryTaxPriceByTaxAmountNoScale(billDynamicObject, entryDynamic);
        BigDecimal discountAmount = entryDynamic.getBigDecimal(this.discountAmountKey);
        String discountType = this.getDiscountType(entryDynamic);
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal discountRate = CalculateUtils.calDiscountByPercent(discountType, discountAmount, qty, taxPrice, scale);
        entryDynamic.set(this.discountRateKey, (Object)discountRate);
    }

    @Override
    public void calSumAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        BigDecimal sumAmount = BigDecimal.ZERO;
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (DynamicObject entry : dynamicObjectCollection) {
            sumAmount = sumAmount.add(entry.getBigDecimal(this.amountKey));
        }
        billDynamicObject.set(this.sumAmountKey, (Object)sumAmount);
    }

    @Override
    public void calSumTax(DynamicObject billDynamicObject, String entryKey) {
        BigDecimal sumTax = BigDecimal.ZERO;
        DynamicObjectCollection col = billDynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            sumTax = sumTax.add(entry.getBigDecimal(this.taxKey));
        }
        billDynamicObject.set(this.sumTaxKey, (Object)sumTax);
    }

    public void calByEntryQtyChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
        } else {
            this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
        }
    }

    public void calByEntryQtyByAmountChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryTaxPriceByTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryPriceByTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
        } else {
            this.calEntryPriceByAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxPriceByAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
        }
    }

    @Override
    public void calSum(DynamicObject billDynamicObject, String entryKey) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumTax = BigDecimal.ZERO;
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        BigDecimal sumQty = BigDecimal.ZERO;
        for (DynamicObject entryDynamicObject : dynamicObjectCollection) {
            sumAmount = sumAmount.add(entryDynamicObject.getBigDecimal("amount"));
            sumTax = sumTax.add(entryDynamicObject.getBigDecimal("tax"));
            sumTaxAmount = sumTaxAmount.add(entryDynamicObject.getBigDecimal("taxamount"));
            sumQty = sumQty.add(entryDynamicObject.getBigDecimal("qty"));
        }
        billDynamicObject.set(this.sumAmountKey, (Object)sumAmount);
        billDynamicObject.set(this.sumTaxKey, (Object)sumTax);
        billDynamicObject.set(this.sumTaxAmountKey, (Object)sumTaxAmount);
        billDynamicObject.set(this.sumQtyKey, (Object)sumQty);
    }

    public void calByEntryPriceChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        this.calEntryTaxPriceByPrice(dynamicObject, entryKey, rowIndex);
        this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
        this.calEntryTax(dynamicObject, entryKey, rowIndex);
        this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
    }

    public void calByEntryTaxPriceChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        log.info(entryKey + "\u7684taxPrice\u89e6\u53d1\u8ba1\u7b97\u3002\u3002\u3002");
        this.calEntryPriceByTaxPrice(dynamicObject, entryKey, rowIndex);
        this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryTax(dynamicObject, entryKey, rowIndex);
        this.calEntryAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
        this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
        this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
    }

    public void calByEntryAmountChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        this.calEntryPriceByAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryTaxPriceByAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryTax(dynamicObject, entryKey, rowIndex);
        this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
        this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
    }

    public void calByEntryTaxAmountChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        this.calEntryTaxPriceByTaxAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryPriceByTaxAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryTax(dynamicObject, entryKey, rowIndex);
        this.calEntryAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
        this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
        this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
    }

    public void calByEntryDiscountRateChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        String taxType = dynamicObject.getString(this.taxTypeKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
        }
    }

    public void calByEntryDiscountAmountChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        String taxType = dynamicObject.getString(this.taxTypeKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.calEntryDiscountRate(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.calEntryDiscountRate(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
        }
    }

    public void calByEntryTaxRateChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryPriceByTaxPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calSumAmount(dynamicObject, entryKey, rowIndex);
        } else {
            this.calEntryTaxPriceByPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calSumTaxAmount(dynamicObject, entryKey);
        }
        this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
    }

    public void calByEntryTaxChange(DynamicObject dynamicObject, String entryKey, int rowIndex) {
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calSumAmount(dynamicObject, entryKey, rowIndex);
        } else {
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calSumTaxAmount(dynamicObject, entryKey);
        }
    }

    protected boolean isContainTax(DynamicObject billDynamicObject) {
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        return TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType);
    }

    public void calEntryActcheckamount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal amount = BigDecimal.ZERO;
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxAmount = entryDynamic.getBigDecimal(this.actchecktaxamountKey);
            BigDecimal tax = this.calEntryActTax(billDynamicObject, entryDynamic, this.actchecktaxamountKey, this.actcheckamountKey, scale);
            amount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            BigDecimal price = entryDynamic.getBigDecimal(this.actcheckpriceKey);
            String discountType = this.getDiscountType(entryDynamic);
            amount = CalculateUtils.calAmountByDiscountPercent(discountType, qty, price, discountRate, scale);
        }
        amount = amount.setScale(scale, 4);
        entryDynamic.set(this.actcheckamountKey, (Object)amount);
    }

    private BigDecimal calEntryActTax(DynamicObject billDynamicObject, DynamicObject entryDynamic, String actchecktaxamountKeyField, String actcheckamountKeyField, int scale) {
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal taxAmount = entryDynamic.getBigDecimal(actchecktaxamountKeyField);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal tax = BigDecimal.ZERO;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceExludeTax(taxAmount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal amount = entryDynamic.getBigDecimal(actcheckamountKeyField);
            tax = CalculateUtils.calTax(amount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceInludeTax(taxAmount, taxRate, scale);
        }
        return tax;
    }

    public void calEntryActTaxAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        BigDecimal taxAmount;
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        boolean containTax = this.isContainTax(billDynamicObject);
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        if (containTax) {
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            BigDecimal taxPrice = entryDynamic.getBigDecimal(this.actchecktaxpriceKey);
            BigDecimal discount = entryDynamic.getBigDecimal(this.discountRateKey);
            String discountType = this.getDiscountType(entryDynamic);
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(discountType, qty, taxPrice, discount, scale);
        } else {
            BigDecimal amount = entryDynamic.getBigDecimal(this.actcheckamountKey);
            BigDecimal tax = this.calEntryActTax(billDynamicObject, entryDynamic, this.actchecktaxamountKey, this.actcheckamountKey, scale);
            tax = tax.setScale(scale, 4);
            taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
        }
        taxAmount = taxAmount.setScale(scale, 4);
        entryDynamic.set(this.actchecktaxamountKey, (Object)taxAmount);
    }

    public void calEntryActTaxPriceByPrice(DynamicObject billDynamicObject, String entryKey, int rowIndex, String type) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal price = BigDecimal.ZERO;
        if ("amount".equals(type)) {
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            price = this.getActPriceByAmount(entryDynamic, qty, scale);
        } else {
            price = entryDynamic.getBigDecimal(this.actcheckpriceKey);
        }
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
        entryDynamic.set(this.actchecktaxpriceKey, (Object)taxPrice);
    }

    public void calEntryActPriceByTaxPrice(DynamicObject billDynamicObject, String entryKey, int rowIndex, String type) {
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        if (null == taxType || "2".equals(taxType)) {
            return;
        }
        BigDecimal price = this.getActCheckPriceByTax(billDynamicObject, scale, entryDynamic, type);
        price = price.setScale(scale, 4);
        entryDynamic.set(this.actcheckpriceKey, (Object)price);
    }

    private BigDecimal getActCheckPriceByTax(DynamicObject billDynamicObject, int scale, DynamicObject entryDynamic, String type) {
        BigDecimal taxPrice = BigDecimal.ZERO;
        if ("amount".equals(type)) {
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            taxPrice = this.getActTaxTriceAmount(entryDynamic, qty, scale);
        } else {
            taxPrice = entryDynamic.getBigDecimal(this.actchecktaxpriceKey);
        }
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPriceNoScale(taxPrice, taxRate, scale) : CalculateUtils.calPriceIsPriceInTaxNoScale(taxRate, taxPrice, scale);
        return price;
    }

    public void calEntryActPriceByAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        BigDecimal price = this.getActPriceByAmount(entryDynamic, qty, scale);
        price = price.setScale(scale, 4);
        entryDynamic.set(this.actcheckpriceKey, (Object)price);
    }

    private BigDecimal getActPriceByAmount(DynamicObject entryDynamic, BigDecimal qty, int scale) {
        BigDecimal amount = entryDynamic.getBigDecimal(this.actcheckamountKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal price = CalculateUtils.calPriceNoScale(discountType, amount, qty, discountRate, scale);
        return price;
    }

    public void calEntryActTaxPriceByTaxAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision(billDynamicObject);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        BigDecimal taxPrice = this.getActTaxTriceAmount(entryDynamic, qty, scale);
        taxPrice = taxPrice.setScale(scale, 4);
        entryDynamic.set(this.actchecktaxpriceKey, (Object)taxPrice);
    }

    private BigDecimal getActTaxTriceAmount(DynamicObject entryDynamic, BigDecimal qty, int scale) {
        BigDecimal taxAmount = entryDynamic.getBigDecimal(this.actchecktaxamountKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale(discountType, taxAmount, qty, discountRate, scale);
        return taxPrice;
    }

    public void calEntryActTaxAmountByActCheckAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        BigDecimal amount = entryDynamic.getBigDecimal(this.actcheckamountKey);
        BigDecimal tax = this.calEntryActTax(billDynamicObject, entryDynamic, this.actchecktaxamountKey, this.actcheckamountKey, scale);
        BigDecimal taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
        entryDynamic.set(this.actchecktaxamountKey, (Object)taxAmount);
    }

    public void calByEntryActCheckTaxAmountChange(DynamicObject dynamicObject, String entryKey, String suffix, int rowIndex) {
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.initFiledValue(suffix);
            this.calEntryActTaxPriceByTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActPriceByTaxPrice(dynamicObject, entryKey, rowIndex, "amount");
            this.calEntryActcheckamount(dynamicObject, entryKey, rowIndex);
            String name = dynamicObject.getDynamicObjectType().getName();
            if ("scp_check".equals(name) || "pur_check".equals(name)) {
                this.calEntryUnmatchAmt(dynamicObject, entryKey, rowIndex, "amount");
                this.calEntryUnmatchAmount(dynamicObject, entryKey, rowIndex, "amount");
                this.calEntryDiffamtAmount(dynamicObject, entryKey, rowIndex, suffix);
            }
        }
    }

    public void calByEntryActCheckTaxPriceChange(DynamicObject dynamicObject, String entryKey, String suffix, int rowIndex) {
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.initFiledValue(suffix);
            this.calEntryActTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActPriceByTaxPrice(dynamicObject, entryKey, rowIndex, "price");
            this.calEntryActcheckamount(dynamicObject, entryKey, rowIndex);
            String name = dynamicObject.getDynamicObjectType().getName();
            if ("scp_check".equals(name) || "pur_check".equals(name)) {
                this.calEntryUnmatchAmt(dynamicObject, entryKey, rowIndex, "price");
                this.calEntryUnmatchAmount(dynamicObject, entryKey, rowIndex, "price");
                this.calEntryDiffamtAmount(dynamicObject, entryKey, rowIndex, suffix);
            }
        }
    }

    public void calByEntryActCheckAmountChange(DynamicObject dynamicObject, String entryKey, String suffix, int rowIndex) {
        boolean containTax = this.isContainTax(dynamicObject);
        if (!containTax) {
            this.initFiledValue(suffix);
            this.calEntryActPriceByAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActTaxPriceByPrice(dynamicObject, entryKey, rowIndex, "amount");
            this.calEntryActTaxAmountByActCheckAmount(dynamicObject, entryKey, rowIndex);
            String name = dynamicObject.getDynamicObjectType().getName();
            if ("scp_check".equals(name) || "pur_check".equals(name)) {
                this.calEntryUnmatchAmt(dynamicObject, entryKey, rowIndex, "amount");
                this.calEntryUnmatchAmount(dynamicObject, entryKey, rowIndex, "amount");
                this.calEntryDiffamtAmount(dynamicObject, entryKey, rowIndex, suffix);
            }
        }
    }

    public void calByEntryActCheckPriceChange(DynamicObject dynamicObject, String entryKey, String suffix, int rowIndex) {
        boolean containTax = this.isContainTax(dynamicObject);
        if (!containTax) {
            this.initFiledValue(suffix);
            this.calEntryActcheckamount(dynamicObject, entryKey, rowIndex);
            this.calEntryActTaxPriceByPrice(dynamicObject, entryKey, rowIndex, "price");
            this.calEntryActTaxAmountByActCheckAmount(dynamicObject, entryKey, rowIndex);
            String name = dynamicObject.getDynamicObjectType().getName();
            if ("scp_check".equals(name) || "pur_check".equals(name)) {
                this.calEntryUnmatchAmt(dynamicObject, entryKey, rowIndex, "price");
                this.calEntryUnmatchAmount(dynamicObject, entryKey, rowIndex, "price");
                this.calEntryDiffamtAmount(dynamicObject, entryKey, rowIndex, suffix);
            }
        }
    }

    private void calEntryDiffamtAmount(DynamicObject billDynamicObject, String entryKey, int rowIndex, String suffix) {
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal taxAmount = entryDynamic.getBigDecimal(this.actchecktaxamountKey);
        BigDecimal inTaxAmount = BigDecimal.ZERO;
        inTaxAmount = this.inTaxAmountKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.inTaxAmountKey) : entryDynamic.getBigDecimal(this.inTaxAmountKey + suffix);
        int scale = CurrencyUtils.getAmtPrecision(billDynamicObject);
        BigDecimal diffAmt = taxAmount.subtract(inTaxAmount).setScale(scale, 4);
        entryDynamic.set(this.diffAmtKey, (Object)diffAmt);
    }

    public void calByEntryActQtyChange(DynamicObject dynamicObject, String entryKey, String suffix, int rowIndex) {
        this.initFiledValue(suffix);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        this.calByEntryQtyChange(dynamicObject, entryKey, rowIndex);
        BigDecimal discountAmount = entryDynamic.getBigDecimal(this.discountAmountKey);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal taxPrice = entryDynamic.getBigDecimal(this.taxPriceKey);
            BigDecimal price = entryDynamic.getBigDecimal(this.priceKey);
            entryDynamic.set(this.actPriceKey, (Object)price);
            entryDynamic.set(this.actTaxPriceKey, (Object)taxPrice);
        } else {
            this.calEntryActualPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryActualTaxPrice(dynamicObject, entryKey, rowIndex);
        }
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryActTaxAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryActcheckamount(dynamicObject, entryKey, rowIndex);
        } else {
            this.calEntryActcheckamount(dynamicObject, entryKey, rowIndex);
            this.calEntryActTaxAmount(dynamicObject, entryKey, rowIndex);
        }
        String name = dynamicObject.getDynamicObjectType().getName();
        if ("scp_check".equals(name) || "pur_check".equals(name)) {
            this.calEntryUnmatchAmt(dynamicObject, entryKey, rowIndex, "price");
            this.calEntryUnmatchAmount(dynamicObject, entryKey, rowIndex, "price");
            this.calEntryDiffamtAmount(dynamicObject, entryKey, rowIndex, suffix);
        }
    }

    @Override
    public void calByEntryActCheckAmountChange(DynamicObject dynamicObject, String entryKey, String suffix) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (int rowIndex = 0; rowIndex < dynamicObjectCollection.size(); ++rowIndex) {
            String srcBillType = ((DynamicObject)dynamicObjectCollection.get(rowIndex)).getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock(srcBillType) && !CheckUtils.isPurReciept(srcBillType)) continue;
            this.calByEntryActCheckAmountChange(dynamicObject, entryKey, suffix, rowIndex);
        }
    }

    @Override
    public void calByEntryActCheckTaxAmountChange(DynamicObject dynamicObject, String entryKey, String suffix) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (int rowIndex = 0; rowIndex < dynamicObjectCollection.size(); ++rowIndex) {
            String srcBillType = ((DynamicObject)dynamicObjectCollection.get(rowIndex)).getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock(srcBillType) && !CheckUtils.isPurReciept(srcBillType)) continue;
            this.calByEntryActCheckTaxAmountChange(dynamicObject, entryKey, suffix, rowIndex);
        }
    }

    @Override
    public void calByEntryActQtyChange(DynamicObject dynamicObject, String entryKey, String suffix) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (int rowIndex = 0; rowIndex < dynamicObjectCollection.size(); ++rowIndex) {
            String srcBillType = ((DynamicObject)dynamicObjectCollection.get(rowIndex)).getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock(srcBillType) && !CheckUtils.isPurReciept(srcBillType)) continue;
            this.calByEntryActQtyChange(dynamicObject, entryKey, suffix, rowIndex);
        }
    }

    @Override
    public void calEntryUnmatchAmount(DynamicObject billDynamicObject, String entryKey) {
        boolean inputamount = billDynamicObject.getBoolean("inputamount");
        if (inputamount) {
            this.calEntryUnmatchAmount(billDynamicObject, entryKey, "amount");
        } else {
            this.calEntryUnmatchAmount(billDynamicObject, entryKey, "price");
        }
    }

    @Override
    public void calEntryUnmatchAmt(DynamicObject billDynamicObject, String entryKey) {
        boolean inputamount = billDynamicObject.getBoolean("inputamount");
        if (inputamount) {
            this.calEntryUnmatchAmt(billDynamicObject, entryKey, "amount");
        } else {
            this.calEntryUnmatchAmt(billDynamicObject, entryKey, "price");
        }
    }

    public void calEntryUnmatchAmount(DynamicObject dynamicObject, String entryKey, int rowIndex, String type) {
        DynamicObjectCollection dynamicObjectCollection;
        int scale = CurrencyUtils.getAmtPrecision(dynamicObject);
        String suffix = "";
        if ("entryentity1".equals(entryKey)) {
            suffix = "1";
        }
        if ((dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey)) == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal unmatchAmount = this.getUnmatchAmount(scale, suffix, dynamicObject, entryDynamic, type);
        entryDynamic.set(this.unmatchAmountKey, (Object)unmatchAmount);
    }

    public void calEntryUnmatchAmt(DynamicObject dynamicObject, String entryKey, int rowIndex, String type) {
        DynamicObjectCollection dynamicObjectCollection;
        int scale = CurrencyUtils.getAmtPrecision(dynamicObject);
        String suffix = "";
        if ("entryentity1".equals(entryKey)) {
            suffix = "1";
        }
        if ((dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey)) == null) {
            return;
        }
        DynamicObject entryDynamic = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal unmatchTaxAmount = this.getUnmatchTaxAmount(scale, suffix, dynamicObject, entryDynamic, type);
        entryDynamic.set(this.getUnmatchAmtKey(), (Object)unmatchTaxAmount);
    }

    private BigDecimal getUnmatchTaxAmount(int scale, String suffix, DynamicObject billDynamicObject, DynamicObject entryDynamic, String type) {
        BigDecimal unmatchTaxAmount = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        int scaleprice = CurrencyUtils.getPircePrecision(billDynamicObject);
        qty = this.unmatchQtyKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.unmatchQtyKey) : entryDynamic.getBigDecimal(this.unmatchQtyKey + suffix);
        String discountType = "";
        discountType = this.discountTypekey.endsWith(suffix) ? entryDynamic.getString(this.discountTypekey) : entryDynamic.getString(this.discountTypekey + suffix);
        BigDecimal discount = BigDecimal.ZERO;
        discount = this.discountRateKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.discountRateKey) : entryDynamic.getBigDecimal(this.discountRateKey + suffix);
        BigDecimal taxRate = BigDecimal.ZERO;
        taxRate = this.taxRateKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.taxRateKey) : entryDynamic.getBigDecimal(this.taxRateKey + suffix);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal actcheckTaxPrice = BigDecimal.ZERO;
            actcheckTaxPrice = "amount".equals(type) ? this.getActTaxTriceAmount(entryDynamic, qty, scaleprice) : entryDynamic.getBigDecimal(this.actchecktaxpriceKey);
            unmatchTaxAmount = CalculateUtils.calTaxAmountByDiscountPercent(discountType, qty, actcheckTaxPrice, discount, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal actcheckprice = BigDecimal.ZERO;
            actcheckprice = "amount".equals(type) ? this.getActPriceByAmount(entryDynamic, qty, scaleprice) : entryDynamic.getBigDecimal(this.actcheckpriceKey);
            unmatchTaxAmount = CalculateUtils.calTaxAmountByPrice(discountType, qty, actcheckprice, discount, taxRate, scale);
        }
        unmatchTaxAmount = unmatchTaxAmount.setScale(scale, 4);
        return unmatchTaxAmount;
    }

    private BigDecimal getUnmatchAmount(int scale, String suffix, DynamicObject billDynamicObject, DynamicObject entryDynamic, String type) {
        BigDecimal unmatchAmount = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        qty = this.unmatchQtyKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.unmatchQtyKey) : entryDynamic.getBigDecimal(this.unmatchQtyKey + suffix);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal discount = BigDecimal.ZERO;
        discount = this.discountRateKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.discountRateKey) : entryDynamic.getBigDecimal(this.discountRateKey + suffix);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxAmount = entryDynamic.getBigDecimal(this.unmatchAmtKey);
            BigDecimal tax = this.calEntryActTax(billDynamicObject, entryDynamic, this.unmatchAmtKey, this.unmatchAmountKey, scale);
            unmatchAmount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal actcheckprice = BigDecimal.ZERO;
            if ("amount".equals(type)) {
                int scaleprice = CurrencyUtils.getPircePrecision(billDynamicObject);
                actcheckprice = this.getActPriceByAmount(entryDynamic, qty, scaleprice);
            } else {
                actcheckprice = entryDynamic.getBigDecimal(this.actcheckpriceKey);
            }
            unmatchAmount = CalculateUtils.calAmountByDiscountPercent(discountType, qty, actcheckprice, discount, scale);
        }
        unmatchAmount = unmatchAmount.setScale(scale, 4);
        return unmatchAmount;
    }

    @Override
    public void reCalBill(DynamicObject dynamicObject, String entryKey) {
        log.info(entryKey + "@\u5f00\u59cb\u91cd\u7b97--------------------");
        boolean containTax = this.isContainTax(dynamicObject);
        DynamicObjectCollection entryCols = dynamicObject.getDynamicObjectCollection(entryKey);
        for (int rowIndex = 0; rowIndex < entryCols.size(); ++rowIndex) {
            if (containTax) {
                this.calEntryPriceByTaxPrice(dynamicObject, entryKey, rowIndex);
                this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
                this.calEntryTax(dynamicObject, entryKey, rowIndex);
                this.calEntryAmount(dynamicObject, entryKey, rowIndex);
                this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
                continue;
            }
            this.calEntryTaxPriceByPrice(dynamicObject, entryKey, rowIndex);
            this.calEntryDiscountAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryAmount(dynamicObject, entryKey, rowIndex);
            this.calEntryTax(dynamicObject, entryKey, rowIndex);
            this.calEntryTaxAmount(dynamicObject, entryKey, rowIndex);
        }
        this.calSum(dynamicObject, entryKey);
        log.info(entryKey + "@\u91cd\u7b97\u7ed3\u675f--------------------");
    }

    public void calEntryUnmatchAmount(DynamicObject dynamicObject, String entryKey, String type) {
        int scale = CurrencyUtils.getAmtPrecision(dynamicObject);
        String suffix = "";
        if ("entryentity1".equals(entryKey)) {
            suffix = "1";
        }
        this.initFiledValue(suffix);
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            String srcBillType = entry.getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock(srcBillType) && !CheckUtils.isPurReciept(srcBillType)) continue;
            BigDecimal unmatchAmount = this.getUnmatchAmount(scale, suffix, dynamicObject, entry, type);
            entry.set(this.unmatchAmountKey, (Object)unmatchAmount);
        }
    }

    public void calEntryUnmatchAmt(DynamicObject dynamicObject, String entryKey, String type) {
        int scale = CurrencyUtils.getAmtPrecision(dynamicObject);
        String suffix = "";
        if ("entryentity1".equals(entryKey)) {
            suffix = "1";
        }
        this.initFiledValue(suffix);
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            String srcBillType = entry.getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock(srcBillType) && !CheckUtils.isPurReciept(srcBillType)) continue;
            BigDecimal unmatchTaxAmount = this.getUnmatchTaxAmount(scale, suffix, dynamicObject, entry, type);
            entry.set(this.unmatchAmtKey, (Object)unmatchTaxAmount);
        }
    }

    public void initField(String qtyKey, String discountTypeKey, String discountRateKey, String taxRateKey, String actchecktaxpriceKey, String actcheckpriceKey, String unmatchQtyKey) {
        this.setQtyKey(qtyKey);
        this.setDiscountTypekey(discountTypeKey);
        this.setDiscountRateKey(discountRateKey);
        this.setTaxRateKey(taxRateKey);
        this.setActcheckpriceKey(actcheckpriceKey);
        this.setActchecktaxpriceKey(actchecktaxpriceKey);
        this.setUnmatchQtyKey(unmatchQtyKey);
    }

    public BigDecimal getUnmatchTaxAmount(DynamicObject entryDynamic, int scaleamount, int scaleprice, String taxType, String type, BigDecimal taxAmount, BigDecimal amount) {
        BigDecimal unmatchTaxAmount = BigDecimal.ZERO;
        BigDecimal qty = entryDynamic.getBigDecimal(this.unmatchQtyKey);
        String discountType = entryDynamic.getString(this.discountTypekey);
        BigDecimal discount = entryDynamic.getBigDecimal(this.discountRateKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal actcheckTaxPrice = BigDecimal.ZERO;
            actcheckTaxPrice = "amount".equals(type) ? CalculateUtils.calTaxPriceNoScale(discountType, taxAmount, qty, discount, scaleprice) : entryDynamic.getBigDecimal(this.actchecktaxpriceKey);
            unmatchTaxAmount = CalculateUtils.calTaxAmountByDiscountPercent(discountType, qty, actcheckTaxPrice, discount, scaleamount);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal actcheckprice = BigDecimal.ZERO;
            actcheckprice = "amount".equals(type) ? CalculateUtils.calPriceNoScale(discountType, amount, qty, discount, scaleprice) : entryDynamic.getBigDecimal(this.actcheckpriceKey);
            unmatchTaxAmount = CalculateUtils.calTaxAmountByPrice(discountType, qty, actcheckprice, discount, taxRate, scaleamount);
        }
        unmatchTaxAmount = unmatchTaxAmount.setScale(scaleamount, 4);
        return unmatchTaxAmount;
    }

    protected void initFiledValue(String suffix) {
        if (!this.getQtyKey().endsWith(suffix)) {
            this.setQtyKey(this.getQtyKey() + suffix);
            this.setAmountKey(this.getAmountKey() + suffix);
            this.setActPriceKey(this.getActPriceKey() + suffix);
            this.setActTaxPriceKey(this.getActTaxPriceKey() + suffix);
            this.setDiscountTypekey(this.getDiscountTypekey() + suffix);
            this.setDiscountRateKey(this.getDiscountRateKey() + suffix);
            this.setDiscountAmountKey(this.getDiscountAmountKey() + suffix);
            this.setPriceKey(this.getPriceKey() + suffix);
            this.setTaxKey(this.getTaxKey() + suffix);
            this.setTaxAmountKey(this.getTaxAmountKey() + suffix);
            this.setTaxPriceKey(this.getTaxPriceKey() + suffix);
            this.setTaxRateKey(this.getTaxRateKey() + suffix);
            this.setUnmatchQtyKey(this.getUnmatchQtyKey() + suffix);
            this.setLoctaxamountKey(this.getLoctaxamountKey() + suffix);
            this.setLocamountKey(this.getLocamountKey() + suffix);
            this.setLoctaxKey(this.getLoctaxKey() + suffix);
            this.setDiffAmtKey(this.getDiffAmtKey() + suffix);
            this.setInTaxAmountKey(this.getInTaxAmountKey() + suffix);
        }
    }
}

