/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.scm.common.util.MetaDataUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelUtil {
    private static Log log = LogFactory.getLog(ExcelUtil.class);
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcel(IFormView view, ExcelDataEntity excelData) {
        Workbook workbook = excelData.getWorkbook();
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            in = new ByteArrayInputStream(out.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsFullUrl(excelData.getFileName(), (InputStream)in, timeout);
            String tempFileId = UrlUtil.getParam((String)tempUrl, (String)"id");
            HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(2);
            refEntitiyMap.put("entityNum", view.getEntityId());
            Object permissionItemId = view.getFormShowParameter().getCustomParam("scmItemId");
            if (permissionItemId == null) {
                permissionItemId = "47150e89000000ac";
            }
            refEntitiyMap.put("permissionItemId", permissionItemId);
            refEntitiyMap.put("appId", view.getFormShowParameter().getServiceAppId());
            redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), timeout);
            DisposableUrlParam param = new DisposableUrlParam();
            param.setPath(tempUrl);
            param.setEntityNum(view.getEntityId());
            param.setPermItem(String.valueOf(permissionItemId));
            param.setPkId((Object)0);
            tempUrl = AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)param);
            view.download(tempUrl);
        }
        catch (IOException e1) {
            log.error((Throwable)e1);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                excelData.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    public static void setColumn(ExcelDataEntity excelDataEntity) {
        String entityKey = excelDataEntity.getEntityKey();
        if (null == entityKey) {
            throw new KDBizException(ResManager.loadKDString((String)"entityKey\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExcelUtil_0", (String)"scm-common", (Object[])new Object[0]));
        }
        String entryKey = excelDataEntity.getEntryKey();
        if (null == entryKey) {
            throw new KDBizException(ResManager.loadKDString((String)"entryKey\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExcelUtil_1", (String)"scm-common", (Object[])new Object[0]));
        }
        List<String> columnList = MetaDataUtil.getColumnKey(entityKey, entryKey);
        excelDataEntity.setColumnKeyList(columnList);
    }

    public static void setExcelHeader(ExcelDataEntity excelDataEntity, IDataModel model) throws IOException {
        ExcelUtil.setColumn(excelDataEntity);
        List<String> columnKeyList = excelDataEntity.getColumnKeyList();
        ArrayList<String> columnTitleList = new ArrayList<String>(columnKeyList.size());
        for (String column : columnKeyList) {
            DynamicProperty pro = (DynamicProperty)model.getDataEntityType().findProperty(column);
            if (null == pro) continue;
            StringBuilder headTitileSb = new StringBuilder(pro.getDisplayName().toString());
            if (excelDataEntity.isAddColumnKeyToHeader()) {
                if (column.equals("supplier")) {
                    headTitileSb.append(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExcelUtil_2", (String)"scm-common", (Object[])new Object[0])).append("${").append(column).append('}').append(ResManager.loadKDString((String)"\u6ce8\uff1a\u53ea\u80fd\u586b\u6b63\u5f0f\u4f9b\u5e94\u5546\u540d\u79f0", (String)"ExcelUtil_3", (String)"scm-common", (Object[])new Object[0]));
                } else {
                    headTitileSb.append("${").append(column).append('}');
                }
            }
            columnTitleList.add(headTitileSb.toString());
        }
        excelDataEntity.setExcelHeader(columnTitleList);
    }
}

