/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.mal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;

public class MalNewOrderUtils {
    private static Map<String, String> ecOrderMap = new HashMap<String, String>(8);

    public static String getPlatformId(String source) {
        return ecOrderMap.get(source);
    }

    public static String getOrderId(String source, String pkId) {
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkId), (String)ecOrderMap.get(source));
        if (StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JD.getVal(), (CharSequence)source) || StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal(), (CharSequence)source)) {
            return order.getString("jdorderid");
        }
        return order.getString("porderid");
    }

    public static String getSubOrderId(String source, String pkId) {
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkId), (String)ecOrderMap.get(source));
        if (StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JD.getVal(), (CharSequence)source) || StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal(), (CharSequence)source)) {
            return order.getString("number");
        }
        return order.getString("orderid");
    }

    public static Object getParentOrderPkId(String orderId, String source) {
        DynamicObject dynamicObject = null;
        dynamicObject = StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JD.getVal(), (CharSequence)source) || StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal(), (CharSequence)source) ? QueryServiceHelper.queryOne((String)ecOrderMap.get(source), (String)"id", (QFilter[])new QFilter[]{new QFilter("jdorderid", "=", (Object)orderId)}) : QueryServiceHelper.queryOne((String)ecOrderMap.get(source), (String)"id", (QFilter[])new QFilter[]{new QFilter("orderid", "=", (Object)orderId)});
        return null == dynamicObject ? null : dynamicObject.get("id");
    }

    public static Object getOrderPkId(String parentOrderId, String source, String skuId) {
        DynamicObject dynamicObject = null;
        if (null != source && source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal())) {
            dynamicObject = QueryServiceHelper.queryOne((String)ecOrderMap.get(source), (String)"id", (QFilter[])new QFilter[]{new QFilter("porderid", "=", (Object)parentOrderId).and(new QFilter("entryentity.goods.number", "=", (Object)skuId))});
        }
        return null == dynamicObject ? null : dynamicObject.get("id");
    }

    public static DynamicObject getOrderDyn(String orderPkId, String source) {
        return BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(orderPkId), (String)ecOrderMap.get(source));
    }

    public static Set<Long> getEcOrderPks(String source, Set<Object> ecOrderIds) {
        HashSet<Long> pks = new HashSet<Long>(ecOrderIds.size());
        QFilter filter = null;
        filter = StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JD.getVal(), (CharSequence)source) || StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal(), (CharSequence)source) ? new QFilter("jdorderid", "in", ecOrderIds) : new QFilter("orderid", "in", ecOrderIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MalNewOrderUtils", (String)ecOrderMap.get(source), (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            ds.forEach(row -> pks.add(row.getLong("id")));
        }
        return pks;
    }

    public static Map<Long, DynamicObject> queryEcOrderByEcOrderIds(String source, Set<String> ecOrderIds) {
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection ecOrders = MalNewOrderUtils.queryEcOrderByEcOrderIds(source, ecOrderIds, "id, orderid, porderid, invoiceid, invoicecode");
        for (DynamicObject ecOrderDyn : ecOrders) {
            res.put(ecOrderDyn.getLong("id"), ecOrderDyn);
        }
        return res;
    }

    public static DynamicObjectCollection queryEcOrderDetailByEcOrderIds(String source, Set<String> ecOrderIds) {
        return MalNewOrderUtils.queryEcOrderByEcOrderIds(source, ecOrderIds, "id, orderid, porderid, invoiceid, invoicecode,entryentity.goods.id,entryentity.goods.number,entryentity.qty,entryentity.price,entryentity.nakedamount,entryentity.taxamount,entryentity.taxrate");
    }

    private static DynamicObjectCollection queryEcOrderByEcOrderIds(String source, Set<String> ecOrderIds, String selectFields) {
        QFilter filter = StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JD.getVal(), (CharSequence)source) || StringUtils.equalsIgnoreCase((CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal(), (CharSequence)source) ? new QFilter("jdorderid", "in", ecOrderIds) : new QFilter("orderid", "in", ecOrderIds);
        return QueryServiceHelper.query((String)ecOrderMap.get(source), (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
    }

    public static DynamicObject getEcOrderDynByEcOrderId(String ecOrderId, String source) {
        return QueryServiceHelper.queryOne((String)ecOrderMap.get(source), (String)"id, orderid, porderid, invoiceid, invoicecode, markid", (QFilter[])new QFilter[]{new QFilter("orderid", "=", (Object)ecOrderId)});
    }

    public static String getPlatformBySupplierId(Long supplierId) {
        DynamicObject ecAdmitDyn = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)"platform", (QFilter[])new QFilter[]{new QFilter("malsupplier", "=", (Object)supplierId)});
        if (ecAdmitDyn != null) {
            return ecAdmitDyn.getString("platform");
        }
        return EcPlatformEnum.ECPLATFORM_SELF.getVal();
    }

    public static String getPlatformByEcOrderPk(Long ecOrderPk) {
        DynamicObject malOrderDyn = QueryServiceHelper.queryOne((String)"mal_order", (String)"platform", (QFilter[])new QFilter[]{new QFilter("entryentity.order", "=", (Object)ecOrderPk)});
        if (malOrderDyn != null) {
            return malOrderDyn.getString("platform");
        }
        return EcPlatformEnum.UNKNOW.getVal();
    }

    public static boolean checkIsGoodsBizType(DynamicObject bizType) {
        if (!Objects.isNull(bizType) && StringUtils.isNotBlank((CharSequence)bizType.getString("number"))) {
            return bizType.getString("number").startsWith("140");
        }
        return false;
    }

    public static boolean checkIsGoodsBizTypeId(Long bizTypeId) {
        if (!Objects.isNull(bizTypeId)) {
            DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)"bd_biztype");
            return MalNewOrderUtils.checkIsGoodsBizType(bizType);
        }
        return false;
    }

    static {
        ecOrderMap.put(EcPlatformEnum.ECPLATFORM_JD.getVal(), "pbd_jdorder");
        ecOrderMap.put(EcPlatformEnum.ECPLATFORM_JDPRO.getVal(), "pbd_jdorder");
        ecOrderMap.put(EcPlatformEnum.ECPLATFORM_SUNING.getVal(), "pbd_order_sn");
        ecOrderMap.put(EcPlatformEnum.ECPLATFORM_XY.getVal(), "pbd_order_xy");
        ecOrderMap.put(EcPlatformEnum.ECPLATFORM_CG.getVal(), "pbd_order_cg");
        ecOrderMap.put(EcPlatformEnum.ECPLATFORM_DL.getVal(), "pbd_order_dl");
        ecOrderMap.put(EcPlatformEnum.ECPLATFORM_XFS.getVal(), "pbd_order_xfs");
        ecOrderMap.put(EcPlatformEnum.ECPLATFORM_ZKH.getVal(), "pbd_order_zkh");
    }
}

