/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierLifeCycleManagerUtil;

public class SrmCommonValidator {
    private static final Set<String> verifiedBill = new HashSet<String>();
    private static final int ENTRY_MAX_PROVINCE_NUM = 34;

    protected static boolean isVerifyCode(String billType) {
        return verifiedBill.contains(billType);
    }

    public static Map<String, Object> supRegValidator(ExtendedDataEntity rowDataEntity) {
        DynamicObjectCollection regstockentry;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        boolean isSucced = SrmCommonValidator.validateBaseInfo(rowDataEntity, sb, true);
        DynamicObjectCollection aptitudeRows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entry_aptitude");
        isSucced = SrmCommonValidator.validateAptitude(aptitudeRows, sb, isSucced);
        DynamicObjectCollection bankRows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entry_bank");
        isSucced = SrmCommonValidator.validateBank(bankRows, sb, isSucced);
        DynamicObjectCollection linkRows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entry_link");
        if (linkRows != null && linkRows.size() != 0) {
            List<String> distinctEmail1s;
            List<String> distinctMobiles;
            Map groupMap;
            int i = 1;
            ArrayList<String> mobiles = new ArrayList<String>();
            ArrayList<String> email1s = new ArrayList<String>();
            int count = 0;
            Object qFilter = null;
            String phone = rowDataEntity.getDataEntity().getString("phone").trim();
            for (DynamicObject row : linkRows) {
                String name1 = row.getString("name1");
                String entryMobile = row.getString("mobile1");
                String entryEmail = row.getString("email1");
                boolean availableEntryPhone = true;
                boolean availableEntryEmail = true;
                StringBuilder accountEntryMessage = new StringBuilder();
                if (name1 == null) {
                    sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f>\u7b2c{0}\u884c\uff1a{1}\u59d3\u540d\u201d\u65e0\u6548", (String)"SrmCommonValidator_20", (String)"scm-common", (Object[])new Object[0]), i, name1)).append("\n");
                    isSucced = false;
                }
                if ((entryEmail == null || entryEmail.isEmpty()) && (entryMobile == null || entryMobile.isEmpty())) {
                    accountEntryMessage.append(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f>\u624b\u673a(\u8d26\u53f7)\u201d\u65e0\u6548\u3002", (String)"SrmCommonValidator_35", (String)"scm-common", (Object[])new Object[0])).append("\n");
                    availableEntryPhone = false;
                    accountEntryMessage.append(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f>\u90ae\u7bb1\u201d\u65e0\u6548\u3002", (String)"SrmCommonValidator_36", (String)"scm-common", (Object[])new Object[0])).append("\n");
                    availableEntryEmail = false;
                } else if (entryMobile != null && !entryMobile.isEmpty() && !SrmCommonValidator.isPhoneValid(entryMobile)) {
                    accountEntryMessage.append(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f>\u624b\u673a(\u8d26\u53f7)\u201d\u65e0\u6548\u3002", (String)"SrmCommonValidator_35", (String)"scm-common", (Object[])new Object[0])).append("\n");
                    availableEntryPhone = false;
                } else if (entryEmail != null && !entryEmail.isEmpty() && !StringUtils.isEmail((String)entryEmail)) {
                    accountEntryMessage.append(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f>\u90ae\u7bb1\u201d\u65e0\u6548\u3002", (String)"SrmCommonValidator_36", (String)"scm-common", (Object[])new Object[0])).append("\n");
                    availableEntryEmail = false;
                }
                if (!availableEntryEmail || !availableEntryPhone) {
                    isSucced = false;
                    sb.append((CharSequence)accountEntryMessage);
                }
                if (availableEntryEmail && StringUtils.isNotEmpty((CharSequence)entryEmail)) {
                    email1s.add(entryEmail);
                }
                if (availableEntryPhone && StringUtils.isNotEmpty((CharSequence)entryMobile)) {
                    mobiles.add(entryMobile);
                }
                if (row.getBoolean("isdefault_link")) {
                    ++count;
                }
                ++i;
            }
            if (count > 1) {
                sb.append(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f>\u9ed8\u8ba4\u8054\u7cfb\u4eba\u201d\u4e0d\u80fd\u591a\u4e8e1\u4e2a", (String)"SrmCommonValidator_22", (String)"scm-common", (Object[])new Object[0])).append("\n");
                isSucced = false;
            } else if (count == 0) {
                sb.append(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f\u201d\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u8054\u7cfb\u4eba\u3002", (String)"SrmCommonValidator_23", (String)"scm-common", (Object[])new Object[0])).append("\n");
                isSucced = false;
            }
            if (mobiles.size() > 0 && Objects.nonNull(groupMap = mobiles.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) && groupMap.size() > 0 && (distinctMobiles = groupMap.keySet().stream().filter(key -> (Long)groupMap.get(key) > 1L).distinct().collect(Collectors.toList())).size() > 0) {
                isSucced = false;
                distinctMobiles.forEach(x -> sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f>\u624b\u673a\u53f7\u7801{0}\u201d\u91cd\u590d\u3002", (String)"SrmCommonValidator_37", (String)"scm-common", (Object[])new Object[0]), x)).append("\n"));
            }
            if (email1s.size() > 0 && Objects.nonNull(groupMap = email1s.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) && groupMap.size() > 0 && (distinctEmail1s = groupMap.keySet().stream().filter(key -> (Long)groupMap.get(key) > 1L).distinct().collect(Collectors.toList())).size() > 0) {
                isSucced = false;
                distinctEmail1s.forEach(x -> sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e>\u8054\u7cfb\u4eba\u4fe1\u606f>\u90ae\u7bb1{0}\u91cd\u590d\u3002", (String)"SrmCommonValidator_38", (String)"scm-common", (Object[])new Object[0]), x)).append("\n"));
            }
        }
        if (!SrmCommonValidator.validateStockratio(regstockentry = rowDataEntity.getDataEntity().getDynamicObjectCollection("regstockentry"))) {
            sb.append(ResManager.loadKDString((String)"\u80a1\u6743\u4fe1\u606f\u4e2d\u6301\u80a1\u6bd4\u5217\u5927\u4e8e100%", (String)"SrmCommonValidator_41", (String)"scm-common", (Object[])new Object[0]));
            isSucced = false;
        }
        resultMap.put("succed", isSucced);
        resultMap.put("message", sb);
        return resultMap;
    }

    public static Map<String, Object> aptitudeMustInputValidate(ExtendedDataEntity rowDataEntity) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Boolean enableNewQualification = ParamConfigUtil.getCacheBooleanParamConfig((String)"enableNewQualification");
        if (!enableNewQualification.booleanValue()) {
            resultMap.put("succed", true);
            return resultMap;
        }
        DynamicObjectCollection aptitudeRows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entry_aptitude");
        HashSet<Long> companyIdSet = new HashSet<Long>();
        HashSet<Long> aptitudeIdSet = new HashSet<Long>();
        for (DynamicObject dyn : aptitudeRows) {
            companyIdSet.add(dyn.getLong("companytype.id"));
            aptitudeIdSet.add(dyn.getLong("aptitudetype1.id"));
        }
        QFilter qFilter = new QFilter("group.id", "in", companyIdSet);
        qFilter.and(new QFilter("required", "=", (Object)true));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] qualificationConfigs = BusinessDataServiceHelper.load((String)"bd_qualification_config", (String)"qfttype,required,group", (QFilter[])new QFilter[]{qFilter});
        boolean flag = true;
        HashMap<Long, DynamicObject> quatypeMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> omissionMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject quaconfig : qualificationConfigs) {
            long qfttypeId = quaconfig.getLong("qfttype.id");
            quatypeMap.put(qfttypeId, quaconfig.getDynamicObject("qfttype"));
            if (aptitudeIdSet.contains(qfttypeId)) continue;
            omissionMap.put(qfttypeId, quaconfig.getDynamicObject("group"));
            flag = false;
        }
        resultMap.put("succed", flag);
        resultMap.put("quatypeMap", quatypeMap);
        resultMap.put("omissionMap", omissionMap);
        return resultMap;
    }

    public static boolean validateStockratio(DynamicObjectCollection regstockentry) {
        BigDecimal stockratioAdd;
        return kd.bos.orm.util.CollectionUtils.isEmpty((Collection)regstockentry) || !Objects.nonNull(stockratioAdd = regstockentry.stream().map(x -> x.getBigDecimal("stockratio")).reduce(BigDecimal.ZERO, BigDecimal::add)) || stockratioAdd.compareTo(new BigDecimal(100)) <= 0;
    }

    public static void validateLinkUserInfo(ExtendedDataEntity rowDataEntity, Map<String, Object> resultMap) {
        DynamicObjectCollection linkRows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entry_link");
        boolean isSucced = true;
        Object succedValue = resultMap.get("succed");
        StringBuilder stringBuilder = new StringBuilder();
        if (succedValue instanceof Boolean) {
            isSucced = (Boolean)resultMap.get("succed");
            stringBuilder.append(resultMap.get("message"));
        }
        if (linkRows != null && linkRows.size() != 0) {
            QFilter qFilter = null;
            String phone = rowDataEntity.getDataEntity().getString("phone").trim();
            for (DynamicObject row2 : linkRows) {
                String entryMobile = row2.getString("mobile1");
                String entryEmail = row2.getString("email1");
                if (entryEmail != null && !entryEmail.isEmpty() && phone.equals(entryEmail)) {
                    qFilter = new QFilter("email", "=", (Object)phone);
                    if (entryMobile == null || entryMobile.isEmpty()) continue;
                    qFilter.or("phone", "=", (Object)entryMobile);
                    continue;
                }
                if (entryMobile == null || entryMobile.isEmpty() || !phone.equals(entryMobile)) continue;
                qFilter = new QFilter("phone", "=", (Object)phone);
                if (entryEmail == null || entryEmail.isEmpty()) continue;
                qFilter.or("email", "=", (Object)entryEmail);
            }
            if (qFilter != null) {
                qFilter.and("enable", "=", (Object)"1");
                ArrayList bosUserPkIds = new ArrayList(1);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"bos_user", (String)"id,enable", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)1);){
                    dataSet.forEach(row -> bosUserPkIds.add(row.getLong("id")));
                }
                if (!bosUserPkIds.isEmpty()) {
                    isSucced = false;
                    stringBuilder.append(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u8054\u7cfb\u4eba\u4fe1\u606f\u6ce8\u518c\u8d26\u53f7\u90ae\u7bb1\u6216\u624b\u673a\u53f7\u201d\u5df2\u5728\u7cfb\u7edf\u5b58\u5728\u5bf9\u5e94\u4eba\u5458\u4fe1\u606f\u3002", (String)"SrmCommonValidator_32", (String)"scm-common", (Object[])new Object[0])).append("\n");
                }
            }
            resultMap.put("succed", isSucced);
            resultMap.put("message", stringBuilder);
        }
    }

    private static boolean validateBaseInfo(ExtendedDataEntity rowDataEntity, StringBuilder sb, boolean isSucced) {
        Date listedDate;
        Date regDate;
        Object id = rowDataEntity.getDataEntity().get("id");
        String name = rowDataEntity.getDataEntity().getString("name");
        String linkman = rowDataEntity.getDataEntity().getString("linkman");
        String creditno = rowDataEntity.getDataEntity().getString("societycreditcode");
        DynamicObject org = rowDataEntity.getDataEntity().getDynamicObject("org");
        String billname = rowDataEntity.getDataEntity().getDynamicObjectType().getName();
        boolean flag = isSucced;
        if ("srm_supplierchg".equals(billname) || "adm_supplierchg".equals(billname)) {
            flag = SrmCommonValidator.chgVaildateNameAndCreditcode(rowDataEntity, sb, id, org, name, creditno, billname);
        } else if (!"srm_supplierreg".equals(billname)) {
            flag = SrmCommonValidator.registerVaildateNameAndCreditcode(rowDataEntity, sb, id, org, name, creditno, billname);
        }
        if (org == null) {
            sb.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u6ce8\u518c\u5ba1\u6279\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmCommonValidator_42", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        }
        if (rowDataEntity.getDataEntity().get("curr") == null) {
            sb.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u5e01\u79cd\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmCommonValidator_5", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        }
        boolean availableAccount = true;
        StringBuilder accountMessage = new StringBuilder();
        String accountNum = rowDataEntity.getDataEntity().getString("phone");
        if (accountNum == null || accountNum.isEmpty()) {
            accountMessage.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u8d26\u53f7(\u624b\u673a/\u90ae\u7bb1)\u201d\u65e0\u6548\u3002", (String)"SrmCommonValidator_9", (String)"scm-common", (Object[])new Object[0])).append("\n");
            availableAccount = false;
        } else if (!StringUtils.isEmail((String)accountNum) && !SrmCommonValidator.isPhoneValid(accountNum)) {
            accountMessage.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u8d26\u53f7(\u624b\u673a/\u90ae\u7bb1)\u201d\u65e0\u6548\u3002", (String)"SrmCommonValidator_9", (String)"scm-common", (Object[])new Object[0])).append("\n");
            availableAccount = false;
        }
        if (!availableAccount) {
            flag = false;
            sb.append((CharSequence)accountMessage);
        }
        if (StringUtils.equals((CharSequence)"administrator", (CharSequence)linkman)) {
            sb.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u6ce8\u518c\u7528\u6237\u540d\u4e3a\u201cadministrator\u201d\u7684\u7528\u6237\u3002", (String)"SrmCommonValidator_44", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        }
        if (linkman == null || linkman.trim().equals("")) {
            flag = false;
            sb.append(ResManager.loadKDString((String)"\u201c\u57fa\u672c\u4fe1\u606f\u9875\u7b7e>\u7cfb\u7edf\u7ba1\u7406\u5458\u59d3\u540d\u201d\u65e0\u6548", (String)"SrmCommonValidator_10", (String)"scm-common", (Object[])new Object[0])).append("\n");
        }
        if ((regDate = rowDataEntity.getDataEntity().getDate("regDate")) != null && TimeServiceHelper.now().before(regDate)) {
            sb.append(ResManager.loadKDString((String)"\u201c\u57fa\u672c\u4fe1\u606f\u9875\u7b7e>\u4f01\u4e1a\u6ce8\u518c\u65f6\u95f4\u201d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SrmCommonValidator_31", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        }
        if ((listedDate = rowDataEntity.getDataEntity().getDate("listeddate")) != null && TimeServiceHelper.now().before(listedDate)) {
            sb.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u4f01\u4e1a\u4e0a\u5e02\u65f6\u95f4\u201d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SrmCommonValidator_30", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        }
        if (listedDate != null && regDate != null && listedDate.before(regDate)) {
            sb.append(ResManager.loadKDString((String)"\u201c\u57fa\u672c\u4fe1\u606f\u9875\u7b7e>\u516c\u53f8\u6210\u7acb\u65e5\u671f\u201d\u4e0d\u80fd\u665a\u4e8e\u4e0a\u5e02\u65e5\u671f", (String)"SrmCommonValidator_29", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        }
        if (flag) {
            Map<String, Boolean> checkResults = SrmCommonValidator.validateSupchange(name, creditno);
            if (checkResults != null) {
                for (Map.Entry<String, Boolean> entry : checkResults.entrySet()) {
                    if ("name".equals(entry.getKey()) && entry.getValue().booleanValue()) {
                        sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u5f85\u5904\u7406\u72b6\u6001\u4e0b\u76f8\u540c\u540d\u79f0\u7684\u6ce8\u518c\u8d44\u6599\u53d8\u66f4\u5355\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"SrmCommonValidator_45", (String)"scm-common", (Object[])new Object[0]));
                        flag = false;
                        continue;
                    }
                    if (!"societycreditcode".equals(entry.getKey()) || !entry.getValue().booleanValue()) continue;
                    sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u5f85\u5904\u7406\u72b6\u6001\u4e0b\u76f8\u540c\u4fe1\u7528\u4ee3\u7801\u7684\u6ce8\u518c\u8d44\u6599\u53d8\u66f4\u5355\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"SrmCommonValidator_46", (String)"scm-common", (Object[])new Object[0]));
                    flag = false;
                }
            }
            if (SrmCommonValidator.validateIssuerfi(name)) {
                sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u63d0\u4ea4\u72b6\u6001\u4e0b\u76f8\u540c\u540d\u79f0\u7684\u53d1\u653eRFI\u5355\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"SrmCommonValidator_47", (String)"scm-common", (Object[])new Object[0]));
                flag = false;
            }
        }
        return flag;
    }

    private static boolean chgVaildateNameAndCreditcode(ExtendedDataEntity rowDataEntity, StringBuilder sb, Object id, DynamicObject org, String name, String creditno, String billname) {
        boolean flag = true;
        if (name == null || name.trim().equals("")) {
            sb.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u540d\u79f0\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrmCommonValidator_6", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        } else {
            DynamicObject srmSupplier;
            boolean isexist = false;
            QFilter qFilter = new QFilter("name", "=", (Object)name).and("societycreditcode", "!=", (Object)creditno).and("id", "!=", id);
            String orgFiled = null;
            Object orgPk = null;
            if (Objects.nonNull(org)) {
                orgFiled = "org";
                orgPk = org.getPkValue();
                qFilter.and(orgFiled, "=", orgPk);
            }
            if ((srmSupplier = QueryServiceHelper.queryOne((String)"adm_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter})) == null) {
                QFilter filter = new QFilter("name", "=", (Object)name);
                DynamicObject supplier = rowDataEntity.getDataEntity().getDynamicObject("supplier");
                if (Objects.nonNull(supplier)) {
                    Object supplierId = supplier.getPkValue();
                    filter.and("id", "!=", supplierId);
                }
                if (Objects.nonNull(org)) {
                    filter.and("org", "=", org.getPkValue());
                }
                isexist = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])new QFilter[]{filter});
            } else if (srmSupplier != null) {
                isexist = true;
            }
            if (isexist) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\uff1a{0}\u5df2\u5b58\u5728\u3002", (String)"SrmCommonValidator_7", (String)"scm-common", (Object[])new Object[0]), name)).append("\n");
                flag = false;
            }
            if (SrmCommonUtil.isBlackEnterpirse((long)0L, (String)creditno, (String)name)) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u4f01\u4e1a\u201d\uff1a{0}{1}\u5df2\u88ab\u7eb3\u5165\u9ed1\u540d\u5355\u3002", (String)"SrmCommonValidator_8", (String)"scm-common", (Object[])new Object[0]), creditno, name)).append("\n");
                flag = false;
            }
        }
        return flag;
    }

    private static boolean registerVaildateNameAndCreditcode(ExtendedDataEntity rowDataEntity, StringBuilder sb, Object id, DynamicObject org, String name, String creditno, String billname) {
        QFilter filter;
        Object orgPk;
        String orgFiled;
        QFilter qFilter;
        boolean isexist;
        boolean flag = true;
        boolean supplierlifecycle = SupplierLifeCycleManagerUtil.isEnableSupplierLifeCycleManager();
        Set<Long> quitOrgSet = SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgExcludeCurBillSet(name, creditno, id);
        if (name == null || name.trim().equals("")) {
            sb.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u540d\u79f0\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrmCommonValidator_6", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        } else {
            isexist = false;
            if (!supplierlifecycle || quitOrgSet.isEmpty()) {
                qFilter = new QFilter("name", "=", (Object)name).and("id", "!=", id);
                orgFiled = null;
                orgPk = null;
                if (Objects.nonNull(org) && !"adm_supplierreg".equals(billname)) {
                    orgFiled = "org";
                    orgPk = org.getPkValue();
                    qFilter.and(orgFiled, "=", orgPk);
                }
                DynamicObject srmSupplier = QueryServiceHelper.queryOne((String)"srm_supplierreg", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (!supplierlifecycle && srmSupplier == null) {
                    filter = new QFilter("name", "=", (Object)name);
                    isexist = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])new QFilter[]{filter});
                } else if (srmSupplier != null) {
                    isexist = true;
                }
            }
            if (isexist) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\uff1a{0}\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"SrmCommonValidator_7", (String)"scm-common", (Object[])new Object[0]), name)).append("\n");
                flag = false;
            }
            if (SrmCommonUtil.isBlackEnterpirse((long)0L, (String)creditno, (String)name)) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u4f01\u4e1a\u201d\uff1a{0}{1}\u5df2\u88ab\u7eb3\u5165\u9ed1\u540d\u5355\u3002", (String)"SrmCommonValidator_8", (String)"scm-common", (Object[])new Object[0]), creditno, name)).append("\n");
                flag = false;
            }
        }
        if (creditno == null || creditno.trim().equals("")) {
            sb.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmCommonValidator_43", (String)"scm-common", (Object[])new Object[0])).append("\n");
            flag = false;
        } else {
            isexist = false;
            if (!supplierlifecycle || quitOrgSet.isEmpty()) {
                qFilter = new QFilter("societycreditcode", "=", (Object)creditno).and("id", "!=", id);
                orgFiled = null;
                orgPk = null;
                if (Objects.nonNull(org) && !"adm_supplierreg".equals(billname)) {
                    orgFiled = "org";
                    orgPk = org.getPkValue();
                    qFilter.and(orgFiled, "=", orgPk);
                }
                DynamicObject srmuserobj = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (!supplierlifecycle && srmuserobj == null) {
                    filter = new QFilter("societycreditcode", "=", (Object)creditno);
                    isexist = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])new QFilter[]{filter});
                } else if (srmuserobj != null) {
                    isexist = true;
                }
            }
            if (isexist) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u4fe1\u7528\u4ee3\u7801\uff1a{0}\u5df2\u88ab\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"SrmCommonValidator_3", (String)"scm-common", (Object[])new Object[0]), creditno)).append("\n");
                flag = false;
            }
            if (SrmCommonUtil.isBlackEnterpirse((long)0L, (String)creditno, null)) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u4fe1\u7528\u4ee3\u7801\uff1a{0}\u5df2\u88ab\u7eb3\u5165\u9ed1\u540d\u5355\uff0c\u4e0d\u5141\u8bb8\u6ce8\u518c\u3002", (String)"SrmCommonValidator_4", (String)"scm-common", (Object[])new Object[0]), creditno)).append("\n");
                flag = false;
            }
        }
        return flag;
    }

    private static boolean isPhoneValid(String number) {
        if (StringUtils.isNotBlank((CharSequence)number)) {
            number = SrmCommonValidator.getFullPhoneFormat(number);
            List<String> phoneList = Collections.singletonList(number);
            try {
                SrmCommonValidator.validatePhone(phoneList);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    private static void validatePhone(List<String> phoneList) {
        List resultList = I18nServiceHelper.batchVerifyTelephoneNumber(phoneList);
        for (TelephoneVerifyResult item : resultList) {
            Map result;
            String message;
            if (!item.isParseSuccess()) {
                throw new KDBizException(item.getParseErrorMsg());
            }
            if (item.isVerifySuccess() || !StringUtils.isNotBlank((CharSequence)(message = CollectionUtils.isEmpty((Map)(result = item.getVerifyResult())) ? "" : (String)result.get("message")))) continue;
            throw new KDBizException(message);
        }
    }

    private static String getFullPhoneFormat(String phone) {
        if (!phone.startsWith("+")) {
            phone = phone.contains("-") ? "+" + phone : "+86-" + phone;
        }
        return phone;
    }

    private static boolean validateBank(DynamicObjectCollection bankRows, StringBuilder sb, boolean isSuccess) {
        boolean flag = isSuccess;
        if (bankRows != null && bankRows.size() > 0) {
            HashMap bankCountFilter = new HashMap();
            Map<Boolean, Long> defaultMap = bankRows.stream().collect(Collectors.groupingBy(info -> {
                if (!bankCountFilter.containsKey(info.getString("account").trim())) {
                    bankCountFilter.put(info.getString("account").trim(), "0");
                }
                return info.getBoolean("isdefault");
            }, Collectors.counting()));
            Long defultValue = defaultMap.get(Boolean.TRUE);
            if (defultValue != null) {
                if (defultValue > 1L) {
                    sb.append(ResManager.loadKDString((String)"\u201c\u8d22\u52a1\u4fe1\u606f\u9875\u7b7e>\u94f6\u884c\u4fe1\u606f\u201d\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u94f6\u884c\u3002", (String)"SrmCommonValidator_28", (String)"scm-common", (Object[])new Object[0])).append("\n");
                    flag = false;
                }
            } else if (defaultMap.get(Boolean.FALSE) != null) {
                sb.append(ResManager.loadKDString((String)"\u201c\u8d22\u52a1\u4fe1\u606f\u9875\u7b7e>\u94f6\u884c\u4fe1\u606f\u201d\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u94f6\u884c\u3002", (String)"SrmCommonValidator_18", (String)"scm-common", (Object[])new Object[0])).append("\n");
                flag = false;
            }
            if (bankCountFilter.size() != bankRows.size()) {
                sb.append(ResManager.loadKDString((String)"\u8d22\u52a1\u4fe1\u606f\u9875\u7b7e\u7684\u201c\u94f6\u884c\u4fe1\u606f\u94f6\u884c\u8d26\u53f7\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"SrmCommonValidator_34", (String)"scm-common", (Object[])new Object[0])).append("\n");
                flag = false;
            }
        }
        return flag;
    }

    private static boolean validateAptitude(DynamicObjectCollection aptitudeRows, StringBuilder sb, boolean isSuccess) {
        boolean flag = isSuccess;
        if (aptitudeRows != null && aptitudeRows.size() > 0) {
            Iterator iterator = aptitudeRows.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                Date dateto = row.getDate("dateto");
                if (dateto != null) {
                    Date issuedate = row.getDate("issuedate");
                    Date checkdate = row.getDate("checkdate");
                    String aptitudename = row.getString("aptitudename");
                    if (issuedate != null) {
                        if (!issuedate.before(dateto)) {
                            sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u8d44\u8d28\u4fe1\u606f\u9875\u7b7e>\u8d44\u8d28\u4fe1\u606f>\u7b2c{0}\u884c{1}\uff1a\u7b7e\u53d1\u65e5\u671f\u201d\u4e0d\u80fd\u665a\u4e8e\u6709\u6548\u65e5\u671f\u3002", (String)"SrmCommonValidator_13", (String)"scm-common", (Object[])new Object[0]), i, aptitudename)).append("\n");
                            flag = false;
                        }
                        if (!(checkdate == null || checkdate.after(issuedate) && checkdate.before(dateto))) {
                            sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u8d44\u8d28\u4fe1\u606f\u9875\u7b7e>\u8d44\u8d28\u4fe1\u606f>\u7b2c{0}\u884c{1}\uff1a\u6700\u8fd1\u5e74\u68c0\u65e5\u671f\u201d\u5fc5\u987b\u5728\u7b7e\u53d1\u65e5\u671f\u548c\u6709\u6548\u65e5\u671f\u4e4b\u95f4\u3002", (String)"SrmCommonValidator_14", (String)"scm-common", (Object[])new Object[0]), i, aptitudename)).append("\n");
                            flag = false;
                        }
                    }
                }
                ++i;
            }
        }
        return flag;
    }

    private static DataSet queruBosUser(String queryKey, List<String> queryValues) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SrmCommonValidator", (String)"bos_user", (String)"id,phone,email", (QFilter[])new QFilter[]{new QFilter(queryKey, "in", queryValues).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("usertype", "match", (Object)"3").or(new QFilter("usertype", "match", (Object)"1")))}, (String)"id");
        return dataSet;
    }

    public static Map<String, Object> sampleDateValidator(DynamicObjectCollection rows, String type) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        StringBuilder sb = new StringBuilder();
        boolean isSucced = true;
        if (rows == null || rows.size() == 0) {
            return resultMap;
        }
        int i = 1;
        Calendar calendar = Calendar.getInstance();
        Date now = TimeServiceHelper.now();
        for (DynamicObject row : rows) {
            Date senddate = row.getDate("senddate");
            Date arrivaldate = row.getDate("arrivaldate");
            if (senddate == null) continue;
            calendar.setTime(now);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            if (type.equals("senddate") && calendar.getTime().after(senddate)) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u8981\u6c42\u9001\u6837\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u4eca\u5929\u3002", (String)"SrmCommonValidator_24", (String)"scm-common", (Object[])new Object[0]), i)).append('\n');
                isSucced = false;
            }
            if (arrivaldate != null && type.equals("arrivaldate") && arrivaldate.after(senddate)) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u786e\u8ba4\u5230\u8d27\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u8981\u6c42\u9001\u6837\u65f6\u95f4\u3002", (String)"SrmCommonValidator_25", (String)"scm-common", (Object[])new Object[0]), i)).append('\n');
                isSucced = false;
            }
            if (arrivaldate != null && type.equals("testdate") && row.getDate("testdate") != null && row.getDate("testdate").before(arrivaldate)) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6837\u54c1\u6d4b\u8bd5\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u786e\u8ba4\u5230\u8d27\u65f6\u95f4\u3002", (String)"SrmCommonValidator_26", (String)"scm-common", (Object[])new Object[0]), i)).append('\n');
                isSucced = false;
            }
            if (type.equals("testdate") && row.getDate("testdate") != null && row.getDate("testdate").before(senddate)) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6837\u54c1\u6d4b\u8bd5\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u6837\u54c1\u9001\u6837\u65f6\u95f4\u3002", (String)"SrmCommonValidator_27", (String)"scm-common", (Object[])new Object[0]), i)).append('\n');
                isSucced = false;
            }
            ++i;
        }
        resultMap.put("succed", isSucced);
        resultMap.put("message", sb);
        return resultMap;
    }

    public static void emptyEntryRowByKeyFild(IDataModel model, String entry, String keyFild) {
        DynamicObjectCollection rows = model.getDataEntity(true).getDynamicObjectCollection(entry);
        Iterator iterator = rows.iterator();
        DynamicObject row = null;
        Object obj = null;
        while (iterator.hasNext()) {
            row = (DynamicObject)iterator.next();
            obj = row.get(keyFild);
            if (!StringUtils.isBlank((Object)obj)) continue;
            iterator.remove();
        }
    }

    private static boolean validateIssuerfi(String name) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"srm_issuerfi", (String)"id,billstatus,suppliername", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"B")});
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!name.equals(dynamicObject.getString("suppliername"))) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Boolean> validateSupchange(String name, String creditno) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1024);
        QFilter qf = new QFilter("billstatus", "=", (Object)"C").and(new QFilter("cfmstatus", "=", (Object)"A"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"adm_supchange", (String)"id,billstatus,cfmstatus,entryentity.fieldname,entryentity.newvalue", (QFilter[])new QFilter[]{qf});
        for (DynamicObject dynamicObject : dynamicObjects) {
            if ("name".equals(dynamicObject.getString("entryentity.fieldname"))) {
                map.put("name", name.equals(dynamicObject.getString("entryentity.newvalue")));
                continue;
            }
            if (!"societycreditcode".equals(dynamicObject.getString("entryentity.fieldname"))) continue;
            map.put("societycreditcode", creditno.equals(dynamicObject.getString("entryentity.newvalue")));
        }
        return map;
    }

    static {
        verifiedBill.add("srm_supplierchg");
    }
}

