/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierLifeCycleManagerUtil;

public class SrmCompanyRegisterUtil {
    public static String checkName(Object id, String name, String creditno) {
        StringBuilder errMsg = new StringBuilder();
        boolean supplierlifecycle = SupplierLifeCycleManagerUtil.isEnableSupplierLifeCycleManager();
        Set<Long> quitOrgSet = SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgExcludeCurBillSet(name, creditno, id);
        if (name == null || name.trim().equals("")) {
            errMsg.append(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrmCompanyRegisterUtil_0", (String)"scm-srmcore-common", (Object[])new Object[0])).append("\n");
        } else {
            boolean isexist = false;
            if (!supplierlifecycle || quitOrgSet.isEmpty()) {
                QFilter qFilter = new QFilter("name", "=", (Object)name).and("id", "!=", id);
                DynamicObject srmSupplier = QueryServiceHelper.queryOne((String)"srm_supplierreg", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (!supplierlifecycle && srmSupplier == null) {
                    QFilter filter = new QFilter("name", "=", (Object)name);
                    isexist = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])new QFilter[]{filter});
                } else if (srmSupplier != null) {
                    isexist = true;
                }
            }
            if (isexist) {
                errMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\uff1a{0}\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"SrmCompanyRegisterUtil_1", (String)"scm-srmcore-common", (Object[])new Object[0]), name)).append("\n");
            }
            if (SrmCommonUtil.isBlackEnterpirse((long)0L, (String)creditno, (String)name)) {
                errMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u4f01\u4e1a \uff1a{0}{1}\u5df2\u88ab\u7eb3\u5165\u9ed1\u540d\u5355", (String)"SrmCompanyRegisterUtil_2", (String)"scm-srmcore-common", (Object[])new Object[0]), creditno, name)).append("\n");
            }
        }
        return errMsg.toString();
    }

    public static String checkCreditcode(Object id, String name, String creditno) {
        StringBuilder errMsg = new StringBuilder();
        boolean supplierlifecycle = SupplierLifeCycleManagerUtil.isEnableSupplierLifeCycleManager();
        Set<Long> quitOrgSet = SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgExcludeCurBillSet(name, creditno, id);
        if (creditno == null || creditno.trim().equals("")) {
            errMsg.append(ResManager.loadKDString((String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmCompanyRegisterUtil_3", (String)"scm-srmcore-common", (Object[])new Object[0])).append("\n");
        } else {
            boolean isexist = false;
            if (!supplierlifecycle || quitOrgSet.isEmpty()) {
                QFilter qFilter = new QFilter("societycreditcode", "=", (Object)creditno).and("id", "!=", id);
                DynamicObject srmuserobj = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (!supplierlifecycle && srmuserobj == null) {
                    QFilter filter = new QFilter("societycreditcode", "=", (Object)creditno);
                    isexist = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])new QFilter[]{filter});
                } else if (srmuserobj != null) {
                    isexist = true;
                }
            }
            if (isexist) {
                errMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u4fe1\u7528\u4ee3\u7801\uff1a{0}\u5df2\u88ab\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"SrmCompanyRegisterUtil_4", (String)"scm-srmcore-common", (Object[])new Object[0]), creditno)).append("\n");
            }
            if (SrmCommonUtil.isBlackEnterpirse((long)0L, (String)creditno, null)) {
                errMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u4fe1\u7528\u4ee3\u7801\uff1a{0}\u5df2\u88ab\u7eb3\u5165\u9ed1\u540d\u5355\uff0c\u4e0d\u5141\u8bb8\u6ce8\u518c\u3002", (String)"SrmCompanyRegisterUtil_5", (String)"scm-srmcore-common", (Object[])new Object[0]), creditno)).append("\n");
            }
        }
        return errMsg.toString();
    }

    public static String checkLinkmanEntry(DynamicObjectCollection linkRows) {
        List<String> distinctEmail1s;
        List<String> distinctMobiles;
        Map groupMap;
        StringBuilder errMsg = new StringBuilder();
        if (linkRows == null) {
            return errMsg.toString();
        }
        int i = 1;
        ArrayList<String> mobiles = new ArrayList<String>();
        ArrayList<String> email1s = new ArrayList<String>();
        int count = 0;
        for (DynamicObject row : linkRows) {
            String name1 = row.getString("name1");
            String entryMobile = row.getString("mobile1");
            String entryEmail = row.getString("email1");
            boolean availableEntryPhone = true;
            boolean availableEntryEmail = true;
            StringBuilder accountEntryMessage = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)name1)) {
                errMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f-->\u7b2c{0}\u884c\uff1a{1}\u59d3\u540d\u4e3a\u7a7a\u3002", (String)"SrmCompanyRegisterUtil_6", (String)"scm-srmcore-common", (Object[])new Object[0]), i, name1)).append("\n");
            }
            if ((entryEmail == null || entryEmail.isEmpty()) && (entryMobile == null || entryMobile.isEmpty())) {
                accountEntryMessage.append(ResManager.loadResFormat((String)"\u8054\u7cfb\u4eba\u4fe1\u606f-->\u7b2c{0}\u884c\uff1a\u624b\u673a(\u8d26\u53f7) \u65e0\u6548\u3002", (String)"SrmCompanyRegisterUtil_7", (String)"scm-srmcore-common", (Object[])new Object[]{i})).append("\n");
                availableEntryPhone = false;
                accountEntryMessage.append(ResManager.loadResFormat((String)"\u8054\u7cfb\u4eba\u4fe1\u606f-->\u7b2c{0}\u884c\uff1a\u90ae\u7bb1 \u65e0\u6548\u3002", (String)"SrmCompanyRegisterUtil_8", (String)"scm-srmcore-common", (Object[])new Object[]{i})).append("\n");
                availableEntryEmail = false;
            } else if (entryMobile != null && !entryMobile.isEmpty() && !SrmCompanyRegisterUtil.isPhoneValid(entryMobile)) {
                accountEntryMessage.append(ResManager.loadResFormat((String)"\u8054\u7cfb\u4eba\u4fe1\u606f-->\u7b2c{0}\u884c\uff1a\u624b\u673a(\u8d26\u53f7) \u65e0\u6548\u3002", (String)"SrmCompanyRegisterUtil_7", (String)"scm-srmcore-common", (Object[])new Object[]{i})).append("\n");
                availableEntryPhone = false;
            } else if (entryEmail != null && !entryEmail.isEmpty() && !StringUtils.isEmail((String)entryEmail)) {
                accountEntryMessage.append(ResManager.loadResFormat((String)"\u8054\u7cfb\u4eba\u4fe1\u606f-->\u7b2c{0}\u884c\uff1a\u90ae\u7bb1 \u65e0\u6548\u3002", (String)"SrmCompanyRegisterUtil_8", (String)"scm-srmcore-common", (Object[])new Object[]{i})).append("\n");
                availableEntryEmail = false;
            }
            if (!availableEntryEmail || !availableEntryPhone) {
                errMsg.append((CharSequence)accountEntryMessage);
            }
            if (availableEntryEmail && StringUtils.isNotEmpty((CharSequence)entryEmail)) {
                email1s.add(entryEmail);
            }
            if (availableEntryPhone && StringUtils.isNotEmpty((CharSequence)entryMobile)) {
                mobiles.add(entryMobile);
            }
            if (row.getBoolean("isdefault_link")) {
                ++count;
            }
            ++i;
        }
        if (count > 1) {
            errMsg.append(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f \u9ed8\u8ba4\u8054\u7cfb\u4eba \u4e0d\u80fd\u591a\u4e8e 1\u4e2a", (String)"SrmCompanyRegisterUtil_9", (String)"scm-srmcore-common", (Object[])new Object[0])).append("\n");
        } else if (count == 0) {
            errMsg.append(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f  \u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u8054\u7cfb\u4eba", (String)"SrmCompanyRegisterUtil_10", (String)"scm-srmcore-common", (Object[])new Object[0])).append("\n");
        }
        if (mobiles.size() > 0 && Objects.nonNull(groupMap = mobiles.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) && groupMap.size() > 0 && (distinctMobiles = groupMap.keySet().stream().filter(key -> (Long)groupMap.get(key) > 1L).distinct().collect(Collectors.toList())).size() > 0) {
            distinctMobiles.forEach(x -> errMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f  \u624b\u673a\u53f7\u7801{0}\uff0c\u91cd\u590d", (String)"SrmCompanyRegisterUtil_11", (String)"scm-srmcore-common", (Object[])new Object[0]), x)).append("\n"));
        }
        if (email1s.size() > 0 && Objects.nonNull(groupMap = email1s.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) && groupMap.size() > 0 && (distinctEmail1s = groupMap.keySet().stream().filter(key -> (Long)groupMap.get(key) > 1L).distinct().collect(Collectors.toList())).size() > 0) {
            distinctEmail1s.forEach(x -> errMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f  \u90ae\u7bb1{0}\uff0c\u91cd\u590d", (String)"SrmCompanyRegisterUtil_12", (String)"scm-srmcore-common", (Object[])new Object[0]), x)).append("\n"));
        }
        return errMsg.toString();
    }

    private static boolean isPhoneValid(String number) {
        if (StringUtils.isNotBlank((CharSequence)number)) {
            number = SrmCompanyRegisterUtil.getFullPhoneFormat(number);
            List<String> phoneList = Collections.singletonList(number);
            try {
                SrmCompanyRegisterUtil.validatePhone(phoneList);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getFullPhoneFormat(String phone) {
        if (!phone.startsWith("+")) {
            phone = phone.contains("-") ? "+" + phone : "+86-" + phone;
        }
        return phone;
    }

    private static void validatePhone(List<String> phoneList) {
        List resultList = I18nServiceHelper.batchVerifyTelephoneNumber(phoneList);
        for (TelephoneVerifyResult item : resultList) {
            Map result;
            String message;
            if (!item.isParseSuccess()) {
                throw new KDBizException(item.getParseErrorMsg());
            }
            if (item.isVerifySuccess() || !StringUtils.isNotBlank((CharSequence)(message = CollectionUtils.isEmpty((Map)(result = item.getVerifyResult())) ? "" : (String)result.get("message")))) continue;
            throw new KDBizException(message);
        }
    }

    public static void createSrmUser(DynamicObject data) {
        Object pkValue = data.getPkValue();
        DynamicObject adm_userquery = BusinessDataServiceHelper.loadSingle((String)"adm_userquery", (String)"enterprise,creditno,name,number", (QFilter[])new QFilter[]{new QFilter("supplierregid", "=", (Object)pkValue.toString())});
        if (adm_userquery == null) {
            String enterprise = data.getString("name");
            String creditno = data.getString("societycreditcode");
            String linkman = data.getString("linkman");
            String phone = data.getString("phone");
            DynamicObject srm_user = BusinessDataServiceHelper.newDynamicObject((String)"adm_userquery");
            srm_user.set("enterprise", (Object)enterprise);
            srm_user.set("creditno", (Object)creditno);
            srm_user.set("name", (Object)linkman);
            srm_user.set("number", (Object)phone);
            srm_user.set("enable", (Object)"1");
            srm_user.set("status", (Object)"C");
            srm_user.set("supplierregid", (Object)pkValue.toString());
            SrmCommonUtil.saveDynamicObject((String)"adm_userquery", (DynamicObject)srm_user);
        } else {
            adm_userquery.set("enterprise", (Object)data.getString("name"));
            adm_userquery.set("creditno", (Object)data.getString("societycreditcode"));
            adm_userquery.set("name", (Object)data.getString("linkman"));
            adm_userquery.set("number", (Object)data.getString("phone"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adm_userquery});
        }
    }
}

