/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.algox;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.CommonUtil;

public class SupplierDeliverRateMapFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> idxs;

    public SupplierDeliverRateMapFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.buildIndexs();
    }

    public void reduce(Iterable<RowX> it, Collector collector) {
        int batchSize = 100;
        ArrayList<RowX> rows = new ArrayList<RowX>(batchSize);
        HashMap<Long, DynamicObject> destUnitMap = new HashMap<Long, DynamicObject>(batchSize);
        for (RowX row : it) {
            rows.add(row.copy());
            if (rows.size() < batchSize) continue;
            this.handleRows(rows, collector, destUnitMap);
            rows.clear();
        }
        if (!rows.isEmpty()) {
            this.handleRows(rows, collector, destUnitMap);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void handleRows(List<RowX> rows, Collector collector, Map<Long, DynamicObject> destUnitMap) {
        BigDecimal big100 = new BigDecimal("100");
        for (RowX row : rows) {
            Long material = row.getLong(this.idxs.get("material").intValue());
            Long unit = row.getLong(this.idxs.get("unit").intValue());
            Long basicunit = row.getLong(this.idxs.get("basicunit").intValue());
            DynamicObject destUnit = this.getDestUnit(unit, destUnitMap);
            BigDecimal orderqty = row.getBigDecimal(this.idxs.get("orderqty").intValue());
            orderqty = CommonUtil.getDesQtyConv((Long)material, (Long)basicunit, (BigDecimal)orderqty, (DynamicObject)destUnit);
            row.set(this.idxs.get("orderqty").intValue(), (Object)orderqty);
            BigDecimal ontimeqty = row.getBigDecimal(this.idxs.get("ontimeqty").intValue());
            ontimeqty = CommonUtil.getDesQtyConv((Long)material, (Long)basicunit, (BigDecimal)ontimeqty, (DynamicObject)destUnit);
            row.set(this.idxs.get("ontimeqty").intValue(), (Object)ontimeqty);
            BigDecimal delayqty = row.getBigDecimal(this.idxs.get("delayqty").intValue());
            delayqty = CommonUtil.getDesQtyConv((Long)material, (Long)basicunit, (BigDecimal)delayqty, (DynamicObject)destUnit);
            row.set(this.idxs.get("delayqty").intValue(), (Object)delayqty);
            BigDecimal nonarrivalqty = orderqty.subtract(ontimeqty).subtract(delayqty);
            if (nonarrivalqty.compareTo(BigDecimal.ZERO) < 0) {
                nonarrivalqty = BigDecimal.ZERO;
            }
            row.set(this.idxs.get("nonarrivalqty").intValue(), (Object)nonarrivalqty);
            BigDecimal rate100 = new BigDecimal("1.00");
            BigDecimal deliveryrate = null;
            if (BigDecimal.ZERO.compareTo(orderqty) != 0) {
                deliveryrate = ontimeqty.divide(orderqty, 4, 4);
            }
            if (deliveryrate == null || deliveryrate.compareTo(rate100) > 0) {
                deliveryrate = rate100;
            }
            deliveryrate = deliveryrate.multiply(big100).setScale(2, 4);
            row.set(this.idxs.get("deliveryrate").intValue(), (Object)(deliveryrate.toString() + "%"));
            collector.collect(row);
        }
    }

    private DynamicObject getDestUnit(Long desUnitId, Map<Long, DynamicObject> destUnitMap) {
        DynamicObject dyn = destUnitMap.get(desUnitId);
        if (dyn == null && desUnitId != null) {
            dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)desUnitId, (String)"bd_measureunits");
            destUnitMap.put(desUnitId, dyn);
        }
        return dyn;
    }

    private void buildIndexs() {
        Field[] fields = this.rowMeta.getFields();
        ArrayList<String> cols = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            cols.add(field.getName());
        }
        this.idxs = this.buildIndexs(this.rowMeta, cols);
    }

    private Map<String, Integer> buildIndexs(RowMeta rowMeta, Collection<String> cols) {
        HashMap<String, Integer> indexs = new HashMap<String, Integer>(cols.size());
        for (String col : cols) {
            indexs.put(col, rowMeta.getFieldIndex(col));
        }
        return indexs;
    }
}

