/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.checkmapping;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;

public final class PurCheckMapping
implements Serializable {
    private static final long serialVersionUID = -3928993640222523270L;
    private Map<String, String> tarColMap = null;
    private Map<String, String> srcColMap = null;
    private String plugin = null;
    private String checktype = null;

    public PurCheckMapping(DynamicObject dbColsMap) {
        DynamicObjectCollection rows = dbColsMap.getDynamicObjectCollection("colsmap");
        String targetobjcol = "targetobjcol";
        String sourcebillcol = "sourcebillcol";
        HashMap<String, String> tempTarBillColMap = new HashMap<String, String>(16);
        for (DynamicObject row : rows) {
            String val = row.getString(sourcebillcol);
            if (StringUtils.isBlank((String)val) && "1".equals(row.getString("selectvalue"))) {
                String formula = row.getString("formula_tag");
                if (StringUtils.isBlank((String)formula)) continue;
                Map formulaMap = (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
                val = (String)formulaMap.get("expression");
                if (!StringUtils.isBlank((String)val)) {
                    tempTarBillColMap.put(row.getString(targetobjcol), val);
                    continue;
                }
            }
            tempTarBillColMap.put(row.getString(targetobjcol), val);
        }
        String pluginStr = dbColsMap.getString("pluginname");
        String checktype = dbColsMap.getString("checktype");
        this.setChecktype(checktype);
        this.setPlugin(pluginStr);
        this.tarColMap = Collections.unmodifiableMap(tempTarBillColMap);
    }

    public Map<String, String> getTarColMap() {
        return this.tarColMap;
    }

    public Map<String, String> getSrcColMap() {
        return this.srcColMap;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public String getChecktype() {
        return this.checktype;
    }

    public void setChecktype(String checktype) {
        this.checktype = checktype;
    }

    public void setTarColMap(Map<String, String> tarColMap) {
        this.tarColMap = tarColMap;
    }

    public void setSrcColMap(Map<String, String> srcColMap) {
        this.srcColMap = srcColMap;
    }
}

