/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.checkmapping;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.checkmapping.PurCheckMapping;
import kd.scm.common.checkmapping.PurCheckMappingFieldProp;
import kd.scm.common.constant.InitDataConstant;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.CheckUtils;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.CurrencyUtils;
import kd.scm.common.util.caldynamic.CalDynamicImpl;

public final class PurCheckMappingUtils {
    public static final String COLSMAPFIXED = "colsmap";
    public static final String PUR_HANDCHECK = "pur_handcheck";

    public static FormMetadata getFormMetaData(String entityKey) {
        String entityId = MetadataDao.getIdByNumber((String)entityKey, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        if (formmeta == null) {
            return null;
        }
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entitymeta == null) {
            return null;
        }
        formmeta.bindEntityMetadata(entitymeta);
        return formmeta;
    }

    public static List<String> getProQtyOrPriceEntitykey(FormMetadata formmeta) {
        ArrayList<String> decimalField = new ArrayList<String>(8);
        for (ControlAp ap : formmeta.getItems()) {
            FieldAp fieldAp;
            Field field;
            if (!(ap instanceof FieldAp) || !((field = (fieldAp = (FieldAp)ap).getField()) instanceof DecimalField)) continue;
            decimalField.add(fieldAp.getKey());
        }
        return decimalField;
    }

    public static Map<String, List<ControlAp<?>>> getProEntitykey(FormMetadata formmeta, String entryKey) {
        HashMap map = new HashMap(8);
        for (ControlAp ap : formmeta.getItems()) {
            EntryAp entryAp;
            String proEntitykey;
            if (ap instanceof FieldAp) {
                // empty if block
            }
            if (!(ap instanceof EntryAp) || !entryKey.equals(proEntitykey = (entryAp = (EntryAp)ap).getKey())) continue;
            map.put(proEntitykey, entryAp.getItems());
        }
        return map;
    }

    public static void getBillProkey(FormMetadata formmeta, List<PurCheckMappingFieldProp> list, Boolean isTarget) {
        for (ControlAp ap : formmeta.getItems()) {
            if (!(ap instanceof FieldAp) || ap instanceof EntryFieldAp) continue;
            String proKey = ap.getKey();
            PurCheckMappingUtils.addProItemMap("", list, ap, proKey, isTarget);
        }
    }

    public static void getProItemMap(Map<String, List<ControlAp<?>>> map, List<PurCheckMappingFieldProp> list, List<String> includeKey, Boolean isInclude, Boolean isTarget) {
        for (Map.Entry<String, List<ControlAp<?>>> entry : map.entrySet()) {
            List<ControlAp<?>> items = entry.getValue();
            String entryKey = entry.getKey();
            for (ControlAp<?> ap : items) {
                if (!(ap instanceof FieldAp) || ap instanceof BillFormAp || ap instanceof ContainerAp || ap instanceof ButtonAp || ap instanceof BarItemAp || ap instanceof FlexPanelAp || ap instanceof VectorAp) continue;
                String proKey = ap.getKey();
                if (isInclude.booleanValue() && includeKey.contains(proKey)) {
                    PurCheckMappingUtils.addProItemMap(entryKey, list, ap, proKey, isTarget);
                    continue;
                }
                if (isInclude.booleanValue() || includeKey.contains(proKey)) continue;
                PurCheckMappingUtils.addProItemMap(entryKey, list, ap, proKey, isTarget);
            }
        }
    }

    private static void addProItemMap(String entryKey, List<PurCheckMappingFieldProp> list, ControlAp<?> ap, String proKey, Boolean isTarget) {
        if (isTarget.booleanValue()) {
            list.add(new PurCheckMappingFieldProp(ap.getId(), proKey, ap.getName().getLocaleValue(), null, null));
        } else {
            String newProKey = proKey;
            if (StringUtils.isNotBlank((CharSequence)entryKey)) {
                newProKey = entryKey + "." + proKey;
            }
            list.add(new PurCheckMappingFieldProp(ap.getId(), null, null, newProKey, ap.getName().getLocaleValue()));
        }
    }

    public static List<PurCheckMappingFieldProp> getEntityAp(FormMetadata formmeta) {
        ArrayList<PurCheckMappingFieldProp> list = new ArrayList<PurCheckMappingFieldProp>(8);
        List items = formmeta.getItems();
        for (ControlAp ap : items) {
            if (!(ap instanceof EntryAp)) continue;
            EntryAp entryAp = (EntryAp)ap;
            String proEntitykey = entryAp.getKey();
            String name = entryAp.getName().getLocaleValue();
            EntryEntity entry = entryAp.getEntry();
            if (entry == null) continue;
            String id = entry.getId();
            list.add(new PurCheckMappingFieldProp(id, null, null, proEntitykey, name));
        }
        return list;
    }

    private static String getFormulaJson(IFormView view, int row) {
        String formula_tag = "formula_tag";
        return PurCheckMappingUtils.getModelValue(view, row, formula_tag);
    }

    private static String getModelValue(IFormView view, int row, String fieldName) {
        Object formulaValue = view.getModel().getValue(fieldName, row);
        if (formulaValue != null) {
            return (String)formulaValue;
        }
        return "";
    }

    private static String getFldNodes(MainEntityType dataEntityType) {
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.setIncludeEntryEntityAsKeyPrefix(true);
        ops.setIncludePKField(true);
        ops.setIncludeBDRefProp(true);
        ops.setIncludeBDPropPK(true);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, (PropTreeBuildOption)ops);
        return SerializationUtils.toJsonString((Object)billTreeNode);
    }

    public static void showForm(AbstractFormPlugin plugin, IFormView view, IPageCache pageCache, String sourcebillEntityName, String entryKey, int row) {
        String formulaJson = PurCheckMappingUtils.getFormulaJson(view, row);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)sourcebillEntityName);
        String fldNodes = PurCheckMappingUtils.getFldNodes(dataEntityType);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("entitynumber", sourcebillEntityName);
        showParameter.getCustomParams().put("treenodes", fldNodes);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("pur_formula");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, entryKey + "_formula_callback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getCustomParams().put("formula", formulaJson);
        view.showForm(showParameter);
    }

    public static PurCheckMapping findBillColMap(String formId) {
        if (!StringUtils.isBlank((CharSequence)formId)) {
            QFilter filter = new QFilter("sourcebill", "=", (Object)formId);
            filter.and("isenable", "=", (Object)Character.valueOf('1'));
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"pur_check_mapping", (QFilter[])filter.toArray());
            return obj == null ? null : new PurCheckMapping(obj);
        }
        return null;
    }

    public static Set<String> getDeductBill() {
        HashSet<String> list = new HashSet<String>(8);
        QFilter filter = new QFilter("isenable", "=", (Object)Character.valueOf('1'));
        filter.and("checktype", "=", (Object)Character.valueOf('2'));
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pur_check_mapping", (String)"sourcebill,checktype", (QFilter[])filter.toArray());
        for (DynamicObject obj : objs) {
            String sourcebill = obj.getString("sourcebill");
            list.add(sourcebill);
        }
        return list;
    }

    public static List<String> findPurCheckMappingPlugin() {
        DynamicObject[] purCheckMappings;
        ArrayList<String> plugins = new ArrayList<String>(8);
        QFilter filter = new QFilter("isenable", "=", (Object)Character.valueOf('1'));
        for (DynamicObject dy : purCheckMappings = BusinessDataServiceHelper.load((String)"pur_check_mapping", (String)"id,isenable,pluginname", (QFilter[])filter.toArray(), (String)"number asc")) {
            String pluginStr = dy.getString("pluginname");
            plugins.add(pluginStr);
        }
        return plugins;
    }

    public static List<String> getGroupByKeys() {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"pur_check_group_config", (String)"groupby", null, (String)"createtime desc", (int)1);
        String groupbykey = "";
        if (!CollectionUtils.isEmpty((Collection)dys)) {
            groupbykey = ((DynamicObject)dys.get(0)).getString("groupby");
        }
        ArrayList<String> checkGroupsList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)groupbykey)) {
            String[] split = groupbykey.split(",");
            List<String> checkGroups = Arrays.asList(split);
            List filterGroupbyField = checkGroups.stream().filter(f -> !"".equals(f)).collect(Collectors.toList());
            checkGroupsList.addAll(filterGroupbyField);
        }
        return checkGroupsList;
    }

    public static List<PurCheckMappingFieldProp> getPurCheckMappingFieldProps(List<String> fixedEntryKey, Boolean isInclude, Boolean isTarget) {
        ArrayList<PurCheckMappingFieldProp> fieldPropFixeds = new ArrayList<PurCheckMappingFieldProp>(8);
        FormMetadata formmeta = PurCheckMappingUtils.getFormMetaData(PUR_HANDCHECK);
        if (formmeta != null) {
            Map<String, List<ControlAp<?>>> materialentryentity3 = PurCheckMappingUtils.getProEntitykey(formmeta, "materialentryentity3");
            Map<String, List<ControlAp<?>>> sumentryentity = PurCheckMappingUtils.getProEntitykey(formmeta, "sumentryentity");
            PurCheckMappingUtils.getProItemMap(materialentryentity3, fieldPropFixeds, fixedEntryKey, isInclude, isTarget);
            PurCheckMappingUtils.getProItemMap(sumentryentity, fieldPropFixeds, fixedEntryKey, isInclude, isTarget);
        }
        return fieldPropFixeds;
    }

    public static void assembleDetailUnmatchtaxamount(DynamicObject purDetail, String unmatchtaxamountKey, String suffix) {
        String srcBillType = purDetail.getString("srcbilltype" + suffix);
        if (!CheckUtils.isPurInstock((String)srcBillType) && !CheckUtils.isPurReciept((String)srcBillType)) {
            return;
        }
        CalDynamicImpl cal = new CalDynamicImpl();
        int scaleamount = CurrencyUtils.getAmtPrecision((DynamicObject)purDetail, (String)suffix);
        int scaleprice = CurrencyUtils.getPircePrecision((DynamicObject)purDetail, (String)suffix);
        String taxtype = purDetail.getString("taxtype" + suffix);
        String inputamount = purDetail.getString("inputamount" + suffix);
        String type = "";
        if ("amount".equals(inputamount)) {
            type = "amount";
        }
        BigDecimal cfmAmt = CommonUtil.getBigDecimalPro((Object)purDetail.get("taxamount" + suffix));
        BigDecimal tax = CommonUtil.getBigDecimalPro((Object)purDetail.get("tax" + suffix));
        BigDecimal amount = cfmAmt.subtract(tax);
        cal.initField("qty" + suffix, "discounttype" + suffix, "dctrate" + suffix, "taxrate" + suffix, "taxprice" + suffix, "price" + suffix, "unmatchqty" + suffix);
        BigDecimal unmatchTaxAmount = cal.getUnmatchTaxAmount(purDetail, scaleamount, scaleprice, taxtype, type, cfmAmt, amount);
        purDetail.set(unmatchtaxamountKey, (Object)unmatchTaxAmount);
    }

    public static Map<Long, Long> getSplitBusinessTypes() {
        Long baseBusinessTypeId;
        DynamicObject[] baseDatas;
        HashMap<Long, Long> splitBussinessTypes = new HashMap<Long, Long>(8);
        QFilter baseFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        String baseSelectFields = "number,name";
        HashMap<String, Long> baseBusinessTypes = new HashMap<String, Long>(8);
        for (DynamicObject bizType : baseDatas = BusinessDataServiceHelper.load((String)"bd_biztype", (String)baseSelectFields, (QFilter[])new QFilter[]{baseFilter})) {
            String number = bizType.getString("number");
            baseBusinessTypeId = (Long)bizType.getPkValue();
            baseBusinessTypes.put(number, baseBusinessTypeId);
        }
        for (DynamicObject bizType : baseDatas) {
            String businessTypeNumber = bizType.getString("number");
            baseBusinessTypeId = (Long)bizType.getPkValue();
            if (BussinessTypeUtils.IsBizType(businessTypeNumber, "140")) {
                splitBussinessTypes.put(baseBusinessTypeId, (Long)baseBusinessTypes.get("140"));
                continue;
            }
            if (BussinessTypeUtils.IsBizType(businessTypeNumber, "604")) {
                splitBussinessTypes.put(baseBusinessTypeId, (Long)baseBusinessTypes.get("604"));
                continue;
            }
            if (BussinessTypeUtils.IsBizType(businessTypeNumber, "WX110")) {
                splitBussinessTypes.put(baseBusinessTypeId, (Long)baseBusinessTypes.get("WX110"));
                continue;
            }
            splitBussinessTypes.put(baseBusinessTypeId, (Long)baseBusinessTypes.get("110"));
        }
        return splitBussinessTypes;
    }

    public static Long getGoodBusinessTypes() {
        QFilter baseFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        baseFilter.and("number", "=", (Object)"140");
        String baseSelectFields = "number,name";
        DynamicObject baseDatas = BusinessDataServiceHelper.loadSingle((String)"bd_biztype", (String)baseSelectFields, (QFilter[])new QFilter[]{baseFilter});
        if (baseDatas != null) {
            return (Long)baseDatas.getPkValue();
        }
        return 0L;
    }

    public static StringBuilder validateDeduction(List<DynamicObject> checkDynamicList, String entitykey, String suffix) {
        StringBuilder sb = new StringBuilder();
        Set<String> deductBill = PurCheckMappingUtils.getDeductBill();
        Map<Long, Long> splitBusinessTypes = PurCheckMappingUtils.getSplitBusinessTypes();
        Long goodBusinessTypes = PurCheckMappingUtils.getGoodBusinessTypes();
        for (DynamicObject bill : checkDynamicList) {
            long materialId;
            String srcbilltype;
            Boolean isContainDeduction = false;
            BigDecimal sumUnmatchamt = BigDecimal.ZERO;
            ArrayList<Long> instockMaterials = new ArrayList<Long>(8);
            Boolean isGoodBusinessTypes = false;
            DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entitykey);
            HashSet<Long> bussinessTypeIds = new HashSet<Long>(8);
            for (DynamicObject row : entryCols) {
                srcbilltype = row.getString("srcbilltype" + suffix);
                BigDecimal unmatchamt = row.getBigDecimal("unmatchamt");
                sumUnmatchamt = sumUnmatchamt.add(unmatchamt);
                materialId = PurCheckMappingUtils.getMaterialId(row, suffix);
                if (deductBill.contains(srcbilltype)) {
                    isContainDeduction = true;
                    continue;
                }
                if (materialId != 0L) {
                    instockMaterials.add(materialId);
                }
                Long bussinessTypeId = row.getLong("businesstype_in" + suffix);
                Long splitBusinessTypeId = splitBusinessTypes.get(bussinessTypeId);
                bussinessTypeIds.add(splitBusinessTypeId);
                if (!goodBusinessTypes.equals(splitBusinessTypeId)) continue;
                isGoodBusinessTypes = true;
            }
            if (isContainDeduction.booleanValue()) {
                if (sumUnmatchamt.compareTo(BigDecimal.ZERO) <= 0) {
                    sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u62b5\u6263\u9879\uff0c\u53ef\u5f00\u7968\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff0c\u8bf7\u60a8\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurCheckMappingUtils_1", (String)"scm-sccore-common", (Object[])new Object[0])).append(System.lineSeparator());
                }
                for (DynamicObject row : entryCols) {
                    srcbilltype = row.getString("srcbilltype" + suffix);
                    String inbillno = row.getString("inbillno" + suffix);
                    materialId = PurCheckMappingUtils.getMaterialId(row, suffix);
                    if (!deductBill.contains(srcbilltype) || materialId == 0L || instockMaterials.contains(materialId)) continue;
                    sb.append(ResManager.loadKDString((String)"\u6240\u9009\u7d22\u8d54\u5355{0}\u7684\u7269\u6599\u4e0e\u5e93\u5b58\u5355\u636e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurCheckMappingUtils_2", (String)"scm-sccore-common", (Object[])new Object[]{inbillno})).append(System.lineSeparator());
                }
                if (bussinessTypeIds.size() > 1) {
                    sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u62b5\u6263\u9879\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e3a\u59d4\u5916\u91c7\u8d2d\u3001\u5546\u54c1\u7c7b\u91c7\u8d2d\u548c\u7269\u6599\uff08\u9a8c\u6536/\u8d44\u4ea7\uff09\u7c7b\u4e0d\u80fd\u540c\u65f6\u4e0b\u63a8\u5bf9\u8d26\u5355\uff0c\u8bf7\u60a8\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurCheckMappingUtils_3", (String)"scm-sccore-common", (Object[])new Object[0])).append(System.lineSeparator());
                }
            }
            if (!isGoodBusinessTypes.booleanValue() || sumUnmatchamt.compareTo(BigDecimal.ZERO) > 0) continue;
            sb.append(ResManager.loadKDString((String)"\u5546\u54c1\u7c7b\u91c7\u8d2d\u53ef\u5f00\u7968\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff0c\u8bf7\u60a8\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurCheckMappingUtils_4", (String)"scm-sccore-common", (Object[])new Object[0])).append(System.lineSeparator());
        }
        return sb;
    }

    public static long getMaterialId(DynamicObject row, String suffix) {
        Object materialObj = row.get("material" + suffix);
        long materialId = 0L;
        if (materialObj != null) {
            materialId = materialObj instanceof DynamicObject ? ((DynamicObject)materialObj).getLong("id") : ((Long)materialObj).longValue();
        }
        return materialId;
    }

    public static void getCustomSearchSelects(StringBuilder selectFieldSb) {
        if (selectFieldSb != null) {
            StringBuilder result = new StringBuilder(",");
            Map<String, String[]> customSearchMap = PurCheckMappingUtils.getCustomSearchMap("materialentry");
            if (customSearchMap != null) {
                Set<Map.Entry<String, String[]>> entries = customSearchMap.entrySet();
                for (Map.Entry<String, String[]> entry : entries) {
                    if (entry.getValue() == null || entry.getValue().length <= 1 || selectFieldSb.indexOf(entry.getValue()[0]) >= 0) continue;
                    result.append(entry.getValue()[0]).append(" ").append(entry.getKey()).append(",");
                }
            }
            result.deleteCharAt(result.lastIndexOf(","));
            selectFieldSb.append((CharSequence)result);
        }
    }

    public static Map<String, String[]> getCustomSearchMap(String entityKey) {
        HashMap<String, String[]> customSearchMap = new HashMap<String, String[]>();
        customSearchMap.put("warehouse", new String[]{entityKey + ".warehouse", "in"});
        return customSearchMap;
    }

    public static Map<String, Map<String, Object>> wrapCustomFilterMap(Map<String, Object> params, String entityKey) {
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>();
        Map<String, String[]> customSearchMap = PurCheckMappingUtils.getCustomSearchMap("materialentry");
        if (customSearchMap != null) {
            Set<Map.Entry<String, String[]>> entries = customSearchMap.entrySet();
            if (params != null) {
                for (Map.Entry<String, String[]> entry : entries) {
                    HashMap<String, Object> warehouseMap = new HashMap<String, Object>(1);
                    switch (entry.getKey()) {
                        case "warehouse": {
                            String info = (String)params.get(entry.getKey());
                            if (!StringUtils.isNotBlank((CharSequence)info)) break;
                            warehouseMap.put(entry.getValue()[1], Arrays.stream(info.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray());
                            break;
                        }
                        default: {
                            Object infoValue = params.get(entry.getKey());
                            if (infoValue == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(infoValue))) break;
                            warehouseMap.put(entry.getValue()[1], infoValue);
                        }
                    }
                    if (warehouseMap.isEmpty()) continue;
                    filterMap.put(entry.getValue()[0], warehouseMap);
                }
            }
        }
        return filterMap;
    }

    public static Map<String, Map<String, Object>> wrapVmiFilterMap() {
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, QFilter> vmiMap = new HashMap<String, QFilter>(1);
        HashSet<Long> biztypeSet = new HashSet<Long>(2);
        biztypeSet.add(InitDataConstant.BUSINESSTYPE_REVMI_ID);
        biztypeSet.add(InitDataConstant.BUSINESSTYPE_VMI_ID);
        QFilter qfilter = new QFilter("businesstype", "not in", biztypeSet);
        QFilter vmisettleFilter = new QFilter("businesstype", "in", biztypeSet).and(new QFilter("vmisettle", "=", (Object)"1"));
        qfilter.or(vmisettleFilter);
        vmiMap.put("qfilter", qfilter);
        filterMap.put("vmisettle", vmiMap);
        return filterMap;
    }
}

