/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.BillOpration;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import net.sf.json.JSONArray;

public class EasQueryPurInvoiceOperation
extends BillOpration {
    private static final String PUR_ENTRYENTITY = "entryentity1";
    private static final String PUR_ENTRYENTITY_SUFFIX = "1";
    private static final String SAL_ENTRYENTITY = "materialentry";
    private static final String INVOICEADDRESS = "invaddress";
    private static final String INVOICEDATE = "invoicedate";
    private static final String SUPPLIER = "supplier";
    private static final String SRCBILLID = "srcbillid";
    private static final String SRCBILLENTRYID = "srcentryid";
    private static final String ENTRY_QTY = "qty";
    private static final String ENTRY_TAXAMOUNT = "taxamount";
    private static final String ENTRY_AMOUNT = "amount";
    private static final String ENTRY_POBILLID = "pobillid";
    private static final String ENTRY_POENTRYID = "poentryid";

    protected String getOperationKey() {
        return "";
    }

    protected String getEntityKey() {
        return "";
    }

    public String doOperation(Map<String, Object> param) {
        ArrayList<String> invoiceNo_codeList = new ArrayList<String>(1024);
        ArrayList<String> invoiceNoList = new ArrayList<String>(1024);
        JSONArray dataList = JSONArray.fromObject((Object)param.get("data"));
        for (Object data : dataList) {
            Map dataMap = (Map)data;
            invoiceNoList.add(String.valueOf(dataMap.get("invoiceNo")));
            invoiceNo_codeList.add(String.valueOf(dataMap.get("invoiceNo")) + "_" + String.valueOf(dataMap.get("invoiceCode")));
        }
        DynamicObject logInfo = this.logInputData(param);
        QFilter qFilter = new QFilter("entryentity.invno", "in", invoiceNoList);
        String selectors = DynamicObjectUtil.getSelectfields((String)"pur_invoice", (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"pur_invoice", (String)PUR_ENTRYENTITY, (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"pur_invoice", (String)SAL_ENTRYENTITY, (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"pur_invoice", (String)"entryentity", (boolean)false);
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pur_invoice", (String)selectors, (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> newInvoiceList = new ArrayList<DynamicObject>(1024);
        block1: for (DynamicObject invoce : invoices) {
            DynamicObjectCollection invoiceEntrys = invoce.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : invoiceEntrys) {
                String invoceNo = entry.getString("invno");
                String invcode = entry.getString("invcode");
                if (!invoiceNo_codeList.contains(invoceNo + "_" + invcode)) continue;
                newInvoiceList.add(invoce);
                continue block1;
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("code", "200");
        paramMap.put("billtype", "pur_invoice");
        paramMap.put("action", "confirm");
        Map<String, Object> msgMap = EasQueryPurInvoiceOperation.getBillInfo(newInvoiceList.toArray(new DynamicObject[0]));
        if (null != msgMap.get("instock")) {
            msgMap.put("srcBillType", "instock");
        } else {
            msgMap.put("srcBillType", "receipt");
        }
        paramMap.put("data", msgMap);
        this.logOutputData(logInfo, msgMap);
        return JSONObject.toJSONString(paramMap);
    }

    public static Map<String, Object> getBillInfo(DynamicObject[] objs) {
        HashMap<String, Object> type_billMap = new HashMap<String, Object>();
        HashMap<String, Map<Object, Object>> receiptbillMap = new HashMap<String, Map<Object, Object>>();
        HashMap<String, Map<Object, Object>> instockbillMap = new HashMap<String, Map<Object, Object>>();
        HashMap<String, Map<Object, Object>> instockReturnbillMap = new HashMap<String, Map<Object, Object>>();
        for (DynamicObject obj : objs) {
            String isConfirm;
            Map<Object, Object> receiptdetailMap = new HashMap();
            Map<Object, Object> instockdetailMap = new HashMap();
            receiptdetailMap = EasQueryPurInvoiceOperation.getInfo(obj, "receipt");
            instockdetailMap = EasQueryPurInvoiceOperation.getInfo(obj, "instock");
            if (null != receiptdetailMap) {
                isConfirm = EasQueryPurInvoiceOperation.getSsConfirm(obj);
                receiptdetailMap.put("isConfirm", isConfirm);
                receiptdetailMap.put("invoiceBillId", String.valueOf(obj.getPkValue()));
                receiptbillMap.put(obj.get("billno").toString(), receiptdetailMap);
            }
            if (null != instockdetailMap) {
                isConfirm = EasQueryPurInvoiceOperation.getSsConfirm(obj);
                instockdetailMap.put("isConfirm", isConfirm);
                instockdetailMap.put("invoiceBillId", String.valueOf(obj.getPkValue()));
                instockbillMap.put(obj.get("billno").toString(), instockdetailMap);
            }
            if (!ApiConfigUtil.hasXKScmConfig()) continue;
            Map<Object, Object> instockReturndetailMap = new HashMap();
            instockReturndetailMap = EasQueryPurInvoiceOperation.getInfo(obj, "instockreturn");
            if (null == instockReturndetailMap) continue;
            instockReturndetailMap.put("invoiceBillId", String.valueOf(obj.getPkValue()));
            instockReturnbillMap.put(obj.get("billno").toString(), instockReturndetailMap);
        }
        if (receiptbillMap.size() > 0) {
            type_billMap.put("receipt", receiptbillMap);
        }
        if (instockbillMap.size() > 0) {
            type_billMap.put("instock", instockbillMap);
        }
        if (ApiConfigUtil.hasXKScmConfig() && instockReturnbillMap.size() > 0) {
            type_billMap.put("instockreturn", instockReturnbillMap);
        }
        return type_billMap;
    }

    public static String getSsConfirm(DynamicObject obj) {
        String isConfirm = "0";
        if ("A".equals(obj.get("cfmstatus"))) {
            isConfirm = "0";
        }
        if ("B".equals(obj.get("cfmstatus"))) {
            isConfirm = PUR_ENTRYENTITY_SUFFIX;
        }
        if ("C".equals(obj.get("cfmstatus"))) {
            isConfirm = "0";
        }
        return isConfirm;
    }

    public static Map<String, Object> getInfo(DynamicObject bill, String type) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        DynamicObjectCollection invoiceCol = bill.getDynamicObjectCollection("entryentity");
        ArrayList<String> invoiceNoList = new ArrayList<String>(1024);
        ArrayList<String> invoiceCodeList = new ArrayList<String>(1024);
        for (DynamicObject invoice : invoiceCol) {
            invoiceNoList.add(invoice.getString("invno"));
            invoiceCodeList.add(invoice.getString("invcode"));
        }
        detailMap.put("invoiceUrl", bill.get(INVOICEADDRESS));
        detailMap.put("invoiceNo", invoiceNoList);
        detailMap.put("invoiceCode", invoiceCodeList);
        if (bill.get(INVOICEDATE) != null) {
            detailMap.put("invoiceDate", DateUtil.date2str((Date)((Date)bill.get(INVOICEDATE)), null));
        }
        DynamicObject supplier = bill.getDynamicObject(SUPPLIER);
        DynamicObject org = bill.getDynamicObject("org");
        if (null != supplier) {
            detailMap.put("supplierNumber", supplier.getString("number"));
        } else {
            detailMap.put("supplierNumber", "");
        }
        if (null != org) {
            detailMap.put("companyNumber", org.getString("number"));
        } else {
            detailMap.put("companyNumber", "");
        }
        HashMap<String, BigDecimal> entryId_qty_map = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryId_taxAmount_map = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryId_Amount_map = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryId_checkTaxAmount_map = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryId_checkTaxPirce_map = new HashMap<String, BigDecimal>();
        String suffix = PUR_ENTRYENTITY_SUFFIX;
        DynamicObjectCollection entryCol = bill.getDynamicObjectCollection(PUR_ENTRYENTITY);
        DynamicObject[] srcBillObjects = null;
        if (entryCol == null || entryCol.size() == 0) {
            entryCol = bill.getDynamicObjectCollection(SAL_ENTRYENTITY);
            suffix = "";
        } else {
            srcBillObjects = EasQueryPurInvoiceOperation.querySrcBillInfo(entryCol, PUR_ENTRYENTITY, suffix);
        }
        HashMap entryMap = new HashMap();
        for (DynamicObject entry : entryCol) {
            Object sb = null;
            Object sbei = null;
            if (suffix.isEmpty()) {
                sb = entry.get(ENTRY_POBILLID);
                sbei = entry.get(ENTRY_POENTRYID);
            } else if (entry.getString("srcbilltype1").contains("receipt")) {
                if ("instock".equals(type) || ApiConfigUtil.hasXKScmConfig() && ("instockreturn".equals(type) || entry.getBigDecimal("qty1").compareTo(BigDecimal.ZERO) < 0)) continue;
                sb = entry.get("pobillid1");
                sbei = entry.get("poentryid1");
            } else {
                if ("receipt".equals(type) || ApiConfigUtil.hasXKScmConfig() && (!entry.getString("srcbilltype1").contains("return") ? "instockreturn".equals(type) : "instock".equals(type))) continue;
                sb = entry.get(SRCBILLID + suffix);
                DynamicObject srcBillEntry = EasQueryPurInvoiceOperation.getSrcBillEntry(srcBillObjects, sb, sbei = entry.get(SRCBILLENTRYID + suffix));
                if (srcBillEntry != null) {
                    sb = srcBillEntry.get(SRCBILLID);
                    sbei = srcBillEntry.get(SRCBILLENTRYID);
                } else {
                    sb = null;
                    sbei = null;
                }
            }
            if (sbei == null || sbei.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
            String srcBillId = sb.toString();
            String srcBillEntryId = sbei.toString();
            if (entryMap.get(srcBillId) != null) {
                ((List)entryMap.get(srcBillId)).add(srcBillEntryId);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(srcBillEntryId);
                entryMap.put(srcBillId, list);
            }
            BigDecimal qty = CommonUtil.getBigDecimalPro(entryId_qty_map.get(srcBillEntryId));
            entryId_qty_map.put(srcBillEntryId, qty.add(CommonUtil.getBigDecimalPro((Object)entry.get(ENTRY_QTY + suffix))));
            BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entryId_taxAmount_map.get(srcBillEntryId));
            entryId_taxAmount_map.put(srcBillEntryId, taxAmount.add(CommonUtil.getBigDecimalPro((Object)entry.get(ENTRY_TAXAMOUNT + suffix))));
            BigDecimal amount = CommonUtil.getBigDecimalPro(entryId_Amount_map.get(srcBillEntryId));
            entryId_Amount_map.put(srcBillEntryId, amount.add(CommonUtil.getBigDecimalPro((Object)entry.get(ENTRY_AMOUNT + suffix))));
            BigDecimal checkTaxAmount = CommonUtil.getBigDecimalPro(entryId_checkTaxAmount_map.get(srcBillEntryId));
            entryId_checkTaxAmount_map.put(srcBillEntryId, checkTaxAmount.add(CommonUtil.getBigDecimalPro((Object)entry.get("actchecktaxamount"))));
            BigDecimal checkTaxPrice = CommonUtil.getBigDecimalPro(entryId_checkTaxPirce_map.get(srcBillEntryId));
            entryId_checkTaxPirce_map.put(srcBillEntryId, checkTaxPrice.add(CommonUtil.getBigDecimalPro((Object)entry.get("actchecktaxprice"))));
        }
        detailMap.put("checkTaxAmount", entryId_checkTaxAmount_map);
        detailMap.put("checkTaxPrice", entryId_checkTaxPirce_map);
        detailMap.put("invoiceQty", entryId_qty_map);
        detailMap.put("invoiceTaxAmount", entryId_taxAmount_map);
        detailMap.put("invoiceAmount", entryId_Amount_map);
        detailMap.put("srcBillType", type);
        detailMap.put("entry", entryMap);
        if (entryId_qty_map.size() == 0 || entryId_taxAmount_map.size() == 0) {
            return null;
        }
        return detailMap;
    }

    private static DynamicObject getSrcBillEntry(DynamicObject[] srcBillObjs, Object srcBillId, Object srcBillEntryId) {
        DynamicObject entry = null;
        for (DynamicObject srcBill : srcBillObjs) {
            String billId = String.valueOf(srcBill.getPkValue());
            if (!srcBillId.equals(billId)) continue;
            DynamicObjectCollection entryCols = srcBill.getDynamicObjectCollection(SAL_ENTRYENTITY);
            for (DynamicObject entryCol : entryCols) {
                String billEntryId = String.valueOf(entryCol.getPkValue());
                if (!srcBillEntryId.equals(billEntryId)) continue;
                return entryCol;
            }
        }
        return entry;
    }

    private static DynamicObject[] querySrcBillInfo(DynamicObjectCollection entryCol, String entryEntity, String suffix) {
        ArrayList<DynamicObject> allSrcDyObjList = new ArrayList<DynamicObject>();
        DynamicObject[] instockObjects = null;
        DynamicObject[] returnObjects = null;
        if (!suffix.isEmpty()) {
            int i;
            String selectFields = "id,materialentry.id,materialentry.srcbillid,materialentry.srcentryid";
            HashMap paramMap = new HashMap();
            HashMap<String, Set<Object>> idMap = new HashMap<String, Set<Object>>(1);
            idMap.put("in", EasQueryPurInvoiceOperation.getIdList(entryCol, entryEntity, suffix));
            paramMap.put("id", idMap);
            instockObjects = ORMUtil.load((String)"pur_instock", (String)selectFields, paramMap);
            for (i = 0; i < instockObjects.length; ++i) {
                allSrcDyObjList.add(instockObjects[i]);
            }
            returnObjects = ORMUtil.load((String)"pur_return", (String)selectFields, paramMap);
            for (i = 0; i < returnObjects.length; ++i) {
                allSrcDyObjList.add(returnObjects[i]);
            }
        }
        return allSrcDyObjList.toArray(new DynamicObject[0]);
    }

    private static Set<Object> getIdList(DynamicObjectCollection entryCol, String entryEntity, String suffix) {
        HashSet<Object> idList = new HashSet<Object>();
        for (DynamicObject entry : entryCol) {
            Object sb = null;
            Object sbi = null;
            if (!suffix.isEmpty()) {
                sb = entry.get(SRCBILLID + suffix);
                sbi = entry.get(SRCBILLENTRYID + suffix);
            }
            if (sbi == null || sbi.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
            Long srcBillId = Long.valueOf(sb.toString());
            idList.add(srcBillId);
        }
        return idList;
    }
}

