/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.eip.args.OperationArgs;
import kd.scm.common.eip.helper.BillOpration;
import kd.scm.common.eip.util.EipUtils;
import kd.scm.common.util.DynamicObjectUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PurOrderAlertOperation
extends BillOpration {
    private static final String ENTRYID = "id";
    private static final String POENTRYID = "poentryid";
    private Map<String, Map<String, Object>> headDataMap = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> entryDataMap = new HashMap<String, Map<String, Object>>();

    protected String getOperationKey() {
        return "alert";
    }

    protected String getEntityKey() {
        return "pur_order";
    }

    protected void alert(OperationArgs opArgs) {
        this.createPOChangeBill(opArgs.getDynamicObjects());
    }

    protected String getSelectFields() {
        String selectFields = DynamicObjectUtil.getSelectfields((String)this.getEntityKey(), (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)this.getEntityKey(), (String)"materialentry", (boolean)false);
        return selectFields;
    }

    private void createPOChangeBill(DynamicObject[] objs) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(this.getEntityKey());
        pushArgs.setTargetEntityNumber("pur_ordchange");
        pushArgs.setBuildConvReport(false);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        for (DynamicObject purOrder : objs) {
            DynamicObjectCollection cols = purOrder.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(purOrder.getPkValue());
                row.setEntryEntityKey("materialentry");
                row.setEntryPrimaryKeyValue(col.getPkValue());
                selectedRowList.add(row);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pur_ordchange");
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        if (result.isSuccess()) {
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            this.updateConvertData(objs, targetData);
            OperationResult opResult = SaveServiceHelper.saveOperate((String)"pur_ordchange", (DynamicObject[])targetData.toArray(new DynamicObject[0]), null);
            if (opResult.isSuccess()) {
                result.release(refDataProvider, mainType);
            }
        }
    }

    private void updateConvertData(DynamicObject[] sourceData, List<DynamicObject> targetData) {
        this.initData();
        targetData.forEach(data -> {
            String billNo = data.get("billno").toString().toLowerCase();
            EipUtils.map2DynamicObject(this.headDataMap.get(billNo), (DynamicObject)data);
            EipUtils.setBDProperties((DynamicObject)data);
            DynamicObjectCollection cols = data.getDynamicObjectCollection("materialentry");
            cols.forEach(col -> {
                String poEntryId = col.getString(POENTRYID);
                if (this.existEntry(sourceData, billNo, poEntryId)) {
                    Map<String, Object> entryMap = this.entryDataMap.get(billNo + "_" + poEntryId);
                    EipUtils.map2DynamicObject(entryMap, (DynamicObject)col);
                    EipUtils.setBDProperties((DynamicObject)col);
                }
            });
        });
    }

    private void initData() {
        JSONArray list = JSONArray.fromObject(this.param.get("data"));
        JSONObject entity = null;
        for (int i = 0; i < list.size(); ++i) {
            entity = JSONObject.fromObject(list.get(i));
            String number = entity.get("billno").toString().toLowerCase();
            this.headDataMap.put(number, (Map<String, Object>)entity);
            JSONArray entryList = JSONArray.fromObject(entity.get("entryentity"));
            entryList.forEach(object -> {
                JSONObject entry = JSONObject.fromObject((Object)object);
                this.entryDataMap.put(number + "_" + entry.get(ENTRYID), (Map<String, Object>)entry);
            });
        }
    }

    private boolean existEntry(DynamicObject[] sourceData, String purOrderNo, String poEntryId) {
        for (DynamicObject purOrder : sourceData) {
            if (!purOrder.getString("billno").equals(purOrderNo)) continue;
            DynamicObjectCollection cols = purOrder.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                if (!col.getString(POENTRYID).equals(poEntryId)) continue;
                return true;
            }
        }
        return false;
    }
}

