/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.BillCoreHelper;
import kd.scm.common.eip.helper.PurReceiptHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ChangeTypeEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.isc.util.ISCUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.AttachmentUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MessageSendUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class PurOrderChangeHelper
extends BillCoreHelper {
    private static Log log = LogFactory.getLog(PurReceiptHelper.class);
    private static String ENTITY_KEY = "pur_ordchange";

    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    protected String getEntryKey() {
        return "materialentry";
    }

    protected void afterAddEntityTransaction(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntityTransaction(dynamicObjects, headDataMap, entryDataMap);
        HashMap<String, String> extraMap = new HashMap<String, String>();
        extraMap.put("tplScene", "purorderalterconfirm");
        for (DynamicObject dynamicObject : dynamicObjects) {
            MessageSendUtil.send((DynamicObject)dynamicObject, extraMap);
        }
    }

    protected DynamicObject setHeadDefaultProperties(DynamicObject obj) {
        obj.set("cfmstatus", (Object)ConfirmStatusEnum.UNCONFIRM.getVal());
        obj.set("origin", (Object)"2");
        return obj;
    }

    protected DynamicObject setEntryDefaultProperties(DynamicObject obj) {
        obj = super.setEntryDefaultProperties(obj);
        if (!PurOrderChangeHelper.isNewChangeLogic() || !ApiConfigUtil.hasXKScmConfig()) {
            obj.set("chgtype", (Object)ChangeTypeEnum.CHANGE.getVal());
        }
        return super.setEntryDefaultProperties(obj);
    }

    private static boolean isNewChangeLogic() {
        return QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"isNewChangeLogic").and(new QFilter("paramvalue", "=", (Object)"Y"))});
    }

    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.beforeAddEntity(dynamicObjects, headDataMap, entryDataMap);
        HashSet<String> srcPobillIdSet = new HashSet<String>(dynamicObjects.size());
        HashMap<String, DynamicObject> oldKeyVal = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            boolean isc = ISCUtil.isISC();
            if (!isc && dynamicObject.getPkValue() != null && (Long)dynamicObject.getPkValue() != 0L) continue;
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("materialentry");
            DataEntityPropertyCollection dataEntityProperties = entryCol.getDynamicObjectType().getProperties();
            ArrayList<String> entryIdArrs = new ArrayList<String>(entryCol.size());
            for (DynamicObject colRow : entryCol) {
                entryIdArrs.add(colRow.getString("poentryid"));
            }
            String billno = dynamicObject.getString(this.getBillNumber());
            String poBillId = String.valueOf(headDataMap.get(billno.toLowerCase()).get("id"));
            String select = "materialentry.id id,materialentry.qty qty,materialentry.taxprice taxprice,materialentry.taxrate taxrate,materialentry.dctrate dctrate,materialentry.entrydelidate entrydelidate,materialentry.deliaddr deliaddr,materialentry.poentryid poentryid";
            HashMap params = new HashMap(1);
            HashMap<String, ArrayList<String>> sMap = new HashMap<String, ArrayList<String>>(1);
            sMap.put("in", entryIdArrs);
            params.put("materialentry.poentryid", sMap);
            DynamicObjectCollection oldValues = ORMUtil.queryDynamicObjectCollection((String)"pur_order", (String)select, params);
            for (DynamicObject oldRow : oldValues) {
                String poentryid = oldRow.getString("poentryid");
                if (StringUtils.isBlank((String)poentryid) || "0".equals(poentryid)) continue;
                oldKeyVal.put(poentryid, oldRow);
            }
            for (DynamicObject colRow : entryCol) {
                DynamicObject oldVal = (DynamicObject)oldKeyVal.get(colRow.getString("poentryid"));
                if (null == oldVal) {
                    colRow.set("chgtype", (Object)ChangeTypeEnum.ADD.getVal());
                    continue;
                }
                if (!PurOrderChangeHelper.isNewChangeLogic() || !ApiConfigUtil.hasXKScmConfig()) {
                    colRow.set("chgtype", (Object)ChangeTypeEnum.CHANGE.getVal());
                }
                ((IDataEntityProperty)dataEntityProperties.get((Object)"qtyold")).setValue((Object)colRow, oldVal.get("qty"));
                ((IDataEntityProperty)dataEntityProperties.get((Object)"taxpriceold")).setValue((Object)colRow, oldVal.get("taxprice"));
                ((IDataEntityProperty)dataEntityProperties.get((Object)"taxrateold")).setValue((Object)colRow, oldVal.get("taxrate"));
                ((IDataEntityProperty)dataEntityProperties.get((Object)"dctrateold")).setValue((Object)colRow, oldVal.get("dctrate"));
                ((IDataEntityProperty)dataEntityProperties.get((Object)"delidateold")).setValue((Object)colRow, oldVal.get("entrydelidate"));
                ((IDataEntityProperty)dataEntityProperties.get((Object)"deliaddrold")).setValue((Object)colRow, oldVal.get("deliaddr"));
            }
            if (isc) {
                srcPobillIdSet.add(dynamicObject.getString("pobillid"));
                poBillId = dynamicObject.getString("pobillid");
            } else {
                srcPobillIdSet.add(poBillId);
            }
            if (ApiConfigUtil.hasCQScmConfig()) {
                dynamicObject.set(this.getBillNumber(), (Object)billno);
            } else if (ApiConfigUtil.hasXKScmConfig()) {
                dynamicObject.set(this.getBillNumber(), (Object)billno);
            } else {
                dynamicObject.set(this.getBillNumber(), (Object)(billno + "_" + CommonUtil.getBillnoByDate((Object)new Date())));
            }
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("pobillid", (Object)poBillId);
            if (this.minDeliInfo(entryCol).containsKey("delidate")) {
                dynamicObject.set("delidate", this.minDeliInfo(entryCol).get("delidate"));
                dynamicObject.set("deliaddress", this.minDeliInfo(entryCol).get("deliaddress"));
            }
            if (!BillStatusEnum.SUBMIT.getVal().equals(dynamicObject.getString("billstatus"))) continue;
            dynamicObject.set("auditdate", null);
            dynamicObject.set("auditor", null);
        }
        this.changeSrcPurOrderStatus(srcPobillIdSet);
    }

    private Map<String, Object> minDeliInfo(DynamicObjectCollection dynamicObjectCollection) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (resultMap.size() > 0 && dynamicObject.getDate("entrydelidate") != null) {
                    if (!((Date)resultMap.get("delidate")).after(dynamicObject.getDate("entrydelidate"))) continue;
                    resultMap.put("delidate", dynamicObject.getDate("entrydelidate"));
                    resultMap.put("deliaddress", dynamicObject.getString("deliaddr"));
                    continue;
                }
                if (resultMap.size() > 0 || dynamicObject.getDate("entrydelidate") == null) continue;
                resultMap.put("delidate", dynamicObject.getDate("entrydelidate"));
                resultMap.put("deliaddress", dynamicObject.getString("deliaddr"));
            }
        }
        return resultMap;
    }

    private void changeSrcPurOrderStatus(Set<String> srcPobillIdSet) {
        DynamicObject[] objs;
        String selectfields = "id,billno,billstatus,cfmstatus";
        HashMap paramMap = new HashMap();
        HashMap<String, Set<String>> poBillIdMap = new HashMap<String, Set<String>>();
        poBillIdMap.put("in", srcPobillIdSet);
        paramMap.put("materialentry.pobillid", poBillIdMap);
        for (DynamicObject obj : objs = ORMUtil.load((String)"pur_order", (String)selectfields, paramMap)) {
            obj.set("cfmstatus", (Object)ConfirmStatusEnum.ALERT.getVal());
        }
        if (objs.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])objs);
        }
    }

    public List<DynamicObject> getAttachments(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        ArrayList<DynamicObject> attachList = new ArrayList<DynamicObject>();
        for (DynamicObject bill : dynamicObjects) {
            Map<String, Object> billMap = headDataMap.get(bill.getString("pobillno").toLowerCase());
            JSONArray attachMentList = JSONArray.fromObject((Object)billMap.get("attachment"));
            for (Object attachMent : attachMentList) {
                if (attachMent == null || StringUtils.isEmpty((String)attachMent.toString()) || "null".equals(attachMent.toString())) continue;
                JSONObject attachMap = JSONObject.fromObject(attachMent);
                attachMap.put("uid", UUID.randomUUID().toString());
                String url = AttachmentUtil.getUrl((String)String.valueOf(attachMap.get("id")));
                InputStream in = AttachmentUtil.getFile((String)url);
                String fileUrl = AttachmentUtil.uploadFile((InputStream)in, (Map)attachMap);
                attachMap.put("url", fileUrl);
                DynamicObject attatch = AttachmentUtil.createAttachmentData((DynamicObject)bill, (Map)attachMap);
                attachList.add(attatch);
            }
        }
        return attachList;
    }
}

