/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.args.OperationArgs;
import kd.scm.common.eip.helper.BillOpration;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.common.util.WriteBackUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class PurReceiptDeleteOperation
extends BillOpration {
    private static Log log = LogFactory.getLog(PurReceiptDeleteOperation.class);

    protected String getOperationKey() {
        return "delete";
    }

    protected String getEntityKey() {
        return "pur_receipt";
    }

    protected String getSelectFields() {
        String selectFileds = super.getSelectFields();
        StringBuilder selectSb = new StringBuilder();
        selectSb.append(selectFileds).append(',').append("materialentry").append('.').append("id").append(',').append("materialentry").append('.').append("entrystatus").append(',').append("materialentry").append('.').append("poentryid").append(',').append("materialentry").append('.').append("pobillid").append(',').append("materialentry").append('.').append("qty").append(',').append("replenishtype").append(",isreturn");
        return selectSb.toString();
    }

    protected void beforeDelete(OperationArgs opArgs) {
        super.beforeDelete(opArgs);
        this.writeBackSrcBill(opArgs);
        this.deleteTargetBill(opArgs);
    }

    private void deleteTargetBill(OperationArgs opArgs) {
        DynamicObject[] orderCheck;
        DynamicObject[] purReturnObjs;
        ArrayList entryIdstrList = new ArrayList();
        ArrayList entryIdList = new ArrayList();
        ArrayList poEntryPk = new ArrayList();
        for (DynamicObject purReturnObj : purReturnObjs = opArgs.getDynamicObjects()) {
            DynamicObjectCollection entrys = purReturnObj.getDynamicObjectCollection("materialentry");
            entrys.forEach(entry -> {
                entryIdList.add((Long)entry.getPkValue());
                entryIdstrList.add(entry.getPkValue().toString());
                poEntryPk.add(entry.getString("poentryid"));
            });
        }
        ArrayList<Object> targetIdList = new ArrayList<Object>();
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)"scp_receipt", (String)"materialentry", (Long[])entryIdList.toArray(new Long[0]));
        bfRowList.forEach(bfRow -> targetIdList.add(bfRow.getId().getBillId()));
        log.info("###purReceiptDelete deleteScpReturn:" + CommonUtil.collection2str(targetIdList));
        if (targetIdList.size() > 0) {
            SaloutUtil.writeOrderSumoutstockqty(targetIdList);
            this.deletSaleReturnBill(targetIdList);
        }
        log.info("###purReceiptDelete deleteCheckRelation:" + CommonUtil.objs2str((Object[])entryIdstrList.toArray()));
        QFilter filter = new QFilter("srcentryid", "in", entryIdstrList);
        DeleteServiceHelper.delete((String)"pur_checkrelation", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bill : orderCheck = BusinessDataServiceHelper.load((String)"pur_ordercheck", (String)"id,checkstatus,entryentity.poentryid", (QFilter[])new QFilter[]{new QFilter("entryentity.poentryid", "in", poEntryPk).and(new QFilter("checkstatus", "=", (Object)"C"))})) {
            boolean flag = false;
            DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryentity) {
                String poentryid = row.getString("poentryid");
                if (poentryid.isEmpty() || !poEntryPk.contains(poentryid)) continue;
                flag = true;
            }
            if (!flag) continue;
            entryentity.clear();
            bill.set("checkstatus", (Object)"B");
        }
        SaveServiceHelper.save((DynamicObject[])orderCheck);
    }

    private void writeBackSrcBill(OperationArgs opArgs) {
        JSONArray list = JSONArray.fromObject(this.param.get("data"));
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        ArrayList<String> inOrRevList = new ArrayList<String>();
        list.forEach(object -> {
            JSONObject entity = JSONObject.fromObject((Object)object);
            Object billNoObject = entity.get("billno");
            if (null != billNoObject) {
                inOrRevList.add(billNoObject.toString());
            }
            JSONArray entryList = JSONArray.fromObject(entity.get("entryentity"));
            for (Object entry : entryList) {
                JSONObject entryMap = JSONObject.fromObject(entry);
                Object poEntryId = entryMap.get("poentryid");
                if (null == poEntryId) continue;
                poEntryIdList.add(poEntryId);
            }
        });
        log.info("###PurreceiptDelete poEntryIdList:" + CommonUtil.collection2str(poEntryIdList));
        if (poEntryIdList.size() > 0) {
            this.writeBackOrderByRecipt((List<Object>)list, poEntryIdList);
            WriteBackUtil.partRejWriteBack(poEntryIdList, poEntryIdList, null, inOrRevList, "delete");
        }
        HashMap<String, ArrayList<Object>> entryIdMap = new HashMap<String, ArrayList<Object>>();
        entryIdMap.put("entryid", poEntryIdList);
        opArgs.addParam(entryIdMap);
    }

    private void writeBackOrderByRecipt(List<Object> list, List<Object> poEntryIdList) {
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> salOutEntryId_qtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> srcPoEntryId_qtyMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection srcBillObjects = OrderUtil.querySrcBillInfo(poEntryIdList);
        Map poEntryId_orderEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)srcBillObjects, (String)"poentryid");
        boolean isReturn = false;
        boolean isReturnAdd = false;
        for (Object object : list) {
            JSONObject entity = JSONObject.fromObject((Object)object);
            Object isReturnObj = entity.get("isreturn");
            Object biztype = entity.get("biztype");
            if (null != isReturnObj && isReturnObj.toString().equals("1")) {
                isReturn = true;
            }
            if (null != biztype && biztype.toString().equals("112")) {
                isReturnAdd = true;
            }
            JSONArray entryList = JSONArray.fromObject(entity.get("entryentity"));
            for (Object entry : entryList) {
                String srcEntryIdStr;
                String saloutentryStr;
                JSONObject entryMap = JSONObject.fromObject(entry);
                Object srcPoEntryId = entryMap.get("poentryid");
                Object saloutentryid = entryMap.get("saloutentryid");
                BigDecimal qty = CommonUtil.getBigDecimalPro(entryMap.get("qty"));
                qty = qty.abs();
                if (null != srcPoEntryId && saloutentryid != null && !(saloutentryStr = saloutentryid.toString()).isEmpty() && !(saloutentryid instanceof JSONNull)) {
                    BigDecimal saloutDecimal = (BigDecimal)salOutEntryId_qtyMap.get(saloutentryid);
                    if (null != saloutDecimal) {
                        BigDecimal bigDecimal = saloutDecimal.add(qty);
                        salOutEntryId_qtyMap.put(saloutentryStr, bigDecimal);
                    } else {
                        salOutEntryId_qtyMap.put(saloutentryStr, qty);
                    }
                    salOutEntryId_qtyMap.put("saloutentryid", BigDecimal.ZERO);
                }
                log.info(((Object)salOutEntryId_qtyMap).toString());
                if (null == srcPoEntryId || (srcEntryIdStr = String.valueOf(srcPoEntryId)).isEmpty()) continue;
                if (salOutEntryId_qtyMap.isEmpty()) {
                    if (null != srcPoEntryId_qtyMap.get(srcEntryIdStr)) {
                        BigDecimal bigDecimal = ((BigDecimal)srcPoEntryId_qtyMap.get(srcEntryIdStr)).add(qty);
                        srcPoEntryId_qtyMap.put(srcEntryIdStr, bigDecimal);
                    } else {
                        srcPoEntryId_qtyMap.put(srcEntryIdStr, qty);
                    }
                    srcPoEntryId_qtyMap.put("poentryid", BigDecimal.ZERO);
                }
                log.info(((Object)salOutEntryId_qtyMap).toString());
                DynamicObject poBillEntry = (DynamicObject)poEntryId_orderEntryMap.get(srcEntryIdStr);
                log.info("poBillEntry" + poBillEntry);
                String poEntryId = null;
                if (poBillEntry == null) continue;
                poEntryId = poBillEntry.getString("entryId");
                if (null != srcEntryId_qtyMap.get(poEntryId)) {
                    srcEntryId_qtyMap.put(poEntryId, ((BigDecimal)srcEntryId_qtyMap.get(poEntryId)).add(qty));
                } else {
                    srcEntryId_qtyMap.put(poEntryId, qty);
                }
                srcEntryIdList.add(Long.valueOf(poEntryId));
            }
        }
        log.info("###writeBackOrderByRecipt isReturn:" + isReturn);
        log.info("srcEntryIdList" + srcEntryIdList);
        HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
        ArrayList<String> proList = new ArrayList<String>();
        if (isReturn) {
            proList.add("sumrecretqty");
        } else {
            proList.add("sumreceiptqty");
        }
        proListMap.put("materialentry", proList);
        if (!srcEntryIdList.isEmpty()) {
            if (isReturnAdd) {
                WriteBackUtil.writeBackBillByReturnAdd("pur_order", proListMap, srcEntryIdList, srcEntryId_qtyMap, "delete");
            } else {
                WriteBackUtil.writeBackBillForPurOrder("pur_order", proListMap, srcEntryIdList, srcEntryId_qtyMap, "delete");
            }
        }
        if (!isReturn) {
            if (salOutEntryId_qtyMap.isEmpty() && !srcPoEntryId_qtyMap.isEmpty()) {
                salOutEntryId_qtyMap.putAll(srcPoEntryId_qtyMap);
            }
            log.info(((Object)salOutEntryId_qtyMap).toString());
            srcEntryId_qtyMap.put("poentryid", BigDecimal.ZERO);
            SaloutUtil.updateReciptQtyOrInstockQty(poEntryIdList, salOutEntryId_qtyMap, "sumreceiptqty", "delete");
        }
    }

    protected void delete(OperationArgs opArgs) {
        super.delete(opArgs);
        DynamicObject[] purOderObjs = this.getPurOrderInfo(opArgs);
        HashMap<String, Object> billMap = new HashMap<String, Object>(purOderObjs.length);
        billMap.put("purOderObjs.length", purOderObjs != null ? purOderObjs.length : 0);
        for (DynamicObject purOrder : purOderObjs) {
            String logStatus = purOrder.getString("logStatus");
            String billId = ((DynamicObject)purOrder.getDynamicObjectCollection("materialentry").get(0)).getString("pobillid");
            billMap.put(billId, logStatus);
        }
        opArgs.getReturnData().put("pur_order", billMap);
    }

    private DynamicObject[] getPurOrderInfo(OperationArgs opArgs) {
        String selectFields = "logstatus,materialentry.pobillid";
        HashMap paramMap = new HashMap(1);
        HashMap poBillIdMap = new HashMap(1);
        poBillIdMap.put("in", opArgs.getParam().get("entryid"));
        paramMap.put("materialentry.poentryid", poBillIdMap);
        return ORMUtil.load((String)"pur_order", (String)selectFields, paramMap);
    }

    private void deletSaleReturnBill(List<Object> saleReturnbillidList) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"scp_salreturn", (Object[])saleReturnbillidList.toArray(), (OperateOption)option);
        if (unAuditResult.isSuccess()) {
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"scp_salreturn", (Object[])saleReturnbillidList.toArray(), (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                StringBuilder message = this.buildErrorMessage(deleteResult);
                log.error("@@\u5220\u9664\u76ee\u6807\u5355\u9500\u552e\u9000\u8d27\u5931\u8d25\uff1a" + message);
                SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)new KDBizException(message.toString()));
            }
        } else {
            StringBuilder message = this.buildErrorMessage(unAuditResult);
            log.error("\u53cd\u5ba1\u6838\u9500\u552e\u9000\u8d27\u5355\u5931\u8d25\uff1a" + message);
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)new KDBizException(message.toString()));
        }
    }

    protected DynamicObject[] getExecuteData() {
        DynamicObject[] objs = ORMUtil.load((String)this.getEntityKey(), (String)this.getSelectFields(), (Map)this.buildCondition(), (String)this.getOrderby());
        this.throwException(objs);
        return objs;
    }
}

