/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.eip.helper.BillCoreHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillPushAssistUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.MessageSendUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.common.util.WriteBackUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import kd.scm.common.util.check.CheckRelationUtil;
import kd.scm.common.util.check.CheckWriteDataEntity;
import org.apache.commons.lang.StringUtils;

public class PurReceiptHelper
extends BillCoreHelper {
    private static Log log = LogFactory.getLog(PurReceiptHelper.class);
    private static String ENTITY_KEY = "pur_receipt";

    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    protected void afterAddEntityTransaction(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntityTransaction(dynamicObjects, headDataMap, entryDataMap);
    }

    protected DynamicObject setHeadSpecialProperties(DynamicObject obj) {
        if (StringUtils.equals((String)"112", (String)obj.get("biztype").toString())) {
            obj.set("replenishtype", (Object)"1");
        } else {
            obj.set("replenishtype", (Object)"3");
        }
        return super.setHeadSpecialProperties(obj);
    }

    protected DynamicObject setHeadDefaultProperties(DynamicObject obj) {
        obj = super.setHeadDefaultProperties(obj);
        obj.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
        return obj;
    }

    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.beforeAddEntity(dynamicObjects, headDataMap, entryDataMap);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Object currency;
            String billno = dynamicObject.getString(this.getBillNumber());
            if (null == dynamicObject.get("replenishtype") || "".equals(dynamicObject.getString("replenishtype"))) {
                dynamicObject.set("replenishtype", (Object)"3");
            }
            if ((currency = dynamicObject.get("curr")) == null || currency.toString().equals("0")) {
                DynamicObject obj = null;
                obj = dynamicObject.getBoolean("isreturn") ? this.getPurRecieptInfo(dynamicObject, entryDataMap) : this.getPurOrderInfo(dynamicObject);
                if (obj != null) {
                    currency = obj.get("curr");
                    dynamicObject.set("curr", currency);
                }
            }
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                entry.set("srcbilltype", (Object)dynamicObject.getDataEntityType().getName());
            }
            if (dynamicObject.getPkValue() != null && (Long)dynamicObject.getPkValue() != 0L) continue;
            Object supplier = dynamicObject.get("supplier");
            for (DynamicObject entry : entryCol) {
                if (!ApiConfigUtil.hasXKScmConfig()) {
                    entry.set("srcbillid", headDataMap.get(billno.toLowerCase()).get("id"));
                }
                if (null != supplier) {
                    entry.set("settlesup", supplier);
                }
                entry.set("srcbilltype", (Object)dynamicObject.getDataEntityType().getName());
            }
        }
        OrderUtil.setPurTypeByOrder(dynamicObjects, headDataMap, entryDataMap, this.getEntryKey());
        this.updateBillPriceInfo(dynamicObjects, headDataMap, entryDataMap);
    }

    private void writeBackSrcBill(List<DynamicObject> objs, Map<String, Map<String, Object>> entryDataMap) {
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, String> entryId_srcEntryIdMap = new HashMap<String, String>();
        HashMap<String, Map<String, Object>> srcEntryId_entryMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : entryDataMap.entrySet()) {
            String srcEntryIdStr;
            Object srcEntryId;
            Object poEntryId = entry.getValue().get("poentryid");
            if (null != poEntryId) {
                poEntryIdList.add(poEntryId);
            }
            if (null == (srcEntryId = entry.getValue().get("saloutentryid")) || (srcEntryIdStr = String.valueOf(srcEntryId)).isEmpty() || Long.valueOf(srcEntryIdStr).equals(0L)) continue;
            Object instockEntryId = entry.getValue().get("srcentryid");
            if (null != instockEntryId) {
                String instockEntryIdStr = instockEntryId.toString();
                entryId_srcEntryIdMap.putIfAbsent(srcEntryIdStr, instockEntryIdStr);
                srcEntryId_entryMap.putIfAbsent(instockEntryIdStr, entry.getValue());
            }
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.getValue().get("basicqty"));
            if (null != srcEntryId_qtyMap.get(srcEntryIdStr)) {
                srcEntryId_qtyMap.put(srcEntryIdStr, ((BigDecimal)srcEntryId_qtyMap.get(srcEntryIdStr)).add(qty));
            } else {
                srcEntryId_qtyMap.put(srcEntryIdStr, qty);
            }
            srcEntryIdList.add(Long.valueOf(srcEntryIdStr));
        }
        log.info("PurReceiptHelper#writeBackSrcBill#srcEntryId_qtyMap" + srcEntryId_qtyMap);
        log.info("PurReceiptHelper#writeBackSrcBill#srcEntryIdList" + srcEntryIdList);
        log.info("PurReceiptHelper#writeBackSrcBill#entryId_srcEntryIdMap" + entryId_srcEntryIdMap);
        log.info("PurReceiptHelper#writeBackSrcBill#srcEntryId_entryMap" + srcEntryId_entryMap);
        if (srcEntryIdList.size() > 0) {
            HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
            ArrayList<String> proList = new ArrayList<String>();
            proList.add("sumreceiptbaseqty");
            proListMap.put("materialentry", proList);
            WriteBackUtil.writeBackBill("scp_saloutstock", proListMap, srcEntryIdList, srcEntryId_qtyMap, "audit");
            WriteBackUtil.skipAuditWriteBackBill("scp_saloutstock", proListMap, srcEntryIdList, srcEntryId_qtyMap, "scp_order");
            SaloutUtil.updateSrcEntryIdBySaloutEntryId(srcEntryIdList, entryId_srcEntryIdMap);
            CheckRelationUtil.createCheckRelation(objs, srcEntryId_entryMap, this.getEntityKey(), this.getEntryKey());
        } else if (poEntryIdList.size() > 0) {
            this.writeBackOrderByReceipt(objs, poEntryIdList);
        }
    }

    private void writeBackOrderByReceipt(List<DynamicObject> objs, List<Object> poEntryIdList) {
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        CheckWriteDataEntity writeData = new CheckWriteDataEntity();
        DynamicObjectCollection srcBillObjects = OrderUtil.querySrcBillInfo(poEntryIdList);
        Map poEntryId_orderEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)srcBillObjects, (String)"poentryid");
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection(this.getEntryKey());
            for (DynamicObject entry : entrys) {
                String srcEntryIdStr;
                Object srcPoEntryId = entry.get("poentryid");
                if (null == srcPoEntryId || (srcEntryIdStr = String.valueOf(srcPoEntryId)).isEmpty()) continue;
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get("basicqty"));
                writeData.setWriteData(srcEntryIdStr, entry.getPkValue().toString(), qty);
                writeData.setEntryIdBillIdMap(entry.getPkValue().toString(), obj.getPkValue().toString());
                writeData.setSrcEntityKey(this.getEntityKey());
                writeData.setTarEntityKey("pur_saloutstock");
                DynamicObject poBillEntry = (DynamicObject)poEntryId_orderEntryMap.get(srcEntryIdStr);
                String poEntryId = null;
                if (poBillEntry == null) continue;
                poEntryId = poBillEntry.getString("entryId");
                if (null != srcEntryId_qtyMap.get(poEntryId)) {
                    srcEntryId_qtyMap.put(poEntryId, ((BigDecimal)srcEntryId_qtyMap.get(poEntryId)).add(qty));
                } else {
                    srcEntryId_qtyMap.put(poEntryId, qty);
                }
                srcEntryIdList.add(Long.valueOf(poEntryId));
            }
        }
        if (!srcEntryIdList.isEmpty()) {
            HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
            ArrayList<String> proList = new ArrayList<String>();
            proList.add("sumreceiptbaseqty");
            proListMap.put("materialentry", proList);
            WriteBackUtil.writeBackBillForPurOrder("pur_order", proListMap, srcEntryIdList, srcEntryId_qtyMap, "audit");
        }
        SaloutUtil.updateReciptQtyOrInstockQty(writeData, "sumreceiptbaseqty", "audit");
    }

    private DynamicObject getPurOrderInfo(DynamicObject dynamicObject) {
        DynamicObject row;
        String poBillNo = null;
        DynamicObjectCollection entryRows = dynamicObject.getDynamicObjectCollection("materialentry");
        Iterator iterator = entryRows.iterator();
        while (iterator.hasNext() && (poBillNo = (row = (DynamicObject)iterator.next()).getString("pobillno")) == null) {
        }
        return QueryServiceHelper.queryOne((String)"pur_order", (String)"billno, curr", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)poBillNo)});
    }

    private DynamicObject getPurRecieptInfo(DynamicObject dynamicObject, Map<String, Map<String, Object>> entryDataMap) {
        Object sourceBillId = null;
        if (null != this.getEntryKey() && entryDataMap.size() > 0) {
            boolean flag = false;
            for (Map.Entry<String, Map<String, Object>> entry : entryDataMap.entrySet()) {
                if (flag) break;
                sourceBillId = entry.getValue().get("pobillid");
                flag = true;
            }
        }
        return QueryServiceHelper.queryOne((String)"pur_order", (String)"curr", (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "=", sourceBillId)});
    }

    protected String getSelectfields(Set<String> keySet) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append(super.getSelectfields(keySet));
        selectFields.append(',').append("taxtype");
        selectFields.append(',').append("replenishtype");
        selectFields.append(',').append("sumtax");
        selectFields.append(',').append("sumtaxamount");
        selectFields.append(',').append("sumamount");
        selectFields.append(',').append("materialentry.srcbilltype");
        selectFields.append(',').append("materialentry.dctamount");
        selectFields.append(',').append("materialentry.dctrate");
        return selectFields.toString();
    }

    protected String getEntrySelectfields(Set<String> keySet, String str) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append(super.getEntrySelectfields(keySet, str));
        selectFields.append("purtype").append('.').append("id");
        selectFields.append("srcbilltype");
        return selectFields.toString();
    }

    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntity(dynamicObjects, headDataMap, entryDataMap);
        log.info("###purReceipt afterAddEntity");
        ArrayList<DynamicObject> returnObjs = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> notReturnObjs = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.getBoolean("isreturn")) {
                returnObjs.add(dynamicObject);
                continue;
            }
            notReturnObjs.add(dynamicObject);
        }
        if (notReturnObjs.size() > 0) {
            log.info("###purReceipt afterAddEntity writeBackSrcBill");
            this.writeBackSrcBill(notReturnObjs, entryDataMap);
        }
        log.info("###purReceipt returnObjs size:" + returnObjs.size());
        if (returnObjs.size() > 0) {
            this.writeByReturnObjs(returnObjs);
        }
        HashMap<String, String> extraMap = new HashMap<String, String>();
        extraMap.put("orgScopeType", "rcvorgscope");
        StringBuilder content = new StringBuilder();
        Map inStockOfSal = MessageSendUtil.getAllSalOutStockBill(dynamicObjects);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Set idOfBiLL = (Set)inStockOfSal.get(dynamicObject.getString("id"));
            Iterator stringIterator = idOfBiLL.iterator();
            StringBuilder salBillNo = new StringBuilder();
            while (stringIterator.hasNext()) {
                salBillNo.append((String)stringIterator.next()).append('\u3001');
            }
            if (dynamicObject.getBoolean("isreturn")) {
                extraMap.put("title", ResManager.loadKDString((String)"\u9000\u8d27\u5df2\u7ecf\u751f\u6548\u8bf7\u67e5\u8be2\u3002", (String)"PurReceiptHelper_0", (String)"scm-common", (Object[])new Object[0]));
                extraMap.put("entityName", new LocaleString(ResManager.loadKDString((String)"\u6536\u8d27\u9000\u8d27", (String)"PurReceiptHelper_1", (String)"scm-common", (Object[])new Object[0])).getLocaleValue());
                extraMap.put("tplScene", "purreceiptreturnquery");
                content.append(ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6210\uff0c\u8bf7\u767b\u5f55\u7cfb\u7edf\u8fdb\u884c\u4e0b\u4e00\u6b65\u5904\u7406\u3002", (String)"PurReceiptHelper_2", (String)"scm-common", (Object[])new Object[0]));
                if (salBillNo.length() > 0) {
                    extraMap.put("content", content.append(MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u53d1\u8d27\u5355\uff1a{0}", (String)"PurReceiptHelper_3", (String)"scm-common", (Object[])new Object[0]), salBillNo.subSequence(0, salBillNo.length() - 1))).toString());
                } else {
                    extraMap.put("content", content.append(MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u53d1\u8d27\u5355\uff1a{0}", (String)"PurReceiptHelper_3", (String)"scm-common", (Object[])new Object[0]), "")).toString());
                }
                MessageSendUtil.send((DynamicObject)dynamicObject, extraMap);
                continue;
            }
            extraMap.put("title", ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6548\u8bf7\u67e5\u8be2\u3002", (String)"PurReceiptHelper_4", (String)"scm-common", (Object[])new Object[0]));
            extraMap.put("tplScene", "purreceiptquery");
            content.append(ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6548\uff0c\u8bf7\u767b\u5f55\u7cfb\u7edf\u8fdb\u884c\u6536\u8d27\u67e5\u8be2\u3002", (String)"PurReceiptHelper_5", (String)"scm-common", (Object[])new Object[0]));
            if (salBillNo.length() > 0) {
                extraMap.put("content", content.append(MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u5904\u7406\u7684\u53d1\u8d27\u5355\u5982\u4e0b\uff1a{0}", (String)"PurReceiptHelper_6", (String)"scm-common", (Object[])new Object[0]), salBillNo.subSequence(0, salBillNo.length() - 1))).toString());
            } else {
                extraMap.put("content", content.append(MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u5904\u7406\u7684\u53d1\u8d27\u5355\u5982\u4e0b\uff1a{0}", (String)"PurReceiptHelper_6", (String)"scm-common", (Object[])new Object[0]), "")).toString());
            }
            MessageSendUtil.send((DynamicObject)dynamicObject, extraMap);
        }
    }

    private void writeByReturnObjs(List<DynamicObject> returnObjs) {
        List newReturnObjs = DynamicObjectUtil.getUnPushBillObjs(returnObjs, (String)"scp_receipt", (String)this.getEntryKey());
        log.info("###purReceiptHelper noTarObjs size:" + newReturnObjs.size());
        if (newReturnObjs.size() > 0) {
            ArrayList<String> proList;
            List tarDataList;
            ArrayList<DynamicObject> returnNotAddObjs = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> returnAddObjs = new ArrayList<DynamicObject>();
            for (DynamicObject dyn : returnObjs) {
                if ("1".equals(dyn.getString("replenishtype"))) {
                    returnAddObjs.add(dyn);
                    continue;
                }
                returnNotAddObjs.add(dyn);
            }
            if (returnNotAddObjs.size() > 0) {
                tarDataList = BillPushAssistUtil.pushToTargetAuditBill(returnObjs, (String)"scp_receipt", (String)"materialentry", (String)"scp_salreturn");
                proList = new ArrayList<String>();
                proList.add("sumrecretqty");
                OrderUtil.writeBackOrderReturnInfo(returnObjs, proList, this.getEntryKey(), "audit");
                CheckRelationUtil.createCheckRelation(returnObjs, tarDataList, this.getEntityKey());
            }
            if (returnAddObjs.size() > 0) {
                tarDataList = BillPushAssistUtil.pushToTargetAuditBill(returnObjs, (String)"scp_receipt", (String)"materialentry", (String)"scp_salreturn");
                proList = new ArrayList();
                proList.add("sumrecretqty");
                OrderUtil.writeBackOrderReturnInfo(returnObjs, proList, this.getEntryKey(), "audit");
                CheckRelationUtil.createCheckRelation(returnObjs, tarDataList, this.getEntityKey());
            }
        }
    }

    private void updateBillPriceInfo(List<DynamicObject> objs, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        if (objs.isEmpty()) {
            return;
        }
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        for (Map.Entry<String, Map<String, Object>> entry : entryDataMap.entrySet()) {
            Object poEntryId;
            BigDecimal taxAmount1;
            Object taxAmount = entry.getValue().get("taxamount");
            if (null != taxAmount && taxAmount.toString().trim().length() > 0 && BigDecimal.ZERO.compareTo(taxAmount1 = new BigDecimal(String.valueOf(taxAmount))) != 0 || null == (poEntryId = entry.getValue().get("poentryid"))) continue;
            poEntryIdList.add(poEntryId);
        }
        DynamicObjectCollection cols = OrderUtil.querySrcBillInfo(poEntryIdList);
        HashMap<String, DynamicObject> poEntryId_orderEntryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject col : cols) {
            String poentryId = col.getString("poentryid");
            if (null == poentryId || poentryId.isEmpty()) continue;
            poEntryId_orderEntryMap.put(poentryId, col);
        }
        ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
        for (DynamicObject obj : objs) {
            boolean isUpdate = false;
            DynamicObjectCollection receiptCols = obj.getDynamicObjectCollection(this.getEntryKey());
            String taxType = TaxTypeEnum.TAXSEXPRICE_INTAX.getVal();
            for (DynamicObject col : receiptCols) {
                String poentryId = col.getString("poentryid");
                DynamicObject orderEntry = (DynamicObject)poEntryId_orderEntryMap.get(poentryId);
                if (null == orderEntry) continue;
                isUpdate = true;
                taxType = orderEntry.getString("taxtype");
                col.set("price", orderEntry.get("price"));
                col.set("taxprice", orderEntry.get("taxprice"));
                col.set("dctrate", orderEntry.get("dctrate"));
                col.set("taxrate", orderEntry.get("taxrate"));
            }
            if (!isUpdate) continue;
            obj.set("taxtype", (Object)taxType);
            iCalDynamic.reCalBill(obj, this.getEntryKey());
        }
    }
}

