/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.eip.args.OperationArgs;
import kd.scm.common.eip.helper.BillOpration;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PurRequestDeleteOperation
extends BillOpration {
    protected String getOperationKey() {
        return "delete";
    }

    protected String getEntityKey() {
        return "pur_request";
    }

    protected void beforeDelete(OperationArgs opArgs) {
        super.beforeDelete(opArgs);
        this.writeBackSrcBillQty(opArgs);
    }

    private void writeBackSrcBillQty(OperationArgs opArgs) {
        JSONArray list = JSONArray.fromObject(this.param.get("data"));
        HashSet numberSet = new HashSet();
        list.forEach(object -> {
            JSONObject entity = JSONObject.fromObject((Object)object);
            numberSet.add(String.valueOf(entity.get("billno")));
        });
        if (numberSet.size() > 0) {
            QFilter prodfilter = new QFilter("billno", "in", numberSet);
            DynamicObject[] requestArray = BusinessDataServiceHelper.load((String)"pur_request", (String)"id,billno,materialentry.qty,materialentry.poentryid,materialentry.pobillno", (QFilter[])new QFilter[]{prodfilter});
            this.writeOrderReturnQty(requestArray);
        }
    }

    public void writeOrderReturnQty(DynamicObject[] requestArray) {
        HashSet<String> orderSet = new HashSet<String>();
        DynamicObjectCollection dynEntry = null;
        DynamicObject entry = null;
        String orderNumber = null;
        String orderEntryId = null;
        BigDecimal qty = BigDecimal.ZERO;
        HashMap<String, Map<String, BigDecimal>> order_entry = new HashMap<String, Map<String, BigDecimal>>();
        Map<String, BigDecimal> entry_returnQty = null;
        for (DynamicObject dyn : requestArray) {
            dynEntry = dyn.getDynamicObjectCollection("materialentry");
            for (int i = 0; i < dynEntry.size(); ++i) {
                entry = (DynamicObject)dynEntry.get(i);
                orderNumber = entry.getString("pobillno");
                qty = entry.getBigDecimal("qty");
                orderEntryId = entry.getString("poentryid");
                if (null == orderNumber) continue;
                orderSet.add(orderNumber);
                if (null != order_entry.get(orderNumber)) {
                    entry_returnQty = (Map)order_entry.get(orderNumber);
                    if (null != entry_returnQty.get(orderEntryId)) {
                        BigDecimal returnQty = (BigDecimal)entry_returnQty.get(orderEntryId);
                        entry_returnQty.put(orderEntryId, returnQty.add(qty));
                        continue;
                    }
                    entry_returnQty.put(orderEntryId, qty);
                    continue;
                }
                entry_returnQty = new HashMap();
                entry_returnQty.put(orderEntryId, qty);
                order_entry.put(orderNumber, entry_returnQty);
            }
        }
        if (orderSet.size() > 0) {
            QFilter prodfilter = new QFilter("billno", "in", orderSet);
            prodfilter.and(QFilter.of((String)"materialentry.sumreturnreqqty > 0", (Object[])new Object[0]));
            DynamicObject[] orderArray = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billno,materialentry.sumreturnreqqty,materialentry.poentryid", (QFilter[])new QFilter[]{prodfilter});
            BigDecimal sumreturnreqqty = BigDecimal.ZERO;
            String poentryid = null;
            String orderNum = null;
            if (orderArray.length > 0) {
                for (DynamicObject dyn : orderArray) {
                    dynEntry = dyn.getDynamicObjectCollection("materialentry");
                    orderNum = dyn.getString("billno");
                    for (int i = 0; i < dynEntry.size(); ++i) {
                        entry = (DynamicObject)dynEntry.get(i);
                        sumreturnreqqty = entry.getBigDecimal("sumreturnreqqty");
                        poentryid = entry.getString("poentryid");
                        if (null == order_entry.get(orderNum) || null == (entry_returnQty = (Map)order_entry.get(orderNum)).get(poentryid)) continue;
                        qty = (BigDecimal)entry_returnQty.get(poentryid);
                        entry.set("sumreturnreqqty", (Object)sumreturnreqqty.subtract(qty));
                    }
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orderArray);
        }
    }
}

