/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.eip.helper.BillCoreHelper;
import kd.scm.common.isc.util.ISCUtil;
import kd.scm.common.util.BillPushAssistUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.MessageSendUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.check.CheckRelationUtil;
import org.apache.commons.lang.StringUtils;

public class PurReturnHelper
extends BillCoreHelper {
    private static Log log = LogFactory.getLog(PurReturnHelper.class);
    private static String ENTITY_KEY = "pur_return";

    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    protected void afterAddEntityTransaction(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntityTransaction(dynamicObjects, headDataMap, entryDataMap);
    }

    protected DynamicObject setHeadSpecialProperties(DynamicObject obj) {
        if (StringUtils.equals((String)"111", (String)obj.get("biztype").toString())) {
            obj.set("rettype", (Object)"1");
            obj.set("replenishtype", (Object)"3");
        } else if (StringUtils.equals((String)"112", (String)obj.get("biztype").toString())) {
            obj.set("rettype", (Object)"1");
            obj.set("replenishtype", (Object)"1");
        }
        obj.set("biztype", (Object)"1");
        return obj;
    }

    protected DynamicObject setHeadDefaultProperties(DynamicObject obj) {
        obj = super.setHeadDefaultProperties(obj);
        return obj;
    }

    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.beforeAddEntity(dynamicObjects, headDataMap, entryDataMap);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (null == dynamicObject.get("replenishtype") || "".equals(dynamicObject.getString("replenishtype"))) {
                dynamicObject.set("replenishtype", (Object)"3");
            }
            BigDecimal sumTaxAmount = BigDecimal.ZERO;
            BigDecimal sumTax = BigDecimal.ZERO;
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("materialentry");
            String billno = dynamicObject.getString(this.getBillNumber());
            if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                for (DynamicObject dynamicObjectInner : dynamicObjectCollection) {
                    Map entryMap = DynamicObjectUtil.plainObject2Map((DynamicObject)dynamicObjectInner);
                    Object tax = entryMap.get("tax");
                    Object taxAmount = entryMap.get("taxamount");
                    dynamicObjectInner.set("srcbilltype", (Object)dynamicObject.getDataEntityType().getName());
                    if (tax != null && taxAmount != null) {
                        sumTax = sumTax.add((BigDecimal)tax);
                        sumTaxAmount = sumTaxAmount.add((BigDecimal)taxAmount);
                    }
                    if (ISCUtil.isISC()) continue;
                    dynamicObjectInner.set("srcbillid", headDataMap.get(billno.toLowerCase()).get("id"));
                }
            }
            dynamicObject.set("sumtax", (Object)sumTax);
            dynamicObject.set("sumtaxamount", (Object)sumTaxAmount);
            if (dynamicObject.getPkValue() != null && (Long)dynamicObject.getPkValue() != 0L) continue;
            if ("1".equals(headDataMap.get(billno.toLowerCase()).get("hasvirtual"))) {
                dynamicObject.set("iscentersettle", (Object)"1");
                continue;
            }
            dynamicObject.set("iscentersettle", (Object)"0");
        }
        OrderUtil.setPurTypeByOrder(dynamicObjects, headDataMap, entryDataMap, this.getEntryKey());
    }

    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntity(dynamicObjects, headDataMap, entryDataMap);
        List<DynamicObject> writeBackDynamicObjects = OrderUtil.getWriteBackObjesByOrder(dynamicObjects, headDataMap, this.getEntryKey());
        List tarDataList = BillPushAssistUtil.pushToTargetAuditBill(writeBackDynamicObjects, (String)"scp_return", (String)"materialentry", (String)"scp_salreturn");
        ArrayList<DynamicObject> writeBackDynamicObjReturn = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> writeBackDynamicObj = new ArrayList<DynamicObject>();
        for (DynamicObject dyn : writeBackDynamicObjects) {
            if ("1".equals(dyn.getString("replenishtype"))) {
                writeBackDynamicObjReturn.add(dyn);
                continue;
            }
            writeBackDynamicObj.add(dyn);
        }
        if (writeBackDynamicObjReturn.size() > 0) {
            OrderUtil.writeBackOrderReturnInfo(writeBackDynamicObjReturn, Collections.singletonList("suminstockretqty"), this.getEntryKey(), "audit");
        }
        if (writeBackDynamicObj.size() > 0) {
            OrderUtil.writeBackOrderReturnInfo(writeBackDynamicObj, Collections.singletonList("suminstockretqty"), this.getEntryKey(), "audit");
        }
        log.info("###purReturnHelper createCheckRelation!");
        CheckRelationUtil.createCheckRelation(writeBackDynamicObjects, tarDataList, this.getEntityKey());
        HashMap<String, String> extraMap = new HashMap<String, String>(1024);
        StringBuilder content = new StringBuilder();
        Map inStockOfSal = MessageSendUtil.getAllSalOutStockBill(dynamicObjects);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Set idOfBiLL = (Set)inStockOfSal.get(dynamicObject.getString("id"));
            Iterator stringIterator = idOfBiLL.iterator();
            extraMap.put("tplScene", "purreturnquery");
            extraMap.put("title", ResManager.loadKDString((String)"\u5df2\u751f\u6210\uff0c\u8bf7\u8fdb\u884c\u4e0b\u4e00\u6b65\u5904\u7406\u3002", (String)"PurReturnHelper_0", (String)"scm-common", (Object[])new Object[0]));
            StringBuilder salBillNo = new StringBuilder();
            while (stringIterator.hasNext()) {
                salBillNo.append((String)stringIterator.next()).append('\u3001');
            }
            content.append(ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6210\uff0c\u8bf7\u767b\u5f55\u7cfb\u7edf\u8fdb\u884c\u4e0b\u4e00\u6b65\u5904\u7406\u3002", (String)"PurReturnHelper_1", (String)"scm-common", (Object[])new Object[0]));
            if (salBillNo.length() == 0) {
                extraMap.put("content", content.append(ResManager.loadKDString((String)"\u672c\u6b21\u5904\u7406\u7684\u53d1\u8d27\u5355\u5982\u4e0b\uff1a{", (String)"PurReturnHelper_2", (String)"scm-common", (Object[])new Object[0])).append('}').toString());
            } else {
                extraMap.put("content", content.append(ResManager.loadKDString((String)"\u672c\u6b21\u5904\u7406\u7684\u53d1\u8d27\u5355\u5982\u4e0b\uff1a{", (String)"PurReturnHelper_2", (String)"scm-common", (Object[])new Object[0])).append(salBillNo.subSequence(0, salBillNo.length() - 1)).append('}').toString());
            }
            MessageSendUtil.send((DynamicObject)dynamicObject, extraMap);
        }
    }

    protected String getSelectfields(Set<String> keySet) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append(super.getSelectfields(keySet));
        selectFields.append(',').append("sumtax");
        selectFields.append(',').append("sumtaxamount");
        selectFields.append(',').append("materialentry.srcbilltype");
        return selectFields.toString();
    }

    protected String getEntrySelectfields(Set<String> keySet, String str) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append(super.getEntrySelectfields(keySet, str));
        selectFields.append(',').append("purtype").append('.').append("id");
        selectFields.append(',').append("srcbillid");
        return selectFields.toString();
    }
}

