/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.handleservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.common.ORMUtil;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractServiceDataHandlePlugin;

public final class ScCheckAuditWriteBackService
extends AbstractServiceDataHandlePlugin {
    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
    }

    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dyn = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        DynamicObject[] dynamicObjects = assembleHandleArgs.getDynamicObjects();
        ArrayList<Long> billIdList = new ArrayList<Long>();
        ArrayList<Long> entryIdList = new ArrayList<Long>();
        HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
        for (DynamicObject bill : dyn) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            HashSet<String> srcBillTypeSet = new HashSet<String>((int)((double)materialentry.size() / 0.75));
            for (DynamicObject entry : materialentry) {
                String srcbilltype = entry.getString("srcbilltype");
                srcBillTypeSet.add(srcbilltype);
                String srcbillid = entry.getString("srcbillid");
                billIdList.add(Long.parseLong(srcbillid));
                String srcentryid = entry.getString("srcentryid");
                entryIdList.add(Long.parseLong(srcentryid));
            }
            String billno = bill.getString("billno");
            HashMap<String, String> idOpTypeMap = new HashMap<String, String>();
            if ("C".equals(bill.getString("billstatus"))) {
                idOpTypeMap.put("opType", "Y");
                idOpTypeMap.put("checkNo", billno);
            } else {
                idOpTypeMap.put("opType", "N");
                idOpTypeMap.put("checkNo", "");
            }
            for (String srcBillType : srcBillTypeSet) {
                this.getReqParam(idOpTypeMap, dataMap, srcBillType, billIdList, entryIdList);
            }
        }
        XkParamArgs scDataHandleArgs = (XkParamArgs)this.getScDataHandleArgs();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("data", dataMap);
        param.put("action", scDataHandleArgs.getAction());
        param.put("code", "200");
        this.logger.info(((Object)param).toString());
        XkParamArgs xkParamArgs = new XkParamArgs();
        xkParamArgs.setDataServiceId(this.getScDataServiceInfo().getServiceId());
        xkParamArgs.setMethod(scDataHandleArgs.getMethod());
        xkParamArgs.setParamMap(param);
        xkParamArgs.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParamArgs);
    }

    private void getReqParam(Map<String, String> idOpTypeMap, HashMap<String, Map<String, Object>> dataMap, String srcBillType, List<Long> billIdList, List<Long> entryIdList) {
        DynamicObject[] col;
        String selectFields = "materialentry.id,materialentry.srcbilltype,materialentry.srcbillid,materialentry.srcentryid";
        HashMap params = new HashMap();
        if (!billIdList.isEmpty()) {
            HashMap<String, List<Long>> billIdParam = new HashMap<String, List<Long>>(1);
            billIdParam.put("in", billIdList);
            params.put("id", billIdParam);
        }
        for (DynamicObject bill : col = ORMUtil.load((String)srcBillType, (String)selectFields, params)) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            HashMap entryMap = new HashMap();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
            HashMap<String, String> reconciliationMap = new HashMap<String, String>();
            String srcbillId = "";
            String xkBillType = "";
            String billType = bill.getDataEntityType().getName();
            if (entrys != null && !entrys.isEmpty()) {
                xkBillType = this.getXKBillType(((DynamicObject)entrys.get(0)).getString("srcbilltype"), billType);
                srcbillId = ((DynamicObject)entrys.get(0)).getString("srcbillId");
                for (DynamicObject entry : entrys) {
                    Long entryId = (Long)entry.getPkValue();
                    if (!entryIdList.contains(entryId)) continue;
                    reconciliationMap.put("F_CQ_IsReconciliation", idOpTypeMap.get("opType"));
                    reconciliationMap.put("F_CQ_ReconciliationBillNo", idOpTypeMap.get("checkNo"));
                    entryMap.put(entry.getString("srcentryid"), reconciliationMap);
                }
            }
            infoMap.put("entry", entryMap);
            infoMap.put("XK_billType", xkBillType);
            dataMap.put(srcbillId, infoMap);
        }
    }

    private String getXKBillType(String entrySrcbillType, String billType) {
        switch (billType) {
            case "pur_instock": 
            case "scp_instock": {
                return "STK_InStock";
            }
            case "pur_return": 
            case "scp_return": {
                return "PUR_MRB";
            }
        }
        if ("pur_receipt".equals(billType) || "scp_receipt".equals(billType)) {
            if ("pur_receipt_return".equals(entrySrcbillType) || "scp_return_receipt".equals(entrySrcbillType)) {
                return "PUR_MRB";
            }
            return "PUR_ReceiveBill";
        }
        return "";
    }
}

