/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.invcloud;

import com.alibaba.fastjson.JSON;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.invcloud.KingdeeInvoiceCloudConfig;
import kd.scm.common.invcloud.bean.AwsCheckInvoiceCloudResp;
import kd.scm.common.invcloud.bean.InvoiceCloudResp;
import kd.scm.common.invcloud.bean.InvoiceData;
import kd.scm.common.invcloud.bean.aws.InvoiceCloudCfg;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.AwsMD5Util;

public class AwsInvoiceCloudServiceHelper {
    private static final String KD_SRM_AWS_CACHE = "KD_SRM_AWS_CACHE";
    private static final String KD_SRM_AWS_GETLINKKEY = "KD_SRM_AWS_GETLINKKEY";
    private static final String KD_SRM_AWS_GETUSERKEY = "KD_SRM_AWS_GETUSERKEY";
    private static final String KD_SRM_AWS_INVOICE_SAVE = "KD_SRM_AWS_INVOICE_SAVE";
    private static final String KD_SRM_AWS_UPDATESTATUS = "KD_SRM_AWS_UPDATESTATUS";
    private static final String KD_SRM_AWS_DELETEINVOICE = "KD_SRM_AWS_DELETEINVOICE";
    private static final String KD_SRM_AWS_INVOICE_QUERY = "KD_SRM_AWS_INVOICE_QUERY";
    private static final String KD_SRM_AWS_GETTOKEN = "KD_SRM_AWS_GETTOKEN";
    private static final String KD_SRM_AWS_CHECKINVOICE = "KD_SRM_AWS_CHECKINVOICE";
    public static final String BXD_KEY_SUFFIX = "pur_invoice_";
    private static final Random rand = new SecureRandom();
    private static final String INVOICE_PAGE_SELECT_INVOICE = "selectInvoice";
    private static Log logger = LogFactory.getLog(AwsInvoiceCloudServiceHelper.class);
    private static final String INVOICE_PAGE_ON_PC = "onPC";
    private static final String INVOICE_PAGE_ACTION_TYPE = "actionType";
    private static final String PUR_AWSINVOICE_PAGE = "pur_awsinvoice_page";

    public static boolean hasInvCloudConfig(DynamicObject org) {
        Long orgId = (Long)org.getPkValue();
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        return config != null && ApiConfigUtil.hasInvCloudConfig();
    }

    public static void showImportInvoice(AbstractFormPlugin plugin, DynamicObject bill, Collection<String> serialNos) {
        FormShowParameter parameter = new FormShowParameter();
        Long pkValue = (Long)bill.getPkValue();
        String invId = BXD_KEY_SUFFIX + String.valueOf(pkValue);
        String billNo = bill.getString("billNo");
        String timestamp = String.valueOf(System.currentTimeMillis());
        String linkKey = AwsInvoiceCloudServiceHelper.getLinkKey();
        DynamicObject org = bill.getDynamicObject("org");
        Long invoiceOrgId = (Long)org.getPkValue();
        String userKey = AwsInvoiceCloudServiceHelper.getUserKey(invoiceOrgId, null, invId, billNo, timestamp);
        String gridParam = KingdeeInvoiceCloudConfig.gridParam();
        AwsInvoiceCloudServiceHelper.cacheRelation(invoiceOrgId, serialNos, invId, billNo, timestamp);
        HashMap<String, Object> customParam = new HashMap<String, Object>(8);
        customParam.put(INVOICE_PAGE_ACTION_TYPE, INVOICE_PAGE_SELECT_INVOICE);
        customParam.put(INVOICE_PAGE_ON_PC, Boolean.TRUE);
        customParam.put("linkKey", linkKey);
        customParam.put("userKey", userKey);
        customParam.put("bxd_key", invId);
        customParam.put("billNumber", billNo);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("gridParam", gridParam);
        param.put("linkKey", linkKey);
        param.put("userKey", userKey);
        param.put("sourceType", "socket");
        param.put("timestamp", timestamp);
        param.put("optMode", "0");
        param.put("invoiceCompanyId", invoiceOrgId);
        customParam.put("importInvoiceIframeUrlReqParam", JSON.toJSONString(param));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("800");
        styleCss.setHeight("530");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, INVOICE_PAGE_SELECT_INVOICE);
        parameter.setFormId(PUR_AWSINVOICE_PAGE);
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getCustomParams().putAll(customParam);
        parameter.setShowTitle(false);
        parameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(parameter);
    }

    public static void viewInvoiceList(AbstractFormPlugin formPlugin, DynamicObject bill, Collection<String> serialNos, String actionType) {
        FormShowParameter parameter = new FormShowParameter();
        Long pkValue = (Long)bill.getPkValue();
        String invId = BXD_KEY_SUFFIX + String.valueOf(pkValue);
        String billNo = bill.getString("billNo");
        String timestamp = String.valueOf(System.currentTimeMillis());
        logger.info("\u8c03\u7528\u524d\u7aef\u67e5\u770b\u53d1\u7968\u5217\u8868\u754c\u9762>>> serialNosKey:" + invId + ", serialNos:" + serialNos);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put(INVOICE_PAGE_ACTION_TYPE, actionType);
        customParam.put("serialNo", String.join((CharSequence)",", serialNos));
        HashMap<String, String> showInvoiceParam = new HashMap<String, String>();
        showInvoiceParam.put("serialNo", String.join((CharSequence)",", serialNos));
        DynamicObject org = bill.getDynamicObject("org");
        Long invoiceOrgId = (Long)org.getPkValue();
        String userKey = AwsInvoiceCloudServiceHelper.getUserKey(invoiceOrgId, serialNos, invId, billNo, timestamp);
        customParam.put("userKey", userKey);
        showInvoiceParam.put("userKey", userKey);
        customParam.put("showInvoiceUrlReqParam", JSON.toJSON(showInvoiceParam));
        parameter.setFormId(PUR_AWSINVOICE_PAGE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption("");
        parameter.setShowTitle(false);
        parameter.getCustomParams().putAll(customParam);
        formPlugin.getView().showForm(parameter);
    }

    private static String getLinkKey() {
        String uri = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("uri", uri);
        try {
            InvoiceCloudResp invoiceDetailReturnVO;
            Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_GETLINKKEY, param);
            if (response != null && (invoiceDetailReturnVO = (InvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), InvoiceCloudResp.class)) != null && invoiceDetailReturnVO.isSuccess()) {
                String linkKey = invoiceDetailReturnVO.getLinkKey();
                logger.info("getLinkKey is success!");
                return linkKey;
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u83b7\u53d6linkKey\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"AwsInvoiceCloudServiceHelper_0", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        return null;
    }

    private static String getUserKey(Long invoiceOrgId, Collection<String> serialNos, String invId, String billNo, String timestamp) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(invoiceOrgId);
        if (config == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u53d1\u7968\u4e91\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"AwsInvoiceCloudServiceHelper_1", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        Map<String, Object> param = AwsInvoiceCloudServiceHelper.getInvoicePCPageCommonParams(config, timestamp);
        param.put("billNumber", billNo);
        param.put("bxd_key", invId);
        param.put("ticketParam", config.genTicketParam());
        String companyName = invoiceOrgId != null ? config.getFirmname() : "No company name";
        param.put("ghf_mc", companyName);
        String gridParam = KingdeeInvoiceCloudConfig.gridParam();
        param.put("gridParam", gridParam);
        if (serialNos != null) {
            param.put("invoiceSerialNos", String.join((CharSequence)",", serialNos));
        }
        param.put("resoure", "4");
        param.put("billType", "");
        String uri = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        param.put("uri", uri);
        try {
            InvoiceCloudResp invoiceDetailReturnVO;
            Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_GETUSERKEY, param);
            if (response != null && (invoiceDetailReturnVO = (InvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), InvoiceCloudResp.class)) != null && invoiceDetailReturnVO.isSuccess()) {
                String userKey = invoiceDetailReturnVO.getUserKey();
                logger.info("getUserKey is success!");
                return userKey;
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u83b7\u53d6userKey\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"AwsInvoiceCloudServiceHelper_2", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        return null;
    }

    private static String cacheRelation(Long invoiceOrgId, Collection<String> serialNos, String invId, String billNo, String timestamp) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(invoiceOrgId);
        Map<String, Object> param = AwsInvoiceCloudServiceHelper.getInvoicePCPageCommonParams(config, timestamp);
        param.put("billnumber", billNo);
        param.put("bxd_key", invId);
        if (serialNos != null) {
            HashMap<String, Collection<String>> fid = new HashMap<String, Collection<String>>(8);
            fid.put("fid", serialNos);
            param.put("data", new Object[]{fid});
        }
        param.put("billType", "");
        String uri = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        param.put("uri", uri);
        try {
            InvoiceCloudResp invoiceDetailReturnVO;
            Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_CACHE, param);
            if (response != null && (invoiceDetailReturnVO = (InvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), InvoiceCloudResp.class)) != null && invoiceDetailReturnVO.isSuccess()) {
                String userKey = invoiceDetailReturnVO.getUserKey();
                logger.info("getUserKey is success!");
                return userKey;
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u83b7\u53d6\u5173\u7cfb\u540c\u6b65\u5355\u636e\u53d1\u7968\u5173\u7cfb\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"AwsInvoiceCloudServiceHelper_10", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        return null;
    }

    private static Map<String, Object> getInvoicePCPageCommonParams(InvoiceCloudCfg config, String timestamp) {
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        String taxRegNum = config.getTaxRegnum();
        String client_id = config.getClientId();
        String client_secret = config.getClientSecret();
        HashMap<String, Object> urlParams = new HashMap<String, Object>(8);
        urlParams.put("timestamp", timestamp);
        urlParams.put("client_id", client_id);
        urlParams.put("tin", taxRegNum);
        String rawSign = client_id + client_secret + timestamp;
        urlParams.put("sign", AwsMD5Util.md5crypt(rawSign));
        urlParams.put("encType", 0);
        urlParams.put("eid", userId);
        urlParams.put("random", String.valueOf(rand.nextInt(Integer.MAX_VALUE)));
        urlParams.put("reqid", AwsInvoiceCloudServiceHelper.getRequestId());
        return urlParams;
    }

    public static InvoiceCloudResp saveInvoice(Long orgId, String billNo, String billId, Map<String, Object> data) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        String uri = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        long timestamp = new Date().getTime();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uri", uri);
        param.put("userKey", "");
        param.put("eid", userId);
        param.put("billTypeId", "");
        param.put("billnumber", billNo);
        param.put("bxd_key", billId);
        param.put("client_id", config.getClientId());
        param.put("tin", config.getTaxRegnum());
        param.put("timestamp", timestamp);
        String raw_sign = config.getClientId() + config.getClientSecret() + timestamp;
        param.put("sign", AwsMD5Util.md5crypt(raw_sign));
        param.put("data", Collections.singletonList(data));
        try {
            Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_INVOICE_SAVE, param);
            if (response != null) {
                InvoiceCloudResp invoiceDetailReturnVO = (InvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), InvoiceCloudResp.class);
                if (invoiceDetailReturnVO != null && invoiceDetailReturnVO.isSuccess()) {
                    logger.info("save is success!");
                    return invoiceDetailReturnVO;
                }
                if (invoiceDetailReturnVO != null) {
                    logger.info("save is error! " + invoiceDetailReturnVO.getDescription() + "(" + invoiceDetailReturnVO.getErrcode() + ")");
                    return invoiceDetailReturnVO;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u4fdd\u5b58\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"AwsInvoiceCloudServiceHelper_3", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        return null;
    }

    public static InvoiceCloudResp updateInvoiceStatus(Long orgId, String billNo, String billId, String expenseStatus, List<Object> data, Map<String, Object> extendParam) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        String uri = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        long timestamp = new Date().getTime();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String taxNo = config.getTaxRegnum();
        param.put("uri", uri);
        param.put("userKey", "");
        param.put("timestamp", timestamp);
        param.put("tin", taxNo);
        param.put("eid", userId);
        param.put("client_id", config.getClientId());
        String raw_sign = config.getClientId() + config.getClientSecret() + timestamp;
        param.put("sign", AwsMD5Util.md5crypt(raw_sign));
        param.put("expenseStatus", expenseStatus);
        param.put("ticketParam", KingdeeInvoiceCloudConfig.getTicketParam(orgId));
        param.put("billnumber", billNo);
        param.put("bxd_key", billId);
        param.put("billTypeId", "");
        param.put("resource", "4");
        if (!ObjectUtils.isEmpty(data)) {
            param.put("invoiceData", data);
        }
        if (!ObjectUtils.isEmpty(extendParam)) {
            param.putAll(extendParam);
        }
        try {
            Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_UPDATESTATUS, param);
            if (response != null) {
                InvoiceCloudResp invoiceDetailReturnVO = (InvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), InvoiceCloudResp.class);
                if (invoiceDetailReturnVO != null && invoiceDetailReturnVO.isSuccess()) {
                    logger.info("updateInvoiceStatus is success!");
                    return invoiceDetailReturnVO;
                }
                if (invoiceDetailReturnVO != null) {
                    logger.info("updateInvoiceStatus is error! " + invoiceDetailReturnVO.getDescription() + "(" + invoiceDetailReturnVO.getErrcode() + ")");
                    return invoiceDetailReturnVO;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u66f4\u65b0\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"AwsInvoiceCloudServiceHelper_4", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        return null;
    }

    public static InvoiceCloudResp deleteInvoice(Long orgId, String billNo, String billId) {
        String uri = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        long timestamp = new Date().getTime();
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        String taxNo = config.getTaxRegnum();
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("uri", uri);
        param.put("userKey", "");
        param.put("timestamp", timestamp);
        param.put("sign", AwsMD5Util.md5crypt(config.getClientId() + config.getClientSecret() + timestamp));
        param.put("client_id", config.getClientId());
        param.put("billnumber", billNo);
        param.put("bxd_key", BXD_KEY_SUFFIX + billId);
        param.put("tin", taxNo);
        param.put("eid", "");
        param.put("billTypeId", "");
        try {
            Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_DELETEINVOICE, param);
            if (response != null) {
                InvoiceCloudResp invoiceDetailReturnVO = (InvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), InvoiceCloudResp.class);
                if (invoiceDetailReturnVO != null && invoiceDetailReturnVO.isSuccess()) {
                    logger.info("deleteInvoice is success!");
                    return invoiceDetailReturnVO;
                }
                if (invoiceDetailReturnVO != null) {
                    logger.info("deleteInvoice is error! " + invoiceDetailReturnVO.getDescription() + "(" + invoiceDetailReturnVO.getErrcode() + ")");
                    return invoiceDetailReturnVO;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u5220\u9664\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"AwsInvoiceCloudServiceHelper_5", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        return null;
    }

    public static String getRequestId() {
        int randdom = rand.nextInt(900) + 100;
        String reqId = String.format("%d%d", System.currentTimeMillis(), randdom);
        return reqId;
    }

    public static List<InvoiceData> queryCloudInvoice(Long orgId, String serialNos) {
        String uri = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        long timestamp = new Date().getTime();
        if (StringUtils.isBlank((String)serialNos)) {
            logger.info("\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
        }
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        String token = AwsInvoiceCloudServiceHelper.getToken(orgId, timestamp, uri);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("serialNo", serialNos);
        param.put("taxNo", config.getTaxRegnum());
        param.put("companyName", config.getFirmname());
        param.put("ticketParam", config.genTicketParam());
        param.put("uri", uri);
        param.put("access_token", token);
        param.put("bxd_key", null);
        try {
            InvoiceCloudResp invoiceDetailReturnVO;
            Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_INVOICE_QUERY, param);
            if (response != null && (invoiceDetailReturnVO = (InvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), InvoiceCloudResp.class)) != null && invoiceDetailReturnVO.isSuccess()) {
                return invoiceDetailReturnVO.getData();
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u67e5\u8be2\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"AwsInvoiceCloudServiceHelper_6", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        return null;
    }

    public static String getToken(Long orgId, Long timestamp, String uri) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        String client_id = config.getClientId();
        String client_secret = config.getClientSecret();
        String raw_sign = client_id + client_secret + timestamp;
        String sign = AwsMD5Util.md5crypt(raw_sign);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("client_id", client_id);
        param.put("sign", sign);
        param.put("timestamp", timestamp);
        param.put("uri", uri);
        String description = "";
        Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_GETTOKEN, param);
        if (response != null) {
            InvoiceCloudResp invoiceDetailReturnVO = (InvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), InvoiceCloudResp.class);
            if (invoiceDetailReturnVO != null && invoiceDetailReturnVO.isSuccess()) {
                return invoiceDetailReturnVO.getAccess_token();
            }
            if (invoiceDetailReturnVO != null) {
                description = invoiceDetailReturnVO.getDescription();
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u516c\u53f8id: {0}\uff0c\u5931\u8d25\u539f\u56e0: {1}\u3002", (String)"AwsInvoiceCloudServiceHelper_9", (String)"scm-sccore-common", (Object[])new Object[]{orgId.toString(), description}));
    }

    public static AwsCheckInvoiceCloudResp checkInvoice(String billId, Long orgId, String checkBuyerName, String checkBuyerTaxNo, Object[] data) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        String uri = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uri", uri);
        param.put("clientId", config.getClientId());
        param.put("expenseId", billId);
        param.put("expenseStatus", "1");
        param.put("ticketParam", KingdeeInvoiceCloudConfig.getTicketParam(orgId));
        param.put("checkBuyerName", checkBuyerName);
        param.put("checkBuyerTaxNo", checkBuyerTaxNo);
        if (!ObjectUtils.isEmpty((Object[])data)) {
            param.put("invoiceData", data);
        }
        long timestamp = System.currentTimeMillis();
        String token = AwsInvoiceCloudServiceHelper.getToken(orgId, timestamp, uri);
        param.put("access_token", token);
        try {
            Object response = AwsInvoiceCloudServiceHelper.callWebApi(KD_SRM_AWS_CHECKINVOICE, param);
            if (response != null) {
                AwsCheckInvoiceCloudResp invoiceDetailReturnVO = (AwsCheckInvoiceCloudResp)JSON.parseObject((String)JSON.toJSONString((Object)response), AwsCheckInvoiceCloudResp.class);
                if (invoiceDetailReturnVO != null && invoiceDetailReturnVO.isSuccess()) {
                    logger.info("checkInvoice is success!");
                    return invoiceDetailReturnVO;
                }
                if (invoiceDetailReturnVO != null) {
                    logger.info("checkInvoice is error! " + invoiceDetailReturnVO.getDescription() + "(" + invoiceDetailReturnVO.getErrcode() + ")");
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u67e5\u9a8c\u53d1\u7968\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u539f\u56e0\uff1a{0}\u3002", (String)"AwsInvoiceCloudServiceHelper_7", (String)"scm-sccore-common", (Object[])new Object[]{invoiceDetailReturnVO.getDescription()}));
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return null;
    }

    public static Object callWebApi(String platformapiNumber, Map<String, Object> params) {
        Object result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscApicService", (String)"invokeScriptApi2", (Object[])new Object[]{platformapiNumber, params, null});
        return result;
    }
}

