/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.invcloud;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scm.common.invcloud.AwsInvoiceCloudServiceHelper;
import kd.scm.common.invcloud.InvoiceCloudServiceHelper;
import kd.scm.common.invcloud.KingdeeInvoiceCloudConfig;
import kd.scm.common.invcloud.bean.AwsCheckInvoiceCloudResp;
import kd.scm.common.invcloud.bean.InvocieReqParam;
import kd.scm.common.invcloud.bean.InvoiceCloudResp;
import kd.scm.common.invcloud.bean.InvoiceData;
import kd.scm.common.invcloud.bean.ValidateInvocieReqParam;
import kd.scm.common.invcloud.bean.ValidateInvocieRespParam;
import kd.scm.common.invcloud.bean.aws.AwsCheckInvoiceData;
import kd.scm.common.invcloud.enums.InvSourceEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ParamUtil;

public class InvoiceCloudHelper {
    private static final String RIM_FPZS_MAIN = "rim_fpzs_main";
    private static final String RIM_VIEW_INVOICE = "rim_view_invoice";

    public static void showSelectedInvoicePage(AbstractFormPlugin plugin, IDataModel model, String closeCallBackKey, Set<String> serialNos) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            Long orgId = (Long)org.getPkValue();
            InvoiceCloudServiceHelper.showImportInvoice(plugin, model, RIM_FPZS_MAIN, orgId, closeCallBackKey);
        } else {
            AwsInvoiceCloudServiceHelper.showImportInvoice(plugin, dataEntity, serialNos);
        }
    }

    public static boolean isEnableXhInvoiceCloud() {
        String isenableinvcloudStr;
        Object isenableinvcloud = ParamUtil.getParamObj((String)"eae607fb000143ac", (String)"invoicecloudxh");
        return isenableinvcloud == null || !"aws".equals(isenableinvcloudStr = String.valueOf(isenableinvcloud));
    }

    public static boolean hasInvCloudConfig(DynamicObject org) {
        if (org == null) {
            return false;
        }
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            return InvoiceCloudServiceHelper.hasInvCloudConfig(org);
        }
        return AwsInvoiceCloudServiceHelper.hasInvCloudConfig(org);
    }

    public static void showInvoiceList(AbstractFormPlugin plugin, IDataModel model, Set<String> serialNos, String actionType) {
        DynamicObject dataEntity = model.getDataEntity(true);
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            InvoiceCloudServiceHelper.viewInvoiceList(plugin, model, RIM_VIEW_INVOICE, serialNos);
        } else {
            AwsInvoiceCloudServiceHelper.viewInvoiceList(plugin, dataEntity, serialNos, actionType);
        }
    }

    public static InvoiceCloudResp invoiceSave(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        if (!InvoiceCloudHelper.hasInvCloudConfig(org)) {
            return null;
        }
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            return InvoiceCloudHelper.invoiceCloudSave(bill, org);
        }
        return InvoiceCloudHelper.saveInvoice(bill);
    }

    public static void deleteInvoice(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        if (!InvoiceCloudHelper.hasInvCloudConfig(org)) {
            return;
        }
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            InvoiceCloudServiceHelper.delete(bill.getPkValue());
        } else {
            String invBillId = String.valueOf(bill.getPkValue());
            Long orgId = bill.getDynamicObject("org").getLong("id");
            String billno = bill.getString("billno");
            AwsInvoiceCloudServiceHelper.deleteInvoice(orgId, billno, invBillId);
        }
    }

    private static InvoiceCloudResp saveInvoice(DynamicObject bill) {
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        ArrayList<String> serialNos = new ArrayList<String>(8);
        String invBillId = "pur_invoice_" + String.valueOf(bill.getPkValue());
        Long orgId = bill.getDynamicObject("org").getLong("id");
        String billno = bill.getString("billno");
        DynamicObjectCollection invEntries = bill.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)invEntries)) {
            for (DynamicObject invEntry : invEntries) {
                String invserialnum = invEntry.getString("invserialnum");
                serialNos.add(invserialnum);
            }
        }
        if (!CollectionUtils.isEmpty(serialNos)) {
            data.put("entryid", invBillId);
            data.put("fid", serialNos.toArray());
            data.put("costTypeId", "");
            data.put("costTypeName", "");
            InvoiceCloudResp resp = AwsInvoiceCloudServiceHelper.saveInvoice(orgId, billno, invBillId, data);
            AwsInvoiceCloudServiceHelper.updateInvoiceStatus(orgId, billno, invBillId, "1", null, null);
            return resp;
        }
        return null;
    }

    public static List<ValidateInvocieRespParam> check(DynamicObject bill, List<DynamicObject> invoiceList) {
        if (CollectionUtils.isEmpty(invoiceList)) {
            return new ArrayList<ValidateInvocieRespParam>(8);
        }
        DynamicObject org = bill.getDynamicObject("org");
        if (!InvoiceCloudHelper.hasInvCloudConfig(org)) {
            return new ArrayList<ValidateInvocieRespParam>(8);
        }
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            return InvoiceCloudHelper.xhInvoiceCheck(bill, invoiceList);
        }
        return InvoiceCloudHelper.awsInvoiceCheck(bill, invoiceList, org);
    }

    private static List<ValidateInvocieRespParam> xhInvoiceCheck(DynamicObject bill, List<DynamicObject> invoiceList) {
        ArrayList<ValidateInvocieRespParam> list = new ArrayList<ValidateInvocieRespParam>(8);
        for (DynamicObject dynamicObject : invoiceList) {
            String invserialnum = dynamicObject.getString("invserialnum");
            String invno = dynamicObject.getString("invno");
            ValidateInvocieReqParam request = new ValidateInvocieReqParam();
            if (StringUtils.isNotEmpty((String)invserialnum)) {
                request.setSerialNo(invserialnum);
            }
            Long pkValue = (Long)bill.getPkValue();
            request.setRealBillId(pkValue);
            ValidateInvocieRespParam check = InvoiceCloudServiceHelper.check(request);
            check.setInvoiceNo(invno);
            list.add(check);
        }
        return list;
    }

    private static List<ValidateInvocieRespParam> awsInvoiceCheck(DynamicObject bill, List<DynamicObject> invoiceList, DynamicObject org) {
        ArrayList<ValidateInvocieRespParam> list = new ArrayList<ValidateInvocieRespParam>(8);
        Long orgId = org.getLong("id");
        String checkBuyerName = org.getString("ffirmname");
        String checkBuyerTaxNo = org.getString("ftaxregnum");
        String invBillId = "pur_invoice_" + String.valueOf(bill.getPkValue());
        Object[] paramlist = new Object[invoiceList.size()];
        for (int i = 0; i < invoiceList.size(); ++i) {
            DynamicObject dynamicObject = invoiceList.get(i);
            String invserialnum = dynamicObject.getString("invserialnum");
            String invcode = dynamicObject.getString("invcode");
            String invno = dynamicObject.getString("invno");
            String invid = dynamicObject.getString("invid");
            Date invdate = dynamicObject.getDate("invdate");
            String invoiceDate = DateUtil.date2str((Date)invdate, (String)"yyyy-MM-dd");
            BigDecimal invoiceAmount = dynamicObject.getBigDecimal("invoiceamount");
            BigDecimal totalAmount = dynamicObject.getBigDecimal("invamount");
            HashMap<String, String> invoiceCheckParam = new HashMap<String, String>();
            invoiceCheckParam.put("invoiceAmount", invoiceAmount.toString());
            invoiceCheckParam.put("totalAmount", totalAmount.toString());
            invoiceCheckParam.put("serialNo", invserialnum);
            invoiceCheckParam.put("invoiceCode", invcode);
            invoiceCheckParam.put("invoiceNo", invno);
            invoiceCheckParam.put("invoiceDate", invoiceDate);
            invoiceCheckParam.put("checkCode", invid);
            paramlist[i] = invoiceCheckParam;
        }
        AwsCheckInvoiceCloudResp invoiceResp = AwsInvoiceCloudServiceHelper.checkInvoice(invBillId, orgId, checkBuyerName, checkBuyerTaxNo, paramlist);
        if (invoiceResp != null && invoiceResp.isSuccess()) {
            List<AwsCheckInvoiceData> invoiceData = invoiceResp.getData();
            for (AwsCheckInvoiceData invoice : invoiceData) {
                ValidateInvocieRespParam resp = new ValidateInvocieRespParam();
                if (!invoice.isSuccess()) {
                    resp.setPass(false);
                    resp.setMsg(invoice.getDescription());
                    resp.setInvoiceNo(invoice.getInvoiceNo());
                    list.add(resp);
                    continue;
                }
                resp.setSerialNo(invoice.getSerialNo());
                resp.setInvoiceNo(invoice.getInvoiceNo());
                if (!StringUtils.isBlank((String)invoice.getTotalAmount())) {
                    resp.setInvoiceAmount(new BigDecimal(invoice.getTotalAmount()));
                }
                if (!StringUtils.isBlank((String)invoice.getTotalTaxAmount())) {
                    resp.setTotalTaxAmount(new BigDecimal(invoice.getTotalTaxAmount()));
                }
                if (!StringUtils.isBlank((String)invoice.getTotalAmount())) {
                    resp.setTotalAmount(new BigDecimal(invoice.getTotalAmount()));
                }
                resp.setBuyerName(invoice.getBuyerName());
                resp.setBuyerTaxNo(invoice.getBuyerTaxNo());
                resp.setSalerName(invoice.getSalerName());
                resp.setSalerTaxNo(invoice.getSalerTaxNo());
                resp.setCheckCode(invoice.getCheckCode());
                resp.setMsg(invoiceResp.getDescription());
                if (invoiceResp.isSuccess()) {
                    resp.setPass(true);
                }
                list.add(resp);
            }
        }
        return list;
    }

    public static boolean signInvoice(DynamicObject bill, List<String> serialNos) {
        DynamicObject org = bill.getDynamicObject("org");
        if (InvoiceCloudHelper.hasInvCloudConfig(org)) {
            if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
                return InvoiceCloudServiceHelper.signInvoice(serialNos);
            }
            return true;
        }
        return true;
    }

    public static boolean unsignInvoice(DynamicObject bill, List<String> serialNos) {
        DynamicObject org = bill.getDynamicObject("org");
        if (InvoiceCloudHelper.hasInvCloudConfig(org)) {
            if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
                return InvoiceCloudServiceHelper.unSignInvoice(serialNos);
            }
            return true;
        }
        return true;
    }

    private static InvoiceCloudResp invoiceCloudSave(DynamicObject bill, DynamicObject org) {
        ArrayList<InvoiceData> invoiceDatas = new ArrayList<InvoiceData>();
        DynamicObjectCollection entryentityCol = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryentity : entryentityCol) {
            String invsource = InvSourceEnum.fromVal(entryentity.getString("invsource")).getVal();
            if (!InvSourceEnum.INVOICECLOUD.getVal().equals(invsource)) continue;
            String invserialnum = entryentity.getString("invserialnum");
            InvoiceData invoiceData = new InvoiceData();
            invoiceData.setSerialNo(invserialnum);
            invoiceDatas.add(invoiceData);
        }
        if (!invoiceDatas.isEmpty()) {
            InvocieReqParam invocieReqParam = new InvocieReqParam();
            String billNo = bill.getString("billno");
            invocieReqParam.setBillNo(billNo);
            invocieReqParam.setBillId(bill.getPkValue().toString());
            invocieReqParam.setOrgId(org.getPkValue().toString());
            invocieReqParam.setInvoiceData(invoiceDatas);
            InvoiceCloudResp queryInvoiceResp = InvoiceCloudServiceHelper.save(invocieReqParam);
            if (!"0000".equals(queryInvoiceResp.getErrcode())) {
                String desc = MessageFormat.format(ResManager.loadKDString((String)"\u5f00\u7968\u5355{0}\u5ba1\u6838\u65f6\u4fdd\u6301\u62a5\u9500\u5355\u5173\u7cfb\u5f02\u5e38\u3002", (String)"InvoiceCloudHelper_0", (String)"scm-sccore-common", (Object[])new Object[0]), billNo);
                queryInvoiceResp.setDescription(desc);
            }
            return queryInvoiceResp;
        }
        return null;
    }
}

