/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.invcloud;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.invcloud.bean.InvocieReqParam;
import kd.scm.common.invcloud.bean.InvoiceCloudResp;
import kd.scm.common.invcloud.bean.InvoiceData;
import kd.scm.common.invcloud.bean.ValidateInvocieCloudResp;
import kd.scm.common.invcloud.bean.ValidateInvocieReqParam;
import kd.scm.common.invcloud.bean.ValidateInvocieRespParam;
import kd.scm.common.util.ApiConfigUtil;

public class InvoiceCloudServiceHelper {
    private static Log logger = LogFactory.getLog(InvoiceCloudServiceHelper.class);
    public static final String OK_CODE = "0000";
    private static final String ENTITYID = "pur_invoice";
    private static final String APPID = "pur";

    public static void showImportInvoice(AbstractFormPlugin formPlugin, IDataModel model, String formId, Long orgId, String callBackKey) {
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        DynamicObject dataEntity = model.getDataEntity(true);
        Object pkValue = dataEntity.getPkValue();
        customParam.put("billType", ENTITYID);
        customParam.put("billNo", model.getValue("billno"));
        customParam.put("billId", pkValue != null ? pkValue.toString() : null);
        customParam.put("entityId", ENTITYID);
        customParam.put("viewPage", ENTITYID);
        customParam.put("orgId", orgId);
        customParam.put("resource", "4");
        DynamicObject org = dataEntity.getDynamicObject("org");
        String purname = org.getString("ffirmname");
        String purtaxno = org.getString("ftaxregnum");
        if (StringUtils.isEmpty((String)purname) || StringUtils.isEmpty((String)purtaxno)) {
            customParam.put("isOperation", true);
        } else {
            ArrayList companyInfo = new ArrayList(16);
            HashMap<String, String> mapCompany = new HashMap<String, String>();
            mapCompany.put("taxNo", purtaxno);
            mapCompany.put("name", purname);
            companyInfo.add(mapCompany);
            customParam.put("companyInfo", companyInfo);
        }
        FormShowParameter param = new FormShowParameter();
        logger.info("\u661f\u701a\u53d1\u7968\u4e91\u5bfc\u5165\u53d1\u7968\uff0ccustomParam: {}", (Object)JSONObject.toJSONString(customParam));
        param.setCustomParams(customParam);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(formId);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, callBackKey));
        formPlugin.getView().showForm(param);
    }

    public static void viewInvoiceList(AbstractFormPlugin formPlugin, IDataModel model, String formId, Collection<String> serialNos) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        Object pkId = model.getDataEntity().getPkValue();
        if (pkId != null) {
            customParams.put("billId", pkId.toString());
        }
        customParams.put("entityId", ENTITYID);
        if (serialNos != null && !serialNos.isEmpty()) {
            ArrayList<String> serialNoList = new ArrayList<String>(serialNos.size());
            serialNoList.addAll(serialNos);
            customParams.put("serialNos", serialNoList);
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.NewWindow);
        param.setFormId(formId);
        logger.info("\u67e5\u770b\u53d1\u7968\uff0c\u53c2\u6570customParams\u4e3a\uff1a{}", customParams);
        formPlugin.getView().showForm(param);
    }

    public static ValidateInvocieRespParam check(ValidateInvocieReqParam request) {
        InvoiceData invoice;
        List<InvoiceData> invoiceDatas;
        InvoiceCloudResp data;
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("entityId", ENTITYID);
        param.put("billId", String.valueOf(request.getRealBillId()));
        if (!StringUtils.isEmpty((String)request.getSerialNo())) {
            param.put("serialNo", request.getSerialNo());
        }
        logger.info("\u67e5\u9a8c\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(param));
        Object resultJson = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"check", (Object[])new Object[]{param});
        logger.info("\u67e5\u9a8c\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(param), (Object)JSONObject.toJSONString((Object)resultJson));
        ValidateInvocieCloudResp queryInvoiceResp = (ValidateInvocieCloudResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultJson), ValidateInvocieCloudResp.class);
        ValidateInvocieRespParam result = new ValidateInvocieRespParam();
        if (OK_CODE.equals(queryInvoiceResp.getErrcode()) && (data = queryInvoiceResp.getData()) != null && (invoiceDatas = data.getData()) != null && !invoiceDatas.isEmpty() && (invoice = invoiceDatas.get(0)) != null) {
            result.setSerialNo(invoice.getSerialNo());
            result.setInvoiceNo(invoice.getInvoiceNo());
            result.setInvoiceAmount(invoice.getAmount());
            result.setTotalTaxAmount(invoice.getTaxAmount());
            result.setTotalAmount(invoice.getTotalAmount());
            result.setBuyerName(invoice.getBuyerName());
            result.setBuyerTaxNo(invoice.getBuyerTaxNo());
            result.setSalerName(invoice.getSalerName());
            result.setSalerTaxNo(invoice.getSalerTaxNo());
            result.setCheckCode(invoice.getCheckCode());
        }
        result.setPass(OK_CODE.equals(queryInvoiceResp.getErrcode()));
        result.setMsg(queryInvoiceResp.getDescription());
        return result;
    }

    public static InvoiceCloudResp save(InvocieReqParam request) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("billType", ENTITYID);
        param.put("entityId", ENTITYID);
        param.put("appId", APPID);
        param.put("viewPage", ENTITYID);
        param.put("resource", "4");
        param.put("status", "1");
        param.put("billNo", request.getBillNo());
        param.put("billId", request.getBillId());
        param.put("orgId", request.getOrgId());
        param.put("billUser", RequestContext.get().getCurrUserId());
        param.put("invoiceData", request.getInvoiceData());
        logger.info("\u4fdd\u5b58\u62a5\u9500\u5355\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(param));
        Object result = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"save", (Object[])new Object[]{param});
        logger.info("\u4fdd\u5b58\u62a5\u9500\u5355\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
        InvoiceCloudResp queryInvoiceResp = (InvoiceCloudResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)result), InvoiceCloudResp.class);
        return queryInvoiceResp;
    }

    public static void delete(Object billId) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("billId", billId.toString());
        param.put("entityId", ENTITYID);
        logger.info("\u5220\u9664\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(param));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"delete", (Object[])new Object[]{param});
        logger.info("\u5220\u9664\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u8fd4\u56de\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)result));
        InvoiceCloudResp queryInvoiceResp = (InvoiceCloudResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)result), InvoiceCloudResp.class);
        if (!OK_CODE.equals(queryInvoiceResp.getErrcode())) {
            logger.info("\u5220\u9664\u53d1\u7968\u5f02\u5e38\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
        }
    }

    public static List<InvoiceData> query(List<String> serialNos) {
        logger.info("\u67e5\u770b\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(serialNos));
        Object resultJson = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"query", (Object[])new Object[]{serialNos});
        logger.info("\u67e5\u770b\u53d1\u7968\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(serialNos), (Object)JSONObject.toJSONString((Object)resultJson));
        InvoiceCloudResp queryInvoiceResp = (InvoiceCloudResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultJson), InvoiceCloudResp.class);
        return queryInvoiceResp.getData();
    }

    public static List<InvoiceData> queryVerify(List<String> serialNos) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>(2);
        param.put("serialNos", serialNos);
        logger.info("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(param));
        Object resultJson = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"queryVerify", (Object[])new Object[]{param});
        logger.info("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(param), (Object)JSONObject.toJSONString((Object)resultJson));
        InvoiceCloudResp queryInvoiceResp = (InvoiceCloudResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultJson), InvoiceCloudResp.class);
        return queryInvoiceResp.getData();
    }

    public static boolean hasInvCloudConfig(DynamicObject org) {
        return org != null && ApiConfigUtil.hasInvCloudConfig() && InvoiceCloudServiceHelper.queryPermissionByOrgId(org.getLong("id"));
    }

    public static boolean queryPermissionByOrgId(Long orgId) {
        logger.info("\u67e5\u8be2\u6536\u7968\u6743\u9650\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)orgId));
        Object resultJson = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"queryPermissionByOrgId", (Object[])new Object[]{orgId});
        logger.info("\u67e5\u8be2\u6536\u7968\u6743\u9650\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c", (Object)JSONObject.toJSONString((Object)orgId), (Object)JSONObject.toJSONString((Object)resultJson));
        InvoiceCloudResp queryInvoiceResp = (InvoiceCloudResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultJson), InvoiceCloudResp.class);
        return OK_CODE.equals(queryInvoiceResp.getErrcode());
    }

    public static boolean signInvoice(List<String> serialNos) {
        logger.info("\u53d1\u7968\u7b7e\u6536\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(serialNos));
        Object resultJson = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"signInvoice", (Object[])new Object[]{serialNos});
        logger.info("\u53d1\u7968\u7b7e\u6536\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c", (Object)JSONObject.toJSONString(serialNos), (Object)JSONObject.toJSONString((Object)resultJson));
        InvoiceCloudResp queryInvoiceResp = (InvoiceCloudResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultJson), InvoiceCloudResp.class);
        return OK_CODE.equals(queryInvoiceResp.getErrcode());
    }

    public static boolean unSignInvoice(List<String> serialNos) {
        logger.info("\u53d1\u7968\u53cd\u7b7e\u6536\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(serialNos));
        Object resultJson = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"unSignInvoice", (Object[])new Object[]{serialNos});
        logger.info("\u53d1\u7968\u53cd\u7b7e\u6536\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c", (Object)JSONObject.toJSONString(serialNos), (Object)JSONObject.toJSONString((Object)resultJson));
        InvoiceCloudResp queryInvoiceResp = (InvoiceCloudResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultJson), InvoiceCloudResp.class);
        return OK_CODE.equals(queryInvoiceResp.getErrcode());
    }
}

